# Generated by default/object.tt
package Paws::Connect::QuickConnect;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has QuickConnectARN => (is => 'ro', isa => 'Str');
  has QuickConnectConfig => (is => 'ro', isa => 'Paws::Connect::QuickConnectConfig');
  has QuickConnectId => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::Connect::TagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::QuickConnect

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::QuickConnect object:

  $service_obj->Method(Att1 => { Description => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::QuickConnect object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Contains information about a quick connect.

=head1 ATTRIBUTES


=head2 Description => Str

The description.


=head2 Name => Str

The name of the quick connect.


=head2 QuickConnectARN => Str

The Amazon Resource Name (ARN) of the quick connect.


=head2 QuickConnectConfig => L<Paws::Connect::QuickConnectConfig>

Contains information about the quick connect.


=head2 QuickConnectId => Str

The identifier for the quick connect.


=head2 Tags => L<Paws::Connect::TagMap>

One or more tags.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

