# Generated by default/object.tt
package Paws::Schemas::PutResourcePolicyInput;
  use Moose;
  has Policy => (is => 'ro', isa => 'Str', required => 1);
  has RevisionId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Schemas::PutResourcePolicyInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Schemas::PutResourcePolicyInput object:

  $service_obj->Method(Att1 => { Policy => $value, ..., RevisionId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Schemas::PutResourcePolicyInput object:

  $result = $service_obj->Method(...);
  $result->Att1->Policy

=head1 DESCRIPTION

Only update the policy if the revision ID matches the ID that's
specified. Use this option to avoid modifying a policy that has changed
since you last read it.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Policy => Str

The resource-based policy.


=head2 RevisionId => Str

The revision ID of the policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Schemas>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

