/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.zip.CRC32;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.context.ErrorStringBuilder;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.LogScan;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.log.CheckpointOperation;
import org.apache.derby.impl.store.raw.log.FileLogger;
import org.apache.derby.impl.store.raw.log.FlushedScan;
import org.apache.derby.impl.store.raw.log.FlushedScanHandle;
import org.apache.derby.impl.store.raw.log.LogAccessFile;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.Scan;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;

public class LogToFile
implements LogFactory,
ModuleControl,
ModuleSupportable,
Serviceable,
PrivilegedExceptionAction {
    private static int fid = 128;
    public static final int LOG_FILE_HEADER_SIZE = 24;
    protected static final int LOG_FILE_HEADER_PREVIOUS_LOG_INSTANT_OFFSET = 16;
    public static final int LOG_RECORD_OVERHEAD = 16;
    public static final String DBG_FLAG = null;
    public static final String DUMP_LOG_ONLY = null;
    public static final String DUMP_LOG_FROM_LOG_FILE = null;
    protected static final String LOG_SYNC_STATISTICS = "LogSyncStatistics";
    private static final int OBSOLETE_LOG_VERSION_NUMBER = 9;
    private static final int DEFAULT_LOG_SWITCH_INTERVAL = 0x100000;
    private static final int LOG_SWITCH_INTERVAL_MIN = 100000;
    private static final int LOG_SWITCH_INTERVAL_MAX = 0x8000000;
    private static final int CHECKPOINT_INTERVAL_MIN = 100000;
    private static final int CHECKPOINT_INTERVAL_MAX = 0x8000000;
    private static final int DEFAULT_CHECKPOINT_INTERVAL = 0xA00000;
    private static final int DEFAULT_LOG_BUFFER_SIZE = 32768;
    private static final int LOG_BUFFER_SIZE_MIN = 8192;
    private static final int LOG_BUFFER_SIZE_MAX = 0x8000000;
    private int logBufferSize = 32768;
    private static final byte IS_BETA_FLAG = 1;
    private static final byte IS_DURABILITY_TESTMODE_NO_SYNC_FLAG = 2;
    private static boolean wasDBInDurabilityTestModeNoSync = false;
    private static final String DEFAULT_LOG_ARCHIVE_DIRECTORY = "DEFAULT";
    private int logSwitchInterval = 0x100000;
    private int checkpointInterval = 0xA00000;
    String dataDirectory;
    private WritableStorageFactory logStorageFactory;
    private boolean logBeingFlushed;
    protected LogAccessFile logOut;
    private StorageRandomAccessFile firstLog = null;
    protected long endPosition = -1L;
    long lastFlush = 0L;
    long logFileNumber = -1L;
    long firstLogFileNumber = -1L;
    private long maxLogFileNumber = Integer.MAX_VALUE;
    private CheckpointOperation currentCheckpoint;
    long checkpointInstant;
    private DaemonService checkpointDaemon;
    private int myClientNumber;
    private volatile boolean checkpointDaemonCalled;
    private long logWrittenFromLastCheckPoint = 0L;
    private RawStoreFactory rawStoreFactory;
    protected DataFactory dataFactory;
    protected boolean ReadOnlyDB;
    private boolean keepAllLogs;
    private boolean databaseEncrypted;
    private boolean recoveryNeeded = true;
    private boolean inCheckpoint = false;
    private boolean inRedo = false;
    private boolean inLogSwitch = false;
    private boolean stopped = false;
    String logDevice;
    private boolean logNotSynced = false;
    private boolean logArchived = false;
    private boolean logSwitchRequired = false;
    int test_logWritten = 0;
    int test_numRecordToFillLog = -1;
    private int mon_flushCalls;
    private int mon_syncCalls;
    private int mon_numLogFlushWaits;
    private boolean mon_LogSyncStatistics;
    private int mon_numBytesToLog;
    protected volatile StandardException corrupt;
    private boolean isFrozen;
    ProductVersionHolder jbmsVersion;
    private int onDiskMajorVersion;
    private int onDiskMinorVersion;
    private boolean onDiskBeta;
    private CRC32 checksum = new CRC32();
    private boolean isWriteSynced = false;
    public static final String TEST_LOG_SWITCH_LOG = null;
    public static final String TEST_LOG_INCOMPLETE_LOG_WRITE = null;
    public static final String TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES = null;
    public static final String TEST_LOG_FULL = null;
    public static final String TEST_SWITCH_LOG_FAIL1 = null;
    public static final String TEST_SWITCH_LOG_FAIL2 = null;
    public static final String TEST_RECORD_TO_FILL_LOG = null;
    public static final String TEST_MAX_LOGFILE_NUMBER = null;
    private int action;
    private StorageFile activeFile;
    private File toFile;
    private String activePerms;

    public int getTypeFormatId() {
        return 128;
    }

    public LogToFile() {
        this.keepAllLogs = PropertyUtil.getSystemBoolean("derby.storage.keepTransactionLog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardException markCorrupt(StandardException standardException) {
        boolean bl = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt == null && standardException != null) {
                this.corrupt = standardException;
                bl = true;
            }
        }
        if (this.corrupt == standardException) {
            this.logErrMsg(this.corrupt);
        }
        if (bl) {
            logToFile = this;
            synchronized (logToFile) {
                this.stopped = true;
                if (this.logOut != null) {
                    try {
                        this.logOut.corrupt();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.logOut = null;
            }
            if (this.dataFactory != null) {
                this.dataFactory.markCorrupt(null);
            }
        }
        return standardException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCorrupt() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt != null) {
                throw StandardException.newException("XSLAA.D", this.corrupt);
            }
        }
    }

    public Logger getLogger() {
        if (this.ReadOnlyDB) {
            return null;
        }
        return new FileLogger(this);
    }

    public void recover(RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory) throws StandardException {
        this.checkCorrupt();
        this.rawStoreFactory = rawStoreFactory;
        this.dataFactory = dataFactory;
        if (this.firstLog != null) {
            this.logOut = new LogAccessFile(this, this.firstLog, this.logBufferSize);
        }
        if (this.recoveryNeeded) {
            try {
                StorageFile storageFile;
                RawTransaction rawTransaction;
                FileLogger fileLogger = (FileLogger)this.getLogger();
                if (this.checkpointInstant != 0L) {
                    this.currentCheckpoint = this.findCheckpoint(this.checkpointInstant, fileLogger);
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                StreamLogScan streamLogScan = null;
                if (this.currentCheckpoint != null) {
                    rawTransaction = null;
                    transactionFactory.useTransactionTable((Formatable)((Object)rawTransaction));
                    l = this.currentCheckpoint.redoLWM();
                    l2 = this.currentCheckpoint.undoLWM();
                    if (rawTransaction != null) {
                        l3 = this.checkpointInstant;
                    }
                    this.firstLogFileNumber = LogCounter.getLogFileNumber(l);
                    if (LogCounter.getLogFileNumber(l2) < this.firstLogFileNumber) {
                        this.firstLogFileNumber = LogCounter.getLogFileNumber(l2);
                    }
                    streamLogScan = (StreamLogScan)this.openForwardsScan(l2, (LogInstant)null);
                } else {
                    transactionFactory.useTransactionTable(null);
                    long l4 = LogCounter.makeLogInstantAsLong(this.logFileNumber, 24L);
                    this.firstLogFileNumber = this.logFileNumber;
                    streamLogScan = (StreamLogScan)this.openForwardsScan(l4, (LogInstant)null);
                }
                rawTransaction = transactionFactory.startTransaction(rawStoreFactory, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
                rawTransaction.recoveryTransaction();
                this.inRedo = true;
                long l5 = fileLogger.redo(rawTransaction, transactionFactory, streamLogScan, l, l3);
                this.inRedo = false;
                StorageRandomAccessFile storageRandomAccessFile = null;
                if (l5 == 0L) {
                    Monitor.logTextMessage("L007");
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (this.privExists(storageFile) && !this.privDelete(storageFile)) {
                        storageFile = this.getLogFileName(++this.logFileNumber);
                    }
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
                    }
                    catch (IOException iOException) {
                        storageRandomAccessFile = null;
                    }
                    if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                        }
                        storageRandomAccessFile = null;
                        this.ReadOnlyDB = true;
                    } else {
                        try {
                            if (!this.initLogFile(storageRandomAccessFile, this.logFileNumber, 0L)) {
                                throw this.markCorrupt(StandardException.newException("XSLAQ.D", storageFile.getPath()));
                            }
                        }
                        catch (IOException iOException) {
                            throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
                        }
                        this.lastFlush = this.endPosition = storageRandomAccessFile.getFilePointer();
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(storageRandomAccessFile);
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rws");
                            storageRandomAccessFile.seek(this.endPosition);
                        }
                        this.logSwitchRequired = false;
                    }
                } else {
                    this.logFileNumber = LogCounter.getLogFileNumber(l5);
                    this.ReadOnlyDB = dataFactory.isReadOnly();
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (!this.ReadOnlyDB) {
                        try {
                            storageRandomAccessFile = this.isWriteSynced ? this.privRandomAccessFile(storageFile, "rws") : this.privRandomAccessFile(storageFile, "rw");
                        }
                        catch (IOException iOException) {
                            storageRandomAccessFile = null;
                        }
                        if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                            if (storageRandomAccessFile != null) {
                                storageRandomAccessFile.close();
                            }
                            storageRandomAccessFile = null;
                            this.ReadOnlyDB = true;
                        }
                    }
                    if (!this.ReadOnlyDB) {
                        this.endPosition = LogCounter.getLogFilePosition(l5);
                        if (streamLogScan.isLogEndFuzzy()) {
                            storageRandomAccessFile.seek(this.endPosition);
                            long l6 = storageRandomAccessFile.length();
                            Monitor.logTextMessage("L010", storageFile, new Long(this.endPosition), new Long(l6));
                            long l7 = (l6 - this.endPosition) / (long)this.logBufferSize;
                            int n = (int)((l6 - this.endPosition) % (long)this.logBufferSize);
                            byte[] byArray = new byte[this.logBufferSize];
                            while (l7-- > 0L) {
                                storageRandomAccessFile.write(byArray);
                            }
                            if (n != 0) {
                                storageRandomAccessFile.write(byArray, 0, n);
                            }
                            if (!this.isWriteSynced) {
                                this.syncFile(storageRandomAccessFile);
                            }
                        }
                        this.lastFlush = this.endPosition;
                        storageRandomAccessFile.seek(this.endPosition);
                    }
                }
                if (storageRandomAccessFile != null) {
                    this.logOut = new LogAccessFile(this, storageRandomAccessFile, this.logBufferSize);
                }
                if (this.logSwitchRequired) {
                    this.switchLogFile();
                }
                boolean bl = transactionFactory.noActiveUpdateTransaction();
                if (this.ReadOnlyDB && !bl) {
                    throw StandardException.newException("XSLAF.D");
                }
                if (!bl) {
                    transactionFactory.rollbackAllTransactions(rawTransaction, rawStoreFactory);
                }
                transactionFactory.handlePreparedXacts(rawStoreFactory);
                rawTransaction.close();
                this.dataFactory.postRecovery();
                transactionFactory.resetTranId();
                if (!this.ReadOnlyDB) {
                    boolean bl2 = true;
                    if (this.currentCheckpoint != null && bl && l != 0L && l2 != 0L && this.logFileNumber == LogCounter.getLogFileNumber(l) && this.logFileNumber == LogCounter.getLogFileNumber(l2) && this.endPosition < LogCounter.getLogFilePosition(l) + 1000L) {
                        bl2 = false;
                    }
                    if (bl2 && !this.checkpoint(rawStoreFactory, dataFactory, transactionFactory, false)) {
                        this.flush(this.logFileNumber, this.endPosition);
                    }
                }
                fileLogger.close();
                this.recoveryNeeded = false;
            }
            catch (IOException iOException) {
                throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException));
            }
            catch (StandardException standardException) {
                throw this.markCorrupt(standardException);
            }
            catch (Throwable throwable) {
                throw this.markCorrupt(StandardException.newException("XSLA6.D", throwable));
            }
        }
        transactionFactory.useTransactionTable(null);
        transactionFactory.resetTranId();
        this.checkpointDaemon = this.rawStoreFactory.getDaemon();
        if (this.checkpointDaemon != null) {
            this.myClientNumber = this.checkpointDaemon.subscribe(this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkpoint(RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory, boolean bl) throws StandardException {
        boolean bl2 = this.checkpointWithTran(null, rawStoreFactory, dataFactory, transactionFactory);
        if (!bl2 && bl) {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                while (this.inCheckpoint) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean checkpointWithTran(RawTransaction rawTransaction, RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory) throws StandardException {
        boolean bl = true;
        if (this.logOut == null) {
            return false;
        }
        LogToFile logToFile = this;
        // MONITORENTER : logToFile
        if (this.corrupt != null) {
            throw StandardException.newException("XSLAA.D", this.corrupt);
        }
        if (this.inCheckpoint) {
            bl = false;
        } else {
            this.inCheckpoint = true;
        }
        long l = this.endPosition;
        // MONITOREXIT : logToFile
        if (!bl) {
            return false;
        }
        boolean bl2 = rawTransaction == null;
        try {
            try {
                if (l > (long)this.logSwitchInterval) {
                    this.switchLogFile();
                    this.logWrittenFromLastCheckPoint = 0L;
                } else {
                    this.logWrittenFromLastCheckPoint = -this.endPosition;
                }
                if (bl2) {
                    rawTransaction = transactionFactory.startInternalTransaction(rawStoreFactory, ContextService.getFactory().getCurrentContextManager());
                }
                Object object = this;
                // MONITORENTER : object
                long l2 = this.currentInstant();
                LogCounter logCounter = new LogCounter(l2);
                Formatable formatable = (LogCounter)transactionFactory.firstUpdateInstant();
                long l3 = formatable == null ? l2 : formatable.getValueAsLong();
                // MONITOREXIT : object
                dataFactory.checkpoint();
                object = transactionFactory.getTransactionTable();
                formatable = new CheckpointOperation(l2, l3, (Formatable)object);
                rawTransaction.logAndDo((Loggable)formatable);
                LogCounter logCounter2 = (LogCounter)rawTransaction.getLastLogInstant();
                if (logCounter2 == null) throw StandardException.newException("XSLAI.D");
                this.flush(logCounter2);
                rawTransaction.commit();
                if (bl2) {
                    rawTransaction.close();
                    rawTransaction = null;
                }
                if (!this.writeControlFile(this.getControlFileName(), logCounter2.getValueAsLong())) {
                    throw StandardException.newException("XSLAE.D", this.getControlFileName());
                }
                this.currentCheckpoint = formatable;
                if (!this.logArchived()) {
                    this.truncateLog(this.currentCheckpoint);
                }
                dataFactory.removeDroppedContainerFileStubs(logCounter);
            }
            catch (IOException iOException) {
                throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
            }
            Object var18_16 = null;
            Object object2 = this;
            // MONITORENTER : object2
            this.inCheckpoint = false;
            this.notifyAll();
            // MONITOREXIT : object2
            if (rawTransaction == null) return true;
            if (!bl2) return true;
            try {
                rawTransaction.commit();
                rawTransaction.close();
                return true;
            }
            catch (StandardException object2) {
                throw this.markCorrupt(StandardException.newException("XSLA3.D", (Throwable)object2));
            }
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            Object object3 = this;
            // MONITORENTER : object3
            this.inCheckpoint = false;
            this.notifyAll();
            // MONITOREXIT : object3
            if (rawTransaction == null) throw throwable;
            if (!bl2) throw throwable;
            try {}
            catch (StandardException object3) {
                throw this.markCorrupt(StandardException.newException("XSLA3.D", (Throwable)object3));
            }
            rawTransaction.commit();
            rawTransaction.close();
            throw throwable;
        }
    }

    public void flush(LogInstant logInstant) throws StandardException {
        long l;
        long l2;
        if (logInstant == null) {
            l2 = 0L;
            l = 0L;
        } else {
            LogCounter logCounter = (LogCounter)logInstant;
            l2 = logCounter.getLogFileNumber();
            l = logCounter.getLogFilePosition();
        }
        this.flush(l2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() throws StandardException {
        long l;
        long l2;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            l2 = this.logFileNumber;
            l = this.endPosition;
        }
        this.flush(l2, l);
    }

    private boolean verifyLogFormat(StorageFile storageFile, long l) throws StandardException {
        boolean bl = false;
        try {
            StorageRandomAccessFile storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            bl = this.verifyLogFormat(storageRandomAccessFile, l);
            storageRandomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private boolean verifyLogFormat(StorageRandomAccessFile storageRandomAccessFile, long l) throws StandardException {
        try {
            storageRandomAccessFile.seek(0L);
            int n = storageRandomAccessFile.readInt();
            int n2 = storageRandomAccessFile.readInt();
            long l2 = storageRandomAccessFile.readLong();
            if (n != fid || l2 != l) {
                throw StandardException.newException("XSLAC.D", this.dataDirectory);
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSLAM.D", iOException, (Object)this.dataDirectory);
        }
        return true;
    }

    private boolean initLogFile(StorageRandomAccessFile storageRandomAccessFile, long l, long l2) throws IOException, StandardException {
        if (storageRandomAccessFile.length() != 0L) {
            return false;
        }
        storageRandomAccessFile.seek(0L);
        storageRandomAccessFile.writeInt(fid);
        storageRandomAccessFile.writeInt(9);
        storageRandomAccessFile.writeLong(l);
        storageRandomAccessFile.writeLong(l2);
        this.syncFile(storageRandomAccessFile);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchLogFile() throws StandardException {
        boolean bl = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            block23: {
                while (this.logBeingFlushed | this.isFrozen) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
                if (this.endPosition == 24L) {
                    return;
                }
                StorageFile storageFile = this.getLogFileName(this.logFileNumber + 1L);
                if (this.logFileNumber + 1L >= this.maxLogFileNumber) {
                    throw StandardException.newException("XSLAK.D", new Long(this.maxLogFileNumber));
                }
                StorageRandomAccessFile storageRandomAccessFile = null;
                try {
                    if (this.privExists(storageFile) && !this.privDelete(storageFile)) {
                        this.logErrMsg(MessageService.getTextMessage("L015", storageFile.getPath()));
                        return;
                    }
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
                    }
                    catch (IOException iOException) {
                        storageRandomAccessFile = null;
                    }
                    if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                        }
                        storageRandomAccessFile = null;
                        return;
                    }
                    if (this.initLogFile(storageRandomAccessFile, this.logFileNumber + 1L, LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition))) {
                        bl = true;
                        this.logOut.writeEndMarker(0);
                        this.endPosition += 4L;
                        this.inLogSwitch = true;
                        this.flush(this.logFileNumber, this.endPosition);
                        this.logOut.close();
                        this.logWrittenFromLastCheckPoint += this.endPosition;
                        this.lastFlush = this.endPosition = storageRandomAccessFile.getFilePointer();
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(storageRandomAccessFile);
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rws");
                            storageRandomAccessFile.seek(this.endPosition);
                        }
                        this.logOut = new LogAccessFile(this, storageRandomAccessFile, this.logBufferSize);
                        storageRandomAccessFile = null;
                        ++this.logFileNumber;
                    } else {
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = null;
                        if (this.privExists(storageFile)) {
                            this.privDelete(storageFile);
                        }
                        storageFile = null;
                        this.logErrMsg(MessageService.getTextMessage("L016", storageFile.getPath()));
                    }
                }
                catch (IOException iOException) {
                    this.inLogSwitch = false;
                    this.logErrMsg(MessageService.getTextMessage("L017", storageFile.getPath(), iOException.toString()));
                    try {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = null;
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (storageFile != null && this.privExists(storageFile)) {
                        this.privDelete(storageFile);
                        storageFile = null;
                    }
                    if (!bl) break block23;
                    this.logOut = null;
                    throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
                }
            }
            this.inLogSwitch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer(long l, long l2) throws IOException, StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (l < this.logFileNumber) {
                return;
            }
            if (l2 < this.lastFlush) {
                return;
            }
            this.logOut.flushLogAccessFile();
        }
    }

    private void truncateLog(CheckpointOperation checkpointOperation) {
        if (this.keepAllLogs) {
            return;
        }
        long l = this.getFirstLogNeeded(checkpointOperation);
        if (l == -1L) {
            return;
        }
        this.firstLogFileNumber = l;
        for (long i = this.firstLogFileNumber; i < l; ++i) {
            StorageFile storageFile = null;
            try {
                storageFile = this.getLogFileName(i);
                if (!this.privDelete(storageFile)) continue;
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFirstLogNeeded(CheckpointOperation checkpointOperation) {
        long l;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            l = LogCounter.getLogFileNumber(checkpointOperation.undoLWM());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeControlFile(StorageFile storageFile, long l) throws IOException, StandardException {
        StorageRandomAccessFile storageRandomAccessFile = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(fid);
        dataOutputStream.writeInt(9);
        dataOutputStream.writeLong(l);
        if (this.onDiskMajorVersion == 0) {
            this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
            this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
            this.onDiskBeta = this.jbmsVersion.isBeta();
        }
        dataOutputStream.writeInt(this.onDiskMajorVersion);
        dataOutputStream.writeInt(this.onDiskMinorVersion);
        dataOutputStream.writeInt(this.jbmsVersion.getBuildNumberAsInt());
        byte by = 0;
        if (this.onDiskBeta) {
            by = (byte)(by | 1);
        }
        if (this.logNotSynced || wasDBInDurabilityTestModeNoSync) {
            by = (byte)(by | 2);
        }
        dataOutputStream.writeByte(by);
        long l2 = 0L;
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeLong(l2);
        dataOutputStream.flush();
        this.checksum.reset();
        this.checksum.update(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        dataOutputStream.writeLong(this.checksum.getValue());
        dataOutputStream.flush();
        try {
            this.checkCorrupt();
            try {
                storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
            }
            catch (IOException iOException) {
                storageRandomAccessFile = null;
                boolean bl = false;
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                return bl;
            }
            if (!this.privCanWrite(storageFile)) {
                boolean bl = false;
                return bl;
            }
            storageRandomAccessFile.seek(0L);
            storageRandomAccessFile.write(byteArrayOutputStream.toByteArray());
            this.syncFile(storageRandomAccessFile);
            storageRandomAccessFile.close();
            try {
                storageRandomAccessFile = this.privRandomAccessFile(this.getMirrorControlFileName(), "rw");
            }
            catch (IOException iOException) {
                storageRandomAccessFile = null;
                boolean bl = false;
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                return bl;
            }
            storageRandomAccessFile.seek(0L);
            storageRandomAccessFile.write(byteArrayOutputStream.toByteArray());
            this.syncFile(storageRandomAccessFile);
        }
        finally {
            if (storageRandomAccessFile != null) {
                storageRandomAccessFile.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readControlFile(StorageFile storageFile, Properties properties) throws IOException, StandardException {
        long l;
        boolean bl;
        FilterInputStream filterInputStream;
        ByteArrayInputStream byteArrayInputStream;
        block21: {
            StorageRandomAccessFile storageRandomAccessFile = null;
            byteArrayInputStream = null;
            filterInputStream = null;
            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            bl = false;
            l = 0L;
            long l2 = 0L;
            long l3 = storageRandomAccessFile.length();
            byte[] byArray = null;
            try {
                if (l3 < 16L) {
                    l2 = -1L;
                } else if (l3 == 16L) {
                    byArray = new byte[16];
                    storageRandomAccessFile.readFully(byArray);
                } else if (l3 > 16L) {
                    byArray = new byte[(int)storageRandomAccessFile.length() - 8];
                    storageRandomAccessFile.readFully(byArray);
                    l2 = storageRandomAccessFile.readLong();
                    if (l2 != 0L) {
                        this.checksum.reset();
                        this.checksum.update(byArray, 0, byArray.length);
                    }
                }
                if (l2 == this.checksum.getValue() || l2 == 0L) {
                    boolean bl2;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    filterInputStream = new DataInputStream(byteArrayInputStream);
                    if (((DataInputStream)filterInputStream).readInt() != fid) {
                        throw StandardException.newException("XSLAC.D", this.dataDirectory);
                    }
                    int n = ((DataInputStream)filterInputStream).readInt();
                    l = ((DataInputStream)filterInputStream).readLong();
                    this.onDiskMajorVersion = ((DataInputStream)filterInputStream).readInt();
                    this.onDiskMinorVersion = ((DataInputStream)filterInputStream).readInt();
                    int n2 = ((DataInputStream)filterInputStream).readInt();
                    byte by = ((DataInputStream)filterInputStream).readByte();
                    wasDBInDurabilityTestModeNoSync = (by & 2) != 0;
                    boolean bl3 = this.onDiskBeta = (by & 1) != 0;
                    if (!(!this.onDiskBeta || this.jbmsVersion.isBeta() && this.onDiskMajorVersion == this.jbmsVersion.getMajorVersion() && this.onDiskMinorVersion == this.jbmsVersion.getMinorVersion() || (bl2 = false))) {
                        throw StandardException.newException("XSLAP.D", this.dataDirectory, (Object)ProductVersionHolder.simpleVersionString(this.onDiskMajorVersion, this.onDiskMinorVersion, this.onDiskBeta));
                    }
                    if (this.onDiskMajorVersion > this.jbmsVersion.getMajorVersion() || this.onDiskMajorVersion == this.jbmsVersion.getMajorVersion() && this.onDiskMinorVersion > this.jbmsVersion.getMinorVersion()) {
                        throw StandardException.newException("XSLAN.D", this.dataDirectory, (Object)ProductVersionHolder.simpleVersionString(this.onDiskMajorVersion, this.onDiskMinorVersion, this.onDiskBeta));
                    }
                    if (this.onDiskMajorVersion != this.jbmsVersion.getMajorVersion() || this.onDiskMinorVersion != this.jbmsVersion.getMinorVersion()) {
                        bl = true;
                    }
                    if (l2 == 0L && (this.onDiskMajorVersion > 3 || this.onDiskMinorVersion > 5 || this.onDiskMajorVersion == 0)) {
                        l = 0L;
                    }
                }
                Object var19_15 = null;
                if (storageRandomAccessFile == null) break block21;
            }
            catch (Throwable throwable) {
                Object var19_16 = null;
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
                throw throwable;
            }
            storageRandomAccessFile.close();
        }
        if (byteArrayInputStream != null) {
            byteArrayInputStream.close();
        }
        if (filterInputStream != null) {
            filterInputStream.close();
        }
        if (bl && Monitor.isFullUpgrade(properties, ProductVersionHolder.simpleVersionString(this.onDiskMajorVersion, this.onDiskMinorVersion, this.onDiskBeta))) {
            this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
            this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
            this.onDiskBeta = this.jbmsVersion.isBeta();
            if (!this.writeControlFile(storageFile, l)) {
                throw StandardException.newException("XSLAE.D", storageFile);
            }
        }
        return l;
    }

    public StorageFile getLogDirectory() throws StandardException {
        StorageFile storageFile = null;
        storageFile = this.logStorageFactory.newStorageFile("log");
        if (!this.privExists(storageFile) && !this.privMkdirs(storageFile)) {
            throw StandardException.newException("XSLAQ.D", storageFile.getPath());
        }
        return storageFile;
    }

    public String getCanonicalLogPath() {
        if (this.logDevice == null) {
            return null;
        }
        try {
            return this.logStorageFactory.getCanonicalName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private StorageFile getControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log.ctrl");
    }

    private StorageFile getMirrorControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "logmirror.ctrl");
    }

    private StorageFile getLogFileName(long l) throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log" + l + ".dat");
    }

    private CheckpointOperation findCheckpoint(long l, FileLogger fileLogger) throws IOException, StandardException, ClassNotFoundException {
        StreamLogScan streamLogScan = (StreamLogScan)this.openForwardsScan(l, (LogInstant)null);
        Loggable loggable = fileLogger.readLogRecord(streamLogScan, 100);
        streamLogScan.close();
        if (loggable instanceof CheckpointOperation) {
            return (CheckpointOperation)loggable;
        }
        return null;
    }

    protected LogScan openBackwardsScan(long l, LogInstant logInstant) throws IOException, StandardException {
        this.checkCorrupt();
        if (l == 0L) {
            return this.openBackwardsScan(logInstant);
        }
        this.flushBuffer(LogCounter.getLogFileNumber(l), LogCounter.getLogFilePosition(l));
        return new Scan(this, l, logInstant, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogScan openBackwardsScan(LogInstant logInstant) throws IOException, StandardException {
        long l;
        this.checkCorrupt();
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.logOut.flushLogAccessFile();
            l = this.currentInstant();
        }
        return new Scan(this, l, logInstant, 4);
    }

    public ScanHandle openFlushedScan(DatabaseInstant databaseInstant, int n) throws StandardException {
        return new FlushedScanHandle(this, databaseInstant, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogScan openForwardsScan(long l, LogInstant logInstant) throws IOException, StandardException {
        this.checkCorrupt();
        if (l == 0L) {
            l = this.firstLogInstant();
        }
        if (logInstant != null) {
            LogCounter logCounter = (LogCounter)logInstant;
            this.flushBuffer(logCounter.getLogFileNumber(), logCounter.getLogFilePosition());
        } else {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.logOut != null) {
                    this.logOut.flushLogAccessFile();
                }
            }
        }
        return new Scan(this, l, logInstant, 1);
    }

    protected StorageRandomAccessFile getLogFileAtBeginning(long l) throws IOException, StandardException {
        long l2 = LogCounter.makeLogInstantAsLong(l, 24L);
        return this.getLogFileAtPosition(l2);
    }

    protected StorageRandomAccessFile getLogFileAtPosition(long l) throws IOException, StandardException {
        this.checkCorrupt();
        long l2 = LogCounter.getLogFileNumber(l);
        long l3 = LogCounter.getLogFilePosition(l);
        StorageFile storageFile = this.getLogFileName(l2);
        if (!this.privExists(storageFile)) {
            return null;
        }
        StorageRandomAccessFile storageRandomAccessFile = null;
        try {
            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            if (!this.verifyLogFormat(storageRandomAccessFile, l2)) {
                storageRandomAccessFile.close();
                storageRandomAccessFile = null;
            } else {
                storageRandomAccessFile.seek(l3);
            }
        }
        catch (IOException iOException) {
            try {
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                    storageRandomAccessFile = null;
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        return storageRandomAccessFile;
    }

    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.__rt.storage.log");
        return string == null || !string.equals("readonly");
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        Object object;
        String string;
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        this.logDevice = properties.getProperty("logDevice");
        if (this.logDevice != null) {
            string = null;
            try {
                object = new URL(this.logDevice);
                string = ((URL)object).getFile();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string != null) {
                this.logDevice = string;
            }
        }
        this.restoreLogs(properties);
        this.logBufferSize = PropertyUtil.getSystemInt("derby.storage.logBufferSize", 8192, 0x8000000, 32768);
        if (this.logStorageFactory == null) {
            this.getLogStorageFactory();
        }
        if (this.logDevice != null) {
            string = null;
            try {
                object = new URL(this.logDevice);
                string = ((URL)object).getFile();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string != null) {
                this.logDevice = string;
            }
            if (!bl && !this.privExists((StorageFile)(object = this.logStorageFactory.newStorageFile("log")))) {
                throw StandardException.newException("XSLAB.D", object.getPath());
            }
        }
        this.jbmsVersion = Monitor.getMonitor().getEngineVersion();
        string = properties.getProperty("dataEncryption");
        this.databaseEncrypted = Boolean.valueOf(string);
        object = properties.getProperty("derby.storage.logArchiveMode");
        this.logArchived = Boolean.valueOf((String)object);
        this.getLogFactoryProperties(null);
        this.isWriteSynced = this.logStorageFactory.supportsRws() ? !PropertyUtil.getSystemBoolean("derby.storage.fileSyncTransactionLog") : false;
        if ("test".equalsIgnoreCase(PropertyUtil.getSystemProperty("derby.system.durability"))) {
            this.logNotSynced = true;
            this.isWriteSynced = false;
        }
        boolean bl2 = bl;
        this.checkpointInstant = 0L;
        try {
            StorageFile storageFile;
            StorageFile storageFile2 = this.getControlFileName();
            if (!bl2) {
                if (this.privExists(storageFile2)) {
                    this.checkpointInstant = this.readControlFile(storageFile2, properties);
                    if (wasDBInDurabilityTestModeNoSync) {
                        Monitor.logMessage(MessageService.getTextMessage("L020", "derby.system.durability", "test"));
                    }
                    if (this.checkpointInstant == 0L && this.getMirrorControlFileName().exists()) {
                        this.checkpointInstant = this.readControlFile(this.getMirrorControlFileName(), properties);
                    }
                } else if (this.logDevice != null) {
                    throw StandardException.newException("XSLAB.D", storageFile2.getPath());
                }
                this.logFileNumber = this.checkpointInstant != 0L ? LogCounter.getLogFileNumber(this.checkpointInstant) : 1L;
                storageFile = this.getLogFileName(this.logFileNumber);
                if (!this.privExists(storageFile)) {
                    if (this.logDevice != null) {
                        throw StandardException.newException("XSLAB.D", storageFile2.getPath());
                    }
                    this.logErrMsg(MessageService.getTextMessage("L018", storageFile.getPath()));
                    bl2 = true;
                } else if (!this.verifyLogFormat(storageFile, this.logFileNumber)) {
                    Monitor.logTextMessage("L008", storageFile);
                    if (!this.privDelete(storageFile) && this.logFileNumber == 1L) {
                        this.logErrMsgForDurabilityTestModeNoSync();
                        throw StandardException.newException("XSLAC.D", this.dataDirectory);
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                if (this.writeControlFile(storageFile2, 0L)) {
                    this.firstLogFileNumber = 1L;
                    this.logFileNumber = 1L;
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (this.privExists(storageFile)) {
                        Monitor.logTextMessage("L009", storageFile);
                        if (!this.privDelete(storageFile)) {
                            this.logErrMsgForDurabilityTestModeNoSync();
                            throw StandardException.newException("XSLAC.D", this.dataDirectory);
                        }
                    }
                    this.firstLog = this.privRandomAccessFile(storageFile, "rw");
                    if (!this.initLogFile(this.firstLog, this.logFileNumber, 0L)) {
                        throw StandardException.newException("XSLAQ.D", storageFile.getPath());
                    }
                    this.endPosition = this.firstLog.getFilePointer();
                    this.lastFlush = this.firstLog.getFilePointer();
                    if (this.isWriteSynced) {
                        this.preAllocateNewLogFile(this.firstLog);
                        this.firstLog.close();
                        this.firstLog = this.privRandomAccessFile(storageFile, "rws");
                        this.firstLog.seek(this.endPosition);
                    }
                } else {
                    this.ReadOnlyDB = true;
                    this.logOut = null;
                    this.firstLog = null;
                }
                this.recoveryNeeded = false;
            } else {
                this.recoveryNeeded = true;
            }
        }
        catch (IOException iOException) {
            throw Monitor.exceptionStartingModule(iOException);
        }
        if (!this.checkVersion(10, 1)) {
            this.maxLogFileNumber = 0x3FFFFFL;
        }
    }

    private void getLogStorageFactory() throws StandardException {
        if (this.logDevice == null) {
            DataFactory dataFactory = (DataFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.raw.data.DataFactory");
            this.logStorageFactory = (WritableStorageFactory)dataFactory.getStorageFactory();
        } else {
            try {
                PersistentService persistentService = Monitor.getMonitor().getServiceType(this);
                this.logStorageFactory = (WritableStorageFactory)persistentService.getStorageFactoryInstance(false, this.logDevice, null, null);
            }
            catch (IOException iOException) {
                throw StandardException.newException("XSLAB.D", iOException, (Object)this.logDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.checkpointDaemon != null) {
            this.checkpointDaemon.unsubscribe(this.myClientNumber);
            this.checkpointDaemon.stop();
        }
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.stopped = true;
            if (this.logOut != null) {
                try {
                    this.logOut.flushLogAccessFile();
                    this.logOut.close();
                }
                catch (IOException iOException) {
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                this.logOut = null;
            }
        }
        if (!(this.corrupt != null || this.logArchived() || this.keepAllLogs || this.ReadOnlyDB)) {
            this.deleteObsoleteLogfiles();
        }
        if (this.logDevice != null) {
            this.logStorageFactory.shutdown();
        }
        this.logStorageFactory = null;
    }

    private void deleteObsoleteLogfiles() {
        StorageFile storageFile;
        long l = this.getFirstLogNeeded(this.currentCheckpoint);
        if (l == -1L) {
            return;
        }
        try {
            storageFile = this.getLogDirectory();
        }
        catch (StandardException standardException) {
            return;
        }
        String[] stringArray = this.privList(storageFile);
        if (stringArray != null) {
            StorageFile storageFile2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                long l2;
                if (stringArray[i].startsWith("log") && stringArray[i].endsWith(".dat") && (l2 = Long.parseLong(stringArray[i].substring(3, stringArray[i].length() - 4))) < l && !this.privDelete(storageFile2 = this.logStorageFactory.newStorageFile(storageFile, stringArray[i]))) continue;
            }
        }
    }

    public boolean serviceASAP() {
        return false;
    }

    public boolean serviceImmediately() {
        return false;
    }

    public void getLogFactoryProperties(PersistentSet persistentSet) throws StandardException {
        String string;
        String string2;
        if (persistentSet == null) {
            string2 = PropertyUtil.getSystemProperty("derby.storage.logSwitchInterval");
            string = PropertyUtil.getSystemProperty("derby.storage.checkpointInterval");
        } else {
            string2 = PropertyUtil.getServiceProperty(persistentSet, "derby.storage.logSwitchInterval");
            string = PropertyUtil.getServiceProperty(persistentSet, "derby.storage.checkpointInterval");
        }
        if (string2 != null) {
            this.logSwitchInterval = Integer.parseInt(string2);
            if (this.logSwitchInterval < 100000) {
                this.logSwitchInterval = 100000;
            } else if (this.logSwitchInterval > 0x8000000) {
                this.logSwitchInterval = 0x8000000;
            }
        }
        if (string != null) {
            this.checkpointInterval = Integer.parseInt(string);
            if (this.checkpointInterval < 100000) {
                this.checkpointInterval = 100000;
            } else if (this.checkpointInterval > 0x8000000) {
                this.checkpointInterval = 0x8000000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performWork(ContextManager contextManager) {
        Object object = this;
        synchronized (object) {
            if (this.corrupt != null) {
                return 1;
            }
        }
        object = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        try {
            if (object != null) {
                TransactionController transactionController = null;
                try {
                    transactionController = object.getAndNameTransaction(contextManager, "SystemTransaction");
                    this.getLogFactoryProperties(transactionController);
                }
                finally {
                    if (transactionController != null) {
                        transactionController.commit();
                    }
                }
            }
            this.rawStoreFactory.checkpoint();
        }
        catch (StandardException standardException) {
            Monitor.logTextMessage("L011");
            this.logErrMsg(standardException);
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        this.checkpointDaemonCalled = false;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long appendLogRecord(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws StandardException {
        long l;
        boolean bl = false;
        if (this.ReadOnlyDB) {
            throw StandardException.newException("XSLAH.D");
        }
        if (n2 <= 0) {
            throw StandardException.newException("XSLB6.S");
        }
        try {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.corrupt != null) {
                    throw StandardException.newException("XSLAA.D", this.corrupt);
                }
                if (this.logOut == null) {
                    throw StandardException.newException("XSLAJ.D");
                }
                if (this.endPosition + 16L + (long)n2 >= 0xFFFFFFFL) {
                    this.switchLogFile();
                    if (this.endPosition + 16L + (long)n2 >= 0xFFFFFFFL) {
                        throw StandardException.newException("XSLAL.D", new Long(this.logFileNumber), (Object)new Long(this.endPosition), (Object)new Long(n2), (Object)new Long(0xFFFFFFFL));
                    }
                }
                this.endPosition += this.logOut.reserveSpaceForChecksum(n2, this.logFileNumber, this.endPosition);
                l = LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
                this.logOut.writeLogRecord(n2, l, byArray, n, byArray2, n3, n4);
                if (n4 != 0) {
                    // empty if block
                }
                this.endPosition += (long)(n2 + 16);
            }
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException("XSLA4.D", iOException));
        }
        return l;
    }

    protected synchronized long currentInstant() {
        return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
    }

    protected synchronized long endPosition() {
        return this.endPosition;
    }

    private synchronized long getLogFileNumber() {
        return this.logFileNumber;
    }

    private synchronized long firstLogInstant() {
        return LogCounter.makeLogInstantAsLong(this.firstLogFileNumber, 24L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void flush(long l, long l2) throws StandardException {
        long l3 = 0L;
        LogToFile logToFile2 = this;
        synchronized (logToFile2) {
            try {
                boolean bl;
                do {
                    if (this.corrupt != null) {
                        throw StandardException.newException("XSLAA.D", this.corrupt);
                    }
                    while (this.isFrozen) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw StandardException.interrupt(interruptedException);
                        }
                    }
                    if (l2 == 0L) return;
                    if (l < this.logFileNumber) return;
                    if (l2 < this.lastFlush) {
                        return;
                    }
                    if (this.recoveryNeeded && this.inRedo) {
                        return;
                    }
                    if (this.logBeingFlushed) {
                        bl = true;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw StandardException.interrupt(interruptedException);
                        }
                    } else {
                        bl = false;
                        if (!this.isWriteSynced) {
                            this.logOut.flushLogAccessFile();
                        } else {
                            this.logOut.switchLogBuffer();
                        }
                        l3 = this.endPosition;
                        this.logBeingFlushed = true;
                    }
                } while (bl);
            }
            catch (IOException iOException) {
                throw this.markCorrupt(StandardException.newException("XSLA0.D", iOException, (Object)this.getLogFileName(this.logFileNumber).getPath()));
            }
        }
        boolean bl = false;
        try {
            try {
                if (this.isWriteSynced) {
                    this.logOut.flushDirtyBuffers();
                } else if (!this.logNotSynced) {
                    this.logOut.syncLogAccessFile();
                }
                bl = true;
            }
            catch (SyncFailedException syncFailedException) {
                throw this.markCorrupt(StandardException.newException("XSLA0.D", syncFailedException, (Object)this.getLogFileName(this.logFileNumber).getPath()));
            }
            catch (IOException iOException) {
                throw this.markCorrupt(StandardException.newException("XSLA0.D", iOException, (Object)this.getLogFileName(this.logFileNumber).getPath()));
            }
            Object var12_14 = null;
            LogToFile logToFile = this;
            synchronized (logToFile) {
                this.logBeingFlushed = false;
                if (bl) {
                    this.lastFlush = l3;
                }
                this.notifyAll();
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            LogToFile logToFile = this;
            synchronized (logToFile) {
                this.logBeingFlushed = false;
                if (bl) {
                    this.lastFlush = l3;
                }
                this.notifyAll();
                throw throwable;
            }
        }
        if (this.logWrittenFromLastCheckPoint + l3 > (long)this.checkpointInterval && this.checkpointDaemon != null && !this.checkpointDaemonCalled && !this.inLogSwitch) {
            LogToFile logToFile4 = this;
            synchronized (logToFile4) {
                if (this.logWrittenFromLastCheckPoint + l3 <= (long)this.checkpointInterval) return;
                if (this.checkpointDaemon == null) return;
                if (this.checkpointDaemonCalled) return;
                if (this.inLogSwitch) return;
                this.checkpointDaemonCalled = true;
                this.checkpointDaemon.serviceNow(this.myClientNumber);
                return;
            }
        }
        if (l3 <= (long)this.logSwitchInterval) return;
        if (this.checkpointDaemonCalled) return;
        if (this.inLogSwitch) return;
        LogToFile logToFile5 = this;
        synchronized (logToFile5) {
            if (l3 <= (long)this.logSwitchInterval) return;
            if (this.checkpointDaemonCalled) return;
            if (this.inLogSwitch) return;
            this.inLogSwitch = true;
            this.switchLogFile();
            return;
        }
    }

    private void syncFile(StorageRandomAccessFile storageRandomAccessFile) throws StandardException {
        int n = 0;
        while (true) {
            try {
                storageRandomAccessFile.sync(false);
            }
            catch (IOException iOException) {
                ++n;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n <= 20) continue;
                throw StandardException.newException("XSLA4.D", iOException, null);
            }
            break;
        }
    }

    public LogScan openForwardsFlushedScan(LogInstant logInstant) throws StandardException {
        this.checkCorrupt();
        return new FlushedScan(this, ((LogCounter)logInstant).getValueAsLong());
    }

    public LogScan openForwardsScan(LogInstant logInstant, LogInstant logInstant2) throws StandardException {
        try {
            long l = logInstant == null ? 0L : ((LogCounter)logInstant).getValueAsLong();
            return this.openForwardsScan(l, logInstant2);
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
        }
    }

    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.encrypt(byArray, n, n2, byArray2, n3);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.decrypt(byArray, n, n2, byArray2, n3);
    }

    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public int getEncryptedDataLength(int n) {
        if (n % this.getEncryptionBlockSize() != 0) {
            return n + this.getEncryptionBlockSize() - n % this.getEncryptionBlockSize();
        }
        return n;
    }

    public synchronized LogInstant getFirstUnflushedInstant() {
        return new LogCounter(this.logFileNumber, this.lastFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.logArchived) {
                this.switchLogFile();
            }
            this.isFrozen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.isFrozen = false;
            this.notifyAll();
        }
    }

    public boolean logArchived() {
        return this.logArchived;
    }

    boolean checkVersion(int n, int n2) {
        if (this.onDiskMajorVersion > n) {
            return true;
        }
        return this.onDiskMajorVersion == n && this.onDiskMinorVersion >= n2;
    }

    protected void logErrMsg(String string) {
        this.logErrMsgForDurabilityTestModeNoSync();
        Monitor.logTextMessage("L001");
        Monitor.logMessage(string);
        Monitor.logTextMessage("L002");
    }

    protected void logErrMsg(Throwable throwable) {
        this.logErrMsgForDurabilityTestModeNoSync();
        if (this.corrupt != null) {
            Monitor.logTextMessage("L003");
            this.printErrorStack(this.corrupt);
            Monitor.logTextMessage("L004");
        }
        if (throwable != this.corrupt) {
            Monitor.logTextMessage("L005");
            this.printErrorStack(throwable);
            Monitor.logTextMessage("L006");
        }
    }

    private void logErrMsgForDurabilityTestModeNoSync() {
        if (this.logNotSynced || wasDBInDurabilityTestModeNoSync) {
            Monitor.logTextMessage("L021", "derby.system.durability", "test");
        }
    }

    private void printErrorStack(Throwable throwable) {
        ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(Monitor.getStream().getHeader());
        errorStringBuilder.stackTrace(throwable);
        Monitor.logMessage(errorStringBuilder.get().toString());
        errorStringBuilder.reset();
    }

    private long logtest_appendPartialLogRecord(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws StandardException {
        return 0L;
    }

    protected void testLogFull() throws IOException {
    }

    public StorageRandomAccessFile getLogFileToSimulateCorruption(long l) throws IOException, StandardException {
        return null;
    }

    public void enableLogArchiveMode() throws StandardException {
        if (!this.logArchived) {
            this.logArchived = true;
            AccessFactory accessFactory = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
            if (accessFactory != null) {
                TransactionController transactionController = null;
                transactionController = accessFactory.getTransaction(ContextService.getFactory().getCurrentContextManager());
                transactionController.setProperty("derby.storage.logArchiveMode", (Serializable)((Object)"true"), true);
            }
        }
    }

    public void disableLogArchiveMode() throws StandardException {
        this.logArchived = false;
        AccessFactory accessFactory = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        if (accessFactory != null) {
            TransactionController transactionController = null;
            transactionController = accessFactory.getTransaction(ContextService.getFactory().getCurrentContextManager());
            transactionController.setProperty("derby.storage.logArchiveMode", (Serializable)((Object)"false"), true);
        }
    }

    public void deleteOnlineArchivedLogFiles() {
        this.deleteObsoleteLogfiles();
    }

    public synchronized boolean copyActiveLogFiles(File file) throws StandardException {
        long l;
        long l2 = this.getFirstLogNeeded(this.currentCheckpoint);
        if (l2 == -1L) {
            return true;
        }
        StorageFile storageFile = this.getLogFileName(l2);
        File file2 = null;
        long l3 = l = this.logArchived ? this.getLogFileNumber() - 1L : this.getLogFileNumber();
        while (l2 <= l) {
            file2 = new File(file, storageFile.getName());
            if (!this.privCopyFile(storageFile, file2)) {
                return false;
            }
            storageFile = this.getLogFileName(++l2);
        }
        storageFile = this.getControlFileName();
        if (!this.privCopyFile(storageFile, file2 = new File(file, storageFile.getName()))) {
            return false;
        }
        storageFile = this.getMirrorControlFileName();
        return this.privCopyFile(storageFile, file2 = new File(file, storageFile.getName()));
    }

    public boolean inRFR() {
        if (this.recoveryNeeded) {
            boolean bl = false;
            try {
                bl = !this.privCanWrite(this.getControlFileName());
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            bl = bl || this.dataFactory != null && this.dataFactory.isReadOnly();
            return !bl;
        }
        return false;
    }

    public void checkpointInRFR(LogInstant logInstant, long l, DataFactory dataFactory) throws StandardException {
        dataFactory.checkpoint();
        try {
            if (!this.writeControlFile(this.getControlFileName(), ((LogCounter)logInstant).getValueAsLong())) {
                throw StandardException.newException("XSLAE.D", this.getControlFileName());
            }
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
        }
        dataFactory.removeDroppedContainerFileStubs(new LogCounter(l));
    }

    private void restoreLogs(Properties properties) throws StandardException {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        string = properties.getProperty("createFrom");
        if (string == null) {
            string = properties.getProperty("restoreFrom");
        } else {
            bl = true;
        }
        if (string == null) {
            string = properties.getProperty("rollForwardRecoveryFrom");
        } else {
            bl2 = true;
        }
        if (string != null) {
            if (!bl && this.logDevice == null) {
                this.logDevice = properties.getProperty("derby.storage.logDeviceWhenBackedUp");
            }
            this.getLogStorageFactory();
            StorageFile storageFile = this.logStorageFactory.newStorageFile("log");
            if (bl && this.privExists(storageFile)) {
                throw StandardException.newException("XSLAT.D", this.getLogDirPath(storageFile));
            }
            if (bl2 && this.logDevice != null && !this.privRemoveDirectory(storageFile) && !this.privDelete(storageFile)) {
                throw StandardException.newException("XSDG7.D", this.getLogDirPath(storageFile));
            }
            storageFile = this.getLogDirectory();
            File file = new File(string, "log");
            String[] stringArray = this.privList(file);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file, stringArray[i]);
                    StorageFile storageFile2 = this.logStorageFactory.newStorageFile(storageFile, stringArray[i]);
                    if (this.privCopyFile(file2, storageFile2)) continue;
                    throw StandardException.newException("XSLAR.D", file2, (Object)storageFile2);
                }
            } else {
                throw StandardException.newException("XSLAS.D", file);
            }
            this.logSwitchRequired = true;
        }
    }

    private void preAllocateNewLogFile(StorageRandomAccessFile storageRandomAccessFile) throws IOException, StandardException {
        int n = this.logSwitchInterval - 24;
        int n2 = this.logBufferSize * 2;
        byte[] byArray = new byte[n2];
        int n3 = n / n2;
        int n4 = n % n2;
        try {
            while (n3-- > 0) {
                storageRandomAccessFile.write(byArray);
            }
            if (n4 != 0) {
                storageRandomAccessFile.write(byArray, 0, n4);
            }
            this.syncFile(storageRandomAccessFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StorageRandomAccessFile openLogFileInWriteMode(StorageFile storageFile) throws IOException {
        if (this.isWriteSynced) {
            return this.privRandomAccessFile(storageFile, "rws");
        }
        return this.privRandomAccessFile(storageFile, "rw");
    }

    private String getLogDirPath(StorageFile storageFile) {
        if (this.logDevice == null) {
            return ((Object)storageFile).toString();
        }
        return this.logDevice + this.logStorageFactory.getSeparator() + ((Object)storageFile).toString();
    }

    protected boolean privExists(StorageFile storageFile) {
        return this.runBooleanAction(0, storageFile);
    }

    protected boolean privDelete(StorageFile storageFile) {
        return this.runBooleanAction(1, storageFile);
    }

    protected synchronized StorageRandomAccessFile privRandomAccessFile(StorageFile storageFile, String string) throws IOException {
        this.action = 2;
        this.activeFile = storageFile;
        this.activePerms = string;
        try {
            return (StorageRandomAccessFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    protected boolean privCanWrite(StorageFile storageFile) {
        return this.runBooleanAction(3, storageFile);
    }

    protected boolean privMkdirs(StorageFile storageFile) {
        return this.runBooleanAction(4, storageFile);
    }

    protected synchronized String[] privList(File file) {
        this.action = 8;
        this.toFile = file;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    protected synchronized String[] privList(StorageFile storageFile) {
        this.action = 5;
        this.activeFile = storageFile;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    protected synchronized boolean privCopyFile(StorageFile storageFile, File file) {
        this.action = 6;
        this.activeFile = storageFile;
        this.toFile = file;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    protected synchronized boolean privCopyFile(File file, StorageFile storageFile) {
        this.action = 9;
        this.activeFile = storageFile;
        this.toFile = file;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    protected boolean privRemoveDirectory(StorageFile storageFile) {
        return this.runBooleanAction(7, storageFile);
    }

    private synchronized boolean runBooleanAction(int n, StorageFile storageFile) {
        this.action = n;
        this.activeFile = storageFile;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    public Object run() throws IOException {
        switch (this.action) {
            case 0: {
                return ReuseFactory.getBoolean(this.activeFile.exists());
            }
            case 1: {
                return ReuseFactory.getBoolean(this.activeFile.delete());
            }
            case 2: {
                return this.activeFile.getRandomAccessFile(this.activePerms);
            }
            case 3: {
                return ReuseFactory.getBoolean(this.activeFile.canWrite());
            }
            case 4: {
                return ReuseFactory.getBoolean(this.activeFile.mkdirs());
            }
            case 5: {
                return this.activeFile.list();
            }
            case 6: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((StorageFactory)this.logStorageFactory, this.activeFile, this.toFile));
            }
            case 7: {
                if (!this.activeFile.exists()) {
                    return ReuseFactory.getBoolean(true);
                }
                return ReuseFactory.getBoolean(this.activeFile.deleteAll());
            }
            case 8: {
                return this.toFile.list();
            }
            case 9: {
                return ReuseFactory.getBoolean(FileUtil.copyFile(this.logStorageFactory, this.toFile, this.activeFile));
            }
        }
        return null;
    }
}

