#!/usr/bin/perl

################################################################################
# File: .................. 05testGeteBayOfficialTime.t
# Location: .............. <user_defined_location>/eBay-API/t
# Original Author: ....... Milenko Milanovic
# Last Modified By: ...... Tim Keefer
# Last Modified: ......... 07/03/2008 @ 12:10
#
# Description:
# Simple test installation script that will attempt to make the very simple
# eBay XML API call 'GeteBayOfficialTime'.  This will prove the module is set
# up properly, and at least the intheritance tree of classes is working, along
# with the autogenerated code related to GeteBayOfficialTime.
################################################################################

use lib qw( t/lib );
use TestCommon::Credentials;

BEGIN {

    # Debug use only
    #diag("05.begin - \$::REQUIRED_MODS = $::REQUIRED_MODS");

    # Required Incldues
    # ------------------------------------------------------------------------------
    use strict; use warnings;
    use Test::More tests => 3; # 3 distinct tests.

    SKIP: {

        # Check for the existence of any dependencies on other modules/classes.
        eval {
            require File::Spec;
            require eBay::API::XML::Call::GeteBayOfficialTime;
            require eBay::API::XML::DataType::Enum::AckCodeType;
        };

        # If there was an error given by the eval above, then the user must have
        # skipped the auto-generation phase, or there is some other module
        # dependency that is breaking things, thus we should skip this test.
        if ($@) {
            skip(
                "SKIP 1:  missing modules required for testing:  [ $@ ]\n\n", 2
            );
        }

        # Tests 1-2
        use_ok('eBay::API::XML::Call::GeteBayOfficialTime');
        use_ok('eBay::API::XML::DataType::Enum::AckCodeType');
      
    } # end SKIP block

} # end BEGIN block


# Debug use only
#diag("05.middle - \$::REQUIRED_MODS = $::REQUIRED_MODS");

SKIP: {
    
    # try to load the eBay API credentials
    unless ( TestCommon::Credentials->load() ) {
       skip( "SKIP 2:  Missing eBay API credentials, skipping API tests.", 1 );
    }

    # Generate and instance of the call.
    my $pCall = eBay::API::XML::Call::GeteBayOfficialTime->new();

    # Set all necessary properties for the call.
    $pCall->setDevID($arg_devid) if $arg_devid;
    $pCall->setAppID($arg_appid) if $arg_appid;
    $pCall->setCertID($arg_certid) if $arg_certid;
    $pCall->setAuthToken($arg_authtoken) if $arg_authtoken;

    # Default site to be US (core).
    $pCall->setSiteID('0');

    # Default webservice interface to be Sandbox.
    $pCall->setApiUrl( $arg_api_url );

    # Execute the API call.
    $pCall->execute();

    if ( $arg_verbose ) {
        diag( "Request:"   . $pCall->getHttpRequestAsString() );
        diag( "Response: " . $pCall->getHttpResponseAsString() );    
    }

    # Test 3
    # Determine if the API call was a success.
    is( $pCall->getAck(), eBay::API::XML::DataType::Enum::AckCodeType::Success,
        'Testing API Call "GeteBayOfficialTime" '
    ); 

} # end SKIP block

# Debug use only
#diag("05.end - \$::REQUIRED_MODS = $::REQUIRED_MODS");
