/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class UrlEncoded
extends MultiMap {
    private static Log log = LogFactory.getLog(class$org$mortbay$util$UrlEncoded == null ? (class$org$mortbay$util$UrlEncoded = UrlEncoded.class$("org.mortbay.util.UrlEncoded")) : class$org$mortbay$util$UrlEncoded);
    static /* synthetic */ Class class$org$mortbay$util$UrlEncoded;

    public UrlEncoded(UrlEncoded url) {
        super((Map)url);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String s) {
        super(6);
        this.decode(s, StringUtil.__ISO_8859_1);
    }

    public UrlEncoded(String s, String charset) {
        super(6);
        this.decode(s, charset);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, this, StringUtil.__ISO_8859_1);
    }

    public void decode(String query, String charset) {
        UrlEncoded.decodeTo(query, this, charset);
    }

    public String encode() {
        return this.encode(StringUtil.__ISO_8859_1, false);
    }

    public String encode(String charset) {
        return this.encode(charset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String encode(String charset, boolean equalsForNullValue) {
        StringBuffer result;
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        StringBuffer stringBuffer = result = new StringBuffer(128);
        synchronized (stringBuffer) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = entry.getKey().toString();
                Object list = entry.getValue();
                int s = LazyList.size(list);
                if (s == 0) {
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (equalsForNullValue) {
                        result.append('=');
                    }
                } else {
                    for (int i = 0; i < s; ++i) {
                        if (i > 0) {
                            result.append('&');
                        }
                        Object val = LazyList.get(list, i);
                        result.append(UrlEncoded.encodeString(key, charset));
                        if (val != null) {
                            String str = val.toString();
                            if (str.length() > 0) {
                                result.append('=');
                                result.append(UrlEncoded.encodeString(str, charset));
                                continue;
                            }
                            if (!equalsForNullValue) continue;
                            result.append('=');
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                    }
                }
                if (!iter.hasNext()) continue;
                result.append('&');
            }
            return result.toString();
        }
    }

    public static void decodeTo(String content, MultiMap map) {
        UrlEncoded.decodeTo(content, map, StringUtil.__ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap map, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        value = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        if (key == null) continue block9;
                        map.add(key, value);
                        key = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                value = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, value);
            } else if (mark < content.length()) {
                key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(byte[] data, int offset, int length, MultiMap map, String charset) {
        if (data == null || length == 0) {
            return;
        }
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            try {
                int ix = offset;
                int end = offset + length;
                int ox = offset;
                String key = null;
                String value = null;
                while (ix < end) {
                    byte c = data[ix++];
                    switch ((char)c) {
                        case '&': {
                            value = new String(data, offset, ox, charset);
                            if (key != null) {
                                map.add(key, value);
                                key = null;
                            }
                            ox = offset;
                            break;
                        }
                        case '=': {
                            if (key != null) break;
                            key = new String(data, offset, ox, charset);
                            ox = offset;
                            break;
                        }
                        case '+': {
                            data[ox++] = 32;
                            break;
                        }
                        case '%': {
                            int i0 = 225;
                            byte b0 = (byte)i0;
                            data[ox++] = (byte)((TypeUtil.convertHexDigit(data[ix++]) << 4) + TypeUtil.convertHexDigit(data[ix++]));
                            break;
                        }
                        default: {
                            data[ox++] = c;
                        }
                    }
                }
                if (key != null) {
                    value = new String(data, offset, ox, charset);
                    map.add(key, value);
                }
            }
            catch (UnsupportedEncodingException e) {
                log.warn("EXCEPTION ", e);
            }
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), StringUtil.__ISO_8859_1);
    }

    public static String decodeString(String encoded, String charset) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), charset);
    }

    public static String decodeString(String encoded, int offset, int length, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        byte[] bytes = null;
        int n = 0;
        for (int i = 0; i < length; ++i) {
            char c = encoded.charAt(offset + i);
            if (c < '\u0000' || c > '\u00ff') {
                throw new IllegalArgumentException("Not encoded");
            }
            if (c == '+') {
                if (bytes == null) {
                    bytes = new byte[length * 2];
                    encoded.getBytes(offset, offset + i, bytes, 0);
                    n = i;
                }
                bytes[n++] = 32;
                continue;
            }
            if (c == '%' && i + 2 < length) {
                char cn = encoded.charAt(offset + i + 1);
                byte b = cn >= 'a' && cn <= 'z' ? (byte)(10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(10 + cn - 65) : (byte)(cn - 48));
                cn = encoded.charAt(offset + i + 2);
                b = cn >= 'a' && cn <= 'z' ? (byte)(b * 16 + 10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(b * 16 + 10 + cn - 65) : (byte)(b * 16 + cn - 48));
                if (bytes == null) {
                    bytes = new byte[length * 2];
                    encoded.getBytes(offset, offset + i, bytes, 0);
                    n = i;
                }
                i += 2;
                bytes[n++] = b;
                continue;
            }
            if (n <= 0) continue;
            bytes[n++] = (byte)c;
        }
        if (bytes == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        try {
            return new String(bytes, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, 0, n);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, StringUtil.__ISO_8859_1);
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("EXCEPTION ", e);
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("EXCEPTION ", e);
            return new String(encoded, 0, n);
        }
    }

    public Object clone() {
        return super.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

