# Generated by default/object.tt
package Paws::TimestreamQuery::ColumnInfo;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Paws::TimestreamQuery::Type', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::TimestreamQuery::ColumnInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::TimestreamQuery::ColumnInfo object:

  $service_obj->Method(Att1 => { Name => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::TimestreamQuery::ColumnInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Contains the meta data for query results such as the column names, data
types, and other attributes.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the result set column. The name of the result set is
available for columns of all data types except for arrays.


=head2 B<REQUIRED> Type => L<Paws::TimestreamQuery::Type>

The data type of the result set column. The data type can be a scalar
or complex. Scalar data types are integers, strings, doubles, booleans,
and others. Complex data types are types such as arrays, rows, and
others.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::TimestreamQuery>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

