# SYNOPSIS

    use Proch::N50 qw(getStats getN50);
    
    # Get basic N50
    my $n50 = getN50('assembly.fasta');
    
    # Get comprehensive statistics
    my $stats = getStats('assembly.fasta');
    
    # Get statistics with JSON output
    my $stats_json = getStats('assembly.fasta', 'JSON');
    
    # Get only JSON output
    my $json = jsonStats('assembly.fasta');

# DESCRIPTION

A lightweight module to calculate assembly statistics from FASTA/FASTQ files.
Provides N50, N75, N90, auN metrics, and sequence length distributions.

## getStats()

Calculate N50, N75, N90, auN, and other statistics for a FASTA/FASTQ file.

Parameters:
    $file      - Path to FASTA/FASTQ file
    $wantJSON  - Optional flag to return JSON output
    $customN   - Optional custom N-metric to calculate

Example:
    my $stats = getStats('assembly.fasta', 'JSON', 80);
    print $stats->{json};

## \_calculateMetrics

Internal function to calculate N50, N75, N90, and other metrics

Parameters:
    \\%sizes     - Hash reference of sequence lengths and their frequencies
    $total\_size - Total size of all sequences
    $custom\_n   - Optional custom N-metric to calculate

Returns: ($n50, $min, $max, $auN, $n75, $n90, $nx)

## getN50

Quick function to get only the N50 value for a file.

Parameters:
    $file - Path to FASTA/FASTQ file

Returns: N50 value or 0 on error

## jsonStats

Get statistics in JSON format.

Parameters:
    $file - Path to FASTA/FASTQ file

Returns: JSON string with statistics or undef on error

# BUGS

Please report any bugs or feature requests at:
[https://github.com/telatin/proch-n50/issues](https://github.com/telatin/proch-n50/issues)
