package WordList::Phrase::ZH::Idiom::ChineseTools;

our $DATE = '2016-02-10'; # DATE
our $VERSION = '0.03'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words_contains_unicode",32152,"num_words_contains_whitespace",0,"num_words",32152,"num_words_contains_nonword_chars",0,"shortest_word_len",2,"longest_word_len",10,"avg_word_len",4.04018412540433); # STATS

1;
# ABSTRACT: Chinese idioms (chengyu) from chinese-tools.com

=pod

=encoding UTF-8

=head1 NAME

WordList::Phrase::ZH::Idiom::ChineseTools - Chinese idioms (chengyu) from chinese-tools.com

=head1 VERSION

This document describes version 0.03 of WordList::Phrase::ZH::Idiom::ChineseTools (from Perl distribution WordList-Phrase-ZH-Idiom-ChineseTools), released on 2016-02-10.

=head1 SYNOPSIS

 use WordList::Phrase::ZH::Idiom::ChineseTools;

 my $wl = WordList::Phrase::ZH::Idiom::ChineseTools->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 4.04018412540433 |
 | longest_word_len                 | 10               |
 | num_words                        | 32152            |
 | num_words_contains_nonword_chars | 0                |
 | num_words_contains_unicode       | 32152            |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 2                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-Phrase-ZH-Idiom-ChineseTools>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-Phrase-ZH-Proverb-ChineseTools>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-Phrase-ZH-Idiom-ChineseTools>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<http://www.chinese-tools.com/chinese/chengyu/dictionary>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一丁不识
一不扭众
一世之雄
一世龙门
一丘一壑
一丘之貉
一丝一毫
一丝不挂
一丝不紊
一丝不苟
一丝两气
一丝半粟
一个半个
一个巴掌拍不响
一个萝卜一个坑
一串骊珠
一举一动
一举万里
一举三反
一举两全
一举两得
一举千里
一举成名
一举手之劳
一之为甚
一之已甚
一之谓甚
一乱涂地
一了百了
一了百当
一事不知
一事无成
一五一十
一些半些
一人之交
一人敌
一人有庆
一介不取
一介不苟
一介之善
一介之士
一介之才
一介书生
一仍旧贯
一代不如一代
一代宗臣
一代文宗
一代楷模
一代谈宗
一代风流
一代鼎臣
一以当十
一以当百
一以贯之
一体同心
一佛出世
一倡一和
一倡三叹
一倡百和
一偏之见
一偏之论
一傅众咻
一元复始
一元大武
一决胜负
一决雌雄
一刀两断
一刀两段
一刀切
一分一毫
一分为二
一切万物
一切众生
一刻千金
一剑之任
一力承当
一动不如一静
一劳久逸
一劳永逸
一匡九合
一匡天下
一十八层地狱
一十八般兵器
一十八般武艺
一卧不起
一厢情原
一厢情愿
一去不复返
一双两好
一反其道
一反常态
一反既往
一发千钧
一发破的
一口一声
一口三舌
一口两匙
一口同声
一口同音
一口吸尽西江水
一口咬定
一叶报秋
一叶知秋
一叶落知天下秋
一叶迷山
一叶障目
一吐为快
一吟一咏
一吠百声
一吹一唱
一呵而就
一呼再喏
一呼百应
一呼百诺
一命之荣
一命呜呼
一命归西
一命归阴
一命鸣呼
一品白衫
一哄而上
一哄而散
一哄而起
一唱一和
一唱三叹
一唱百和
一喷一醒
一噎止餐
一嚬一笑
一团和气
一团漆黑
一国三公
一场春梦
一坐一起
一坐尽倾
一坐尽惊
一坐皆惊
一块石头落了地
一块石头落地
一塌刮子
一塌糊涂
一塌胡涂
一壶千金
一壸千金
一夔一契
一夔已足
一夕一朝
一天一地
一天星斗
一夫之勇
一夫之用
一夫当关
一失足成千古恨
一如既往
一孔不达
一孔之见
一字一句
一字一板
一字一泪
一字一珠
一字不易
一字不苟
一字之师
一字兼金
一字千秋
一字千金
一字千钧
一字师
一字褒贬
一字连城
一字长城
一字长蛇阵
一官半职
一定不易
一定不移
一定之规
一客不烦二主
一室生春
一家一火
一家一计
一家之作
一家之学
一家之言
一家之计
一家之辞
一家无二
一家眷属
一家老小
一寒如此
一寸丹心
一寸光阴一寸金
一寸赤心
一射之地
一尘不到
一尘不染
一尘不缁
一尺水十丈波
一尺水翻腾做一丈波
一尺水翻腾做百丈波
一山不藏二虎
一岁三迁
一岁九迁
一岁再赦
一岁载赦
一差两讹
一差二悮
一差二误
一差二错
一差半错
一己之私
一己之见
一帆顺风
一帆风顺
一席之地
一干二净
一干人犯
一年一度
一年之计在于春
一年半载
一床两好
一床锦被遮盖
一应俱全
一座皆惊
一廉如水
一式一样
一弛一张
一张一弛
一弹指顷
一彻万融
一往情深
一往无前
一往直前
一往而深
一得之功
一得之愚
一得之见
一德一心
一心一力
一心一德
一心一意
一心一腹
一心一计
一心一路
一心同体
一心同功
一心同归
一心无二
一念之差
一念之误
一息奄奄
一息尚存
一悲一喜
一意孤行
一成一旅
一成不变
一成不易
一手一脚
一手一足
一手包办
一手托天
一手遮天
一扫而光
一扫而空
一技之长
一把死拿
一抔黄土
一报还一报
一拍即合
一拥而上
一拥而入
一挥九制
一挥而就
一挥而成
一掊土
一接如旧
一推两搡
一掷乾坤
一掷千金
一掷百万
一揽包收
一搭一档
一搭一檔
一搭两用
一支半节
一改故辙
一文不值
一文不名
一文如命
一文钱难倒英雄汉
一斑半点
一斑窥豹
一方之任
一无可取
一无所取
一无所得
一无所成
一无所有
一无所求
一无所知
一无所能
一无所获
一无所长
一无所闻
一无是处
一无长物
一日万几
一日万机
一日万里
一日三复
一日三岁
一日三月
一日三省
一日三秋
一日三覆
一日之长
一日之雅
一日九迁
一日千丈
一日千里
一旦一夕
一时三刻
一时之权
一时之秀
一时之选
一时伯仲
一时千载
一时半刻
一时半晌
一时半霎
一星半点
一晦一明
一暝不视
一暴十寒
一曝十寒
一曲阳关
一望无垠
一望无边
一望无际
一望而知
一朝一夕
一朝之忿
一朝之患
一朝千里
一朝天子一朝臣
一木难支
一本万利
一本正经
一来一往
一来二去
一板一眼
一板三眼
一枕南柯
一枕槐安
一枕邯郸
一枕黄梁
一枕黄粱
一枝一栖
一枝一节
一枝之栖
一柱承天
一柱擎天
一树百获
一栖两雄
一根一板
一梦华胥
一棍子打死
一棒一条痕
一概而论
一榻横陈
一榻胡涂
一槌定音
一模一样
一模二样
一步一个脚印
一步一趋
一步一鬼
一步登天
一死一生
一毛不拔
一毫不差
一毫不染
一毫不苟
一毫千里
一民同俗
一气呵成
一气浑成
一波万波
一波三折
一波才动万波随
一泻万里
一泻千里
一泻百里
一浆十饼
一清二楚
一清二白
一清如水
一渊不两蛟
一溜烟
一潭死水
一点一滴
一点半点
一点灵犀
一熏一莸
一片丹心
一片冰心
一片宫商
一片散沙
一片汪洋
一片焦土
一牛九锁
一牛吼地
一牛鸣
一牛鸣地
一物不知
一物降一物
一狐之掖
一狐之腋
一狠二狠
一献三售
一献三酬
一现昙华
一班一级
一班一辈
一班半点
一琴一鹤
一瓣心香
一生一世
一生一代
一生九死
一男半女
一画开天
一病不起
一百二十行
一盘散沙
一目之士
一目了然
一目五行
一目十行
一目数行
一相情原
一相情愿
一眨巴眼
一瞑不视
一矢双穿
一知半见
一知半解
一知片解
一石二鸟
一碗水端平
一碧万顷
一秉大公
一秉至公
一秉虔诚
一穷二白
一空依傍
一窍不通
一窝蜂
一笑一颦
一笑了之
一笑了事
一笑倾城
一笑千金
一笑百媚
一笑置之
一笔不苟
一笔勾断
一笔勾消
一笔勾销
一笔抹摋
一笔抹杀
一笔抹煞
一筹莫展
一箪一瓢
一箭上垛
一箭之地
一箭之遥
一箭双雕
一箭双鵰
一篑之功
一簧两舌
一索得男
一索成男
一纸千金
一纸空文
一线之路
一线生机
一统天下
一缘一会
一网尽扫
一网打尽
一而光
一股脑儿
一肢一节
一肢半节
一脉同气
一脉相传
一脉相承
一脉相通
一脉香烟
一脚不移
一臂之力
一至于斯
一至于此
一致百虑
一般无二
一般见识
一花独放
一苇可航
一草一木
一落千丈
一薰一莸
一虎不河
一蛇两头
一蟹不如一蟹
一行作吏
一衣带水
一表人才
一表人材
一表人物
一表堂堂
一表非俗
一表非凡
一褱而论
一见了然
一见倾心
一见如故
一见如旧
一见钟情
一视同仁
一览无余
一览无遗
一觞一咏
一触即发
一触即溃
一言一行
一言不发
一言两语
一言丧邦
一言中的
一言为定
一言九鼎
一言以蔽之
一言兴邦
一言千金
一言半句
一言半语
一言半辞
一言堂
一言难尽
一语中人
一语中的
一语双关
一语破的
一语道破
一误再误
一诺千金
一诺无辞
一谦四益
一谷不升
一谷不登
一败如水
一败涂地
一贫如洗
一资半级
一走了之
一跌不振
一路平安
一路神祇
一路福星
一路货色
一路顺风
一路风尘
一路风清
一蹴可几
一蹴而就
一蹴而得
一蹴而成
一蹶不兴
一蹶不振
一身两头
一身两役
一身二任
一身五心
一身是胆
一身而二任
一身都是胆
一轨同风
一轰而散
一辞同轨
一辞莫赞
一迎一和
一还一报
一退六二五
一通百通
一邱之貉
一重一掩
一针一线
一针一缐
一针见血
一钱不值
一钱不名
一钱不落虚空地
一钱如命
一锤子买卖
一锤定音
一长一短
一长两短
一长二短
一长半短
一门同气
一门心思
一问三不知
一闻千悟
一阶半级
一阶半职
一隅三反
一隅之地
一隅之见
一隅之说
一雕双兔
一雷二闪
一面之交
一面之款
一面之缘
一面之识
一面之词
一面之辞
一面之雅
一面如旧
一鞭一条痕
一鞭先着
一鞭先著
一顾倾城
一顾千金
一颦一笑
一风吹
一飞冲天
一饥两饱
一饭三吐哺
一饭之德
一饭千金
一饮一啄
一馈十起
一马一鞍
一马平川
一马当先
一高二低
一鳞一爪
一鳞半爪
一鳞半甲
一鳞片爪
一鳞片甲
一鵰双兔
一鸣惊人
一麾出守
一鼓一板
一鼓作气
一鼻子灰
一鼻孔出气
一齐众楚
一龙一猪
一龙一蛇
丁一卯二
丁一确二
丁公凿井
七七八八
七上八下
七上八落
七了八当
七事八事
七十二行
七口八嘴
七嘴八张
七嘴八舌
七大八小
七子八壻
七子八婿
七孔生烟
七开八得
七张八嘴
七弯八拐
七情六欲
七慌八乱
七手八脚
七扭八歪
七折八扣
七担八挪
七拉八扯
七拱八翘
七拼八凑
七捞八攘
七损八伤
七损八益
七推八阻
七搭八扯
七搭八搭
七擒七纵
七支八搭
七断八续
七日来复
七棱八瓣
七横八竖
七次量衣一次裁
七步之才
七步八叉
七步成章
七步成诗
七歪八扭
七死七生
七死八活
七湾八扭
七湾八拐
七满八平
七生七死
七男八壻
七男八婿
七疮八孔
七病八倒
七病八痛
七相五公
七破八补
七穿八洞
七穿八烂
七窍冒火
七窍玲珑
七窍生烟
七窝八代
七纵七擒
七纵七禽
七纵八横
七老八倒
七老八十
七脚八手
七舌八嘴
七行俱下
七言八语
七贞九烈
七足八手
七返丹
七返还丹
七郤八手
七长八短
七零八碎
七零八落
七青八黄
七颠八倒
七首八脚
七高八低
万万千千
万丈高楼平地起
万不失一
万不得已
万世一时
万世不易
万世师表
万世无疆
万世流芳
万事亨通
万事大吉
万人之敌
万人空巷
万代千秋
万众一心
万全之策
万全之计
万别千差
万刼不复
万劫不复
万变不离其宗
万口一词
万口一谈
万口一辞
万古千秋
万古流芳
万古留芳
万古长存
万古长春
万古长青
万壑争流
万壑千岩
万夫不当
万夫不当之勇
万夫莫当
万头攒动
万家灯火
万家生佛
万寿无疆
万岁千秋
万年无疆
万应灵丹
万应灵药
万念俱寂
万念俱灰
万恨千愁
万户千门
万无一失
万死一生
万死不辞
万死犹轻
万民涂炭
万水千山
万流景仰
万物之灵
万目睚眦
万目睽睽
万签插架
万箭攒心
万箭穿心
万籁俱寂
万籁无声
万紫千红
万绪千头
万绪千端
万缕千丝
万苦千辛
万语千言
万象更新
万象森罗
万贯家私
万贯家财
万赖俱寂
万赖无声
万载千秋
万选青钱
万里无云
万里迢迢
万里长城
万里长征
万里鹏程
万里鹏翼
万马奔腾
万马齐喑
万马齐瘖
丈二和尚
三三两两
三三五五
三三四四
三下五除二
三不拗六
三五成群
三亲六故
三亲六眷
三亲四眷
三人为众
三人成虎
三从四德
三令五申
三位一体
三余读书
三六九等
三兽渡河
三写成乌
三写易字
三冬二夏
三分鼎立
三分鼎足
三十三天
三十六行
三十而立
三占从二
三反四覆
三叠阳关
三句不离本行
三句话不离本行
三台八座
三吐三握
三告投杼
三命而俯
三回九转
三回五次
三坟五典
三复斯言
三复白圭
三天两头
三夫之对
三夫之言
三夫成市虎
三头两日
三头两绪
三头两面
三头八臂
三头六臂
三头六证
三头六面
三头对案
三好两歉
三好两歹
三好二怯
三妻四妾
三姑六婆
三婆两嫂
三媒六证
三宫六院
三家村
三寸不烂之舌
三寸之舌
三对六面
三尸五鬼
三尸暴跳
三山五岳
三差两错
三差五错
三平二满
三年之艾
三年五载
三年化碧
三徙成国
三徙成都
三心两意
三心二意
三思而后行
三思而行
三怨成府
三战三北
三户亡秦
三折肱为良医
三拳不敌四手
三拳两脚
三拳二脚
三推六问
三教九流
三日新妇
三旨相公
三旬九食
三星在天
三星在户
三智五猜
三更半夜
三曹对案
三月不知肉味
三朋四友
三朝五日
三朝元老
三期贤佞
三榜定案
三槐九棘
三步两脚
三毛七孔
三求四告
三江七泽
三江五湖
三汤两割
三汤五割
三沐三熏
三沐三薰
三浴三熏
三浴三衅
三清四白
三灾八难
三灾六难
三熏三沐
三牲五鼎
三环五扣
三班六房
三瓦两巷
三瓦两舍
三生有幸
三番两次
三番五次
三病四痛
三百六十行
三百瓮虀
三百瓮齑
三皇五帝
三盈三虚
三省吾身
三窝两块
三等九格
三等九般
三纲五常
三纸无驴
三缄其口
三翻四复
三翻四覆
三老五更
三老四少
三脚两步
三臡八菹
三臡八葅
三般两样
三节两寿
三茶六礼
三茶六饭
三荤五厌
三薰三沐
三蛇七鼠
三衅三浴
三街两市
三街六巷
三街六市
三言两句
三言两语
三言讹虎
三谏之义
三豕涉河
三贞九烈
三贞五烈
三足鼎立
三跪九叩
三迁之教
三过其门而不入
三迭阳关
三邻四舍
三长两短
三长四短
三阳交泰
三阳开泰
三顾茅庐
三顾草庐
三风十愆
三饥两饱
三首六臂
三马同槽
三魂七魄
三魂出窍
上下一心
上下交困
上下其手
上下同心
上下同欲
上下同门
上交不谄
上兵伐谋
上勤下顺
上医医国
上南落北
上和下睦
上天入地
上好下甚
上嫚下暴
上当学乖
上情下达
上慢下暴
上援下推
上方宝剑
上智下愚
上替下陵
上树拔梯
上根大器
上梁不正下梁歪
上楼去梯
上溢下漏
上漏下湿
上烝下报
上窜下跳
上竿掇梯
上篇上论
上蒸下报
上行下效
上谄下渎
上陵下替
上雨旁风
下不为例
下乔入幽
下乔木入幽谷
下乔迁谷
下井投石
下回分解
下坂走丸
下塞上聋
下学上达
下情上达
下愚不移
下气怡声
下气怡色
下笔千言
下笔如神
下笔成文
下笔成章
下笔成篇
下笔有神
下落不明
下车之始
下车伊始
下车作威
下车泣罪
下逐客令
下里巴人
下阪走丸
下陵上替
下马冯妇
下马威
下马看花
不一而足
不三不四
不上不下
不上不落
不世
不世之业
不世之功
不丰不俭
不丰不杀
不为五斗米折腰
不为已甚
不主故常
不义之财
不乏先例
不乏其人
不习地土
不习水土
不了不当
不了了之
不了而了
不事边幅
不二法门
不亢不卑
不亦乐乎
不亦善夫
不仁不义
不今不古
不以一眚掩大德
不以为奇
不以为意
不以为然
不以为耻
不以人废言
不以辞害志
不伏烧埋
不伤脾胃
不伦不类
不依不饶
不便水土
不修小节
不修边幅
不值一哂
不值一笑
不值一钱
不值一顾
不值一驳
不假思索
不偏不倚
不偏不党
不做不休
不偢不倸
不僧不俗
不入时宜
不共戴天
不关痛痒
不关紧要
不冷不热
不凉不酸
不出所料
不分伯仲
不分彼此
不分玉石
不分畛域
不分皂白
不分胜负
不分轩轾
不分青白
不分青红皂白
不切实际
不刊之书
不刊之典
不刊之论
不刊之说
不到黄河心不死
不加思索
不务正业
不务空名
不劣方头
不动声色
不劳而成
不劳而获
不勤而获
不卑不亢
不即不离
不厌其烦
不厌其繁
不厌其详
不及之法
不古不今
不可一世
不可乡迩
不可企及
不可偏废
不可动摇
不可同日而语
不可名状
不可向迩
不可告人
不可多得
不可奈何
不可开交
不可思议
不可捉摸
不可揆度
不可摸捉
不可收拾
不可救疗
不可救药
不可教训
不可枚举
不可理喻
不可磨灭
不可移易
不可究诘
不可端倪
不可终日
不可胜举
不可胜数
不可胜算
不可胜纪
不可胜言
不可胜计
不可胜记
不可胜道
不可言传
不可言喻
不可言宣
不可言状
不可造次
不可逾越
不可限量
不吃烟火食
不吃羊肉空惹一身膻
不合时宜
不同凡响
不同戴天
不同流俗
不名一文
不名一格
不名一钱
不吐不茹
不吝指教
不吝珠玉
不吝赐教
不咎既往
不咸不淡
不哼不哈
不啻天渊
不因不由
不因人热
不在话下
不堪一击
不堪入目
不堪入耳
不堪其忧
不堪回首
不堪言状
不堪设想
不堪造就
不声不吭
不声不响
不声不气
不壹而三
不壹而足
不复堪命
不失圭撮
不失时机
不失毫厘
不失黍絫
不夷不惠
不奈之何
不好意思
不如归去
不媿下学
不存不济
不存芥蒂
不学无术
不学无识
不宁唯是
不安于位
不安于室
不安其室
不容分说
不容置喙
不容置疑
不容置辩
不寒而栗
不尴不尬
不屈不挠
不屑一顾
不屑教诲
不屑毁誉
不差上下
不差毫厘
不差毫发
不差累黍
不干不净
不干不浄
不平则鸣
不幸而言中
不废江河
不弃草昧
不当不正
不当人子
不待蓍龟
不徇私情
不徐不疾
不得不尔
不得人心
不得其所
不得其死
不得命
不得善终
不得已而为之
不得已而用之
不得开交
不得而知
不得要领
不得违误
不忍卒读
不忘故旧
不忘沟壑
不忙不暴
不忮不求
不念僧面念佛面
不念旧恶
不怀好意
不急之务
不恤人言
不恶而严
不悱不发
不情之请
不惑之年
不惜工本
不愤不启
不愧下学
不愧不作
不愧不怍
不愧屋漏
不慌不忙
不懂装懂
不成三瓦
不成体统
不成器
不打不成相识
不打不相识
不打自招
不抗不卑
不折不扣
不护细行
不拔一毛
不拔之志
不拘一格
不拘于时
不拘小节
不拘形迹
不拘细节
不拘细行
不择手段
不择生冷
不按君臣
不挑之祖
不挠不屈
不挠不折
不揣冒昧
不揪不採
不揪不睬
不揪不采
不擒二毛
不改其乐
不攻自破
不教之教
不教而杀
不教而诛
不敢后人
不敢告劳
不敢掠美
不敢旁骛
不敢自专
不敢苟同
不敢越雷池一步
不敢造次
不敢问津
不敢高攀
不文不武
不断如带
不旋踵
不无小补
不日不月
不时之需
不时之须
不明不白
不易一字
不易之典
不易之论
不是冤家不聚头
不晓世务
不曾序过
不服水土
不期修古
不期然而然
不期而会
不期而同
不期而然
不期而遇
不染一尘
不栉进士
不根之论
不根之谈
不次之位
不次之迁
不欢而散
不欺屋漏
不欺暗室
不欺闇室
不正之风
不步人脚
不死不活
不毛之地
不求甚解
不求闻达
不治之症
不法古不修今
不法常可
不测之忧
不测之祸
不测之罪
不爽毫发
不爽累黍
不牧之地
不猧不魀
不甘后人
不甘寂寞
不甘示弱
不甘雌伏
不甚了了
不生不灭
不由分说
不由自主
不留余地
不疾不徐
不痛不痒
不痴不聋
不登大雅
不登大雅之堂
不白之冤
不直一文
不直一钱
不相上下
不相为谋
不相问闻
不相闻问
不省人事
不看僧面看佛面
不着疼热
不着边际
不瞅不睬
不瞽不聋
不矜不伐
不矜细行
不知丁董
不知不觉
不知世务
不知人间有羞耻事
不知其详
不知凡几
不知利害
不知去向
不知天高地厚
不知头脑
不知好歹
不知寝食
不知就里
不知所云
不知所以
不知所出
不知所厝
不知所可
不知所措
不知所终
不知所言
不知所错
不知死活
不知深浅
不知甘苦
不知疼痒
不知痛痒
不知端倪
不知纪极
不知老之将至
不知者不罪
不知肉味
不知自爱
不知自量
不知薡蕫
不知起倒
不知轻重
不知进退
不知颠倒
不知高下
不知高低
不破不立
不磷不缁
不祥之兆
不祧之宗
不祧之祖
不禁不由
不稂不莠
不稼不穑
不立文字
不管一二
不管三七二十一
不管不顾
不紧不慢
不絶如发
不絶如带
不絶如线
不絶如缕
不絶若线
不约而同
不经世故
不经之语
不经之说
不经之谈
不绝于耳
不绝如发
不绝如带
不绝如线
不绝如缕
不绝若线
不置可否
不置褒贬
不羁之才
不羁之民
不羞当面
不習水土
不翼而飞
不耻下问
不耻最后
不耻相师
不肖子孙
不胜其任
不胜其烦
不胜其苦
不胜杯杓
不胜枚举
不胜桮杓
不胫而走
不能登大雅之堂
不能自已
不能自拔
不能赞一词
不能赞一辞
不脩边幅
不腆之仪
不臣之心
不自满假
不自量力
不舍昼夜
不舞之鹤
不苟言笑
不茶不饭
不药而愈
不落俗套
不落窠臼
不落边际
不蔓不支
不蔓不枝
不虚此行
不虞之誉
不衫不履
不见天日
不见棺材不下泪
不见棺材不落泪
不见经传
不觉技痒
不解之仇
不解之缘
不言不语
不言而信
不言而喻
不言而谕
不计其数
不记前仇
不讳之朝
不讳之路
不讳之门
不识一丁
不识不知
不识东家
不识之无
不识人间有羞耻事
不识大体
不识好歹
不识局面
不识庐山真面目
不识抬举
不识时务
不识泰山
不识起倒
不识马肝
不识高低
不谋同辞
不谋而合
不谋而同
不负众望
不败之地
不贪为宝
不费之惠
不费吹灰之力
不赏之功
不赞一词
不越雷池
不足与谋
不足为凭
不足为外人道
不足为奇
不足为意
不足为据
不足为法
不足为虑
不足为训
不足介意
不足挂齿
不足轻重
不足齿数
不轨之徒
不轻然诺
不辞劳苦
不辞而别
不辟斧钺
不辨真伪
不辨菽粟
不辨菽麦
不辩菽麦
不辱使命
不迁之庙
不过尔尔
不近人情
不近道理
不进则退
不远万里
不远千里
不违农时
不追既往
不通水火
不逞之徒
不速之客
不遑启处
不遑宁处
不遑宁息
不遑暇食
不遑枚举
不遗余力
不遗寸长
不遗巨细
不避斧钺
不避水火
不避汤火
不避艰险
不郎不秀
不问不闻
不问皂白
不问青红皂白
不间不界
不闻不问
不阴不阳
不随以止
不露圭角
不露声色
不露形色
不露神色
不露锋芒
不露锋铓
不顾一切
不顾前后
不顾大局
不顾死活
不食之地
不食周粟
不食烟火
不食马肝
不饥不寒
不饮盗泉
不骄不躁
不齿于人
不龟手药
与世俯仰
与世偃仰
与世推移
与世无争
与世沈浮
与世沉浮
与世浮沉
与世长辞
与世隔绝
与人为善
与众不同
与受同科
与日俱增
与时偕行
与时推移
与时消息
与民同乐
与民更始
与民除害
与物无忤
与物无竞
与狐谋皮
与虎添翼
与虎谋皮
丑声远播
丑媳妇总得见公婆
丑态毕露
丑态百出
丑类恶物
专心一志
专心一意
专心致志
专横跋扈
专欲难成
专精覃思
且住为佳
且食蛤蜊
世上无难事
世代书香
世俗之见
世外桃源
世异时移
世态人情
世态炎凉
世扰俗乱
世掌丝纶
世济其美
世道人心
世道人情
世风日下
丘山之功
业业兢兢
业业矜矜
业峻鸿绩
业精于勤
丛山峻岭
丛轻折轴
丛雀渊鱼
东倒西歪
东偷西摸
东兔西乌
东冲西决
东冲西撞
东冲西突
东劳西燕
东南之宝
东南之秀
东南之美
东南半壁
东南竹箭
东南雀飞
东墙处子
东壁余光
东声西击
东央西告
东央西浼
东奔西向
东奔西撞
东奔西窜
东奔西走
东奔西跑
东奔西逃
东完西缺
东家效颦
东家西舍
东寻西觅
东山之志
东山再起
东山复起
东山高卧
东差西误
东市朝衣
东床之选
东床佳婿
东床坦腹
东床姣婿
东床娇婿
东床娇客
东床快婿
东床择对
东张西张
东张西望
东张西觑
东征西怨
东征西讨
东徙西迁
东怒西怨
东怨西怒
东扬西荡
东扭西捏
东扯西拉
东扯西拽
东扶西倒
东抄西袭
东投西窜
东抹西涂
东拉西扯
东拦西阻
东拼西凑
东挦西扯
东挦西撦
东挨西撞
东挪西借
东挪西凑
东挪西撮
东捞西摸
东捱西问
东掩西遮
东搜西罗
东摇西摆
东撙西节
东播西流
东支西吾
东敲西逼
东方不亮西方亮
东方千骑
东方将白
东施效颦
东曦既驾
东望西观
东来西去
东横西倒
东歪西倒
东洋大海
东流西上
东流西落
东海扬尘
东海捞针
东海逝波
东海鲸波
东涂西抹
东游西荡
东游西逛
东滚西爬
东猎西渔
东猜西揣
东猜西疑
东睃西望
东瞧西望
东砍西斫
东碰西撞
东磕西撞
东穿西撞
东窗事发
东窗事犯
东窗消息
东窗计
东箭南金
东荡西除
东荡西驰
东藏西躲
东补西凑
东西南北
东西南北人
东西南北客
东西南朔
东西易面
东观之殃
东观续史
东观西望
东讨西伐
东讨西征
东诓西骗
东谈西说
东走西撞
东走西顾
东趋西步
东跑西颠
东踅西倒
东蹓西逛
东躲西藏
东躲西跑
东迁西徙
东逃西窜
东道主
东道主人
东道之谊
东遮西掩
东邻西舍
东郭先生
东野巴人
东野败驾
东量西折
东门逐兔
东门黄犬
东闪西挪
东闯西走
东闯西踱
东零西散
东零西碎
东零西落
东风人面
东风入律
东风化雨
东风压倒西风
东风吹马耳
东风射马耳
东风浩荡
东风过耳
东风马耳
东飘西徙
东飘西泊
东飘西荡
东食西宿
东驰西击
东驰西撞
东驰西骋
东鳞西爪
东鸣西应
丝丝入扣
丝分缕析
丝分缕解
丝发之功
丝恩发怨
丝来线去
丝析发解
丝竹中年
丝竹筦弦
丝竹管弦
丝纷栉比
丢三忘四
丢三拉四
丢三落四
丢下耙儿弄扫帚
丢人现眼
丢卒保车
丢盔卸甲
丢盔弃甲
丢盔抛甲
丢魂丢魄
丢魂失魄
两世为人
两两三三
两全其美
两叶掩目
两头三绪
两头三面
两头和番
两头白面
两小无猜
两意三心
两手空空
两次三番
两相情原
两相情愿
两瞽相扶
两耳塞豆
两肋插刀
两肩荷口
两脚书橱
两脚居间
两脚野狐
两般三样
两虎相争
两虎相斗
两袖清风
两豆塞耳
两败俱伤
两道三科
两部鼓吹
两雄不并立
两面三刀
两面二舌
两鬓如霜
两鼠斗穴
严丝合缝
严于律己
严于律已
严刑峻制
严刑峻法
严家饿隶
严惩不贷
严气正性
严阵以待
严陈以待
严霜烈日
丧天害理
丧家之犬
丧家之狗
丧尽天良
丧师辱国
丧心病狂
丧明之痛
丧权辱国
丧胆亡魂
丧胆游魂
丧胆销魂
丧身失节
丧魂失魄
丧魂落魄
个中妙趣
个中滋味
中冓之言
中原逐鹿
中外合璧
中庸之道
中心摇摇
中流一壶
中流一壸
中流击枻
中流击楫
中流底柱
中流砥柱
中立不倚
中西合璧
中道而废
中风狂走
中饱私囊
中馈乏人
中馈犹虚
丰亨豫大
丰功伟绩
丰功厚利
丰功懿德
丰功盛烈
丰功硕德
丰功茂德
丰取刻与
丰墙峭址
丰墙峭阯
丰墙硗下
丰姿冶丽
丰姿绰约
丰富多彩
丰富多采
丰屋之戒
丰屋之祸
丰屋之过
丰屋延灾
丰屋生灾
丰屋蔀家
丰年玉荒年谷
丰年稔岁
丰度翩翩
丰标不凡
丰神异彩
丰神绰约
丰筋多力
丰肌弱骨
丰肌秀骨
丰草长林
丰衣足食
串亲访友
串通一气
临事制变
临事而惧
临军对垒
临军对阵
临别赠言
临别赠语
临危下石
临危不惧
临危不惮
临危不挠
临危不苟
临危不顾
临危制变
临危受命
临危授命
临危致命
临去秋波
临崖勒马
临崖失马
临川羡鱼
临敌卖阵
临敌易将
临文不讳
临时抱佛脚
临机制变
临机制胜
临机应变
临机立断
临机能断
临机设变
临机辄断
临水楼台
临水登山
临池学书
临河欲鱼
临河羡鱼
临深履冰
临深履尾
临深履薄
临渊结网
临渊羡鱼
临渴掘井
临渴穿井
临潼斗宝
临财不苟
临锋决敌
临阵磨刀
临阵磨枪
临阵脱逃
临难不屈
临难不恐
临难不惧
临难不慑
临难不苟
临难不避
临难不顾
临难如归
临难无慑
临难苟免
临难铸兵
临风对月
丸泥封关
丹之所藏者赤
丹书白马
丹书铁券
丹书铁契
丹凤朝阳
丹墀
丹心如故
丹心碧血
丹楹刻桷
丹漆随梦
丹铅甲乙
丹青不渝
丹青妙手
丹黄甲乙
为万安计
为丛驱雀
为五斗米折腰
为人作嫁
为人师表
为人说项
为仁不富
为善最乐
为国为民
为国捐躯
为好成歉
为富不仁
为小失大
为山止篑
为德不卒
为德不终
为恶不悛
为所欲为
为期不远
为民父母
为民请命
为民除害
为法自弊
为渊驱鱼
为虎作伥
为虎傅翼
为虎添翼
为虺弗摧
为蛇添足
为蛇画足
为裘为箕
为非作恶
为非作歹
为鬼为蜮
主一无适
主圣臣良
主守自盗
主客颠倒
主少国疑
主忧臣辱
主情造意
主敬存诚
主文谲谏
丽句清词
丽句清辞
丽藻春葩
举一反三
举一废百
举不胜举
举世无双
举世无敌
举世混浊
举世皆知
举世瞩目
举世闻名
举例发凡
举动荆棘
举十知九
举善荐贤
举国一致
举国上下
举国若狂
举手之劳
举手加额
举手投足
举手相庆
举措不当
举措失当
举无遗策
举枉措直
举案齐眉
举棋不定
举棋若定
举止不凡
举止大方
举止失措
举止娴雅
举止自若
举止言谈
举步生风
举目千里
举目无亲
举直厝枉
举直措枉
举直错枉
举眼无亲
举纲持领
举要删芜
举贤任能
举贤使能
举足轻重
举踵思慕
举踵思望
举重若轻
举首加额
举首奋臂
举首戴目
举鼎拔山
举鼎絶脰
举鼎絶膑
举鼎绝膑
乃心王室
乃我困汝
乃文乃武
乃武乃文
久久不忘
久假不归
久别重逢
久历风尘
久安长治
久居人下
久归道山
久怀慕蔺
久悬不决
久惯牢成
久惯老诚
久旱逢甘雨
久束湿薪
久病成医
久经风霜
久而久之
久要不忘
久负盛名
久闻大名
义不反顾
义不取容
义不容辞
义不生财
义形于色
义愤填胸
义愤填膺
义断恩絶
义断恩绝
义无反顾
义无旋踵
义正词严
义正辞严
义正辞约
义气相投
义浆仁粟
义海恩山
义结金兰
义胆忠肝
义薄云天
义重恩深
之乎者也
之死不渝
之死靡二
之死靡他
之死靡它
乌七八糟
乌合之众
乌天黑地
乌头白马生角
乌头马角
乌帽红裙
乌有先生
乌烟瘴气
乌焉成马
乌焦巴弓
乌白马角
乌衣之游
乌衣子弟
乌衣门第
乌踆兔走
乌集之交
乌集之众
乌面鹄形
乌飞兔走
乌鸟私情
乍暖还寒
乍毛变色
乐不可支
乐不可极
乐不可言
乐不思蜀
乐不极盘
乐业安居
乐事劝功
乐以忘忧
乐善不倦
乐善好义
乐善好施
乐嗟苦咄
乐在其中
乐天任命
乐天安命
乐天知命
乐尽哀生
乐尽悲来
乐山乐水
乐山爱水
乐往哀来
乐成人美
乐新厌旧
乐昌之镜
乐昌分镜
乐昌破镜
乐极则忧
乐极则悲
乐极哀来
乐极悲来
乐极悲生
乐极生哀
乐极生悲
乐此不倦
乐此不疲
乐祸不悛
乐祸幸灾
乐而不厌
乐而不淫
乐而不荒
乐而忘死
乐而忘返
乐行忧违
乐退安贫
乐道好古
乐道安命
乐道安贫
乐道忘饥
乐道遗荣
乔妆打扮
乔妆改扮
乔文假醋
乔松之寿
乔装打扮
乔装改扮
乔迁之喜
乔龙画虎
乖僻邪谬
乖唇蜜舌
乖嘴蜜舌
乘云行泥
乘人之危
乘伪行诈
乘兴而来
乘其不备
乘其不意
乘利席胜
乘势使气
乘坚策肥
乘坚驱良
乘时乘势
乘机打刼
乘机打劫
乘热打铁
乘肥衣轻
乘胜追击
乘胜逐北
乘舆播越
乘虚而入
乘虚蹈隙
乘虚迭出
乘车戴笠
乘轻驱肥
乘间伺隙
乘间投隙
乘间抵隙
乘险抵巇
乘隙捣虚
乘隙而入
乘顺水船
乘风兴浪
乘风破浪
乘风转舵
乘高决水
乘鸾跨凤
乘龙佳壻
乘龙佳婿
乘龙快婿
乘龙配凤
乜斜缠帐
九世之仇
九九归一
九九归原
九五之尊
九仞一篑
九儒十丐
九关虎豹
九原可作
九变十化
九合一匡
九回肠断
九垓八埏
九天九地
九天仙女
九天揽月
九宗七祖
九州四海
九州岛四海
九年之储
九年之蓄
九折臂
九故十亲
九曲回肠
九死一生
九死不悔
九死未悔
九江八河
九泉之下
九洲四海
九流三教
九流人物
九流十家
九流宾客
九流百家
九烈三贞
九牛一毛
九牛一毫
九牛二虎之力
九牛拉不转
九蒸三熯
九行八业
九衢三市
九转功成
九间大殿
九间朝殿
九阍虎豹
九霄云外
九鼎一丝
九鼎不足为重
九鼎大吕
乞儿乘车
乞儿马医
乞哀告怜
乞浆得酒
乞穷俭相
习与体成
习与性成
习为故常
习以为常
习以成俗
习以成性
习俗移人
习俗移性
习惯成自然
习惯自然
习惯若自然
习故安常
习焉不察
习焉不觉
习焉弗察
习而不察
习若自然
习非成俗
习非成是
习非胜是
乡书难寄
乡利倍义
乡壁虚造
书不尽意
书不尽言
书不释手
书囊无底
书声朗朗
书声琅琅
书生之见
书画卯酉
书空咄咄
书缺有间
书读五车
书通二酉
书香世家
书香人家
书香门户
书香门第
买上告下
买上嘱下
买东买西
买官鬻爵
买椟还珠
买爵贩官
买牛卖剑
买牛息戈
买犁卖剑
买犂卖剑
买犊卖刀
买王得羊
买田阳羡
买空卖空
买笑寻欢
买笑迎欢
买笑追欢
买臣覆水
买菜求益
买贱卖贵
买铁思金
买静求安
买马招兵
买马招军
乱七八糟
乱七八遭
乱世凶年
乱世英雄
乱作一团
乱作胡为
乱坠天花
乱头粗服
乱弹琴
乱点鸳鸯
乱琼碎玉
乱箭攒心
乱臣贼子
乱语胡言
乱首垢面
乳声乳气
乳犊不怕虎
乳臭未干
乳臭未除
乳间股脚
乾乾翼翼
乾端坤倪
了不可见
了不长进
了了可见
了如指掌
了无惧色
了然于胸
了然无闻
了若指掌
了身脱命
了身达命
予取予夺
予取予携
予取予求
予夺生杀
予智予雄
予齿去角
争先恐后
争分夺秒
争前恐后
争名夺利
争名竞利
争多论少
争奇斗艳
争妍斗艳
争强好胜
争强斗狠
争强斗胜
争强显胜
争权夺利
争权攘利
争猫丢牛
争短论长
争锋吃醋
争长竞短
争长论短
争风吃醋
争鸡失羊
事不关己
事不宜迟
事不师古
事不有余
事不过三
事与原违
事与心违
事与愿违
事以密成
事倍功半
事出无奈
事出有因
事半功倍
事半功百
事危累卵
事后诸葛亮
事在人为
事在必行
事在萧墙
事实胜于雄辩
事宽则圆
事宽即圆
事往日迁
事必躬亲
事急无君子
事捷功倍
事无三不成
事无二成
事无大小
事无巨细
事无常师
事核言直
事款则圆
事火咒龙
事生肘腋
事缓则圆
事败垂成
事过境迁
事过情迁
事过景迁
事预则立
事齐事楚
二一添作五
二三其德
二三其意
二三君子
二八佳人
二分明月
二姓之好
二心三意
二心两意
二惠竞爽
二把刀
二桃杀三士
二满三平
二竖为虐
二童一马
二缶钟惑
二缶锺惑
二者不可得兼
二话不说
二龙戏珠
于事无补
于今为烈
于呼哀哉
于安思危
于家为国
于心何忍
于心无愧
于飞之乐
亏心短行
云中仙鹤
云中白鹤
云交雨合
云兴霞蔚
云净天空
云合响应
云合景从
云合雾集
云堦月地
云天雾地
云天高谊
云容月貌
云尤雨殢
云屯席卷
云屯星聚
云屯森立
云屯蚁聚
云屯雨集
云屯雾散
云屯雾集
云屯飙散
云屯鸟散
云布雨施
云布雨润
云开见天
云开见日
云开雾散
云开雾释
云心水性
云心鹤眼
云悲海思
云情雨意
云愁海思
云愁雨怨
云扰幅裂
云收雨散
云散风流
云朝雨暮
云期雨信
云期雨约
云树之思
云树遥隔
云梦闲情
云次鳞集
云泥之别
云泥之差
云泥异路
云泥殊路
云消雨散
云消雾散
云涌风飞
云涌飙发
云淡风轻
云烟过眼
云程万里
云程发轫
云窗月帐
云窗月户
云窗雾槛
云窗雾阁
云窗霞户
云罗天网
云翻雨覆
云舒霞卷
云蒸雾集
云蒸霞蔚
云蒸龙变
云行雨施
云行雨洽
云谲波诡
云起雪飞
云起龙襄
云起龙骧
云趋鹜赴
云过天空
云迷雾罩
云迷雾锁
云锦天章
云阶月地
云集响应
云集景从
云集景附
云雨巫山
云雾迷蒙
云霓之望
云飞泥沉
云飞烟灭
云飞雨散
云鬟雾鬓
云龙井蛙
云龙风虎
互为因果
互为表里
互剥痛疮
互相推诿
互相标榜
互通有无
五世其昌
五亲六眷
五体投地
五体投诚
五侯七贵
五侯蜡烛
五光十色
五典三坟
五内俱崩
五内如焚
五冬六夏
五劳七伤
五十步笑百步
五合六聚
五味俱全
五大三粗
五子登科
五尺之僮
五尺之童
五尺竖子
五尺童子
五彩缤纷
五心六意
五抢六夺
五斗折腰
五方杂厝
五方杂处
五日京兆
五月披裘
五月粜新谷
五月飞霜
五步成诗
五毒俱全
五洲四海
五湖四海
五申三令
五男二女
五短身材
五石六鹢
五积六受
五经扫地
五羖大夫
五脊六兽
五脏六腑
五色无主
五色相宣
五色缤纷
五花八门
五花大绑
五花杀马
五蕴皆空
五藏六府
五虚六耗
五行俱下
五行八作
五行并下
五角六张
五言长城
五谷不分
五谷不升
五谷丰熟
五谷丰登
五车腹笥
五里雾
五里雾中
五陵年少
五陵英少
五陵豪气
五雀六燕
五零二落
五零四散
五音六律
五颜六色
五风十雨
五马分尸
五鬼闹判
五黄六月
五鼎万钟
井中求火
井中视星
井井有序
井井有方
井井有条
井井有法
井井有绪
井底之蛙
井底虾蟆
井底虾蟇
井底蛤蟆
井底鸣蛙
井水不犯河水
井渫不食
井渫莫食
井然有序
井然有条
井管拘墟
井臼亲操
井蛙之见
井蛙醯鸡
亘古不灭
亘古亘今
亘古奇闻
亘古新闻
亘古未有
亘古通今
亚肩叠背
亚肩迭背
亟疾苛察
亡不待夕
亡不旋跬
亡不旋踵
亡可奈何
亡命之徒
亡国之器
亡国之声
亡国之社
亡国之音
亡国大夫
亡国灭种
亡国破家
亡戟得矛
亡猿灾木
亡猿祸木
亡矢遗镞
亡秦三户
亡羊之叹
亡羊得牛
亡羊补牢
亡魂丧胆
亡魂丧魄
亡魂失魄
亢心憍气
亢极之悔
亢音高唱
亢龙有悔
交口同声
交口称誉
交口称赞
交口赞誉
交头互耳
交头接耳
交梨火枣
交浅言深
交淡若水
交相辉映
交能易作
交臂历指
交臂失之
交臂相失
交詈聚唾
交颈并头
亥豕相望
亦复如是
亦庄亦谐
亦步亦趋
亦趋亦步
亨嘉之会
享帚自珍
京兆画眉
京兆眉妩
亭亭玉立
亭台楼阁
亲上做亲
亲上成亲
亲临其境
亲仁善邻
亲冒矢石
亲如手足
亲如骨肉
亲密无间
亲当矢石
亲操井臼
亲疏贵贱
亲痛仇快
亲离众叛
亲贤远佞
亹亹不倦
人一己百
人丁兴旺
人不可貌相
人不聊生
人不自安
人世沧桑
人中之龙
人中狮子
人中骐骥
人中龙虎
人之常情
人事不省
人事不知
人事不醒
人事代谢
人云亦云
人亡家破
人亡政息
人亡物在
人亡邦瘁
人人得而诛之
人人皆知
人人自危
人以群分
人仰马翻
人众胜天
人千人万
人单势孤
人去楼空
人取我与
人各有志
人命关天
人命危浅
人喊马嘶
人困马乏
人地生疏
人声鼎沸
人多势众
人多口杂
人多嘴杂
人多手杂
人多阙少
人头畜鸣
人存政举
人定胜天
人寿年丰
人尽其才
人山人海
人己一视
人弃我取
人强胜天
人强马壮
人微望轻
人微权轻
人微言贱
人微言轻
人心不古
人心不足蛇吞象
人心丧尽
人心叵测
人心向背
人心大快
人心如面
人心归向
人心惟危
人心惶惶
人心所向
人心所归
人心涣散
人心皇皇
人心莫测
人心隔肚皮
人心难测
人怕出名猪怕壮
人急偎亲
人急智生
人急计生
人怨天怒
人怨神怒
人情世态
人情世故
人情之常
人情冷暖
人情恟恟
人情汹汹
人我是非
人所共知
人手一册
人才出众
人才济济
人才辈出
人才难得
人文荟萃
人材出众
人来人往
人来客去
人来客往
人杰地灵
人极计生
人模狗样
人欢马叫
人欲横流
人死留名
人民城郭
人浮于事
人浮于食
人涉卬否
人满为患
人烟浩穰
人烟稠密
人琴两亡
人琴俱亡
人琴俱逝
人生七十古来稀
人生何处不相逢
人生如寄
人生如朝露
人生如梦
人生朝露
人生自古谁无死
人生若寄
人生路不熟
人生面不熟
人百其身
人神共嫉
人神共愤
人神同嫉
人离乡贱
人稠物穰
人穷志短
人穷智短
人约黄昏
人给家足
人老珠黄
人自为战
人自为政
人荒马乱
人莫予毒
人言可畏
人言啧啧
人言籍籍
人言藉藉
人语马嘶
人财两失
人财两空
人贫智短
人足家给
人迹罕至
人逢喜事精神爽
人间地狱
人间天上
人间天堂
人间重晚晴
人非土木
人非木石
人非物是
人非草木
人面兽心
人面桃花
人面狗心
亿万斯年
亿兆一心
亿辛万苦
什伍东西
什围伍攻
什袭以藏
什袭珍藏
什袭而藏
仁义之兵
仁义之师
仁义君子
仁义道德
仁人义士
仁人君子
仁人志士
仁同一视
仁心仁术
仁心仁闻
仁柔寡断
仁民爱物
仁浆义粟
仁者能仁
仁至义尽
仁言利博
仁言利溥
仅以身免
仅容旋马
仆仆亟拜
仆仆道途
仆仆风尘
今不如昔
今夕何夕
今愁古恨
今日有酒今日醉
今昔之感
今是昔非
今是昨非
今月古月
今朝有酒今朝醉
今来古往
今生今世
今蝉蜕壳
今蝉蜕殻
今雨新知
今非昔比
仍陋袭简
从一而终
从中作梗
从中渔利
从井救人
从令如流
从俗就简
从俗浮沉
从善如流
从善如登
从善若流
从壁上观
从天而下
从天而降
从头到尾
从头彻尾
从头至尾
从容不迫
从容就义
从容应对
从容自如
从容自若
从宽发落
从心所欲
从恶如崩
从恶是崩
从恶若崩
从流忘反
从谏如流
从轻发落
从长商议
从长计议
从长计较
从风而服
从风而靡
仓卒主人
仓卒之际
仓皇出逃
仓皇失措
仓皇无措
他乡异县
他乡故知
他乡遇故知
他山之石
他山攻错
仗义执言
仗义疎财
仗义疏财
仗势欺人
仗气使酒
仗节死义
仗马寒蝉
付之一叹
付之一炬
付之一笑
付之丙丁
付之东流
付之度外
付之梨枣
付诸一炬
付诸一笑
付诸东流
付诸洪乔
仙姿佚貌
仙姿玉色
仙姿玉貌
仙姿玉质
仙山楼阁
仙山琼阁
仙液琼浆
仙露明珠
仙风道格
仙风道气
仙风道骨
代为说项
代人受过
代人捉刀
代人说项
代代相传
代拆代行
代越庖俎
代马依风
代马望北
令不虚行
令人作呕
令人切齿
令人发指
令人喷饭
令人捧腹
令人注目
令人瞩目
令人神往
令人莫测
令人起敬
令人齿冷
令原之戚
令行如流
令行禁止
以一儆百
以一奉百
以一当十
以一持万
以一知万
以一警百
以不济可
以丰补歉
以为后图
以义割恩
以义断恩
以书为御
以人为鉴
以人为镜
以人废言
以人择官
以众暴寡
以伪乱真
以佚待劳
以假乱真
以偏概全
以儆效尤
以党举官
以公灭私
以养伤身
以冠补履
以冰致蝇
以刑去刑
以刑止刑
以刑致刑
以利相倾
以利累形
以力服人
以功补过
以勤补拙
以升量石
以半击倍
以卵击石
以卵投石
以卵敌石
以叔援嫂
以口问心
以古为鉴
以古为镜
以古制今
以古喻今
以古方今
以古非今
以售其奸
以噎废飡
以噎废餐
以夜继日
以夜继昼
以夜继朝
以夜续昼
以大恶细
以天下为己任
以夷伐夷
以夷制夷
以夷攻夷
以夷治夷
以学愈愚
以守为攻
以宫笑角
以容取人
以小见大
以尽吾齿
以屈求伸
以己度人
以弱制强
以弱胜强
以强凌弱
以强胜弱
以往鉴来
以微知着
以微知著
以德报德
以德报怨
以德服人
以德追祸
以心传心
以心问心
以忍为阍
以快先睹
以怨报德
以恶报恶
以意为之
以意逆志
以慎为键
以戈舂黍
以战养战
以战去战
以手加额
以指挠沸
以指测河
以攻为守
以文乱法
以文会友
以文害辞
以日为年
以日继夜
以暴易暴
以杀去杀
以杀止杀
以权谋私
以权达变
以柔克刚
以柔制刚
以桃代李
以此类推
以毁为罚
以毒攻毒
以毛相马
以水投水
以水投石
以水救水
以水洗血
以水济水
以求一逞
以汤止沸
以汤沃沸
以汤沃雪
以沫相濡
以法为教
以泽量尸
以渴服马
以火去蛾
以火救火
以火止沸
以点带面
以煎止燔
以牙还牙
以狸至鼠
以狸致鼠
以狸饵鼠
以玉抵乌
以玉抵鹊
以珠弹雀
以理服人
以疏间亲
以疑决疑
以白为黑
以白诋青
以直报怨
以直抱怨
以眼还眼
以瞽引瞽
以石投卵
以石投水
以碫投卵
以礼相待
以私害公
以私废公
以筌为鱼
以筦窥天
以筳撞锺
以简御繁
以简驭繁
以管窥天
以管窥豹
以类相从
以索续组
以紫为朱
以紫乱朱
以终天年
以绝后患
以羊易牛
以老卖老
以耳为目
以耳代目
以肉去蚁
以肉啖虎
以肉喂虎
以肉餧虎
以肉驱蝇
以胶投漆
以荷析薪
以莛叩钟
以莛扣钟
以莛撞钟
以蚓投鱼
以螳当车
以蠡测海
以血洗血
以观后効
以观后效
以规为瑱
以言为讳
以言举人
以言取人
以言徇物
以誉为赏
以誉进能
以计代战
以讹传讹
以词害意
以貌取人
以貍至鼠
以身作则
以身报国
以身殉国
以身殉职
以身许国
以身试法
以身试险
以辞取人
以辞害意
以退为进
以逸击劳
以逸待劳
以邻为壑
以郄视文
以酒解酲
以铢称镒
以铢程镒
以锥刺地
以锥飡壶
以锥飡壸
以锥餐壶
以镒称铢
以防万一
以防不测
以骨去蚁
以鱼驱蝇
以鹿为马
以黑为白
仪态万千
仪态万方
仪表堂堂
仪静体闲
仰不愧天
仰之弥高
仰事俛畜
仰事俯畜
仰事俯育
仰人眉睫
仰人鼻息
仰取俯拾
仰屋着书
仰屋窃叹
仰屋著书
仰拾俯取
仰而赋诗
仰观俯察
仰面唾天
仰面朝天
仰首伸眉
价值连城
价增一顾
价廉物美
价等连城
任人唯亲
任人唯贤
任其自流
任其自然
任劳任怨
任怨任劳
任贤使能
任达不拘
任重才轻
任重至远
任重致远
任重道悠
任重道远
仿徨失措
企踵可待
伈伈睍睍
伉俪情深
伊于胡底
伊何底止
伏低做小
伏地圣人
伏法受诛
伏而咶天
伏虎降龙
伏首贴耳
伏龙凤雏
伐冰之家
伐功矜能
伐异党同
伐性之斧
伐毛换髓
伐毛洗髓
伐罪吊人
伐罪吊民
休休有容
休兵罢战
休养生息
休声美誉
休戚与共
休戚相关
休明盛世
休牛归马
休牛散马
众人国士
众人广坐
众人拾柴火焰高
众叛亲离
众口一词
众口一辞
众口交传
众口交詈
众口交赞
众口同声
众口嗷嗷
众口如一
众口熏天
众口相传
众口纷纭
众口铄金
众口销金
众口难调
众啄同音
众喣山动
众喣漂山
众喣飘山
众嘘漂山
众多非一
众好众恶
众寡不敌
众寡势殊
众寡悬殊
众寡悬絶
众寡悬绝
众少成多
众川赴海
众心如城
众心成城
众志成城
众怒难任
众怒难犯
众怨之的
众所共知
众所周知
众所瞩目
众擎易举
众星拱北
众星拱月
众星拱极
众星捧月
众星攒月
众星环极
众望所归
众望攸归
众楚羣咻
众楚群咻
众毁销骨
众毛攒裘
众毛飞骨
众流归海
众犬吠声
众目共睹
众目共视
众目具瞻
众目昭彰
众目睽睽
众盲摸象
众矢之的
众虎同心
众议成林
众说纷揉
众说纷纭
众醉独醒
众难羣疑
众难群疑
众难群移
优哉游哉
优孟衣冠
优昙一现
优柔厌饫
优柔寡断
优柔餍饫
优游不断
优游卒岁
优游岁月
优游涵泳
优游自在
优游自如
优游自得
优游自若
优游自适
优胜劣败
优贤扬历
优贤飏历
会家不忙
会少离多
会者不忙
会逢其适
会道能说
伟绩丰功
传为佳话
传为笑柄
传为笑谈
传为美谈
传圭袭组
传宗接代
传杯弄盏
传杯换盏
传柄移藉
传檄而定
传爵袭紫
传神阿堵
传经送宝
传诵一时
传道受业
传闻不如亲见
传闻异辞
传风扇火
传风搧火
传龟袭紫
伤化败俗
伤天害理
伤弓之鸟
伤心惨目
伤心疾首
伤心蒿目
伤教败俗
伤筋动骨
伤言扎语
伤风败俗
伤风败化
伯乐一顾
伯乐相马
伯仲之间
伯仲叔季
伯劳飞燕
伯埙仲篪
伯歌季舞
伯玉知非
伯道无儿
伴食中书
伴食宰相
伶仃孤苦
伶俐乖巧
伶牙俐齿
伸冤理枉
伸头探脑
伸头缩颈
伸手不见五指
伺瑕导蠙
伺瑕导隙
伺瑕抵蠙
伺瑕抵隙
似懂非懂
似是而非
似曾相识
似有如无
似水如鱼
似水流年
似漆如胶
似笑非笑
似箭在弦
似醉如痴
位不期骄
位卑言高
位极人臣
低三下四
低吟浅唱
低唱浅斟
低唱浅酌
低回不已
低声下气
低声哑气
低声细语
低头丧气
低头哈腰
低头搭脑
低头耷脑
低心下意
低情曲意
低眉垂眼
低眉折腰
低眉顺眼
低首下心
低首下气
佐雍得尝
佐饔得尝
体国经野
体大思精
体恤入微
体无完皮
体无完肤
体物缘情
体规画圆
体贴入妙
体贴入微
何乐不为
何乐而不为
何其毒也
何其相似乃尔
何其衰也
何去何从
何德堪之
何必当初
何患无辞
何所不为
何所不有
何所不至
何罪之有
何足为奇
何足介意
何足挂齿
何足道哉
余业遗烈
余光分人
余勇可贾
余味无穷
余响绕梁
余响遶梁
余声三日
余妙绕梁
余子碌碌
余杯冷炙
余桃啖君
余波未平
余烬复燃
余腥残秽
余膏剩馥
余霞成绮
余霞散绮
余音绕梁
余音缭绕
余音袅袅
余韵流风
余风遗文
余食赘行
佛口蛇心
佛头加秽
佛头着粪
佛头著粪
佛心蛇口
佛性禅心
佛眼佛心
佛眼相看
作作有芒
作古正经
作善降祥
作壁上观
作奸犯科
作奸犯罪
作好作歹
作如是观
作威作福
作嫁衣裳
作小服低
作恶多端
作歹为非
作法自弊
作法自毙
作浪兴风
作福作威
作育人材
作舍道旁
作舍道边
作茧自缚
作言造语
作贼心虚
作辍无常
作金石声
你唱我和
你夺我争
你死我活
你追我赶
佣中佼佼
佩紫怀黄
佩韦佩弦
佯轮诈败
佯输诈败
佯风诈冒
佳人才子
佳人薄命
佳儿佳妇
佳兵不祥
佴之蚕室
佶屈聱牙
佹形僪状
佹得佹失
佻身飞镞
使乖弄巧
使功不如使过
使嘴使舌
使心作倖
使心作幸
使心别气
使心用倖
使心用幸
使心用腹
使性傍气
使性掼气
使性谤气
使愚使过
使料所及
使智使勇
使羊将狼
使臂使指
使蚊负山
使贤任能
使贪使愚
使酒骂坐
使酒骂座
侃侃而言
侃侃而谈
侃侃訚訚
侃侃誾誾
侃侃谔谔
侃然正色
侈丽闳衍
侈人观听
侈侈不休
侈恩席宠
侈纵偷苟
侈衣美食
例直禁简
例行公事
例行差事
侍执巾栉
侍执巾节
侏儒一节
侏儒观戏
侔色揣称
供不应求
供过于求
侜张为幻
依丱附木
依人篱下
依依不舍
依依惜别
依头缕当
依头顺尾
依山傍水
依心像意
依本画葫芦
依样画葫芦
依样葫芦
依法炮制
依法砲制
依流平进
依然如故
依然故我
依经傍注
依翠偎红
依艹附木
依草附木
依葫芦画瓢
依违两可
依门傍户
依门卖笑
依阿取容
侠肝义胆
侧目而视
侧足而立
侭多侭少
侯服玉食
侯门似海
侯门如海
便宜从事
便宜施行
便宜行事
便辞巧说
便还就孤
促膝谈心
俊杰廉悍
俎樽折冲
俏成俏败
俐齿伶牙
俗下文字
俗不可医
俗不可耐
俗谚口碑
俛拾仰取
俛拾地芥
俛首帖耳
保国安民
保境息民
保家卫国
保残守缺
保泰持盈
保盈持泰
俟河之清
信以为真
信及豚鱼
信口开合
信口开呵
信口开喝
信口开河
信口胡言
信口雌黄
信守不渝
信手拈来
信步而行
信笔涂鸦
信而好古
信而有征
信而有证
信言不美
信誓旦旦
信赏必罚
信马由缰
俨乎其然
俭不中礼
俭以养廉
俭以养德
俭可养廉
俭存奢失
俭故能广
俭腹高谈
修心养性
修文偃武
修旧起废
修桥补路
修真养性
修短随化
修身洁行
修辞立诚
修饰边幅
修鳞养爪
修齐治平
俯仰之间
俯仰唯唯
俯仰无愧
俯仰由人
俯仰随人
俯拾仰取
俯拾即是
俯拾地芥
俯拾皆是
俯首听命
俯首就缚
俯首帖耳
俯首弭耳
俯首戢耳
俯首贴耳
俱收并蓄
俾夜作昼
俾昼作夜
倍日并行
倍道兼行
倍道兼进
倍道而行
倍道而进
倏忽之间
倒三颠四
倒冠落佩
倒冠落珮
倒凤颠鸾
倒因为果
倒屣相迎
倒山倾海
倒峡泻河
倒廪倾囷
倒悬之危
倒悬之急
倒悬之苦
倒戈卸甲
倒戢干戈
倒打一瓦
倒打一耙
倒执手版
倒持太阿
倒持干戈
倒持戈矛
倒持手板
倒持泰阿
倒果为因
倒海翻江
倒箧倾囊
倒箧倾筐
倒绷孩儿
倒置干戈
倒背如流
倒行逆施
倒街卧巷
倒裳索领
倒载干戈
倔头强脑
倔强倨傲
倘来之物
倚人卢下
倚人庐下
倚傍门户
倚势凌人
倚天拔地
倚姣作媚
倚官仗势
倚官挟势
倚强凌弱
倚玉偎香
倚翠偎红
倚老卖老
倚草附木
倚财仗势
倚门倚闾
倚门傍户
倚门卖俏
倚门卖笑
倚门献笑
倚门窥户
倚闾望切
倚马七纸
倚马千言
倚马可待
倜傥不羁
倜傥不羣
倜傥不群
借书留真
借交报仇
借公行私
借刀杀人
借剑杀人
借古喻今
借古讽今
借坡下驴
借客报仇
借尸还阳
借尸还魂
借景生情
借水推船
借水行舟
借箸代筹
借篷使风
借花献佛
借贷无门
借身报仇
借酒浇愁
借镜观形
借面吊丧
借题发挥
借风使船
倡情冶思
倡条冶叶
倡而不和
倦尾赤色
倦鸟知还
倩人捉刀
倩女离魂
债台高筑
债多不愁
倾国倾城
倾城倾国
倾家破产
倾家竭产
倾家荡产
倾家败产
倾巢出动
倾巢而出
倾心吐胆
倾抱写诚
倾摇懈弛
倾柯卫足
倾盆大雨
倾盖如故
倾筐倒庋
倾筐倒箧
倾箱倒箧
倾耳注目
倾耳细听
倾耳而听
倾肝沥胆
倾肠倒肚
偃兵修文
偃旗仆鼓
偃旗卧鼓
偃旗息鼓
偃武休兵
偃武修文
偃武兴文
偃武崇文
偃武息戈
偃武櫜兵
偃武行文
偃武觌文
偃甲息兵
偃革为轩
偃革倒戈
偃革尚文
偃鼠饮河
假人假义
假人辞色
假仁假义
假仁假意
假以辞色
假公济私
假公营私
假力于人
假名托姓
假惺惺
假慈悲
假戏真做
假手于人
假痴不癫
假痴假呆
假眉三道
假虎张威
假誉驰声
假途灭虢
假道灭虢
假门假事
假门假氏
偎干就湿
偎慵堕懒
偎红倚翠
偏三向四
偏乡僻壤
偏信则暗
偏听偏信
偏听偏言
偕生之疾
做一天和尚撞一天钟
做一日和尚撞一天钟
做一日和尚撞一日钟
做人做世
做刚做柔
做好做恶
做好做歹
做小伏低
做张做势
做张做智
做张做致
做神做鬼
做贼心虚
做鬼做神
停云落月
停妻再娶
停滞不前
停留长智
停辛伫苦
停辛贮苦
健步如飞
偭规越矩
偭规错矩
偶一为之
偶变投隙
偷东摸西
偷偷摸摸
偷合取容
偷合苟从
偷合苟容
偷声细气
偷天换日
偷媚取容
偷安旦夕
偷寒送暖
偷工减料
偷梁换柱
偷狗戏鸡
偷营劫寨
偷闲躲静
偷香窃玉
偷鸡不着蚀把米
偷鸡摸狗
偷鸡盗狗
偿其大欲
傅粉何郎
傅粉施朱
傍人篱壁
傍人篱落
傍人门户
傍花随柳
傍若无人
傍观冷眼
傍观者清
傥来之物
傫如丧狗
催人泪下
傲不可长
傲世轻物
傲头傲脑
傲慢不逊
傲慢少礼
傲慢无礼
傲然屹立
傲然挺立
傲睨一世
傲睨一切
傲睨万物
傲睨得志
傲睨自若
傲贤慢士
傲雪凌霜
傲雪欺霜
傲霜斗雪
傲骨嶙嶙
傻头傻脑
像形夺名
像心像意
像心如意
像心称意
像心适意
像模像样
像模象样
像煞有介事
僭赏滥刑
僵李代桃
僵桃代李
僻字涩句
儋石之储
儒雅风流
儗不于伦
儗非其伦
儿女之情
儿女亲家
儿女姻亲
儿女子语
儿女心肠
儿女情长
儿女成行
儿怜兽扰
儿童之见
儿童走卒
允执其中
允执厥中
允文允武
元元之民
元元本本
元奸巨恶
元恶大奸
元恶大憝
元戎启行
元方季方
元经秘旨
元龙豪气
元龙高卧
兄友弟恭
兄弟怡怡
兄弟阋墙
兄死弟及
兄肥弟瘦
充天塞地
充栋汗牛
充栋盈车
充箱盈架
充类至尽
充耳不闻
充闾之庆
充饥画饼
兆载永劫
先下手为强
先人后己
先代所美
先入为主
先入之见
先公后私
先发制人
先号后庆
先号后笑
先圣先师
先声后实
先声夺人
先天不足
先得我心
先忧后乐
先悉必具
先意希旨
先意承志
先意承指
先意承旨
先意承颜
先我着鞭
先斩后奏
先断后闻
先来后到
先河后海
先睹为快
先知先觉
先礼后兵
先笑后号
先自隗始
先花后果
先行后闻
先覩为快
先见之明
先难后获
先驱蝼蚁
光前启后
光前絶后
光前绝后
光前裕后
光华夺目
光可鉴人
光复旧物
光天化日
光宗耀祖
光彩夺目
光彩溢目
光彩耀目
光彩陆离
光怪陆离
光明正大
光明磊落
光焰万丈
光芒万丈
光车骏马
光辉灿烂
光采夺目
光阴似箭
光阴如箭
光阴荏苒
光风霁月
克伐怨欲
克传弓冶
克俭克勤
克勤克俭
克嗣良裘
克尽厥职
克己复礼
克己奉公
克己慎行
克敌制胜
克爱克威
克绍箕裘
克肩一心
克逮克容
免开尊口
免怀之岁
兔丝燕麦
兔头麞脑
兔死凫举
兔死犬饥
兔死狐悲
兔死狗烹
兔缺乌沈
兔缺乌沉
兔葵燕麦
兔角牛翼
兔角龟毛
兔走乌飞
兔走鹘落
兔起乌沉
兔起凫举
兔起鹘落
党同伐异
党同妒异
党同妬异
党坚势盛
党恶佑奸
党豺为虐
党邪丑正
党邪陷正
兜肚连肠
兢兢业业
兢兢乾乾
兢兢干干
兢兢战战
兢兢翼翼
入不敷出
入主出奴
入乡问俗
入乡随俗
入井望天
入吾彀中
入国问俗
入土为安
入圣超凡
入地无门
入境问俗
入境问禁
入孝出弟
入孝出悌
入宝山而空回
入室升堂
入室操戈
入室昇堂
入幕之宾
入情入理
入文出武
入木三分
入死出生
入海算沙
入火赴汤
入理切情
入竟问禁
入邦问俗
入铁主簿
入门问讳
入阁登坛
入骨相思
全军覆没
全军覆灭
全力以赴
全功尽弃
全受全归
全国一盘棋
全始全终
全心全意
全无心肝
全智全能
全民皆兵
全璧归赵
全盘托出
全知全能
全神关注
全神灌注
全神贯注
全能全智
全身远害
八万四千
八九不离十
八仙过海
八字打开
八字没一撇
八字没见一撇
八府巡按
八拜之交
八斗之才
八方呼应
八方支持
八方支援
八方风雨
八牕玲珑
八珍玉食
八百孤寒
八窗玲珑
八纮同轨
八荒之外
八街九陌
八难三灾
八面受敌
八面圆通
八面威风
八面张罗
八面玲珑
八面莹澈
八面见光
八面驶风
八音迭奏
八音遏密
公之于众
公买公卖
公事公办
公听并观
公子哥儿
公子王孙
公尔忘私
公平交易
公平合理
公平无私
公平正直
公忠体国
公才公望
公报私仇
公报私雠
公明正大
公是公非
公正不阿
公正廉明
公正廉洁
公正无私
公私两便
公私两利
公私两济
公私交困
公私兼顾
公而忘私
公耳忘私
公规密谏
公诸同好
公道合理
公门桃李
六亲不认
六亲无靠
六出奇计
六出纷飞
六合之内
六尘不染
六尺之孤
六尺之托
六尺之讬
六月飞霜
六朝金粉
六根清净
六根清浄
六根清静
六畜不安
六畜兴旺
六神不安
六神无主
六耳不同谋
六臂三头
六街三市
六街三陌
六趣轮回
六通四辟
六通四达
六道轮回
六问三推
六韬三略
六马仰秣
兰因絮果
兰心蕙性
兰情蕙性
兰摧玉折
兰桂齐芳
兰熏桂馥
兰艾同焚
兰艾难分
兰芝常生
兰芷之室
兰薰桂馥
兰质熏心
兰质蕙心
兰质薰心
共为唇齿
共商国是
共挽鹿车
共枝别干
共贯同条
关山迢递
关山阻隔
关心民瘼
关怀备至
关情脉脉
关门大吉
关门打狗
关门落闩
兴云致雨
兴亡祸福
兴亡继絶
兴亡继绝
兴会淋漓
兴兵动众
兴利除害
兴利除弊
兴味索然
兴如嚼蜡
兴妖作乱
兴妖作孽
兴妖作怪
兴家立业
兴师动众
兴师问罪
兴废继絶
兴废继绝
兴微继絶
兴微继绝
兴文匽武
兴灭继絶
兴灭继绝
兴致勃勃
兴致淋漓
兴致索然
兴观群怨
兴讹造讪
兴词构讼
兴趣盎然
兴邦立国
兴风作浪
兴高彩烈
兴高采烈
兵不厌权
兵不厌诈
兵不接刃
兵不污刃
兵不由将
兵不血刃
兵不雪刃
兵临城下
兵凶战危
兵出无名
兵在其颈
兵在精而不在多
兵多将广
兵多者败
兵强则灭
兵强将勇
兵强马壮
兵微将寡
兵慌马乱
兵戈扰攘
兵戎相见
兵拏祸结
兵无常势
兵无常形
兵无血刃
兵未血刃
兵精粮足
兵荒马乱
兵行诡道
兵败如山倒
兵贵先声
兵贵神速
兵车之会
兵连祸接
兵连祸结
兵销革偃
兵闻拙速
其乐不穷
其乐无穷
其势汹汹
其味无穷
其应如响
其应若响
其貌不扬
其道亡繇
其道无由
具体而微
具自陈道
具食与乐
典则俊雅
典妻鬻子
典章文物
典谟训诰
典身卖命
兹事体大
养儿防老
养威蓄鋭
养威蓄锐
养家活口
养家糊口
养尊处优
养晦韬光
养生丧死
养生之道
养生送死
养生送终
养痈成患
养痈贻患
养痈遗患
养精畜锐
养精蓄鋭
养精蓄锐
养老送终
养虎为患
养虎伤身
养虎留患
养虎自啮
养虎自残
养虎自毙
养虎自贻灾
养虎自遗患
养虎自齧
养虎贻患
养虎遗患
养虺成蛇
养贤纳士
养鋭蓄威
养锐蓄威
养音九皋
养鹰扬去
养鹰飏去
兼人之勇
兼包并容
兼包并畜
兼善天下
兼官重绂
兼容并包
兼容并蓄
兼弱攻昧
兼收博采
兼收并录
兼收并畜
兼收并蓄
兼收并采
兼收并録
兼朱重紫
兼权尚计
兼权熟计
兼爱无私
兼程前进
兼程并进
兼而有之
兼葭倚玉
兼葭秋水
兼览博照
兽困则噬
兽心人面
兽穷则啮
兽穷则齧
兽聚鸟散
兽迒鸟迹
冁然而笑
内修外攘
内助之贤
内圣外王
内外交困
内外夹攻
内峻外和
内忧外侮
内忧外患
内柔外刚
内查外调
内省不疚
内视反听
内顾之忧
再三再四
再不其然
再作冯妇
再作道理
再做道理
再实之根必伤
再接再历
再接再厉
再接再砺
再生父母
再衰三涸
再衰三竭
再造之恩
冒名接脚
冒名顶替
冒大不韪
冒天下之大不韪
冗词赘句
军不血刃
军临城下
军令如山
军法从事
冠上加冠
冠上履下
冠冕堂皇
冠履倒易
冠履倒置
冠屦倒施
冠山戴粒
冠盖如云
冠盖相望
冠绝一时
冠袍带履
冢中枯骨
冢木已拱
冤冤相报
冤天屈地
冤家对头
冤家路狭
冤家路窄
冤沉海底
冥思苦想
冥思苦索
冥昭瞢闇
冥漠之乡
冥漠之都
冥行擿埴
冥行盲索
冥顽不灵
冬扇夏炉
冬日可爱
冬日夏云
冬温夏凊
冬温夏清
冬烘先生
冬烘头脑
冬箑夏裘
冬裘夏葛
冯唐头白
冯唐已老
冯唐易老
冯唐白首
冯河暴虎
冯生弹铗
冯驩弹铗
冰壶秋月
冰壸秋月
冰天雪地
冰天雪窑
冰天雪窖
冰寒于水
冰山易倒
冰山难靠
冰心一片
冰散瓦解
冰洁渊清
冰洁玉清
冰消云散
冰消冻解
冰消瓦解
冰消雪释
冰消雾散
冰清水冷
冰清玉洁
冰清玉润
冰清玉粹
冰炭不同器
冰炭不同炉
冰炭不投
冰炭不相容
冰肌玉骨
冰肌雪肠
冰解云散
冰解冻释
冰解壤分
冰解的破
冰销叶散
冰销雾散
冰雪严寒
冰雪聪明
冰魂素魄
冰魂雪魄
冲云破雾
冲冠发怒
冲冠怒发
冲冠眦裂
冲口而出
冲坚毁锐
冲州撞府
冲州过府
冲昏头脑
冲锋陷坚
冲锋陷鋭
冲锋陷锐
冲锋陷阵
冲风冒雨
冲风破浪
决一死战
决一胜负
决一雌雄
决不待时
决命争首
决断如流
决疣溃痈
决胜于千里之外
决胜千里
决胜庙堂
冶叶倡条
冶容诲淫
冷嘲热讽
冷嘲热骂
冷心冷面
冷暖自知
冷水浇头
冷水浇背
冷灰爆豆
冷牕冻壁
冷眼旁观
冷眼相待
冷眼静看
冷窗冻壁
冷若冰霜
冷血动物
冷言冷语
冷言热语
冷语冰人
冷酷无情
冷锅里爆豆
冷面寒铁
冻浦鱼惊
冻解冰释
凄入肝脾
凄然泪下
凄风冷雨
凄风寒雨
凄风楚雨
凄风苦雨
凌上虐下
凌云之志
凌弱暴寡
凌杂米盐
凌霄之志
减师半德
凛如霜雪
凛若冰霜
凛若秋霜
凝瞩不转
凝脂点漆
几不欲生
几尽一刻
几次三番
凡偶近器
凡夫俗子
凡夫肉眼
凡才浅识
凡桃俗李
凡胎浊体
凡胎浊骨
凡胎肉眼
凤仪兽舞
凤冠霞帔
凤凰于飞
凤凰在笯
凤凰来仪
凤协鸾和
凤友鸾交
凤友鸾谐
凤只鸾孤
凤叹虎视
凤吟鸾吹
凤子龙孙
凤引九雏
凤彩鸾章
凤愁鸾怨
凤枭同巢
凤楼龙阙
凤歌鸾舞
凤毛济美
凤毛鸡胆
凤毛麟角
凤毛龙甲
凤泊鸾漂
凤泊鸾飘
凤狂龙躁
凤皇于蜚
凤皇于飞
凤皇来仪
凤管鸾笙
凤管鸾箫
凤箫鸾管
凤箫龙管
凤翥鸾回
凤翥鸾翔
凤翥鹏翔
凤翥龙翔
凤翥龙蟠
凤翥龙骧
凤臆龙鬐
凤舞鸾歌
凤舞龙蟠
凤舞龙飞
凤表龙姿
凤采鸾章
凤附龙攀
凤雏麟子
凤靡鸾吪
凤食鸾栖
凤骨龙姿
凤髓龙肝
凤鸣朝阳
凤鸣鹤唳
凤鸣麟出
凫居雁聚
凫短鹤长
凫胫鹤膝
凫趋雀跃
凫鹤从方
凭几之诏
凭几据杖
凭城借一
凭白无故
凭空捏造
凭空揑造
凭虚公子
凭轼旁观
凭轼结辙
凶喘肤汗
凶多吉少
凶年饥岁
凶相毕露
凶神恶煞
凶终隙未
凶终隙末
出一头地
出丑扬疾
出丑放乖
出世离群
出世超凡
出乎反乎
出乎意外
出乎意料
出乎意表
出乎预料
出乖弄丑
出乖露丑
出于意外
出于意表
出于无奈
出云入泥
出人头地
出人意外
出人意料
出人意表
出人望外
出以公心
出何典记
出何经典
出入人罪
出入将相
出入无间
出入生死
出入神鬼
出公忘私
出其不备
出其不意
出其不虞
出内之吝
出凡入胜
出出律律
出卖灵魂
出口伤人
出口入耳
出口成章
出圣入神
出处殊涂
出处殊途
出处语默
出处进退
出头之日
出头露面
出夷入险
出奇不穷
出奇划策
出奇制胜
出奇取胜
出奇无穷
出奇致胜
出奴入主
出将入相
出尔反尔
出尘不染
出山泉水
出师不利
出师无名
出师有名
出幽升高
出幽迁乔
出手得卢
出敌不意
出敌意外
出文入武
出有入无
出死入生
出死断亡
出水芙蓉
出污泥而不染
出没不常
出没无常
出浅入深
出淤泥而不染
出生入死
出神入化
出神入定
出类拔萃
出纳之吝
出羣拔萃
出群拔萃
出自意外
出舆入辇
出言不逊
出言吐气
出言吐词
出言吐语
出言成章
出言无状
出言有章
出词吐气
出语成章
出谋划策
出谋献策
出谋画策
出谷迁乔
出门合辙
出门如宾
出门应辙
出陈易新
出震继离
出鬼入神
击中要害
击其不意
击壤鼓腹
击排冒没
击搏挽裂
击楫中流
击毂摩肩
击玉敲金
击电奔星
击石弹丝
击碎唾壶
击筑悲歌
击节叹赏
击节称赏
击钟陈鼎
击钟鼎食
击钵催诗
击鞭锤镫
击鼓鸣金
函盖乾坤
函盖充周
函矢相攻
凾刃之地
凿凿可据
凿凿有据
凿坏以遁
凿坏而遁
凿坯而遁
凿壁偷光
凿柱取书
凿楹纳书
凿空之论
凿空取办
凿空投隙
凿隧入井
凿饮耕食
凿骨捣髓
凿龟数策
刀下留人
刀俎余生
刀光剑影
刀光血影
刀头剑首
刀头燕尾
刀头舔蜜
刀山剑树
刀山火海
刀枪入库
刀枪剑戟
刀耕火种
刀耕火耘
刀耕火耨
刀过竹解
刀锯斧钺
刀锯鼎镬
刁天决地
刁斗森严
刁滑奸诈
刁钻促搯
刁钻促狭
刁钻刻薄
刁钻古怪
刃树剑山
刃迎缕解
分三别两
分丝析缕
分内之事
分别部居
分别门户
分劳赴功
分化瓦解
分厘毫丝
分外妖娆
分守要津
分宵达曙
分家析产
分寸之末
分居异爨
分崩离析
分工合作
分床同梦
分庭伉礼
分庭抗礼
分形共气
分形同气
分形连气
分心挂腹
分情破爱
分我杯羹
分房减口
分文不值
分文不取
分文不名
分文不直
分文未取
分斤拨两
分斤掰两
分星劈两
分星拨两
分星擘两
分朋引类
分条析理
分毫不值
分毫不取
分毫不差
分毫不爽
分毫无爽
分毫析厘
分烟析产
分烟析生
分甘共苦
分甘同苦
分甘绝少
分秒必争
分章析句
分而治之
分花拂柳
分花约柳
分茅列土
分茅胙土
分茅裂土
分茅赐土
分茅锡土
分贫振穷
分路扬镳
分身减口
分身无术
分进合击
分道扬镳
分金掰两
分钗劈凤
分钗断带
分钗破镜
分门别户
分门别类
分鞋破镜
分风劈流
分香卖履
切中时弊
切中时病
切中要害
切切在心
切切此布
切切私语
切树倒根
切理会心
切理厌心
切理餍心
切瑳琢磨
切磋琢磨
切肤之痛
切身体会
切近的当
切骨之仇
切齿拊心
切齿痛心
切齿痛恨
切齿腐心
刊心刻骨
刍荛之见
刍荛之言
刎颈之交
刑于之化
刑余之人
刑措不用
刑期无刑
划一不二
划地为牢
划粥割齑
刓方为圆
刖趾适履
刖趾适屦
列功覆过
列土分茅
列土封疆
列祖列宗
列风淫雨
列鼎而食
刘毅答诏
刘郎前度
刚中柔外
刚克消亡
刚愎自用
刚戾自用
刚柔相济
刚正不阿
刚毅木讷
刚直不阿
刚肠嫉恶
创业垂统
创业维艰
创剧痛深
创巨痛仍
创巨痛深
创意造言
创钜痛仍
创钜痛深
初写黄庭
初出茅庐
初发芙蓉
初生之犊
初生之犊不惧虎
初生之犊不畏虎
初生牛犊不怕虎
初生犊儿
初试锋芒
初露头角
初露锋芒
删华就素
删繁就简
判然不同
判若两人
判若云泥
判若天渊
判若水火
判若鸿沟
刨树搜根
刨根究底
刨根问底
利不亏义
利令志惛
利令智昏
利傍倚刀
利出一孔
利喙赡辞
利害得失
利害攸关
利害相关
利己损人
利市三倍
利惹名牵
利时及物
利析秋毫
利欲熏心
利深祸速
利灾乐祸
利用厚生
利绾名牵
利缰名锁
利锁名缰
利齿伶牙
利齿能牙
别作一眼
别作良图
别具一格
别具匠心
别具只眼
别具心肠
别具慧眼
别具手眼
别具肺肠
别出心裁
别出手眼
别出新意
别出新裁
别出机杼
别创一格
别居异财
别开一格
别开生面
别开蹊径
别抱琵琶
别无二致
别无他物
别无长物
别有人间
别有天地
别有心肝
别有心肠
别有洞天
别有滋味
别有用心
别有肺肠
别有风味
别有风趣
别来无恙
别树一帜
别树一旗
别生枝节
别籍异居
别籍异财
别类分门
别置一喙
别财异居
别风淮雨
别鹤孤鸾
别鹤离鸾
刬恶锄奸
刬旧谋新
刬草除根
刮地皮
刮垢磨光
刮垢磨痕
刮目相待
刮目相看
刮目相见
刮肠洗胃
刮野扫地
刮骨去毒
刮骨抽筋
刳形去皮
刳心雕肾
刳精呕血
刳精鉥心
刳肝沥胆
刳胎杀夭
刳胎焚夭
刳脂剔膏
刺上化下
刺刺不休
刺心切骨
刺心刻骨
刺心裂肝
刺股悬梁
刺股读书
刺虎持鹬
刻不容松
刻不容缓
刻不待时
刻意求工
刻意经营
刻木为吏
刻木为鹄
刻画入微
刻画无盐
刻章琢句
刻翠裁红
刻肌刻骨
刻舟求剑
刻苦耐劳
刻薄寡思
刻足适屦
刻雾裁风
刻骨仇恨
刻骨崩心
刻骨相思
刻骨铭心
刻骨镂心
刻鹄成鹜
刻鹄类鹜
刿心刳肺
刿心刳腹
刿心怵目
刿心鉥肾
刿目怵心
刿目鉥心
刿鉥心腑
刿鉥肝肾
削发披缁
削木为吏
削株掘根
削职为民
削草除根
削足适履
削趾适屦
削铁如泥
削铁无声
前仆后继
前仆后踣
前仰后合
前俯后仰
前倨后卑
前倨后恭
前功尽废
前功尽弃
前功尽灭
前功皆弃
前危后则
前古未有
前古未闻
前合后仰
前呼后拥
前因后果
前尘影事
前度刘郎
前庭悬鱼
前徒倒戈
前思后想
前所未有
前所未闻
前挽后推
前无古人
前歌后舞
前目后凡
前瞻后顾
前程万里
前街后巷
前襟后裾
前覆后戒
前言不搭后语
前言往行
前赴后继
前跋后疐
前车之鉴
前车可鉴
前辙可鉴
剑及履及
剑及屦及
剑头一吷
剑态箫心
剑戟森森
剑拔弩张
剑树刀山
剑气箫心
剑胆琴心
剑首一吷
剔抽禿刷
剔抽秃揣
剔蝎撩蜂
剔透玲珑
剖决如流
剖幽析微
剖心坼肝
剖心析肝
剖心析胆
剖心泣血
剖析肝胆
剖毫析芒
剖玄析微
剖肝沥胆
剖肝泣血
剖腹藏珠
剖蚌得珠
剖蚌求珠
剗恶锄奸
剗旧谋新
剗草除根
剜肉做疮
剜肉医疮
剜肉成疮
剜肉生疮
剜肉补疮
剥床及肤
剥极则复
剥极将复
剥极必复
剥皮抽筋
剥肤之痛
剥肤及髓
剥肤椎髓
剥茧抽丝
剩山残水
剩水残山
剩菜残羹
剩馥残膏
剪发披缁
剪发杜门
剪发被褐
剪恶除奸
剪烛西窗
剪草除根
割地求和
割地称臣
割席分坐
割恩断义
割据一方
割肉补疮
割肉饲虎
割肚牵肠
割股之心
割股疗亲
割臂之盟
割臂盟公
割襟之盟
割须弃袍
割骨疗亲
割鸡焉用牛刀
剸繁决剧
剸繁治剧
劈头盖脸
劈荆斩棘
劈风斩浪
劚山觅玉
劚玉如泥
力不从心
力不胜任
力不能及
力不能支
力不自胜
力争上游
力倍功半
力可拔山
力均势敌
力学不倦
力学笃行
力小任重
力尽筋疲
力屈计穷
力所不及
力所能及
力挽狂澜
力排众议
力敌势均
力敌千钧
力有未逮
力殚财竭
力竭声嘶
力能扛鼎
力透纸背
力钧势敌
劝善惩恶
劝善戒恶
劝善黜恶
劝百讽一
功一美二
功亏一篑
功到自然成
功名利禄
功名富贵
功德圆满
功德无量
功成不居
功成名就
功成名遂
功成弗居
功成行满
功成身退
功成骨枯
功标青史
功盖天下
功若丘山
功薄蝉翼
功行圆满
功败垂成
功遂身退
功高不赏
功高望重
功高盖世
功高震主
加人一等
加减乘除
加官晋爵
加官进爵
加官进禄
加枝添叶
加油加醋
加油添酱
加油添醋
加膝坠泉
加膝坠渊
务本抑末
劣迹昭着
劣迹昭著
动不失时
动中窾要
动之以情
动人心弦
动人心魄
动地惊天
动如参商
动如脱兔
动心忍性
动心怵目
动心骇目
动荡不安
动荡不定
动辄得咎
动静有常
动魄惊心
助人下石
助人为乐
助天为虐
助我张目
助桀为恶
助桀为暴
助桀为虐
助画方略
助纣为虐
助边输财
劫后余生
劫富济贫
劫数难逃
劬劳之恩
劬劳顾复
励兵秣马
励志竭精
励精图治
励精更始
励精求治
劳师动众
劳师糜饷
劳师袭远
劳形苦心
劳心焦思
劳心苦思
劳思逸淫
劳民伤财
劳民动众
劳民费财
劳燕分飞
劳筋苦骨
劳而无功
劳苦功高
劳身焦思
劳逸结合
势不两存
势不两立
势不可当
势不可挡
势不可遏
势倾天下
势倾朝野
势合形离
势在必行
势均力敌
势如劈竹
势如水火
势如破竹
势孤力薄
势成骑虎
势焰熏天
势穷力屈
势穷力竭
势穷力蹙
势若脱兔
势钧力敌
勃然变色
勃然大怒
勃然奋励
勇冠三军
勇往直前
勇猛果敢
勇猛精进
勇者不惧
勇而无谋
勉为其难
勠力同心
勤勤恳恳
勤学好问
勤学苦练
勤能补拙
勺水一脔
勾心斗角
勾魂摄魄
勿忘在莒
勿怠勿忘
勿谓言之不预也
匀红点翠
匀脂抹粉
包举宇内
包办代替
包打天下
包揽词讼
包罗万有
包罗万象
包羞忍耻
包藏奸心
包藏祸心
匍匐之救
匏瓜空悬
匕鬯不惊
匕鬯无惊
化为乌有
化为泡影
化及豚鱼
化外之民
化干戈为玉帛
化性起伪
化整为零
化日光天
化枭为鸠
化民成俗
化民易俗
化腐为奇
化腐成奇
化腐朽为神奇
化若偃草
化险为夷
化零为整
化鸱为凤
北叟失马
北宫婴儿
北斗之尊
北窗高卧
北辕适楚
北辕适粤
北辙南辕
北辰星拱
北道主人
北郭先生
北鄙之声
北鄙之音
北门之寄
北门之管
北门南牙
北门管钥
北门锁钥
北面称臣
北风之恋
匠心独具
匠心独妙
匠心独运
匠石运金
匠门弃材
匡乱反正
匡俗济时
匡其不逮
匡国济时
匡救弥缝
匡时济世
匡时济俗
匡衡凿壁
匡谬正俗
匡鼎解颐
匣剑帷灯
匣里龙吟
匪伊朝夕
匪匪翼翼
匪夷匪惠
匪夷所思
匪朝伊夕
匪石之心
匪石匪席
匹夫之勇
匹夫之谅
匹夫匹妇
匹夫小谅
匹夫怀璧
匹夫无罪
匹夫有责
匹夫沟渎
匹妇沟渠
匹马一麾
匹马单枪
匹马单鎗
匹马只轮
匹马当先
区区之众
区区小事
区区此心
区闻陬见
医时救弊
匿影藏形
匿瑕含垢
匿迹潜形
匿迹销声
匿迹隐形
十万八千里
十万火急
十万火速
十不当一
十世单传
十之八九
十二万分
十二金牌
十二金钗
十亲九故
十亲九眷
十人九慕
十光五色
十全十美
十八层地狱
十八般兵器
十八般武艺
十冬腊月
十十五五
十发十中
十变五化
十口相传
十围五攻
十夫桡椎
十夫楺椎
十字街口
十字街头
十字路口
十字路头
十室九匮
十室九空
十室容贤
十寒一暴
十年九不遇
十年寒窗
十年生聚
十年磨剑
十年窗下
十年读书
十恶不赦
十恶五逆
十成九稳
十战十胜
十手争指
十拏九稳
十拷九棒
十拿九稳
十指连心
十捉九着
十日之饮
十日并出
十有八九
十步芳草
十步香草
十步香车
十死一生
十死不问
十死九活
十浆五馈
十生九死
十病九痛
十目所视
十眠九坐
十米九糠
十羊九牧
十行俱下
十转九空
十载寒窗
十里洋场
十里长亭
十雨五风
十面埋伏
十风五雨
十鼠同穴
千万买邻
千丝万缕
千乘万骑
千了万当
千了百了
千了百当
千人一面
千人所指
千仓万箱
千仞无枝
千伶百俐
千依万顺
千依百顺
千兵万马
千军万马
千刀万剁
千刀万剐
千千万万
千变万化
千变万状
千变万轸
千古一律
千古一时
千古一辙
千古不朽
千古不磨
千古奇闻
千古独步
千古絶唱
千古絶调
千古绝唱
千古绝调
千古罪人
千叮万嘱
千呼万唤
千回万转
千回百折
千回百转
千夫所指
千头万序
千头万绪
千奇百怪
千姿万态
千姿百态
千娇百媚
千家万户
千山万壑
千山万水
千岁一时
千岁鹤归
千岩万壑
千岩竞秀
千峰万壑
千峰百嶂
千差万别
千差万错
千年一律
千形万状
千态万状
千思万想
千思万虑
千恩万谢
千愁万恨
千愁万绪
千推万阻
千方万计
千方百计
千日打柴一日烧
千日斫柴一日烧
千村万落
千条万端
千条万绪
千条万缕
千水万山
千汇万状
千沟万壑
千灾百难
千状万态
千状万端
千生万劫
千生万死
千疮百孔
千疮百痍
千真万确
千磨百折
千秋万世
千秋万代
千秋万古
千秋万岁
千秋人物
千章万句
千端万绪
千篇一律
千红万紫
千绪万端
千虑一失
千虑一得
千补百衲
千言万语
千言万说
千语万言
千载一会
千载一合
千载一圣
千载一弹
千载一日
千载一时
千载一逢
千载一遇
千载奇遇
千载难逢
千载难遇
千辛万苦
千里一曲
千里之任
千里之志
千里之足
千里同风
千里姻缘一线牵
千里姻缘使线牵
千里寄鹅毛
千里无烟
千里犹面
千里神交
千里结言
千里莼羹
千里迢迢
千里送鹅毛
千里骏骨
千里鹅毛
千金一刻
千金一壶
千金一壸
千金一掷
千金一瓠
千金一笑
千金一诺
千金之子
千金之家
千金买笑
千金市骨
千金弊帚
千金敝帚
千金比屋
千钧一发
千钧重负
千锤百炼
千门万户
千闻不如一见
千随百顺
千难万苦
千难万险
千难万难
千龄万代
升堂入室
升堂拜母
升官发财
升山采珠
半三不四
半上半下
半上落下
半丝半缕
半低不高
半信不信
半信半疑
半半拉拉
半半路路
半吐半露
半吞半吐
半壁山河
半壁江山
半壁河山
半夜三更
半懂不懂
半截入土
半推半就
半文不白
半文半白
半斤八两
半斤八面
半新不旧
半新半旧
半梦半醒
半死不活
半死半生
半死辣活
半涂而废
半涂而罢
半生不熟
半生半熟
半疑半信
半痴不颠
半真半假
半筹不纳
半筹莫展
半解一知
半路修行
半路出家
半身不遂
半途而废
半部论语
半部论语治天下
半间不界
半间半界
半青半黄
半面不忘
半面之交
半面之旧
半饥半饱
华不再扬
华亭鹤唳
华冠丽服
华封三祝
华屋丘墟
华屋山丘
华屋山邱
华屋秋墟
华星秋月
华而不实
协力同心
协力齐心
协心同力
协心戮力
协私罔上
卑不足道
卑之无甚高论
卑以自牧
卑卑不足道
卑宫菲食
卑礼厚币
卑谄足恭
卑身屈体
卑身贱体
卑躬屈膝
卑躬屈节
卑辞厚币
卑辞厚礼
卑辞重币
卑鄙无耻
卑鄙龌龊
卑陋龌龊
卒然
卓乎不羣
卓乎不群
卓尔不羣
卓尔不群
卓尔独行
卓有成效
卓然不羣
卓然不群
卓立鸡群
卓绝千古
卓荦不羁
卓荦超伦
单丝不成线
单丝不线
单兵孤城
单刀直入
单刀赴会
单孑独立
单忧极瘁
单文孤证
单枪匹马
单枪独马
单见浅闻
单鎗匹马
单鹄寡凫
卖主求荣
卖乖弄俏
卖俏行奸
卖俏迎奸
卖儿贴妇
卖儿鬻女
卖公营私
卖刀买犊
卖剑买牛
卖剑买犊
卖剑买琴
卖友求荣
卖国求利
卖国求荣
卖头卖脚
卖妻鬻子
卖官卖爵
卖官贩爵
卖官鬻爵
卖官鬻狱
卖富差贫
卖履分香
卖文为生
卖李钻核
卖法市恩
卖爵鬻官
卖犊买刀
卖狗悬羊
卖男鬻女
卖空买空
卖笑追欢
卖身投靠
南冠楚囚
南去北来
南山可移
南山铁案
南州冠冕
南征北伐
南征北战
南征北讨
南户窥郎
南来北往
南枝北枝
南柯一梦
南棹北辕
南橘北枳
南箕北斗
南腔北调
南舣北驾
南航北骑
南船北车
南蛮鴂舌
南蛮鴃舌
南贩北贾
南辕北辙
南郭先生
南郭处士
南金东箭
南阮北阮
南面百城
南面称孤
南风不竞
南鹞北鹰
博古通今
博士买驴
博大精深
博学多才
博学多闻
博学洽闻
博弈犹贤
博文约礼
博施济众
博洽多闻
博物君子
博物多闻
博物洽闻
博硕肥腯
博而不精
博而寡要
博览五车
博览古今
博览群书
博识多通
博通经籍
博采众议
博采众长
博闻多识
博闻强志
博闻强记
博闻强识
博闻辩言
卜夜卜昼
卜昼卜夜
占风使帆
占风望气
卤莽灭裂
卧不安席
卧不安枕
卧冰求鲤
卧床不起
卧榻之侧
卧榻岂容酣睡
卧榻鼾睡
卧薪尝胆
卧虎藏龙
卧雪眠霜
卬头阔步
卬首信眉
印累绶若
危于累卵
危在旦夕
危如朝露
危如累卵
危急存亡
危急存亡之秋
危机四伏
危若朝露
危言危行
危言核论
危言正色
危言竦论
危言耸听
危言覈论
危言逆耳
危言高论
危迫利诱
即事穷理
即兴之作
即小见大
即景生情
即温听厉
即物穷理
即鹿无虞
却之不恭
却病延年
却老还童
却行求前
却金暮夜
卵与石斗
卵石不敌
卵覆鸟飞
卷土重来
卷地皮
卷帙浩繁
卷席而居
卷席而葬
卷旗息鼓
卷甲倍道
卷甲束兵
卷甲衔枚
卷甲韬戈
卸磨杀驴
卿卿我我
历世摩钝
历世磨钝
历久弥坚
历井扪天
历兵秣马
历兵粟马
历历可数
历历可考
历历可见
历历可辨
历历在目
历历在耳
历历落落
历日旷久
历精为治
历精图治
历精更始
厉世摩钝
厉世磨钝
厉兵秣马
厉兵粟马
厉精为治
厉精图治
厉精更始
厉行节约
压倒元白
压卷之作
压肩叠背
压肩迭背
压良为贱
压雪求油
厌故喜新
厌闻饫听
厌难折冲
厕足其间
厕身其间
厚今薄古
厚古薄今
厚味腊毒
厚往薄来
厚德载物
厚德载福
厚此薄彼
厚生利用
厚禄高官
厚积薄发
厚貌深情
厚貌深文
厚貌深辞
厚颜无耻
厝火燎原
厝火积薪
原原委委
原原本本
原始反终
原始要终
原始见终
原封不动
原封未动
原形毕露
原形败露
原来如此
原璧归赵
去伪存真
去住两难
去危就安
去天尺五
去太去甚
去就之分
去故就新
去故纳新
去暗投明
去末归本
去本就末
去本趋末
去泰去甚
去甚去泰
去粗取精
去邪归正
去食存信
参伍错纵
参伍错综
参前倚衡
参商之虞
参回斗转
参天两地
参天贰地
参差不一
参差不齐
参差错落
参横斗转
参辰卯酉
参辰日月
参透机关
又作别论
又弱一个
又当别论
又生一秦
又红又专
及宾有鱼
及时行乐
及溺呼船
及瓜而代
及笄年华
及第成名
及锋而试
友风子雨
双凫一雁
双喜临门
双宿双飞
双斧伐孤树
双柑斗酒
双栖双宿
双桂联芳
双瞳剪水
双管齐下
双足重茧
反其道而行之
反劳为逸
反听内视
反听收视
反哺之情
反哺之私
反唇相稽
反唇相讥
反复推敲
反复无常
反客为主
反戈一击
反戈相向
反手可得
反攻倒算
反朴归真
反朴还淳
反正拨乱
反正还淳
反水不收
反求诸己
反治其身
反璞归真
反目成仇
反眼不识
反经合义
反经合道
反经行权
反老还童
反脸无情
反裘伤皮
反裘负刍
反裘负薪
反覆无常
反败为胜
反身自问
反躬自省
反躬自责
反躬自问
反间之计
反面教员
反面文章
反面无情
反风灭火
反骄破满
发上冲冠
发上指冠
发人深思
发人深省
发凡起例
发号出令
发号吐令
发号布令
发号施令
发奋为雄
发奋图强
发奋蹈厉
发奸摘伏
发奸摘覆
发奸擿伏
发奸露覆
发宪布令
发家致业
发家致富
发屋求狸
发引千钧
发怒冲冠
发怒穿冠
发愤图强
发愤展布
发愤忘食
发愤自厉
发愤自雄
发扬光大
发扬踔厉
发扬蹈励
发扬蹈厉
发指眦裂
发摘奸隐
发擿奸伏
发政施仁
发无不捷
发昏章第十一
发棠之请
发植穿冠
发潜阐幽
发皇张大
发瞽披聋
发短心长
发硎新试
发秃齿豁
发科打诨
发科打趣
发策决科
发纵指使
发纵指示
发综指示
发聋振聩
发荣滋长
发蒙启滞
发蒙启蔽
发蒙振槁
发蒙振聩
发蒙振落
发蒙解惑
发蒙解缚
发言盈庭
发财致富
发踊冲冠
发踪指使
发踪指示
发迹变泰
发隐擿伏
叔度陂湖
取义成仁
取乱侮亡
取乱存亡
取予有节
取以来
取信于人
取信于民
取巧图便
取民愈广
取精用宏
取精用弘
取而代之
取诸宫中
取辖投井
取长弃短
取长补短
取青妃白
取青媲白
受制于人
受宠若惊
变俗易教
变动不居
变化不测
变化不穷
变化多端
变化如神
变化无常
变化无穷
变化莫测
变危为安
变古乱常
变古易俗
变古易常
变名易姓
变容改俗
变幻不测
变幻无常
变幻无穷
变幻莫测
变心易虑
变态百出
变故易常
变本加厉
变炫无穷
变生不测
变生肘腋
变脸变色
变色之言
变色易容
变贪厉薄
变躬迁席
变醨养瘠
变颜变色
变风改俗
变风易俗
叠嶂层峦
叠床架屋
叠矩重规
口不二价
口不应心
口不择言
口中蚤虱
口中雌黄
口传心授
口似悬河
口出不逊
口出大言
口出狂言
口口声声
口口相传
口吐珠玑
口含天宪
口吻生花
口呆目瞪
口呆目钝
口坠天花
口壅若川
口多食寡
口头禅
口如悬河
口尚乳臭
口干舌焦
口干舌燥
口快心直
口惠而实不至
口无择言
口是心苗
口是心非
口服心服
口沸目赤
口燥唇干
口直心快
口碑载道
口耳之学
口耳并重
口耳相传
口耳相承
口腹之累
口若悬河
口蜜腹剑
口血未干
口衔天宪
口角春风
口角生风
口角风情
口讲指画
口诛笔伐
口说无凭
口诵心惟
口诵心维
口谐辞给
口轻舌薄
口齿伶俐
口齿生香
古为今用
古井不波
古井无波
古今中外
古圣先贤
古往今来
古是今非
古木参天
古稀之年
古肥今瘠
古色古香
古调不弹
古调单弹
古貌古心
古道热肠
句斟字酌
句栉字比
句比字栉
另开生面
另有洞天
另楚寒巫
另眼相待
另眼相看
另眼看待
另眼看戏
另眼看觑
另请高明
另谋高就
另起炉灶
另辟蹊径
叨在知己
叨陪末座
叩心泣血
叩源推委
叩石垦壤
叩阍无路
叩马而谏
只争旦夕
只争朝夕
只字不提
只言片语
只身孤影
只轮不反
只轮不返
只轮无反
只重衣衫不重人
只骑不反
只鸡斗酒
只鸡樽酒
只鸡絮酒
叫苦不迭
叫苦连天
可乘之机
可乘之隙
可发一噱
可心如意
可想而知
可操左券
可有可无
可望不可即
可望而不可即
可望而不可及
可歌可泣
可泣可歌
可见一斑
台阁生风
叱咤风云
叱嗟风云
史不絶书
史不绝书
史无前例
右传之八章
右军习气
右翦左屠
叶公好龙
叶散冰离
叶瘦花残
叶落归根
叶落知秋
号令如山
号咷大哭
号啕大哭
号天扣地
号寒啼饥
司农仰屋
司空见惯
司马昭之心
司马牛之叹
司马称好
司马青衫
叹为观止
叹老嗟卑
叹观止矣
吁咈都俞
吁地呼天
吁天呼地
吃不了兜着走
吃力不讨好
吃哑巴亏
吃喝玩乐
吃惊受怕
吃着不尽
吃着碗里瞧着锅里
吃硬不吃软
吃穿用度
吃粮不管事
吃苦耐劳
吃软不吃硬
吃里扒外
吃里爬外
各不相让
各不相谋
各个击破
各为其主
各人自扫门前雪
各从其志
各取所长
各取所需
各司其事
各奔前程
各安生业
各就各位
各尽所能
各式各样
各得其宜
各得其所
各执一词
各执己见
各抒己见
各抒所见
各持己见
各有千秋
各有所好
各有所短
各有所职
各有所长
各自为战
各自为政
各色人等
各色各样
各色名样
各行其志
各行其是
合两为一
合二为一
合从连衡
合情合理
合浦珠还
合浦还珠
合盘托出
合眼摸象
合而为一
合胆同心
合衷共济
吉人天相
吉人自有天相
吉光凤羽
吉光片羽
吉光片裘
吉凶未卜
吉凶祸福
吉日良时
吉日良辰
吉星高照
吉祥如意
吉祥止止
吉网罗钳
吊儿郎当
吊古伤今
吊古寻幽
吊尔郎当
吊形吊影
吊死扶伤
吊死问生
吊死问疾
吊民伐罪
吊胆惊心
吊胆提心
吊誉沽名
同业相仇
同仇敌忾
同仇敌慨
同休共戚
同休等戚
同出一辙
同利相死
同力协契
同功一体
同垂不朽
同堂兄弟
同声一辞
同声共气
同声同气
同声相应
同声相求
同室操戈
同尘合污
同工异曲
同年而校
同年而语
同床共枕
同床各梦
同床异梦
同归于尽
同归殊涂
同归殊途
同德一心
同德协力
同德同心
同心一力
同心一德
同心一意
同心僇力
同心共济
同心共胆
同心协力
同心协德
同心协济
同心叶力
同心合力
同心合德
同心合意
同心合胆
同心同德
同心并力
同心戮力
同心敌忾
同心断金
同心毕力
同心竭力
同忧相救
同恶共济
同恶相党
同恶相助
同恶相恤
同恶相求
同恶相济
同敝相济
同文共规
同文共轨
同日而言
同日而论
同日而语
同日而道
同明相照
同条共贯
同气相求
同气连枝
同流合污
同浴讥裸
同源共流
同源异派
同源异流
同然一辞
同甘共苦
同生共死
同病相怜
同盘而食
同符合契
同类相从
同类相妒
同类相求
同美相妒
同胞共气
同舟共命
同舟共济
同舟敌国
同舟遇风
同船合命
同袍同泽
同门异户
同音共律
名下无虚
名不副实
名不符实
名不虚传
名不虚得
名不虚立
名从主人
名公巨人
名公巨卿
名公钜人
名公钜卿
名列前茅
名利双收
名副其实
名卿巨公
名卿钜公
名同实异
名噪一时
名垂万古
名垂千古
名垂后世
名垂竹帛
名垂青史
名士风流
名声籍甚
名声过实
名存实亡
名实相副
名实相符
名实难副
名山事业
名山大川
名山胜川
名山胜水
名师出高徒
名德重望
名我固当
名扬四海
名标青史
名正理顺
名正言顺
名流巨子
名满天下
名目繁多
名符其实
名缰利锁
名胜古迹
名落孙山
名贸实易
名过其实
名重一时
名门世族
名闻遐迩
名震一时
名鞿利鞚
名高天下
名高难副
后会无期
后会有期
后发制人
后台老板
后悔不及
后悔无及
后悔莫及
后患无穷
后手不接
后拥前呼
后来之秀
后来居上
后来者居上
后浪催前浪
后浪推前浪
后海先河
后生可畏
后生小子
后福无量
后继无人
后继有人
后起之秀
后车之戒
后进之秀
后进领袖
后顾之忧
吐丝自缚
吐刚茹柔
吐哺捉发
吐哺握发
吐哺辍洗
吐心吐胆
吐故纳新
吐气扬眉
吐肝露胆
吐胆倾心
吐食握发
向上一路
向壁虚构
向壁虚造
向声背实
向天而唾
向平之原
向平之愿
向火乞儿
向若而叹
向隅而泣
向风慕义
君命无二
君圣臣贤
君子三戒
君子之交
君子之交淡如水
君子之交淡若水
君子之接如水
君子协定
君子固穷
君子好逑
君子成人之美
君臣佐使
君辱臣死
吞云吐雾
吞刀刮肠
吞刀吐火
吞吞吐吐
吞声忍气
吞声忍泪
吞声饮恨
吞声饮气
吞声饮泣
吞炭漆身
吞符翕景
吞纸抱犬
吞舟之鱼
吞舟是漏
吞舟漏网
吞言咽理
吞风饮雨
吟花咏柳
吟风咏月
吟风弄月
吠形吠声
吠影吠声
吠非其主
否去泰来
否往泰来
否极泰回
否极泰来
否极阳回
否终则泰
否终复泰
否终斯泰
含仁怀义
含冤受屈
含冤莫白
含冤负屈
含冰茹檗
含冰茹蘗
含哺鼓腹
含商咀征
含商咀徵
含垢包羞
含垢匿瑕
含垢弃瑕
含垢忍污
含垢忍耻
含垢忍辱
含垢纳污
含垢藏瑕
含垢藏疾
含宫咀征
含宫咀徵
含情脉脉
含明隐迹
含污忍垢
含沙射影
含牙带角
含牙戴角
含瑕积垢
含着骨头露着肉
含章天挺
含章挺生
含笑九泉
含笑入地
含糊不明
含糊其词
含糊其辞
含苞待放
含苞欲放
含英咀华
含菁咀华
含蓼问疾
含血喷人
含血噀人
含血潠人
含辛忍苦
含辛茹苦
含霜履雪
含饴弄孙
含齿戴发
听之任之
听人穿鼻
听其自便
听其自流
听其自然
听其言而观其行
听天任命
听天委命
听天安命
听天由命
听微决疑
听而不闻
听见风就是雨
听风听水
吮疽舐痔
吮痈舐痔
吮癕舐痔
启宠纳侮
启瞶振聋
吱哩哇啦
吴下阿蒙
吴头楚尾
吴市之箫
吴市吹箫
吴带当风
吴牛喘月
吴越同舟
吸新吐故
吸风饮露
吹叶嚼蕊
吹吹打打
吹唇唱吼
吹垢索瘢
吹大法螺
吹弹得破
吹弹歌舞
吹影镂尘
吹毛利刃
吹毛数睫
吹毛求瑕
吹毛求疵
吹毛洗垢
吹毛索垢
吹毛索疵
吹毛索瘢
吹气如兰
吹气胜兰
吹灯拔蜡
吹灰之力
吹牛拍马
吹皱一池春水
吹竹弹丝
吹箫乞食
吹篪乞食
吹糠见米
吹网欲满
吹胡子瞪眼
吹花嚼蕊
吹角连营
吾家千里驹
吾膝如铁
吾自有处
吾谁与归
呆似木鸡
呆头呆脑
呆如木鸡
呆若木鸡
呆里撒奸
告往知来
告朔饩羊
告老在家
告老还乡
告老还家
告贷无门
呕心抽肠
呕心沥血
呕心滴血
呕心镂骨
呜呼哀哉
呜呼噫嘻
呢喃细语
周公吐哺
周急继乏
周情孔思
周游列国
周穷恤匮
周而不比
周而复始
周规折矩
周郎顾曲
呰牙咧嘴
呱呱坠地
呱呱堕地
呲牙咧嘴
味同嚼蜡
味如嚼蜡
味如鸡肋
呴湿濡沫
呵佛骂祖
呵壁问天
呵欠连天
呶呶不休
呷醋节帅
呼不给吸
呼之欲出
呼卢喝雉
呼吸之间
呼吸相通
呼天叩地
呼天叫地
呼天号地
呼天吁地
呼天唤地
呼天抢地
呼天钥地
呼幺喝六
呼庚呼癸
呼朋唤友
呼朋引类
呼来喝去
呼牛作马
呼牛呼马
呼群结党
呼风唤雨
命世之才
命中注定
命俦啸侣
命在旦夕
命在朝夕
命若悬丝
命薄缘悭
命词遣意
命蹇时乖
命辞遣意
命途多舛
命里注定
咀嚼英华
咂嘴咂舌
咂嘴弄唇
咂嘴弄舌
咂嘴舔唇
咄咄书空
咄咄怪事
咄咄逼人
咄嗟之间
咄嗟便办
咄嗟叱咤
咄嗟立办
咆哮如雷
和光同尘
和如琴瑟
和容悦色
和气生财
和气致祥
和璧隋珠
和盘托出
和睦相处
和而不同
和而不唱
和蔼可亲
和蔼近人
和衣而卧
和衷共济
和颜悦色
和颜说色
和风丽日
和风细雨
咎有应得
咎由自取
咏嘲风月
咏月嘲花
咏月嘲风
咏桑寓柳
咒天骂地
咫尺万里
咫尺之书
咫尺之功
咫尺千里
咫尺天涯
咫尺天颜
咫尺威颜
咫角骖驹
咬人狗儿不露齿
咬姜呷醋
咬定牙关
咬定牙根
咬得菜根
咬文啮字
咬文嚼字
咬文齧字
咬牙切齿
咬牙恨齿
咬紧牙关
咬血为盟
咬钉嚼铁
咬音咂字
咳声叹气
咳珠唾玉
咸与惟新
咸与维新
咸五登三
咸嘴淡舌
咸阳一炬
咸风蛋雨
咽苦吐甘
咽苦吞甘
哀丝豪竹
哀兵必胜
哀告宾服
哀哀欲绝
哀哀父母
哀声叹气
哀天叫地
哀思如潮
哀感中年
哀感天地
哀感顽艳
哀梨蒸食
哀毁瘠立
哀毁骨立
哀痛欲绝
哀而不伤
哀莫大于心死
哀鸿遍地
哀鸿遍野
品头论足
品头评足
品头题足
品学兼优
品竹弹丝
品竹调丝
品竹调弦
品而第之
品貌非凡
哄动一时
哄堂大笑
响和景从
响彻云表
响彻云际
响彻云霄
响答影随
响遏行云
哑口无声
哑口无言
哑子做梦
哑子吃黄连
哑子寻梦
哑子托梦
哑然失笑
哓哓不休
哓音瘏口
哕心沥血
哗世动俗
哗世取名
哗世取宠
哗众取宠
哭丧着脸
哭哭啼啼
哭天喊地
哭天抹泪
哭笑不得
哲人其萎
哺糟啜醨
哺糟歠醨
哼哼唧唧
唇不离腮
唇亡齿寒
唇尖舌利
唇干口燥
唇揭齿寒
唇敝舌腐
唇枪舌剑
唇焦口燥
唇焦舌敝
唇竭齿寒
唇红齿白
唇腐齿落
唇辅相连
唇鎗舌剑
唇齿之邦
唇齿相依
唇齿相须
唉声叹气
唐临晋帖
唐哉皇哉
唐突西子
唐突西施
唐虞之治
唠唠叨叨
唯利是图
唯利是求
唯利是视
唯力是视
唯吾独尊
唯命是从
唯命是听
唯唯否否
唯唯诺诺
唯唯连声
唯妙唯肖
唯我独尊
唯所欲为
唯邻是卜
唱对台戏
唱沙作米
唱筹量沙
唾地成文
唾壶击碎
唾壶击缺
唾壶敲缺
唾手可取
唾手可得
唾面自干
商彝周鼎
商彝夏鼎
啖以重利
啛啛喳喳
啜英咀华
啜菽饮水
啜食吐哺
啧啧称羡
啧啧称赞
啧有烦言
啬己奉公
啮檗吞针
啮臂之好
啮血为盟
啮血沁骨
啮雪吞毡
啮雪餐毡
啸侣命俦
啸傲湖山
啸傲风月
啸吒风云
啸咤风云
啸聚山林
啼啼哭哭
啼天哭地
啼笑皆非
啼饥号寒
喃喃细语
喃喃自语
善与人交
善为说辞
善刀而藏
善善从长
善善恶恶
善始令终
善始善终
善文能武
善有善报
善气迎人
善游者溺
善男信女
善眉善眼
善罢干休
善罢甘休
善罢罢休
善自为谋
善财难舍
善贾而沽
善门难开
善颂善祷
善马熟人
善骑者堕
喉长气短
喊冤叫屈
喋喋不休
喏喏连声
喑噁叱咤
喘息之间
喘息未定
喘月吴牛
喙长三尺
喜上眉梢
喜不自胜
喜从天降
喜出望外
喜形于色
喜怒不形于色
喜怒哀乐
喜怒无常
喜新厌故
喜新厌旧
喜气洋洋
喜溢眉梢
喜眉笑眼
喜笑颜开
喜行于色
喜见于色
喜跃抃舞
喜逐颜开
喜闻乐见
喝西北风
喟然长叹
喧宾夺主
喷云吐雾
喷云泄雾
喷薄欲出
喷血自污
喷雨嘘云
喻之以理
嗑牙料嘴
嗒然若丧
嗔拳不打笑面
嗔目切齿
嗜杀成性
嗜痂之癖
嗟悔无及
嗟来之食
嗤之以鼻
嗫嗫嚅嚅
嗫嚅小儿
嗳声叹气
嗷嗷待哺
嘁嘁喳喳
嘉言善状
嘉言善行
嘉言懿行
嘘寒问暖
嘘枯吹生
嘟嘟哝哝
嘲风咏月
嘲风弄月
嘴尖舌头快
嘴快舌长
嘴清舌白
嘴甜心苦
嘴直心快
嘻皮涎脸
嘻皮笑脸
嘻笑怒骂
噀玉喷珠
噙齿戴发
噤口卷舌
噤口捲舌
噤若寒蝉
器二不匮
器宇不凡
器宇轩昂
器小易盈
器满则覆
器满将覆
器满意得
噩噩浑浑
噬脐何及
噬脐无及
噬脐莫及
嚎天动地
嚎天喊地
嚣张一时
嚼墨喷纸
嚼穿龈血
嚼腭搥床
嚼铁咀金
嚼齿穿龈
囊匣如洗
囊括四海
囊漏储中
囊漏贮中
囊空如洗
囊萤映雪
囊萤照书
囊萤照读
囊里盛锥
囊锥露颖
囓血为盟
囚首丧面
囚首垢面
四不拗六
四书五经
四亭八当
四体不勤
四体百骸
四停八当
四冲八达
四冲六达
四分五剖
四分五落
四分五裂
四大皆空
四姻九戚
四山五岳
四平八稳
四战之国
四战之地
四方之志
四方八面
四方辐辏
四时之气
四时充美
四时八节
四海一家
四海为家
四海之内皆兄弟
四海九州
四海九州岛
四海他人
四海升平
四海承风
四海昇平
四海波静
四海皆兄弟
四海飘零
四海鼎沸
四清六活
四百四病
四纷五落
四肢百体
四肢百骸
四脚朝天
四至八道
四荒八极
四衢八街
四角俱全
四通五达
四通八达
四郊多垒
四面八方
四面出击
四面受敌
四面楚歌
四马攒蹄
回光反照
回光返照
回味无穷
回嗔作喜
回天之力
回天乏术
回天倒日
回天挽日
回天无力
回天转地
回天运斗
回头是岸
回山倒海
回山转海
回干就湿
回心转意
回文织锦
回春之术
回春妙手
回生起死
回眸一笑
回筹转策
回肠九转
回肠伤气
回肠寸断
回肠百转
回肠荡气
回船转舵
回邪入正
回黄转緑
回黄转绿
因乌及屋
因事制宜
因人制宜
因人成事
因人而异
因任授官
因公假私
因公行私
因其固然
因利乘便
因势利导
因噎废食
因地制宜
因小失大
因循坐误
因循守旧
因循苟且
因敌为资
因敌取资
因时制宜
因材施教
因果报应
因树为屋
因祸为福
因祸得福
因缘为市
因袭陈规
因陋守旧
因陋就寡
因陋就简
因难见巧
因风吹火
团团转
团头聚面
团花簇锦
囤积居奇
囫囵半片
囫囵吞枣
困兽犹斗
困心横虑
困心衡虑
困知勉行
困而不学
困而学之
围城打援
围魏救赵
固壁清野
固执己见
固执成见
固步自封
固若金汤
国不堪贰
国之干城
国仇家恨
国士无双
国家栋梁
国富兵强
国富民丰
国富民安
国富民强
国将不国
国尔忘家
国无二君
国无宁日
国步艰难
国泰民安
国破家亡
国而忘家
国耳忘家
国色天姿
国色天香
国计民生
国难当头
图作不轨
图穷匕见
图穷匕首见
图谋不轨
图财害命
囿于成见
圆凿方枘
圆孔方木
圆木警枕
圆顶方趾
圆颅方趾
圆首方足
圈牢养物
圜凿方枘
土偶蒙金
土壤细流
土崩瓦解
土崩鱼烂
土扶成墙
土木形骸
土洋结合
土牛木马
土生土长
土穰细流
土豪劣绅
土阶茅屋
土阶茅茨
土鸡瓦犬
土鸡瓦狗
土龙刍狗
土龙沐猴
圣主垂衣
圣人之年
圣人之徒
圣君贤相
圣帝明王
圣神文武
圣经贤传
在人耳目
在劫难逃
在天之灵
在官言官
在家出家
在所不惜
在所不辞
在所难免
在此一举
在色之戒
在谷满谷
在陈之厄
圭璋特达
圭角不露
圭角岸然
地上天官
地上天宫
地下修文
地丑力敌
地丑德齐
地主之仪
地主之谊
地久天长
地利人和
地动山摇
地动山摧
地北天南
地坼天崩
地塌天荒
地大物博
地崩山摧
地平天成
地广人希
地广人稀
地旷人稀
地棘天荆
地灵人杰
地狱变相
地瘠民贫
地网天罗
地老天昏
地老天荒
地覆天翻
地角天涯
地负海涵
坌鸟先飞
坎井之蛙
坎井之鼃
坎坷不平
坎止流行
坏人心术
坏植散羣
坏植散群
坏法乱纪
坏裳为袴
坏裳为裤
坐上琴心
坐不垂堂
坐不安席
坐不窥堂
坐不重席
坐于涂炭
坐井窥天
坐井观天
坐享其功
坐享其成
坐以待旦
坐以待毙
坐冷板凳
坐卧不宁
坐卧不安
坐卧不离
坐卧针毡
坐吃山崩
坐吃山空
坐地分脏
坐地分赃
坐地自划
坐失事机
坐失机宜
坐失良机
坐山观虎斗
坐怀不乱
坐戒垂堂
坐拥书城
坐拥百城
坐收渔利
坐无虚席
坐树不言
坐树无言
坐立不安
坐筹帷幄
坐而待弊
坐而待旦
坐而待毙
坐而论道
坐薪尝胆
坐薪悬胆
坐观成败
坐视不救
坐视成败
坐言起行
坐运筹策
坐食山空
坑家败业
坑灰未冷
坑绷拐骗
坑蒙拐骗
坚不可摧
坚壁清野
坚如盘石
坚如磐石
坚守不渝
坚定不移
坚强不屈
坚忍不拔
坚执不从
坚持不懈
坚持不渝
坚甲利兵
坚甲利刃
坚甲厉兵
坚苦卓絶
坚苦卓绝
坚贞不屈
坚贞不渝
坚韧不拔
坚额健舌
坠溷飘茵
坠茵落溷
坦然自若
坦腹东床
垂名竹帛
垂名青史
垂头丧气
垂头塌翅
垂头塞耳
垂头搨翼
垂头铩羽
垂帘听决
垂帘听政
垂手可得
垂手而得
垂拱而治
垂暮之年
垂死挣扎
垂涎三尺
垂涎欲滴
垂耳下首
垂范百世
垂裕后昆
垂饵虎口
垂首丧气
垢面蓬头
埋声晦迹
埋天怨地
埋头苦干
埋头顾影
埋轮破柱
城下之盟
城下之辱
城北徐公
城狐社鼠
城门鱼殃
埒才角妙
埒材角妙
埙篪相和
埳井之蛙
埳井之鼃
埽穴犂庭
堂哉皇哉
堂堂一表
堂堂正正
堂皇冠冕
堂皇富丽
堂皇正大
堂而皇之
堆山积海
堆案盈几
堆积如山
堆金叠玉
堆金积玉
堆金迭玉
堑山堙谷
堕云雾中
堕溷飘茵
堕甑不顾
堙谷堑山
堤溃蚁孔
堤溃蚁穴
堪以告慰
塔尖上功德
塞上江南
塞井夷灶
塞井焚舍
塞北江南
塞翁之马
塞翁失马
塞翁得马
塞耳偷铃
塞耳盗钟
塞耳盗锺
填坑满谷
填街塞巷
墓木已拱
墓木拱矣
墙上泥皮
墙倒众人推
墙头马上
墙有耳
墙花路柳
墙花路草
墙面而立
墙风壁耳
墙高基下
增收节支
增砖添瓦
墨子泣丝
墨守成法
墨守成规
墨汁未干
墨突不黔
墨迹未干
壁垒森严
壁立千仞
壁间蛇影
士为知己者死
士农工商
士可杀不可辱
士死知己
士饱马腾
壮发冲冠
壮士断腕
壮士解腕
壮心不已
壮志凌云
壮志未酬
壮气凌云
壮气吞牛
声东击西
声价倍增
声价十倍
声价百倍
声入心通
声动梁尘
声势汹汹
声势浩大
声势烜赫
声势熏灼
声势赫奕
声名烜赫
声名狼籍
声名狼藉
声名藉甚
声名赫奕
声名鹊起
声吞气忍
声嘶力竭
声如洪钟
声威大震
声希味淡
声应气求
声张势厉
声情并茂
声振寰宇
声振屋瓦
声振林木
声气相投
声气相求
声气相通
声求气应
声泪俱下
声泪俱发
声罪致讨
声色不动
声色俱厉
声色并厉
声色犬马
声色狗马
声色货利
声誉十倍
声誉鹊起
声销迹灭
声闻过情
声音笑貌
壶中天地
壶中日月
壶天日月
壶浆塞道
壶浆箪食
壶里乾坤
壸浆箪食
壹倡三叹
壹败涂地
处之夷然
处之怡然
处之晏然
处之泰然
处之绰然
处堂燕雀
处堂燕鹊
处安思危
处实效功
处尊居显
处心积虑
处高临深
备位充数
备多力分
备尝艰苦
备尝辛苦
备而不用
复旧如初
复蹈前辙
夏五郭公
夏日可畏
夏炉冬扇
夏虫不可以语冰
夏虫朝菌
夏虫疑冰
夏虫语冰
夏雨雨人
夏鼎商彝
夕寐宵兴
夕惕朝乾
夕惕朝干
夕惕若厉
夕阳西下
外刚内柔
外厉内荏
外合里差
外合里应
外圆内方
外宽内忌
外宽内明
外宽内深
外巧内嫉
外强中干
外强中瘠
外感内伤
外方内员
外方内圆
外柔内刚
外简内明
夙世冤业
夙世冤家
夙兴夜处
夙兴夜寐
夙兴昧旦
夙夜不解
夙夜匪懈
夙夜匪解
夙夜在公
多一事不如少一事
多一事不如省一事
多事之秋
多凶少吉
多历年所
多历年稔
多口阿师
多嘴多舌
多嘴献浅
多多益办
多多益善
多如牛毛
多快好省
多情善感
多情多义
多情多感
多愁善感
多愁善病
多愁多病
多才多艺
多收并畜
多故之秋
多文为富
多文强记
多方百计
多材多艺
多此一举
多歧亡羊
多灾多难
多端寡要
多管闲事
多能多艺
多艺多才
多藏厚亡
多行不义必自毙
多见广识
多言多语
多言或中
多言数穷
多言繁称
多许少与
多谋善断
多谋善虑
多谋少断
多财善贾
多钱善贾
多闻强记
多闻阙疑
多难兴邦
多鱼之漏
夜不成寐
夜不闭户
夜以继日
夜以继昼
夜光之璧
夜深人静
夜行被绣
夜郎自大
夜长梦多
夜长梦短
夜阑人静
夜雨对床
夜静更深
夜静更阑
夤缘攀附
大中至正
大义凛然
大义灭亲
大书特书
大事不糊涂
大事去矣
大事铺张
大人先生
大人虎变
大仁大义
大做文章
大公无私
大兴土木
大刀阔斧
大功告成
大功毕成
大动公惯
大动干戈
大动肝火
大势已去
大势所趋
大勇若怯
大匠运斤
大千世界
大厦将倾
大厦将颠
大厦栋梁
大发慈悲
大发议论
大发谬论
大发雷霆
大吃一惊
大吆小喝
大吉大利
大同小异
大名难居
大名鼎鼎
大含细入
大吹大打
大吹大擂
大吹法螺
大呼小叫
大呼小喝
大喊大叫
大喜若狂
大喜过望
大器晚成
大地回春
大地春回
大块文章
大块朵颐
大声疾呼
大处着墨
大处着眼
大处落墨
大大咧咧
大大落落
大天白日
大失人望
大失所望
大头小尾
大好河山
大家闺秀
大家风范
大寒索裘
大展宏图
大展经纶
大工告成
大巧若拙
大度包容
大庭广众
大廷广众
大开大合
大开方便之门
大开眼界
大张其词
大张声势
大张挞伐
大张旗鼓
大彻大悟
大得人心
大快人心
大恩大德
大惊失色
大惊小怪
大惑不解
大慈大悲
大手大脚
大才榱槃
大才榱盘
大才槃槃
大才盘盘
大打出手
大摇大摆
大放厥词
大放厥辞
大放悲声
大政方针
大敌当前
大方之家
大旱云霓
大旱望云
大旱望云霓
大明法度
大是大非
大显神通
大显身手
大智大勇
大智如愚
大智若愚
大有人在
大有作为
大有可为
大有可观
大有径庭
大有文章
大有裨益
大有见地
大有起色
大有迳庭
大本大宗
大杀风景
大权在握
大权旁落
大权独揽
大材小用
大杖则走
大树将军
大树底下好乘凉
大梦初醒
大梦方醒
大模大样
大步流星
大气磅礴
大水冲了龙王庙
大江东去
大江南北
大法小廉
大浪淘沙
大海捞针
大渐弥留
大澈大悟
大煞风景
大煞风趣
大璞不完
大直若屈
大直若诎
大相径庭
大相迳庭
大眼望小眼
大禹治水
大笔如椽
大红大紫
大红大緑
大红大绿
大经大法
大缪不然
大而化之
大而无当
大肆厥辞
大肆宣传
大肆挥霍
大肆铺张
大胆包身
大腹便便
大节不夺
大莫与京
大获全胜
大行大市
大街小巷
大言不惭
大计小用
大请大受
大谋不谋
大谬不然
大贤虎变
大败亏轮
大败亏输
大起大落
大路椎轮
大车以载
大辂椎轮
大辩不言
大辩若讷
大逆不道
大逆无道
大醇小疵
大错特错
大难不死
大难临头
大雅之堂
大雅君子
大雨倾盆
大雨如注
大雨滂沱
大音希声
大题小作
大题小做
大风大浪
大马金刀
天上人间
天上石麟
天上麒麟
天下一家
天下为公
天下为家
天下为笼
天下乌鸦一般黑
天下大乱
天下太平
天下归心
天下无双
天下无敌
天下汹汹
天下独步
天下第一
天下莫敌
天不作美
天不假年
天不绝人
天与人归
天之僇民
天之戮民
天之骄子
天人之际
天人共鉴
天从人原
天从人愿
天付良缘
天伦之乐
天作之合
天保九如
天假之年
天假其年
天假因缘
天假良缘
天公地道
天兵天将
天冠地屦
天凝地闭
天华乱坠
天南地北
天南海北
天台路迷
天各一方
天命攸归
天命有归
天地不容
天地剖判
天地经纬
天地诛戮
天地诛灭
天地长久
天堂地狱
天塌地陷
天壤之别
天壤之隔
天壤悬隔
天壤王郎
天外有天
天外飞来
天大地大
天夺之年
天夺之魄
天夺其魄
天女散花
天姿国色
天字第一号
天宝当年
天寒地冻
天崩地坍
天崩地坼
天崩地塌
天崩地裂
天崩地解
天崩地陷
天工人代
天差地远
天平地成
天年不测
天年不遂
天年不齐
天府之国
天开地辟
天怒人怨
天悬地隔
天惊石破
天愁地惨
天成地平
天打雷劈
天授地设
天摇地动
天摧地塌
天方夜谭
天旋地转
天无二日
天无絶人之路
天无绝人之路
天时地利人和
天昏地暗
天昏地黑
天有不测风云
天朗气清
天末凉风
天机不可泄漏
天机不可泄露
天机云锦
天涯咫尺
天涯地角
天涯比邻
天涯海角
天清日白
天清气朗
天渊之别
天渊之隔
天潢贵胄
天灾人祸
天灾地变
天灾地妖
天王老子
天理不容
天理人情
天理昭彰
天理昭昭
天理良心
天理难容
天生丽质
天生地设
天生天化
天生天杀
天生尤物
天真烂漫
天真烂熳
天知地知
天空海阔
天粟马角
天经地义
天经地纬
天缘凑合
天网恢恢
天罗地网
天翻地覆
天老地荒
天花乱坠
天若有情天亦老
天荆地棘
天荒地老
天行时气
天衣无缝
天覆地载
天诛地灭
天诱其衷
天造地设
天造草昧
天道人事
天道好还
天道宁论
天道无亲
天长地久
天长地老
天长日久
天随人原
天随人愿
天震地骇
天香国色
天马行空
天高听下
天高听卑
天高地下
天高地厚
天高地迥
天高日远
天高皇帝远
太上忘情
太丘道广
太仓一粟
太仓稊米
太山北斗
太岁头上动土
太平无事
太平无象
太平盛世
太歳头上动土
太阿倒持
夫人裙带
夫倡妇随
夫唱妇随
夫妻反目
夫子自道
夫荣妻显
夫荣妻贵
夫负妻戴
夫贵妻荣
夭桃秾李
夭桃穠李
夭桃襛李
失之东隅
失之交臂
失张冒势
失张失智
失惊倒怪
失惊打怪
失时落势
失精落彩
失诸交臂
失败为成功之母
失道寡助
失马塞翁
失魂丧胆
失魂丧魄
失魂荡魄
失魂落魄
头一无二
头上安头
头上末下
头上着头
头上著头
头会箕敛
头会箕赋
头出头没
头头是道
头昏目晕
头昏目眩
头昏眼晕
头昏眼暗
头昏眼花
头昏脑眩
头昏脑胀
头昏脑闷
头晕目眩
头晕眼花
头梢自领
头没杯案
头焦额烂
头疼脑热
头痒搔跟
头痛脑热
头痛额热
头眩目昏
头破血出
头破血流
头破血淋
头稍自领
头童齿豁
头角峥嵘
头足倒置
头足异处
头足异所
头重脚轻
头面人物
头高头低
夷然自若
夸多斗靡
夸大其词
夸大其辞
夸夸其谈
夸夸而谈
夸强道会
夸父追日
夸父逐日
夹七夹八
夹板医驼子
夹枪带棍
夹枪带棒
夹袋人物
夺人所好
夺其谈经
夺席谈经
夺眶而出
夺胎换骨
夺门而出
奄奄一息
奇光异彩
奇形异状
奇形怪状
奇想天开
奇才异能
奇技淫巧
奇文共赏
奇文瑰句
奇珍异宝
奇珍异玩
奇离古怪
奇耻大辱
奇花异卉
奇花异草
奇葩异卉
奇装异服
奇谈怪论
奇货可居
奉为圭臬
奉为楷模
奉为至宝
奉令承教
奉公不阿
奉公克己
奉公如法
奉公守法
奉公正己
奉命唯谨
奉命惟谨
奉天承运
奉头鼠窜
奉如神明
奉扬仁风
奉若神明
奉行故事
奉辞伐罪
奋不顾命
奋不顾身
奋勇当先
奋发图强
奋发有为
奋发踔厉
奋发蹈厉
奋武扬威
奋笔疾书
奋笔直书
奋袂而起
奋起直追
奋身不顾
契合金兰
契船求剑
契若金兰
奔走之友
奔走呼号
奔走如市
奔走相告
奔走钻营
奔轶絶尘
奔轶绝尘
奔逸絶尘
奔逸绝尘
奖罚分明
奥妙无穷
奥援有灵
奴颜婢睐
奴颜婢膝
奴颜婢色
奴颜媚骨
奸掳烧杀
奸淫掳掠
好丹非素
好为事端
好为人师
好了疮疤忘了痛
好事之徒
好事多悭
好事多磨
好事天悭
好佚恶劳
好勇斗狠
好吃懒做
好善乐施
好善嫉恶
好善恶恶
好声好气
好大喜功
好天良夜
好奇尚异
好女不穿嫁时衣
好好先生
好学不倦
好心做了驴肝肺
好心好意
好恶不同
好戴高帽
好整以暇
好景不常
好景不长
好梦不长
好梦难圆
好梦难成
好模好样
好汉不吃眼前亏
好生之德
好肉剜疮
好自为之
好色之徒
好行小惠
好行小慧
好言好语
好语似珠
好语如珠
好说歹说
好谋善断
好逸恶劳
好酒贪杯
好问决疑
好问则裕
好骑者堕
好高骛远
好高鹜远
如不胜衣
如丘而止
如丧考妣
如临大敌
如临深渊
如临深谷
如之奈何
如兄如弟
如入无人之境
如出一口
如出一辙
如切如磋
如原以偿
如坐云雾
如坐春风
如坐针毡
如埙如箎
如埙如篪
如堕五里雾中
如堕烟海
如堕烟雾
如天之福
如履如临
如履平地
如履薄冰
如山压卵
如左右手
如应斯响
如弃敝屣
如影随形
如意算盘
如愿以偿
如手如足
如拾地芥
如持左券
如指诸掌
如振落叶
如操左券
如数家珍
如无其事
如日中天
如日方中
如日方升
如是我闻
如有所失
如梦初觉
如梦初醒
如梦如醉
如梦方醒
如椽大笔
如此而已
如水投石
如水赴壑
如汤沃雪
如汤泼雪
如汤浇雪
如汤灌雪
如法泡制
如法炮制
如法砲制
如泣如诉
如泣草芥
如渴如饥
如火如荼
如火燎原
如牛负重
如狼似虎
如狼如虎
如狼牧羊
如痴似醉
如痴如梦
如痴如狂
如痴如醉
如登春台
如石投水
如箭在弦
如胶似漆
如胶如漆
如胶投漆
如臂使指
如芒刺背
如芒在背
如花似月
如花似朵
如花似玉
如花似锦
如获至宝
如获至寳
如获至珍
如虎傅翼
如虎得翼
如虎添翼
如虎生翼
如蚁慕膻
如蚁附膻
如蝇逐臭
如见肺肝
如解倒悬
如蹈水火
如蹈汤火
如运诸掌
如醉初醒
如醉如梦
如醉如狂
如醉如痴
如醉方醒
如释重负
如锥画沙
如雷灌耳
如雷贯耳
如风过耳
如饥似渴
如饥如渴
如饮醍醐
如鱼似水
如鱼得水
如鲠在喉
如鸟兽散
如龙似虎
妄下雌黄
妄口巴舌
妄尘而拜
妄生穿凿
妄自尊大
妄自菲薄
妄言妄听
妄谈祸福
妆嫫费黛
妆模作样
妆聋作哑
妆聋做哑
妇人之仁
妇人孺子
妇人醇酒
妇姑勃溪
妇姑勃谿
妇姑勃豀
妇孺皆知
妍姿艳质
妍蚩好恶
妒能害贤
妒贤嫉能
妒贤疾能
妖不胜德
妖形怪状
妖由人兴
妖言惑众
妖魔鬼怪
妙不可言
妙处不传
妙想天开
妙手丹青
妙手偶得
妙手回春
妙手空空
妙算神机
妙絶时人
妙绝时人
妙舞清歌
妙言要道
妙语惊人
妙语解烦
妙语解颐
妙语连珠
妙趣横生
妥首帖耳
妨功害能
妻儿老小
妻儿老少
妻梅子鹤
妻离子散
妻荣夫贵
始乱终弃
始作俑者
始愿不及此
始末原由
始末缘由
始终不懈
始终不易
始终不渝
始终如一
始终若一
姑妄听之
姑妄言之
姑射神人
姑息养奸
姑置勿论
姓甚名谁
委委佗佗
委曲成全
委曲求全
委罪于人
委肉虎蹊
委过于人
委重投艰
委靡不振
姗姗来迟
姚黄魏品
姚黄魏紫
姜桂之性
姱容修态
姹紫嫣红
姿意妄为
威信扫地
威凤一羽
威凤祥麟
威刑肃物
威望素着
威望素著
威武不屈
威胁利诱
威迫利诱
威重令行
威震天下
威风八面
威风凛凛
威风扫地
威风祥麟
娇声娇气
娇小玲珑
娇生惯养
娇皮嫩肉
娇鸾雏凤
娉婷婀娜
娉婷袅娜
娓娓不倦
娓娓动听
娓娓而谈
娟好静秀
娱妻弄子
娱心悦目
婀娜多姿
婆娑起舞
婆婆妈妈
婢作夫人
婢膝奴颜
媒妁之言
嫁犬逐犬
嫁狗逐狗
嫁狗随狗
嫁祸于人
嫁鸡逐鸡
嫂溺叔援
嫉恶如仇
嫉恶若仇
嫉贤傲士
嫉贤妒能
嫉贪如雠
嫉闲妒能
嫌好道恶
嫌好道歉
嫌好道歹
嫌贫爱富
嫌长道短
嫠不恤纬
嫣然一笑
嫣红姹紫
嬉皮笑脸
嬉笑怒骂
嬴奸买俏
孀妻弱子
子丑寅卯
子为父隐
子夏悬鹑
子女玉帛
子子孙孙
子孝父慈
子曰诗云
子虚乌有
孑然一身
孔孟之道
孔席不暖
孔席不适
孔席墨突
孔思周情
孔情周思
孔武有力
字字珠玉
字字珠玑
字斟句酌
字正腔圆
字里行间
字顺文从
存亡安危
存亡未卜
存亡絶续
存亡绝续
存亡继絶
存亡继绝
存亡续絶
存亡续绝
存十一于千百
存心不良
存心养性
存心积虑
存而不论
孙庞斗智
孙康映雪
孚尹旁达
孚尹明达
孜孜不倦
孜孜不已
孜孜不怠
孜孜不懈
孜孜不辍
孜孜以求
孜孜无倦
孜孜无怠
孜孜汲汲
孜孜矻矻
孝子慈孙
孝子爱日
孝子贤孙
孝子顺孙
孝思不匮
孝悌力田
孝悌忠信
孟母三迁
季友伯兄
季孙之忧
季孟之间
季布一诺
季常之惧
季常之癖
季路一言
孤云野鹤
孤俦寡匹
孤傲不群
孤儿寡妇
孤军作战
孤军奋战
孤军深入
孤学坠绪
孤家寡人
孤寡鳏独
孤履危行
孤形吊影
孤恩负义
孤悬客寄
孤悬浮寄
孤掌难鸣
孤文只义
孤文断句
孤标傲世
孤标独步
孤注一掷
孤犊触乳
孤独矜寡
孤独鳏寡
孤立寡与
孤立无助
孤立无援
孤臣孽子
孤舟独桨
孤芳自赏
孤苦仃俜
孤苦伶仃
孤苦零丁
孤行一意
孤行己意
孤行己见
孤豚腐鼠
孤身只影
孤陋寡闻
孤雌寡鹤
孤雏腐鼠
孤魂野鬼
孤鸾寡鹄
孤鸾照镜
孤鸿寡鹄
学书学剑
学以致用
学如穿井
学富五车
学富才高
学无常师
学无止境
学步邯郸
学浅才疏
学海无涯
学疏才浅
学究天人
学老于年
学而不厌
学而优则仕
学而时习之
学识渊博
学贯中西
学非所用
孳孳不倦
孳孳汲汲
孳孳矻矻
孳蔓难图
孺子可教
孽子孤臣
孽根祸胎
孽障种子
宁折不弯
宁死不屈
宁死不辱
宁缺勿滥
宁缺毋滥
宅中图大
宅心忠厚
守先待后
守分安常
守口如瓶
守土有责
守望相助
守株待兔
守正不回
守正不挠
守正不桡
守正不阿
守瓶缄口
守约施博
守约施搏
守经达权
守缺抱残
守节不移
守财奴
守身如玉
守道安贫
守阙抱残
安不忘危
安之若命
安之若素
安乐窝
安于一隅
安于现状
安于盘石
安份守己
安内攘外
安分守己
安分守已
安分知足
安危与共
安危相易
安国宁家
安国富民
安土乐业
安土重居
安土重旧
安土重迁
安坐待毙
安堵乐业
安堵如故
安如太山
安如泰山
安如盘石
安如磐石
安宅正路
安安稳稳
安室利处
安家乐业
安家立业
安家落户
安富尊荣
安富恤穷
安富恤贫
安居乐业
安常习故
安常处顺
安常守分
安常守故
安常履顺
安心乐业
安心乐意
安心定志
安心落意
安忍无亲
安故重迁
安时处顺
安枕而卧
安步当车
安民告示
安然如故
安然无事
安然无恙
安生乐业
安生服业
安眉带眼
安神定魄
安老怀少
安良除暴
安若泰山
安营下寨
安营扎寨
安贫乐贱
安贫乐道
安贫守道
安身为乐
安身之地
安身之处
安身乐业
安身立命
安车蒲轮
安适如常
安邦定国
安邦治国
安闲自在
安闲自得
安魂定魄
宋才潘面
宋斤鲁削
宋玉东墙
宋画吴冶
完事大吉
完名全节
完好无缺
完璧归赵
完美无疵
完美无缺
宏儒硕学
宏图大志
宏才大略
宏材大略
宗师案临
宗庙社稷
官仓老鼠
官偪民反
官卑职小
官场如戏
官官相为
官官相卫
官官相护
官情纸薄
官报私仇
官样文章
官止神行
官法如炉
官虎吏狼
官轻势微
官运亨通
官逼民反
定乱扶衰
定于一尊
定倾扶危
定国安邦
宛转悠扬
宛转蛾眉
宜喜宜嗔
宜嗔宜喜
宜室宜家
宜家宜室
宝刀不老
宝刀未老
宝山空回
宝珠市饼
宝马香车
实与有力
实事求是
实偪处此
实心实意
实繁有徒
实至名归
实获我心
实蕃有徒
实逼处此
宠柳娇花
宠辱不惊
宠辱皆忘
宠辱若惊
审几度势
审己度人
审时度势
审曲面势
审曲面埶
客死他乡
宣化承流
室不崇坛
室如县罄
室如悬磬
室如悬罄
室徒四壁
室怒市色
室迩人远
室迩人遐
室迩人遥
宦海浮沉
宦海风波
宫车晏驾
宫邻金虎
宰相肚里好撑船
宰鸡教猴
害人不浅
害羣之马
害群之马
宴安酖毒
宴安鸠毒
宴安鸩毒
宴尔新婚
宵旰图治
宵旰忧劳
宵旰忧勤
宵旰焦劳
宵衣旰食
宵鱼垂化
家丑不可外扬
家丑不可外谈
家书抵万金
家亡国破
家传人诵
家传户诵
家传户颂
家反宅乱
家喻户习
家喻户晓
家学渊源
家家户户
家常便饭
家常茶饭
家常里短
家弦户诵
家徒四壁
家徒壁立
家成业就
家散人亡
家无二主
家无儋石
家无常礼
家无担石
家无斗储
家殷人足
家烦宅乱
家破人亡
家破人离
家破身亡
家累千金
家给人足
家给民足
家翻宅乱
家至人说
家至户到
家至户察
家至户晓
家藏户有
家衍人给
家见户说
家谕户晓
家败人亡
家贫亲老
家贫如洗
家贼难防
家道中落
家道从容
家道小康
家道消乏
家长礼短
家长里短
家骥人璧
家鸡野雉
家鸡野鹜
容光焕发
容头过身
容膝之地
宽仁大度
宽以待人
宽大为怀
宽宏大度
宽宏大量
宽怀大度
宽打窄用
宽洪大度
宽洪大量
宽洪海量
宽猛并济
宽猛相济
宽豁大度
宾入如归
宾客如云
宾客盈门
宾客迎门
宾朋满座
宾来如归
宾至如归
宾餞日月
宾饯日月
宿学旧儒
宿弊一清
宿水飡风
宿水飱风
宿水餐风
宿雨餐风
寂天寞地
寂寂无闻
寂然不动
寂然无声
寂若无人
寄人檐下
寄人篱下
寄兴寓情
寄迹山林
寄雁传书
寄颜无所
寄鴈传书
寅吃卯粮
寅支卯粮
密不通风
密云不雨
密密层层
密约偷期
密锣紧鼓
富丽堂皇
富于春秋
富可敌国
富商大贾
富商巨贾
富商蓄贾
富国安民
富国强兵
富国强民
富国彊兵
富国裕民
富在知足
富埒王侯
富埒陶白
富堪敌国
富室大家
富家大室
富家巨室
富贵不淫
富贵不能淫
富贵利达
富贵显荣
富贵浮云
富贵荣华
富贵逼人
富贵逼人来
富贵骄人
富轹万古
富面百城
寒冬腊月
寒往暑来
寒心消志
寒心酸鼻
寒心销志
寒木春华
寒来暑往
寒毛卓竖
寒泉之思
寒灰更然
寒耕暑耘
寒耕热耘
寒腹短识
寒花晚节
寒蝉仗马
寒蝉僵鸟
寒蝉凄切
寒酸落魄
寒附火者
寒风侵肌
寓兵于农
寓情于景
寓意深远
寓意深长
寝不安席
寝不成寐
寝不聊寐
寝丘之志
寝关曝纩
寝皮食肉
寝苫枕土
寝苫枕块
寝苫枕干
寝苫枕戈
寝苫枕草
寝食不安
寝食俱废
察今知古
察察为明
察察而明
察己知人
察见渊鱼
察言观色
察言观行
察颜观色
寡不敌众
寡不胜众
寡二少双
寡人之疾
寡信轻诺
寡凫单鹄
寡廉鲜耻
寡情薄意
寡见少闻
寡见鲜闻
寡闻少见
寡鹄孤鸾
寤寐求之
寥寥可数
寥寥无几
寥若晨星
寸丝不挂
寸丝半粟
寸兵尺铁
寸利必得
寸善片长
寸土不让
寸土尺地
寸土尺金
寸土必争
寸地尺天
寸心千古
寸指测渊
寸有所长
寸木岑楼
寸步不离
寸步不让
寸步千里
寸步难移
寸步难行
寸田尺宅
寸男尺女
寸积铢累
寸草不生
寸草不留
寸草春晖
寸草衔结
寸蹄尺缣
寸蹏尺缣
寸辖制轮
寸进尺退
寸量铢称
寸铁在手
寸铁杀人
寸长尺技
寸长尺短
寸长片善
寸阴尺璧
寸阴是惜
寸阴若岁
对头冤家
对客挥毫
对床夜语
对床夜雨
对床风雨
对景伤情
对景挂画
对牛弹琴
对牛鼓簧
对症下药
对症之药
对症发药
对答如流
对簿公堂
对薄公堂
对证下药
对酒当歌
寻事生非
寻壑经丘
寻幽入微
寻幽探胜
寻弊索瑕
寻枝摘叶
寻根拔树
寻根究底
寻根追底
寻根问底
寻欢作乐
寻死觅活
寻流逐末
寻消问息
寻源讨本
寻瑕伺隙
寻瘢索绽
寻章摘句
寻花觅柳
寻花问柳
寻行数墨
寻行逐队
寻踪觅迹
寻风捉影
导以取保
导德齐礼
寿不压职
寿元无量
寿山福海
寿比南山
寿满天年
寿终正寝
寿陵失步
封刀挂剑
封妻荫子
封官许原
封官许愿
封己守残
封胡羯末
封胡遏末
封豕长蛇
封豨修蛇
封金挂印
射人先射马
射像止啼
射利沽名
射影含沙
射石饮羽
射鱼指天
将伯之助
将伯之呼
将信将疑
将功折罪
将功折过
将功抵罪
将功补过
将功赎罪
将勤补拙
将取固予
将天就地
将夺固与
将心比心
将无作有
将无做有
将本求利
将本求财
将机就机
将机就计
将李代桃
将相之器
将胸比肚
将虾钓鳖
将计就计
将遇良才
将遇良材
将错就错
将门无犬子
将门有将
将门虎子
将顺其美
将飞翼伏
尊主泽民
尊俎折冲
尊古卑今
尊姓大名
尊己卑人
尊师贵道
尊师重道
尊年尚齿
尊无二上
尊贤使能
小不忍则乱大谋
小丑跳梁
小人得志
小受大走
小器易盈
小国寡民
小大由之
小姑独处
小子后生
小家子气
小家碧玉
小小不言
小屈大伸
小屈大申
小巧玲珑
小巫见大巫
小己得失
小康之家
小廉大法
小廉曲谨
小异大同
小往大来
小德出入
小心翼翼
小心谨慎
小恩小惠
小惩大诫
小户人家
小手小脚
小时了了
小本经营
小枉大直
小眼薄皮
小肚鸡肠
小脚女人
小试锋芒
小道消息
小隙沉舟
小题大作
小题大做
小鸟依人
小鹿触心头
小黠大痴
少不更事
少不经事
少吃俭用
少头缺尾
少安无躁
少安毋躁
少小无猜
少年老成
少年老诚
少成若性
少条失教
少气无力
少私寡欲
少纵即逝
少见多怪
少言寡语
尔汝之交
尔虞我诈
尔诈我虞
尖嘴猴腮
尖嘴薄舌
尖担两头脱
尖言冷语
尖言尖语
尖酸刻薄
尘垢秕糠
尘垢粃糠
尘羹涂饭
尘饭涂羹
尚虚中馈
尝出入
尝在围中
尝胆卧薪
尝胆眠薪
尝鼎一脔
尤云殢雨
尤云殢雪
尤物移人
尤红殢翠
尤而效之
尤花殢雪
尧天舜日
尧年舜日
尧趋舜步
尨眉皓发
就事论事
就地取材
就地正法
就棍打腿
就正有道
就汤下面
就虚避实
尸位素餐
尸利素餐
尸居余气
尸居龙见
尸山血海
尸横遍野
尸禄素飡
尸禄素餐
尸鸠之平
尺二冤家
尺二秀才
尺兵寸铁
尺壁寸阴
尺寸之功
尺寸之地
尺寸之柄
尺寸千里
尺寸可取
尺山寸水
尺布斗粟
尺幅千里
尺幅寸缣
尺有所短
尺板斗食
尺树寸泓
尺椽片瓦
尺步绳趋
尺水丈波
尺波电谢
尺泽之鲵
尺瑜寸瑕
尺短寸长
尺竹伍符
尺籍伍符
尺蠖求伸
尻舆神马
尻轮神马
尽人皆知
尽付东流
尽信书不如无书
尽入彀中
尽其在我
尽其所长
尽力而为
尽善尽美
尽多尽少
尽如人意
尽心尽力
尽心竭力
尽忠报国
尽忠竭力
尽态极妍
尽思极心
尽情尽理
尽智竭力
尽欢而散
尽美尽善
尽诚竭节
尽释前嫌
尾大不掉
尾大难掉
尾生之信
尾生抱柱
尿流屁滚
局促不安
局地吁天
局地扣天
局地钥天
局外之人
局天促地
局天扣地
局天蹐地
局骗拐带
局高天蹐厚地
局高蹐厚
屁滚尿流
层出不穷
层出叠见
层出迭见
层台累榭
层峦叠嶂
层峦迭嶂
层见叠出
层见迭出
层见错出
居下讪上
居不重席
居不重茵
居之不疑
居仁由义
居停主人
居利思义
居功自傲
居大不易
居安思危
居安虑危
居安资深
居官守法
居心不良
居心叵测
居心险恶
居无求安
居轴处中
居重驭轻
居高临下
屈尊就卑
屈打成招
屈指可数
屈艳班香
屈节辱命
屈蠖求伸
屈谷巨瓠
屈高就下
屋上乌
屋上建瓴
屋下作屋
屋下架屋
屋下盖屋
屋乌之爱
屋乌推爱
屋如七星
屎屁直流
屎流屁滚
屎滚尿流
屏声息气
屏声敛息
屏声静气
屏气凝神
屏气吞声
屏气慑息
屏气敛息
屐齿之折
展眼舒眉
展翅高飞
展脚伸腰
屙金溺银
属人耳目
属垣有耳
属毛离里
属词比事
属辞比事
屠所牛羊
屠毒笔墨
屠门大嚼
屠龙之伎
屠龙之技
屦及剑及
屦贱踊贵
屯毛不辨
屯积居奇
屯粮积草
屯街塞巷
屯蹶否塞
屯蹷否塞
山中宰相
山亏一篑
山亏一蒉
山光水色
山公倒载
山包海容
山南海北
山吟泽唱
山呼海啸
山复整妆
山容海纳
山寒水冷
山峙渊渟
山崩地坼
山崩地塌
山崩地裂
山崩地陷
山崩川竭
山崩水竭
山崩海啸
山崩钟应
山川米聚
山摇地动
山明水秀
山木自寇
山林隐逸
山枯石死
山栖谷隐
山栖谷饮
山止川行
山殽野湋
山水相连
山河表里
山清水秀
山溜穿石
山珍海味
山珍海胥
山珍海错
山盟海誓
山眉水眼
山砠水厓
山积波委
山穷水尽
山穷水断
山穷水絶
山穷水绝
山童石烂
山肤水豢
山肴海错
山肴野蔌
山节藻棁
山行海宿
山遥水远
山遥路远
山重水复
山锐则不高
山长水远
山长水阔
山阴乘兴
山阴夜雪
山陬海澨
山雨欲来风满楼
山颓木坏
山高水低
山高水长
山高水险
山高皇帝远
山鸡舞镜
山鸣谷应
岁不我与
岁丰年稔
岁在龙虵
岁在龙蛇
岁寒三友
岁寒松柏
岁寒知松柏
岁序更新
岁时伏腊
岁暮天寒
岁月不居
岁月如流
岁月峥嵘
岁月蹉跎
岁比不登
岁稔年丰
岁聿云暮
岁聿其莫
岂弟君子
岂有是理
岂有此理
岌岌不可终日
岌岌可危
岐出岐入
岑楼齐末
岗头泽底
岛瘦郊寒
岩居川观
岩居穴处
岩栖穴处
岩栖谷隐
岩栖谷饮
岩穴之士
岳岳磊磊
岳岳荦荦
岳峙渊渟
岳镇渊渟
岸然道貌
岸谷之变
岿然不动
岿然独存
峣峣易缺
峥嵘岁月
峨冠博带
峨峨汤汤
峨峨洋洋
峭论鲠议
峯回路转
峰回路转
峻宇彫墙
峻宇雕墙
峻阪盐车
崇墉百雉
崇山峻岭
崇本抑末
崇洋媚外
崇论吰议
崇论宏议
崇论谹议
崇论闳议
崇雅黜浮
崎嵚历落
崛地而起
崟崎历落
崟崎磊落
崤函之固
崧生岳降
崭露头脚
崭露头角
嵚崎历落
嵚崎磊落
嵩生岳降
嵬目鸿耳
嵬眼澒耳
巍巍荡荡
巍然屹立
川壅必溃
川泽纳污
川流不息
川渟岳峙
巢倾卵破
巢倾卵覆
巢居穴处
巢林一枝
巢毁卵破
巢焚原燎
工力悉敌
左书右息
左右两难
左右为难
左右图史
左右开弓
左右逢原
左右逢源
左右采获
左图右书
左图右史
左宜右宜
左宜右有
左家娇女
左建外易
左思右想
左拥右抱
左提右挈
左支右吾
左支右绌
左支右调
左枝右梧
左萦右拂
左辅右弼
左道旁门
左邻右舍
左邻右里
左铅右椠
左顾右盼
左顾右眄
巧不可接
巧不可阶
巧伪趋利
巧作名目
巧偷豪夺
巧发奇中
巧取豪夺
巧同造化
巧夺天工
巧妇难为无米之炊
巧捷万端
巧立名目
巧立名色
巧舌如簧
巧言令色
巧言偏辞
巧言利口
巧言如簧
巧语花言
巨人长德
巨学鸿生
巨细无遗
巫云楚雨
巫山云雨
巫山洛浦
差三错四
差强人意
己溺己饥
己饥己溺
巴三揽四
巴三览四
巴人下里
巴前算后
巴头探脑
巴山夜雨
巴山度岭
巴山蜀水
巴山越岭
巴巴劫劫
巴巴急急
巴巴结结
巴高望上
巴高枝儿
巷尾街头
巷议街谈
巾国英雄
巾帼丈夫
巾帼奇才
巾帼英雄
巾帼豪杰
巾帼须眉
币重言甘
市不二价
市井之徒
市井之臣
市井小人
市井无赖
市无二价
市民文学
市道之交
布天盖地
布帆无恙
布帛菽粟
布衣之交
布衣粝食
布衣蔬食
布衣韦带
布衣黔首
布袋里老鸦
布袜青鞋
布被瓦器
布裙荆钗
布颿无恙
布鼓雷门
师严道尊
师出无名
师出有名
师心自是
师心自用
师直为壮
师老兵疲
师老兵破
师道尊严
希世之宝
希世之才
希世之珍
希奇古怪
希旨承颜
帏箔不修
帏薄不修
帘窥壁听
帘视壁听
帝王将相
帝辇之下
帡天极地
带减腰围
带月披星
带水拖泥
带牛佩犊
带着铃铛去做贼
带砺山河
带砺河山
带罪立功
带金佩紫
席上之珍
席不暇暖
席丰履厚
席卷八荒
席卷天下
席卷而逃
席地幕天
席地而坐
席履丰厚
席珍待聘
席薪枕块
席门穷巷
席门蓬巷
帮狗吃食
帮虎吃食
帮闲钻懒
帷幕不修
帷灯匣剑
帷灯箧剑
帷箔不修
帷薄不修
常备不懈
常年累月
常胜将军
常鳞凡介
幕天席地
幕燕釜鱼
幕燕鼎鱼
幡然悔悟
幡然改途
干云蔽日
干净利索
干净利落
干卿底事
干名犯义
干名采誉
干啼湿哭
干城之将
干将莫邪
干巴利脆
干巴利落
干干翼翼
干戈载戢
干柴烈火
干浄利索
干浄利落
干父之蛊
干端坤倪
干脆利索
干脆利落
干霄凌云
干霄蔽日
平分秋色
平原易野
平原督邮
平地一声雷
平地楼台
平地登云
平地起孤丁
平地起家
平地起雷
平地青云
平地风波
平地风雷
平头正脸
平安无事
平心定气
平心易气
平心而论
平心静气
平易近人
平易近民
平步登天
平步青云
平步青霄
平治天下
平流缓进
平淡无奇
平澹无奇
平白无故
平白无辜
平起平坐
平铺直叙
平铺直序
平风静浪
年事已高
年华垂暮
年壮气锐
年复一年
年头月尾
年富力强
年深岁久
年深日久
年深月久
年湮世远
年登花甲
年经国纬
年衰岁暮
年该月值
年谊世好
年谷不登
年轻力壮
年近古稀
年逾古稀
年高德劭
年高德勋
年高德卲
年高望重
并世无两
并为一谈
并威偶势
并存不悖
并容徧覆
并日而食
并疆兼巷
并蒂芙蓉
并行不悖
并赃拿贼
并驱争先
并驾齐驱
幸灾乐祸
幺么小丑
幺幺小丑
幺弦孤韵
幺豚暮鹨
幺麽小丑
幼学壮行
幽期密约
广厦万间
广土众民
广夏细旃
广寒仙子
广庭大众
广开才路
广开言路
广文先生
广种薄收
广结良缘
广见洽闻
广譬曲谕
广陵散绝
庄严宝相
庄周梦蝶
庄生梦蝶
庄舄越吟
庆吊不行
床上叠床
床上安床
床上施床
床上迭床
床下安床
床下牛斗
床头金尽
床笫之私
庐山真面
庐山真面目
庐山面目
应付自如
应付裕如
应刃而解
应变无方
应名点卯
应声虫
应天从人
应天承运
应天顺人
应天顺民
应对如响
应对如流
应弦而倒
应接不暇
应时对景
应有尽有
应机立断
应权通变
应答如响
应答如流
应节合拍
应运而生
底死谩生
庖丁解牛
庚癸之呼
庚癸频呼
庞然大物
庞眉白发
庞眉皓发
庞眉皓首
庞眉鹤发
庞眉黄发
废书而叹
废寝忘食
废寝忘飱
废寝忘餐
废文任武
废然而反
废然而返
废私立公
废话连篇
度外之人
度己以绳
度己失期
度德量力
度日如岁
度日如年
度长絜大
度长絜短
座无虚席
康庄大道
庸中佼佼
庸中皦皦
庸人自扰
庸医杀人
庸庸碌碌
庸耳俗目
庸言庸行
廉可寄财
廉明公正
廉泉让水
廉洁奉公
廉而不刿
廉远堂高
廉顽立懦
廓达大度
延年益寿
延津之合
延津剑合
延颈举踵
延颈企踵
延颈跂踵
延颈鹤望
廷争面折
建功立业
建功立事
建瓴高屋
开云见天
开云见日
开利除害
开华结果
开卷有益
开口见喉咙
开口见心
开口见胆
开台锣鼓
开合自如
开国元勋
开国元老
开国功臣
开国承家
开基创业
开基立业
开天辟地
开宗明义
开山始祖
开山祖师
开山老祖
开山鼻祖
开弓不放箭
开心见肠
开心见胆
开心见诚
开怀畅饮
开来继往
开柙出虎
开源节流
开物成务
开疆展土
开疆拓土
开疆拓境
开疆拓宇
开疆辟土
开眉展眼
开眉笑眼
开科取士
开花结实
开花结果
开诚布公
开诚相见
开路先锋
开锣喝道
开门七件事
开门延盗
开门揖盗
开门见山
开阔眼界
开阶立极
开雾睹天
异乎寻常
异军特起
异军突起
异口同声
异口同辞
异口同音
异口同韵
异名同实
异地相逢
异宝奇珍
异想天开
异曲同工
异木奇花
异涂同归
异端邪说
异草奇花
异路同归
异途同归
异闻传说
异香扑鼻
弃义倍信
弃之可惜
弃之如敝屐
弃之度外
弃之敝屣
弃书捐剑
弃伪从真
弃公营私
弃其余鱼
弃其馀鱼
弃同即异
弃好背盟
弃如敝屣
弃家荡产
弃恶从善
弃情遗世
弃故揽新
弃文存质
弃文就武
弃旧图新
弃旧怜新
弃旧迎新
弃明投暗
弃易求难
弃智遗身
弃暗投明
弃末反本
弃末返本
弃本求末
弃本逐末
弃琼拾砾
弃瑕取用
弃瑕录用
弃瑕忘过
弃瑕録用
弃甲丢盔
弃甲倒戈
弃甲投戈
弃甲曳兵
弃甲负弩
弃短就长
弃短用长
弃笔从戎
弃若敝屣
弃车走林
弃过图新
弃逆归顺
弃道任术
弃邪从正
弃邪归正
弄假成真
弄兵潢池
弄口鸣舌
弄嘴弄舌
弄巧反拙
弄巧成拙
弄影团风
弄性尚气
弄斤操斧
弄斧班门
弄月吟风
弄月嘲风
弄法舞文
弄玉吹箫
弄璋之喜
弄瓦之喜
弄眉挤眼
弄神弄鬼
弄竹弹丝
弄管调弦
弄粉调朱
弄虚作假
弄鬼妆幺
弄鬼弄神
弄鬼掉猴
弊帚千金
弊帚自珍
弊絶风清
弊绝风清
弊衣疎食
弊衣疏食
弊衣箪食
弊衣蔬食
弊车羸马
弋人何篡
弓影杯蛇
弓影浮杯
弓折刀尽
弓调马服
引人入胜
引人注目
引以为憾
引以为戒
引以为耻
引以为荣
引伸触类
引古喻今
引古证今
引吭悲歌
引吭高唱
引吭高声
引吭高歌
引咎自责
引咎责躬
引商刻羽
引商刻角
引喻失义
引律比附
引手投足
引新吐故
引日成岁
引水入墙
引火烧身
引物连类
引狗入寨
引狼入室
引狼拒虎
引狼自卫
引玉之砖
引申触类
引短推长
引类呼朋
引线穿针
引经据典
引经据古
引绳切墨
引绳批根
引绳排根
引绳棋布
引而不发
引虎入室
引虎拒狼
引虎自卫
引足救经
引车卖浆
引过自责
引针拾芥
引锥刺股
引领而望
引颈受戮
引风吹火
引首以望
引鬼上门
弗敢专也
弘奖风流
弘此远谟
弘毅宽厚
弛声走誉
弛高骛远
弛魂宕魄
弟男子侄
张三李四
张公吃酒李公醉
张公吃酒李公颠
张冠李戴
张口掉舌
张口结舌
张唇植髭
张嘴挢舌
张大其事
张大其词
张大其辞
张徨失措
张惶失措
张慌失措
张敞画眉
张本继末
张灯结彩
张灯结采
张牙舞爪
张王李赵
张王赵李
张甲李乙
张皇其事
张皇失措
张眉努目
张眉努眼
张眉张眼
张眼露睛
张脉偾兴
张良借箸
张袂成帷
张袂成阴
弢迹匿光
弥天大祸
弥天大罪
弥天大谎
弥山亘野
弥日累夜
弥留之际
弥缝其阙
弦外之响
弦外之意
弦外之音
弦外有音
弦外遗音
弦无虚发
弩下逃箭
弩张剑拔
弯弓饮羽
弯腰捧腹
弱不好弄
弱不禁风
弱不胜衣
弱本强末
弱水之隔
弱管轻丝
弱肉强食
弸中彪外
弹丝品竹
弹丸之地
弹丸脱手
弹丸黑子
弹丸黑志
弹冠振衣
弹冠振衿
弹冠相庆
弹冠结绶
弹剑作歌
弹尽援绝
弹尽粮绝
弹指之间
弹斤估两
弹无虚发
弹空说嘴
弹觔估两
弹铗无鱼
弹雨枪林
强不知以为知
强中更有强中手
强中自有强中手
强人所难
强作解人
强兵富国
强凫变鹤
强加于人
强唇劣嘴
强嘴拗舌
强嘴硬牙
强奸民意
强将手下无弱兵
强干弱枝
强弓劲弩
强弩之末
强弩之极
强弩末矢
强得易贫
强文假醋
强文浉醋
强本弱支
强本弱末
强本弱枝
强本节用
强枝弱本
强死强活
强死赖活
强直自遂
强而后可
强聒不舍
强自取折
强自取柱
强记博闻
强识博闻
强词夺正
强词夺理
强颜欢笑
强食弱肉
强食自爱
强食靡角
强龙不压地头蛇
归之若水
归全反真
归十归一
归去来兮
归奇顾怪
归心似箭
归心如箭
归根到底
归根究柢
归根结底
归根结柢
归根结蒂
归正守丘
归正邱首
归正首丘
归正首邱
归真反朴
归真反璞
归邪转曜
归马放牛
当世才度
当世无双
当之无愧
当之有愧
当仁不让
当今无辈
当刑而王
当务之急
当务始终
当场出丑
当场出彩
当头一棒
当头对面
当头棒喝
当家作主
当家做主
当家理纪
当家立业
当家立事
当家立纪
当家立计
当局者迷
当断不断
当机立决
当机立断
当着不着
当立之年
当耳旁风
当耳边风
当行出色
当行本色
当轴处中
当门抵户
当面输心背面笑
当面错过
当风秉烛
彗汜画涂
彗泛画涂
彘肩斗酒
彝鼎圭璋
形具神生
形劫势禁
形势逼人
形单影双
形单影只
形只影单
形孤影只
形孤影寡
形容憔悴
形容枯槁
形形色色
形影不离
形影相依
形影相吊
形影相对
形影相附
形影相随
形影自吊
形影自守
形枉影曲
形格势禁
形槁心灰
形禁势格
形色仓皇
形诸笔墨
形输色授
形迹可疑
形销骨立
彤云密布
彩云易散
彩凤随鸦
彩笔生花
彩衣娱亲
彪形大汉
彪炳千古
彫章镂句
彫肝琢肾
彫虫小技
彫虫篆刻
彬彬有礼
彬彬济济
彰善瘅恶
彰往考来
彰明昭着
彰明昭著
彰明较着
彰明较著
影只形单
影只形孤
影形不离
影影绰绰
彷徨失措
彻上彻下
彻内彻外
彻头彻尾
彻里彻外
彻里至外
彻首彻尾
彼众我寡
彼倡此和
彼唱此和
彼弃我取
彼此彼此
彼竭我盈
往古来今
往渚还汀
往蹇来连
往返徒劳
征名责实
征敛无度
径一周三
径情直行
径情直遂
径行直遂
待人接物
待价而沽
待兔守株
待字闺中
待时守分
待时而动
待月西厢
待理不理
待贾而沽
徇国忘身
徇情枉法
徇私作弊
徇私枉法
徇私舞弊
徊肠伤气
徐娘半老
徒乱人意
徒劳往返
徒劳无功
徒劳无益
徒子徒孙
徒托空言
徒拥虚名
徒有其名
徒有虚名
徒讬空言
徒读父书
徒负虚名
徒费唇舌
得不偿丧
得不偿失
得不补失
得不酬失
得人死力
得兔忘蹄
得其三昧
得其所哉
得天独厚
得失参半
得失在人
得失成败
得失相半
得失荣枯
得婿如龙
得寸则寸
得寸得尺
得寸进尺
得尺得寸
得心应手
得意之作
得意之色
得意忘形
得意忘言
得意忘象
得意扬扬
得意洋洋
得意门生
得手应心
得月较先
得未尝有
得未曾有
得步进步
得而复失
得胜回朝
得胜头回
得薄能鲜
得过且过
得道多助
得陇望蜀
得饶人处且饶人
得马失马
得马折足
得马生灾
得鱼忘筌
得鱼忘荃
徘徊歧路
徙善远罪
徙宅忘妻
徙薪曲突
徜徉恣肆
御沟红叶
御驾亲征
循名核实
循名考实
循名覈实
循名课实
循名责实
循常习故
循序渐进
循循善诱
循次而进
循涂守辙
循环往复
循环无端
循规蹈矩
循诵习传
循途守辙
徬徨失措
微不足道
微为繁富
微乎其微
微察秋毫
微文深诋
微显阐幽
微服私行
微机四伏
微言大义
微言大谊
微过细故
德厚流光
德容兼备
德容言功
德尊望重
德才兼备
德本财末
德洋恩普
德浅行薄
德胜头回
德胜头迴
德艺双馨
德薄才疏
德薄才鲜
德薄能鲜
德言容功
德言工容
德言工貌
德輶如毛
德輶如羽
德配天地
德重恩弘
德隆望尊
德隆望重
德音莫违
德高望重
心上心下
心不两用
心不在焉
心不应口
心不由主
心不由意
心中无数
心中有数
心之官则思
心乔意怯
心乡往之
心乱如麻
心事重重
心低意沮
心余力绌
心凝形释
心到神知
心力交瘁
心力衰竭
心劳意冗
心劳意攘
心劳日拙
心去难留
心口不一
心口如一
心口相应
心同止水
心向往之
心回意转
心在魏阙
心坚石穿
心头撞鹿
心头鹿撞
心如刀剉
心如刀割
心如刀搅
心如刀绞
心如刀锉
心如刀锯
心如古井
心如坚石
心如寒灰
心如悬旌
心如木石
心如槁木
心如止水
心如死灰
心如火焚
心如金石
心如铁石
心存目想
心存芥蒂
心孤意怯
心安理得
心宽体胖
心寒胆战
心寒胆落
心小志大
心巧嘴乖
心平气和
心平气定
心广体胖
心开目明
心弛神往
心往神驰
心心念念
心心相印
心忙意乱
心忙意急
心怀叵测
心怀忐忑
心怀鬼胎
心怡神旷
心急如火
心急如焚
心急火燎
心悦神怡
心悦诚服
心惊肉战
心惊肉跳
心惊胆寒
心惊胆战
心惊胆落
心惊胆裂
心惊胆颤
心慈手软
心慈面软
心慌意乱
心慌意急
心慌撩乱
心慕手追
心慵意懒
心手相应
心手相忘
心拙口夯
心摹手追
心旌摇摇
心旌摇曳
心无二用
心无挂碍
心无旁骛
心旷神怡
心旷神恬
心旷神愉
心旷神飞
心明眼亮
心有余悸
心有余而力不足
心有灵犀一点通
心服口服
心服首肯
心术不正
心术不端
心殒胆破
心殒胆落
心比天高
心活面软
心浮气盛
心浮气粗
心浮气躁
心满原足
心满意得
心满意足
心满愿足
心潮澎湃
心灰意冷
心灰意懒
心灰意败
心灵性巧
心灵手巧
心烦意乱
心烦意冗
心烦技痒
心烦虑乱
心焦如火
心焦如焚
心焦火燎
心照不宣
心照情交
心照神交
心狠手毒
心狠手辣
心猿意马
心甘情原
心甘情愿
心病还须心药医
心痒难抓
心痒难挝
心痒难挠
心痒难揉
心直口快
心直嘴快
心瞻魏阙
心知其意
心神不宁
心神不定
心神恍惚
心粗气浮
心粗胆大
心细于发
心细如发
心织笔耕
心绪如麻
心绪恍惚
心胆俱碎
心胆俱裂
心腹之交
心腹之忧
心腹之患
心腹之疾
心腹之病
心腹大患
心腹重患
心膂股肱
心花怒发
心花怒放
心若死灰
心荡神怡
心荡神摇
心荡神迷
心虔志诚
心血来潮
心谤腹非
心贯白日
心辣手狠
心逸日休
心醉神迷
心醉魂迷
心长力短
心长发短
心长绠短
心闲手敏
心雄万夫
心非巷议
心领意会
心领神会
心领神悟
心驰神往
心驰魏阙
心高气傲
必不得已
必不挠北
必也正名
必争之地
必以情
必恭必敬
必操胜券
必由之路
必经之路
必躬必亲
必里迟离
忆苦思甜
忍俊不住
忍俊不禁
忍垢偷生
忍尤含垢
忍心害理
忍无可忍
忍气吞声
忍耻偷生
忍耻含垢
忍耻含羞
忍苦耐劳
忍辱偷生
忍辱含垢
忍辱含羞
忍辱负重
忍隽不禁
忍饥受饿
忐上忑下
忐忐忑忑
忐忑不安
忐忑不定
忑忑忐忐
志同道合
志在千里
志在四方
志在四海
志坚行苦
志士仁人
志大才疏
志广才疎
志广才疏
志得意满
志得气盈
志洁行芳
志满意得
志满气得
志满气骄
志盈心满
志美行厉
志足意满
志骄意满
志骄气盈
志高气扬
忘乎其形
忘乎所以
忘其所以
忘啜废枕
忘寝废食
忘年之交
忘年之契
忘年之好
忘年交
忘形之交
忘形之契
忘形交
忘恩失义
忘恩背义
忘恩负义
忘情负义
忘战必危
忘战者危
忘生舍死
忘象得意
忘餐废寝
忙不择价
忙中有失
忙中有错
忙忙碌碌
忙里偷闲
忠不避危
忠孝两全
忠孝节义
忠心耿耿
忠心贯日
忠心赤胆
忠肝义胆
忠言逆耳
忠贞不渝
忠贯日月
忠贯白日
忠驱义感
忧公忘私
忧国奉公
忧国忘家
忧国忧民
忧国爱民
忧形于色
忧心如捣
忧心如焚
忧心忡忡
忧心悄悄
忧患余生
忧愤成疾
忧深思远
忧盛危明
忧谗畏讥
快人快事
快人快性
快人快语
快刀斩乱丝
快刀斩乱麻
快刀斩麻
快心满志
快心满意
快心遂意
快意当前
快步流星
快犊破车
快马加鞭
念兹在兹
念念不忘
念念有词
忸怩不安
忸怩作态
忽冷忽热
忽忽不乐
忿不顾身
忿世嫉俗
忿忿不平
忿火中烧
忿然作色
怀冤抱屈
怀土之情
怀宝迷邦
怀山襄陵
怀恨在心
怀才不遇
怀才抱器
怀敌附远
怀材抱器
怀柔天下
怀珠抱玉
怀珠韫玉
怀瑾握瑜
怀璧其罪
怀真抱素
怀着鬼胎
怀觚握椠
怀质抱真
怀道迷邦
怀金垂紫
怀金拖紫
怀铅提椠
怀铅握椠
怀银纡紫
怀黄佩紫
怀黄握白
怅然自失
怅然若失
怆地呼天
怆天呼地
怆然涕下
怏怏不乐
怏怏不悦
怒不可遏
怒发冲冠
怒形于色
怒气冲冲
怒气冲天
怒气填胸
怒火中烧
怒火冲天
怒猊渴骥
怒目切齿
怒目横眉
怒目而视
怕死贪生
怕痛怕痒
怕硬欺软
怕风怯雨
怕鬼有鬼
怙恩恃宠
怙恶不悛
怙才骄物
怙终不悔
怙终不悛
怙过不悛
怙顽不悛
怛然失色
怜我怜卿
怜新厌旧
怜新弃旧
怜牙悧齿
怜贫恤老
怜贫惜老
怜贫敬老
怜香惜玉
思不出位
思前想后
思如涌泉
思妇病母
思归其雌
思患预防
思所逐之
思断义绝
思深忧远
思潮起伏
思绪万千
思贤如渴
怠惰因循
怡堂燕雀
怡声下气
怡志养神
怡性养神
怡情养性
怡情悦性
怡情理性
怡然自乐
怡然自得
怡然自若
怡颜悦色
急不及待
急不可待
急不可耐
急不择言
急不择路
急不择途
急不暇择
急中生智
急于事功
急于星火
急于求成
急人之困
急人之难
急先锋
急公好义
急公好施
急公近利
急功好利
急功近利
急功近名
急吏缓民
急处从宽
急如星火
急如风火
急张拘诸
急急如律令
急惊风撞着慢郎中
急拍繁弦
急敛暴征
急景凋年
急景流年
急来报佛脚
急杵捣心
急流勇进
急流勇退
急病让夷
急痛攻心
急竹繁丝
急管繁弦
急脉缓受
急脉缓灸
急赤白脸
急起直追
急转直下
急风暴雨
急风骤雨
怦然心动
性命交关
性命关天
性急口快
性烈如火
怨入骨髓
怨声载道
怨天尤人
怨天忧人
怨天怨地
怨女旷夫
怨家债主
怨气冲天
怨气满腹
怪事咄咄
怪力乱神
怪声怪气
怪形怪状
怪模怪样
怪诞不经
怪诞诡奇
怪雨盲风
怫然不悦
怫然作色
怯声怯气
怯防勇战
怵目惊心
总总林林
总戈成林
总而言之
总角之交
总角之好
恃勇轻敌
恃强凌弱
恃才傲物
恇怯不前
恋恋不舍
恋恋难舍
恋新忘旧
恋栈不去
恋酒贪花
恋酒迷花
恍如梦境
恍如梦寐
恍如隔世
恍恍荡荡
恍然大悟
恍然若失
恐后争先
恐后无凭
恐慌万状
恐遭物议
恒河一沙
恒河沙数
恓恓惶惶
恢宏大度
恢廓大度
恢恑憰怪
恢恢有余
恢诡谲怪
恣凶稔恶
恣心纵欲
恣情纵欲
恣意妄为
恣意妄行
恣无忌惮
恣睢无忌
恣肆无忌
恤老怜贫
恨之入骨
恨入骨髓
恨如头醋
恨海难填
恨相知晚
恨相见晚
恨铁不成钢
恩不放债
恩同再造
恩同山岳
恩同父母
恩威并用
恩威并行
恩威并重
恩将仇报
恩山义海
恩德如山
恩怨分明
恩恩相报
恩断义绝
恩有重报
恩深义重
恩甚怨生
恩若再生
恩荣并济
恩逾慈母
恩重如山
恩重泰山
恪守不渝
恪守成宪
恫疑虚喝
恫疑虚猲
恬不为怪
恬不为意
恬不知怪
恬不知愧
恬不知羞
恬不知耻
恬淡寡欲
恬淡无为
恬淡无欲
恬然自足
恬言柔舌
恭敬不如从命
恭敬桑梓
恭而有礼
恭行天罚
恭贺新禧
恭逢其盛
恭默守静
息事宁人
息交绝游
息怒停瞋
息息相关
息息相通
息迹静处
息黥补劓
恰到好处
恰如其分
恶不去善
恶事行千里
恶作剧
恶叉白赖
恶声恶气
恶尘无染
恶居下流
恶性循环
恶恶从短
恶意中伤
恶有恶报
恶湿居下
恶直丑正
恶积祸盈
恶籍盈指
恶紫夺朱
恶虎不食子
恶衣恶食
恶衣粝食
恶衣菲食
恶衣蔬食
恶言厉色
恶言詈辞
恶语中伤
恶语伤人
恶语相加
恶贯已盈
恶贯满盈
恶迹昭着
恶迹昭著
恶醉强酒
恻怛之心
恻隐之心
恼羞变怒
恼羞成怒
悃愊无华
悄然无声
悉帅敝赋
悉索敝赋
悉索薄赋
悍然不顾
悒悒不乐
悔不当初
悔之不及
悔之无及
悔之晚矣
悔其少作
悔恨交加
悔罪自新
悔读南华
悔过自新
悔过自责
悖入悖出
悖言乱辞
悠哉游哉
悠悠忽忽
悠悠荡荡
悠游自在
悠游自得
悠然自得
悠闲自在
患得患失
患至呼天
患难与共
患难之交
患难夫妻
悦目娱心
悦目赏心
悦近来远
悬兵束马
悬剑空垄
悬壶问世
悬头刺股
悬崕峭壁
悬崖勒马
悬崖峭壁
悬崖撒手
悬崖絶壁
悬崖绝壁
悬崖转石
悬心吊胆
悬悬而望
悬旌万里
悬梁刺股
悬梁刺骨
悬榻留宾
悬河注水
悬河注火
悬河泻水
悬河泻火
悬灯结彩
悬狟素飡
悬疣附赘
悬石程书
悬而未决
悬肠挂肚
悬若日月
悬车之岁
悬车之年
悬车告老
悬车束马
悬车致仕
悬门抉目
悬鞀建铎
悬首吴阙
悬驼就石
悬鹑百结
悬鼓待椎
悬鼗建铎
悬龟系鱼
悯时病俗
悱恻缠绵
悲不自胜
悲从中来
悲喜交集
悲声载道
悲天悯人
悲愁垂涕
悲愤填膺
悲欢离合
悲歌击筑
悲歌慷慨
悲歌易水
悲痛欲绝
悲观厌世
悼心失图
悼心疾首
情不可却
情不自已
情不自禁
情人眼里出西施
情凄意切
情同一家
情同手足
情同骨肉
情在骏奔
情天孽海
情孚意合
情急智生
情恕理遣
情意绵绵
情投契合
情投意合
情投意和
情投意忺
情投意洽
情投谊合
情文并茂
情景交融
情有可原
情深一往
情深义重
情深似海
情深友于
情深意重
情深潭水
情深骨肉
情理难容
情真意切
情窦初开
情至意尽
情见乎言
情见乎词
情见乎辞
情见于色
情见力屈
情见势屈
情见埶竭
情逐事迁
情逾骨肉
情重姜肱
情长纸短
情随事迁
情非得已
情面难却
惊世絶俗
惊世绝俗
惊世震俗
惊世骇俗
惊世骇目
惊喜交加
惊喜交集
惊喜欲狂
惊喜若狂
惊天动地
惊天地泣鬼神
惊师动众
惊弓之鸟
惊弦之鸟
惊心丧魄
惊心动魄
惊心吊胆
惊心吊魄
惊心夺目
惊心怵目
惊心悲魄
惊心悼胆
惊心惨目
惊心眩目
惊心破胆
惊心裂胆
惊心褫魄
惊心骇目
惊心骇瞩
惊心骇神
惊恐万状
惊恐失色
惊惶万状
惊惶失措
惊惶失色
惊惶无措
惊愕失色
惊愚骇俗
惊慌失措
惊慌失色
惊慌无措
惊才絶艳
惊才绝艳
惊才风逸
惊涛巨浪
惊涛怒浪
惊涛骇浪
惊猿脱兔
惊皇失措
惊神泣鬼
惊神破胆
惊羣动众
惊群动众
惊耳骇目
惊肉生髀
惊蛇入草
惊见骇闻
惊起梁尘
惊采絶艳
惊采绝艳
惊风怒涛
惊风骇浪
惊魂丧魄
惊魂动魄
惊魂失魄
惊魂夺魄
惊魂摄魄
惊魂未定
惊魂落魄
惊鸿艳影
惑世盗名
惑世诬民
惘然若失
惙怛伤悴
惜墨如金
惜字如金
惜客好义
惜指失掌
惜玉怜香
惜老怜贫
惝恍迷离
惟利是命
惟利是图
惟利是求
惟利是营
惟利是视
惟利是趋
惟利是逐
惟力是视
惟口起羞
惟命是从
惟命是听
惟妙惟肖
惟我独尊
惟所欲为
惟日不足
惟日为岁
惟精惟一
惟肖惟妙
惠子知我
惠然之顾
惠然肯来
惠而不费
惠风和畅
惨不忍睹
惨不忍言
惨不忍闻
惨无人理
惨无人道
惨无天日
惨淡经营
惨澹经营
惨然不乐
惨絶人寰
惨緑少年
惨緑年华
惨緑愁红
惨绝人寰
惨绿少年
惨绿年华
惨绿愁红
惨雨酸风
惩一儆百
惩一戒百
惩一警百
惩前毖后
惩忿窒欲
惩恶劝善
惩羹吹虀
惩羹吹韲
惩羹吹齑
惬心贵当
惭凫企鹤
惮赫千里
想入非非
想当然
想方设法
想望丰采
想望风褱
想望风采
惴惴不安
惶恐不安
惶惶不可终日
惶惶不安
惹事招非
惹事生非
惹是招非
惹是生非
惹火烧身
惹灾招祸
惹祸招愆
惹祸招殃
惹祸招灾
惹草拈花
惹草沾花
惺惺作态
惺惺惜惺惺
惺惺相惜
愀然不乐
愀然无乐
愁云惨淡
愁云惨雾
愁多夜长
愁山闷海
愁潘病沈
愁眉不展
愁眉啼妆
愁眉泪眼
愁眉苦眼
愁眉苦脸
愁眉蹙额
愁眉锁眼
愁红怨绿
愁红惨緑
愁红惨绿
愁绪如麻
愁肠九回
愁肠九转
愁肠寸断
愁肠殢酒
愁肠百结
愁长殢酒
意义深长
意乱心忙
意兴盎然
意兴索然
意出望外
意前笔后
意合情投
意味深长
意在笔先
意在笔前
意在言外
意广才疏
意往神驰
意得志满
意想不到
意惹情牵
意懒心慵
意懒心灰
意料之外
意望已过
意气扬扬
意气洋洋
意气用事
意气相得
意气相投
意气自如
意气自若
意气风发
意气飞扬
意气高昂
意满志得
意转心回
意马心猿
愚不可及
愚公移山
愚夫惷妇
愚夫愚妇
愚夫蠢妇
愚昧无知
愚民安知
愚眉肉眼
感人心脾
感人肺肝
感人肺腑
感今怀昔
感今思昔
感今惟昔
感同身受
感天动地
感恩图报
感恩怀德
感恩戴德
感情用事
感慨万千
感慨万端
感慨激昂
感慨系之
感戴二天
感旧之哀
感极涕零
感深肺腑
感激不尽
感激涕零
感遇忘身
愣头愣脑
愤不欲生
愤不顾身
愤世嫉俗
愤世疾俗
愤世疾邪
愤愤不平
愤时疾俗
愤风惊浪
愧不敢当
愧天怍人
愧悔无地
慈乌反哺
慈乌返哺
慈悲为本
慈明无双
慈眉善目
慈眉善眼
慌不择路
慌作一团
慌做一团
慌慌张张
慌手忙脚
慌手慌脚
慎始敬终
慎小事微
慎小谨微
慎终于始
慎终如始
慎终承始
慎终追远
慎身修永
慎重其事
慕古薄今
慕名而来
慢弛之阙
慢易生忧
慢条丝礼
慢条厮礼
慢条斯理
慢条斯礼
慢腾斯礼
慢藏诲盗
慧业才人
慧业文人
慧心妙舌
慧心巧思
慨当以慷
慨然允诺
慨然应允
慰情胜无
慷他人之慨
慷慨仗义
慷慨就义
慷慨悲歌
慷慨捐生
慷慨淋漓
慷慨激扬
慷慨激昂
慷慨激烈
慷慨解囊
慷慨赴义
慷慨输将
慷慨陈词
憎爱分明
憔神悴力
憨状可掬
憬然有悟
懊悔无及
懦词怪说
懵懵懂懂
戎马仓皇
戎马倥偬
戎马倥傯
戎马劻勷
戎马生涯
戎马生郊
戏彩娱亲
戏蝶游蜂
成一家言
成也萧何败萧何
成事不说
成人之善
成人之美
成仁取义
成佛作祖
成千上万
成千成万
成千累万
成千论万
成双作对
成双成对
成名成家
成团打块
成城断金
成家立业
成家立计
成己成物
成帮结队
成年古代
成年累月
成日成夜
成王败寇
成竹在胸
成算在心
成羣作队
成羣打伙
成羣结伙
成羣结党
成羣结队
成羣逐队
成羣集党
成群作队
成群打伙
成群结伙
成群结党
成群结队
成群逐队
成群集党
成败兴废
成败利钝
成败在此一举
成败得失
成败论人
成风之斫
成风尽垩
成龙配套
我心如秤
我武惟扬
我行我素
我见犹怜
我负子戴
我醉欲眠
我黼子佩
戒备森严
戒奢宁俭
戒骄戒躁
戕身伐命
战不旋踵
战天斗地
战战业业
战战兢兢
战战惶惶
战战栗栗
战无不克
战无不胜
战火纷飞
戚戚具尔
戛戛独造
戛然而止
戛玉敲冰
戛玉敲金
戛玉锵金
戛玉鸣金
戛釜撞瓮
戟指嚼舌
戟指怒目
戢鳞委翼
戢鳞潜翼
截发剉稾
截发剉藳
截发留宾
截断众流
截然不同
截胫剖心
截趾适履
截趾适屦
截趾適履
截辕杜辔
截铁斩钉
截镫留鞭
截长补短
截鹤续凫
戮力一心
戮力同心
戮力壹心
戮力齐心
戳心灌髓
戳无路儿
戴发含牙
戴发含齿
戴圆履方
戴天履地
戴天蹐地
戴头识脸
戴日戴斗
戴月披星
戴清履浊
戴玄履黄
戴盆望天
戴眉含齿
戴笠乘车
戴笠故交
戴罪立功
戴霜履冰
戴高帽儿
戴高帽子
戴鸡佩豚
户告人晓
户曹参军
户枢不朽
户枢不蝼
户枢不蠹
户限为穿
房谋杜断
所作所为
所剩无几
所向克捷
所向披靡
所向无前
所向无敌
所向皆靡
所在皆是
所当无敌
所见所闻
所见略同
所费不赀
扇席温枕
扇枕温席
扇枕温衾
扇枕温被
扇火止沸
扇风点火
手下留情
手不停挥
手不停毫
手不应心
手不释书
手不释卷
手到拈来
手到拿来
手到擒来
手到病除
手忙脚乱
手急眼快
手挥目送
手无寸刃
手无寸铁
手无缚鸡之力
手泽之遗
手疾眼快
手眼通天
手胼足胝
手脚干净
手脚无措
手舞足蹈
手足之情
手足失措
手足异处
手足无措
手足胼胝
手足重茧
手零脚碎
手高手低
手高眼低
才兼文武
才华横溢
才华盖世
才华超众
才占八斗
才墨之薮
才多识寡
才大如海
才大难用
才夸八斗
才子佳人
才学兼优
才广妨身
才德兼备
才望高雅
才气无双
才气过人
才疏学浅
才疏德薄
才疏志大
才疏意广
才疏计拙
才短思涩
才短气粗
才秀人微
才蔽识浅
才薄智浅
才识过人
才貌两全
才貌俱全
才貌兼全
才貌双全
才貌双绝
才贯二酉
才轻德薄
才过屈宋
才高七步
才高八斗
才高意广
才高气清
才高行厚
才高行洁
才高识远
才高运蹇
扎根串连
扑地掀天
扑天盖地
扑朔迷离
扑杀此獠
扒耳搔腮
扒高踩低
打人骂狗
打入冷宫
打凤捞龙
打凤牢龙
打击报复
打家劫舍
打家截舍
打家截道
打富济贫
打小算盘
打开天窗说亮话
打得火热
打恭作揖
打情卖笑
打情骂俏
打情骂趣
打成一片
打抱不平
打拱作揖
打死老虎
打死虎
打滚撒泼
打牙犯嘴
打牙配嘴
打狗看主
打破常规
打破沙锅璺到底
打破沙锅问到底
打破砂锅璺到底
打破砂锅问到底
打破迷关
打肿脸充胖子
打草惊蛇
打草蛇惊
打落水狗
打虎牢龙
打蛇打七寸
打街骂巷
打诨插科
打躬作揖
打边鼓
打退堂鼓
打铁趁热
打闷葫芦
打马虎眼
打鸡骂狗
打鸭子上架
打鸭惊鸳
打鸭惊鸳鸯
托之空言
托于空言
托公报私
托公行私
托凤攀龙
托孤寄命
托物寓兴
托物寓感
托物引类
托物感怀
托物连类
托物陈喻
托诸空言
托骥之蝇
扛鼎抃牛
扛鼎拔山
扞格不入
扣人心弦
扣壶长吟
扣楫中流
扣槃扪烛
扣槃扪籥
扣盘扪烛
扣盘扪钥
执两用中
执意不从
执文害意
执柯作伐
执法不阿
执法如山
执牛耳
执粗井灶
执经问难
执而不化
执迷不反
执迷不悟
执迷不误
执迷不返
执迷不醒
执锐披坚
执鞭坠镫
执鞭随蹬
执鞭随镫
扪参历井
扪心无愧
扪心自问
扪虱而言
扪虱而谈
扫地以尽
扫地俱尽
扫地出门
扫地无余
扫地无遗
扫墓望丧
扫榻以待
扫眉才子
扫穴擒渠
扫穴犁庭
扫锅刮灶
扫除天下
扬厉铺张
扬名四海
扬名显亲
扬威曜武
扬威耀武
扬己露才
扬幡招魂
扬扬得意
扬扬自得
扬武耀威
扬汤止沸
扬清厉俗
扬清抑浊
扬清激浊
扬眉吐气
扬眉眴目
扬眉瞬目
扬葩振藻
扬蘤扢藻
扬铃打鼓
扬长而去
扬长避短
扬风扢雅
扭亏增盈
扭扭捏捏
扭曲作直
扭直作曲
扭转乾坤
扭转干坤
扯旗放炮
扯空砑光
扯篷拉纤
扯纤拉烟
扯顺风旗
扯鼓夺旗
扳龙附凤
扶倾济弱
扶危定乱
扶危定倾
扶危拯溺
扶危持颠
扶危救困
扶危济困
扶危济急
扶危翼倾
扶墙摸壁
扶弱抑强
扶摇万里
扶摇直上
扶正祛邪
扶正黜邪
扶老携幼
扶辇下除
扶颠持危
批亢抵巇
批亢捣虚
批吭捣虚
批毛求疵
批砉导窾
批红判白
批逆龙鳞
批郄导窾
批郤导窾
批隙导窾
批风抹月
批鳞请剑
扼亢拊背
扼吭夺食
扼吭拊背
扼喉抚背
扼腕叹息
扼腕抵掌
扼腕长叹
扼襟控咽
承上启下
承上起下
承先启后
承前启后
承天之佑
承天之祐
承天之祜
承嬗离合
承平盛世
承星履草
承欢膝下
承颜候色
抃风儛润
抃风舞润
抉奥阐幽
抉瑕掩瑜
抉瑕摘衅
抉目东门
抉目吴门
抉目悬门
抉目胥门
把持不定
把玩无厌
把素持斋
把臂入林
把臂徐去
把薪助火
把酒持螯
把饭叫饥
抑塞磊落
抑强扶弱
抑扬顿挫
抑郁寡欢
抓乖卖俏
抓乖弄俏
抓破脸子
抓破脸皮
抓破面皮
抓耳挠腮
投井下石
投传而去
投其所好
投刃皆虚
投卵击石
投壶电笑
投山窜海
投戈讲艺
投戈讲蓺
投木报琼
投机倒把
投机取巧
投桃之报
投桃报李
投梭之拒
投梭折齿
投河奔井
投河觅井
投畀豺虎
投石下井
投石拔距
投石超距
投石问路
投笔从戎
投膏止火
投袂援戈
投袂而起
投袂荷戈
投诸四裔
投闲置散
投间抵隙
投阱下石
投隙抵巇
投隙抵罅
投鞭断流
投鼠之忌
投鼠忌器
抖搂精神
抖擞精神
抗尘走俗
抗颜为师
折冲之臣
折冲厌难
折冲尊俎
折冲御侮
折冲樽俎
折戟沉沙
折槁振落
折矩周规
折箭为誓
折而族之
折胶堕指
折腰五斗
折节下士
折节待士
折节读书
折足覆餗
折长补短
折鼎覆餗
抚世酬物
抚今思昔
抚今悼昔
抚今痛昔
抚今追昔
抚心自问
抚掌击节
抚掌大笑
抚时感事
抚景伤情
抚绥万方
抚躬自问
抛乡离井
抛头露面
抛戈弃甲
抛砖引玉
抟心壹志
抟心揖志
抟沙作饭
抟沙嚼蜡
抟空捕影
抟香弄粉
抠心挖肚
抠心挖血
抢地呼天
护国佑民
护过饰非
报仇雪恨
报仇雪耻
报冰公事
报应不爽
报效万一
报本反始
报李投桃
报雠雪恨
披发入山
披发左衽
披发左袵
披发文身
披发缨冠
披古通今
披坚执鋭
披坚执锐
披头散发
披头盖脑
披心沥血
披心相付
披星带月
披星戴月
披林撷秀
披枷带锁
披枷戴锁
披榛采兰
披毛戴角
披毛求瑕
披毛求疵
披毛索靥
披毛索黡
披沙剖璞
披沙拣金
披沙简金
披沥肝胆
披沥肝膈
披红戴花
披罗戴翠
披肝沥胆
披肝沥血
披肝露胆
披荆斩棘
披裘带索
披裘负薪
披襟解带
披霄决汉
披露肝胆
披露腹心
披麻带孝
披麻带索
披麻戴孝
披麻救火
抬脚动手
抱不平
抱令守律
抱关击柝
抱关执籥
抱关执钥
抱冰公事
抱头大哭
抱头痛哭
抱头鼠窜
抱子弄孙
抱宝怀珍
抱屈衔冤
抱布贸丝
抱怨雪耻
抱恨终天
抱恨黄泉
抱成一团
抱打不平
抱朴含真
抱枝拾叶
抱柱之信
抱椠怀铅
抱残守缺
抱残守阙
抱法处势
抱火卧薪
抱火厝薪
抱火寝薪
抱玉握珠
抱璞泣血
抱瓮出灌
抱瓮灌园
抱蔓摘瓜
抱薪救火
抱薪救焚
抱表寝绳
抱诚守真
抱负不凡
抵掌而谈
抵死漫生
抵死瞒生
抵死谩生
抵瑕蹈隙
抵瑕陷厄
抵背扼喉
抵足而眠
抹一鼻子灰
抹月批风
抹月秕风
抹粉施脂
抽丁拔楔
抽丝剥茧
抽刀断水
抽抽噎噎
抽抽搭搭
抽梁换柱
抽祕骋妍
抽秘骋妍
抽筋剥皮
抽筋拔骨
抽胎换骨
抽薪止沸
抽黄对白
拂袖而去
拂袖而归
拄笏看山
拄笏西山
拄颊看山
担惊受怕
担惊受恐
担惊忍怕
担雪塞井
担雪填井
担雪填河
拆东墙补西墙
拆东补西
拆牌道字
拆白道字
拆西补东
拈华摘艳
拈斤播两
拈断髭须
拈毫弄管
拈花一笑
拈花弄月
拈花弄柳
拈花微笑
拈花惹草
拈花摘艳
拈轻怕重
拈轻掇重
拈酸吃醋
拈酸泼醋
拉三扯四
拉大旗作虎皮
拉家带口
拉帮结派
拉拉扯扯
拉拉杂杂
拉捭摧藏
拉朽摧枯
拉枯折朽
拉闲散闷
拊心泣血
拊背扼吭
拊背扼喉
拊背搤吭
拊膺顿足
拍手称快
拍板成交
拍案叫絶
拍案叫绝
拍案惊奇
拍案而起
拍马溜须
拏云握雾
拏云攫石
拏风跃云
拐弯抹角
拒之门外
拒人于千里之外
拒人千里
拒狼进虎
拒虎进狼
拒谏饰非
拔丁抽楔
拔丛出类
拔了萝卜地皮宽
拔刀相助
拔刀相向
拔剑论功
拔十失五
拔十得五
拔地倚天
拔地参天
拔地摇山
拔宅上升
拔宅飞升
拔山举鼎
拔山扛鼎
拔山盖世
拔山超海
拔帜易帜
拔帜树帜
拔新领异
拔本塞原
拔本塞源
拔来报往
拔树寻根
拔树搜根
拔树撼山
拔毛济世
拔毛连茹
拔犀擢象
拔类超羣
拔类超群
拔羣出萃
拔群出萃
拔苗助长
拔茅连茹
拔萃出类
拔萃出羣
拔萃出群
拔葵去织
拔葵啖枣
拔赵帜易汉帜
拔赵帜立赤帜
拔赵易汉
拔辖投井
拔锅卷席
拖人下水
拖人落水
拖天扫地
拖泥带水
拖男带女
拖金委紫
拖青纡紫
拖麻拽布
拘俗守常
拘奇抉异
拘挛补衲
拘文牵义
拘神遣将
拙口笨腮
拙口钝腮
拙嘴笨腮
拙嘴笨舌
拙贝罗香
招事惹非
招亡纳叛
招兵买马
招军买马
招摇撞骗
招摇过市
招是惹非
招是揽非
招是搬非
招是生非
招权纳贿
招权纳赂
招权纳赇
招架不住
招灾惹祸
招灾揽祸
招花惹草
招蜂引蝶
招蜂惹蝶
招财进宝
招贤纳士
招降纳叛
招风惹草
招风惹雨
招风揽火
拜倒辕门
拜将封侯
拜恩私室
拜赐之师
拜鬼求神
拟于不伦
拟规画圆
拟非其伦
拣佛烧香
拣精拣肥
拣精择肥
拥书南面
拥书百城
拥兵自固
拥政爱民
拥篲救火
拥雾翻波
拨万论千
拨万轮千
拨乱为治
拨乱反正
拨乱反治
拨乱济危
拨乱济时
拨云撩雨
拨云睹日
拨云见日
拨云雾见青天
拨嘴撩牙
拨草寻蛇
拨草瞻风
拨雨撩云
择主而事
择善而从
择善而行
择地而蹈
择福宜重
择肥而噬
择邻而居
括目相待
拭目以俟
拭目以待
拭目而待
拭面容言
拯溺扶危
拱手听命
拱手而降
拱手让人
拱挹指麾
拱揖指挥
拱揖指撝
拱揖指麾
拱肩缩背
拳中掿沙
拳打脚踢
拳拳之枕
拳拳在念
拳拳服膺
拳拳盛意
拼死拼活
拽巷啰街
拽巷攞街
拽巷逻街
拽布披麻
拽布拖麻
拽耙扶犁
拽象拖犀
拾人唾余
拾人唾涕
拾人涕唾
拾人牙慧
拾带重还
拾掇无遗
拾遗补阙
拾金不昧
拾陈蹈故
拿三搬四
拿下马来
拿云捉月
拿云握雾
拿云攫石
拿刀动杖
拿刀弄杖
拿手好戏
拿班作势
拿班做势
拿粗夹细
拿粗挟细
拿糖作醋
拿腔作势
拿腔作调
拿腔做势
拿贼拿赃
拿贼见赃
持久之计
持之以恒
持之有故
持人长短
持刀动杖
持危扶颠
持平之论
持戈试马
持斋把素
持权合变
持橐簪笔
持正不阿
持满戒盈
持盈保泰
持盈守成
持禄养交
持筹握算
持螯把酒
持蠡测海
持衡拥璇
持论公允
挂一漏万
挂冠归去
挂冠求去
挂印悬牌
挂席为门
挂灯结彩
挂羊头卖狗肉
挂肚牵心
挂肚牵肠
指不胜偻
指不胜屈
指东划西
指东画西
指东话西
指东说西
指事类情
指亲托故
指南攻北
指名道姓
指囷相赠
指天为誓
指天射鱼
指天画地
指天誓日
指山卖磨
指山说磨
指手划脚
指手点脚
指手画脚
指手顿脚
指挥可定
指挥若定
指掌可取
指方画圆
指日可下
指日可待
指日成功
指日而待
指日誓心
指日高升
指李推张
指树为姓
指桑说槐
指桑骂槐
指猪骂狗
指瑕造隙
指皁为白
指皂为白
指矢天日
指破迷团
指空话空
指腹为婚
指雁为羹
指鸡骂狗
指鹿为马
指鹿作马
指麾可定
挈瓶之智
挈瓶之知
挈领提纲
按兵不举
按兵不动
按兵束甲
按名责实
按图索骏
按图索骥
按堵如故
按捺不住
按步就班
按甲休兵
按甲寝兵
按行自抑
按辔徐行
按部就班
挑三嫌四
挑三拣四
挑三拨四
挑三检四
挑三豁四
挑么挑六
挑唇料嘴
挑幺挑六
挑得篮里便是菜
挑拨离间
挑毛拣刺
挑牙料唇
挑精拣肥
挑肥拣瘦
挑茶斡刺
挑雪填井
挖空心思
挖耳当招
挖肉补疮
挟主行令
挟势弄权
挟天子以令天下
挟天子以令诸侯
挟山超海
挟细拿粗
挠喉捩嗓
挠曲枉直
挠直为曲
挠腮撧耳
挢抂过正
挢揉造作
挢枉过正
挤手捏脚
挤眉弄眼
挤眉溜眼
挥剑成河
挥戈反日
挥戈回日
挥戈返日
挥戈退日
挥斥八极
挥日阳戈
挥毫落纸
挥汗如雨
挥汗成雨
挥沐吐餐
挥洒自如
挥翰临池
挥金如土
挥霍无度
挦毛捣鬓
挦章撦句
挦绵扯絮
挨三顶五
挨冻受饿
挨家挨户
挨山塞海
挨肩叠背
挨肩并足
挨肩搭背
挨肩擦背
挨肩擦脸
挨肩擦膀
挨肩迭背
挨门挨户
挨门逐户
挨风缉缝
挫骨扬灰
振兵泽旅
振兵释旅
振奋人心
振振有词
振振有辞
振穷恤寡
振穷恤贫
振聋发聩
振臂一呼
振衣濯足
振裘持领
振贫济乏
振领提纲
挹彼注兹
挹彼注此
挹斗扬箕
挹盈注虚
挺而走险
挺胸凸肚
挺胸叠肚
挺身而出
挺鹿走险
捉刀代笔
捉影捕风
捉摸不定
捉班做势
捉生替死
捉虎擒蛟
捉衿肘见
捉衿见肘
捉衿露肘
捉襟肘见
捉襟见肘
捉襟露肘
捉贼捉脏
捉贼捉赃
捉贼见赃
捉风捕影
捉风捕月
捉鸡骂狗
捉鼠拿猫
捋虎须
捋袖揎拳
捎关打节
捏一把汗
捏怪排科
捏手捏脚
捏脚捏手
捐弃前嫌
捐忿弃瑕
捐本逐末
捐残去杀
捐身徇义
捐躯报国
捐躯殉国
捐躯赴难
捐金抵璧
捕影系风
捕风捉影
损上益下
损之又损
损人不利己
损人利己
损人害己
损人益己
损人肥己
损公肥私
损兵折将
损军折将
损己利人
损有余补不足
损本逐末
换斗移星
换日偷天
换汤不换药
换羽移宫
换骨夺胎
换骨脱胎
捣虚批吭
捣虚撇抗
捧头鼠窜
捧心西子
捧毂推轮
捧腹大笑
捩手覆羹
捭阖纵横
据为己有
据义履方
据图刎首
据理力争
据鞍读书
据高临下
捰袖揎拳
捱三顶五
捱三顶四
捱风缉缝
捶床拍枕
捶床捣枕
捶胸跌脚
捶胸跌足
捶胸顿脚
捶胸顿足
捶骨沥髓
捷报频传
捷足先得
捷足先登
捷雷不及掩耳
捻土为香
捻土焚香
捻神捻鬼
掀天动地
掀天揭地
掀天斡地
掀拳裸袖
掀风鼓浪
掂斤估两
掂斤抹两
掂斤播两
掂梢折本
掇拾章句
掇臀捧屁
掇菁撷华
掇青拾紫
授业解惑
授人以柄
授人口实
授受不亲
授柄于人
掉三寸舌
掉书袋
掉以轻心
掉头鼠窜
掉臂不顾
掉舌鼓唇
掊斗折衡
掌上明珠
掌上观文
掌上观纹
掎挈伺诈
掎裳连袂
掎裳连襼
掎角之势
掐头去尾
掐尖落钞
排山倒海
排山压卵
排忧解难
排患解纷
排斥异己
排沙简金
排沙见金
排糠障风
排除万难
排除异己
排难解纷
掘井及泉
掘室求鼠
掞藻飞声
探丸借客
探口而出
探囊取物
探囊胠箧
探头探脑
探头缩脑
探幽索隐
探本穷源
探汤蹈火
探竿影草
探观止矣
探赜索隐
探赜钩深
探骊得珠
掣襟露肘
掤扒吊拷
接三连四
接二连三
接袂成帷
接踵比肩
接踵而来
接踵而至
接连不断
接风洗尘
控名责实
推三推四
推三阻四
推东主西
推亡固存
推天抢地
推崇备至
推己及人
推己及物
推干就湿
推心置腹
推心致腹
推本溯源
推枯折腐
推梨让枣
推波助澜
推涛作浪
推燥居湿
推而广之
推聋作哑
推聋妆哑
推舟于陆
推襟送抱
推诚布公
推诚接物
推诚相见
推诚置腹
推贤让能
推贤进善
推轮捧毂
推陈出新
推陈致新
推食解衣
掩人耳目
掩其不备
掩其无备
掩口失声
掩口而笑
掩口胡卢
掩口葫芦
掩恶扬善
掩恶扬美
掩旗息鼓
掩瑕藏疾
掩目捕雀
掩眼捕雀
掩耳偷铃
掩耳盗钟
掩耳盗铃
掩耳盗锺
掩过扬善
掩过饰非
掩骼埋窆
掩骼埋胔
掩鼻偷香
掩鼻而过
措心积虑
措手不及
措置裕如
掷地作金石声
掷地有声
掷地赋声
掷地金声
掷杖成龙
掷果潘安
掷果潘郎
掷鼠忌器
揆情审势
揆情度理
揆文奋武
揆时度势
揆理度势
揆理度情
揎拳拢袖
揎拳捋袖
揎拳捰袖
揎拳掳袖
揎拳攞袖
揎拳舞袖
揎拳裸手
揎拳裸臂
揎拳裸袖
揎腕攘臂
描写画角
描头画角
描神画鬼
描龙绣凤
提名道姓
提心吊胆
提心在口
提纲举领
提纲挈领
提纲振领
提要钩玄
插圈弄套
插架万轴
插科使砌
插科打诨
插翅难逃
插翅难飞
揖盗开门
揠苗助长
握云拿雾
握发吐哺
握发吐飧
握手言欢
握拳透掌
握拳透爪
握沐吐飱
握炭流汤
握瑜怀玉
握瑜怀瑾
握粟出卜
握素怀铅
握素披黄
握纲提领
握蛇骑虎
握铅抱椠
握雨携云
握雾拏云
握风捕影
揣合逢迎
揣奸把猾
揣时度力
揣骨听声
揭地掀天
揭竿而起
揭箧担囊
揭箧探囊
援古刺今
援古证今
援笔成章
援笔立成
援鳖失龟
揽名责实
揽权纳贿
揽辔中原
揽辔澄清
揽辔登车
搀前落后
搀行夺市
搅海翻江
搏手无策
搏牛之虻
搓手顿脚
搓手顿足
搔到痒处
搔头弄姿
搔头抓耳
搔头摸耳
搔着痒处
搔首弄姿
搔首踟蹰
搜奇抉怪
搜岩采干
搜扬侧陋
搜根剔齿
搜章摘句
搜章擿句
搜索枯肠
搜索肾胃
搜肠刮肚
搜肠润吻
搠笔巡街
搤臂啮指
搥胸跌脚
搥胸跌足
搦朽磨钝
搧风点火
搬口弄舌
搬唇弄舌
搬唇递舌
搬弄是非
搬斤播两
搬石砸脚
搬起石头打自己的脚
搭搭撒撒
搴旗取将
搴旗斩将
携云握雨
携幼扶老
携男挈女
携老扶弱
搽脂抹粉
摄威擅势
摄魄钩魂
摅肝沥胆
摆尾摇头
摆袖却金
摇唇鼓喙
摇唇鼓舌
摇嘴掉舌
摇头叹息
摇头幌脑
摇头摆尾
摇头摆脑
摇头晃脑
摇头稾脑
摇头麰尾
摇尾乞怜
摇尾求食
摇尾涂中
摇席破坐
摇席破座
摇手触禁
摇摇摆摆
摇摇欲坠
摇旗呐喊
摇笔即来
摇羽毛扇
摇身一变
摇鹅毛扇
摊书傲百城
摊书拥百城
摘句寻章
摘埴索涂
摘瑕指瑜
摘瓜抱蔓
摘胆剜心
摘艳熏香
摘艳薰香
摧兰折玉
摧刚为柔
摧坚获丑
摧坚陷阵
摧心剖肝
摧折豪强
摧朽拉枯
摧枯折腐
摧枯拉朽
摧枯拉腐
摧枯振朽
摧眉折腰
摧身碎首
摧锋陷坚
摧锋陷阵
摧陷廓清
摩厉以需
摩厉以须
摩口膏舌
摩拳擦掌
摩砺以须
摩肩击毂
摩肩接毂
摩肩接踵
摩肩擦踵
摩顶放踵
摩顶至足
摩顶至踵
摸不着头脑
摸头不着
摸金校尉
摸门不着
摽梅之年
撁五挂四
撅坑撅堑
撅天扑地
撇呆打堕
撑天拄地
撑岸就船
撑肠拄肚
撑肠拄腹
撑霆裂月
撒娇卖俏
撒娇撒痴
撒水拿鱼
撒泼打滚
撒泼放刁
撒痴撒娇
撒科打诨
撒诈捣虚
撒豆成兵
撒骚放屁
撞头搕脑
撞头磕脑
撞府冲州
撞阵冲军
撦鼓夺旗
撧耳挠腮
撧耳揉腮
撧耳顿足
撩云拨雨
撩火加油
撩蜂剔蝎
撩蜂吃螫
播土扬尘
播弄是非
播穅眯目
播糠眯目
撮土焚香
撮盐入水
撮盐入火
撮科打哄
撮科打閧
撺拳拢袖
撼地摇天
撼天震地
撼树蚍蜉
擂天倒地
擂鼓筛锣
擂鼓鸣金
擅作威福
擅壑专丘
操之过切
操之过急
操之过激
操之过蹙
操其奇赢
操刀伤锦
操刀制锦
操刀必割
操奇计赢
操奇逐赢
操戈入室
操戈同室
操揉磨治
操斧伐柯
操矛入室
操纵自如
操翰成章
操觚染翰
操赢致奇
操身行世
擎天之柱
擎天架海
擐甲执兵
擐甲挥戈
擒奸擿伏
擒奸讨暴
擒贼先擒王
擒贼擒王
擗踊拊心
擘两分星
擘肌分理
擢发莫数
擢发难数
擢筋剥肤
擢筋割骨
擦拳抹掌
擦拳磨掌
擦掌磨拳
擦脂抹粉
擿伏发奸
擿伏发隐
擿埴索涂
擿埴索途
擿奸发伏
擿植索涂
攀今吊古
攀今掉古
攀今揽古
攀今擥古
攀炎附热
攀花折柳
攀花问柳
攀藤揽葛
攀藤附葛
攀蟾折桂
攀车卧辙
攀辕卧辙
攀高接贵
攀高结贵
攀鳞附翼
攀龙托凤
攀龙讬凤
攀龙附凤
攀龙附骥
攒三聚五
攒三集五
攒眉苦脸
攒眉蹙额
攒锋聚镝
攒零合整
攘人之美
攘外安内
攘往熙来
攘攘熙熙
攘权夺利
攘来熙往
攘肌及骨
攘臂一呼
攘袂引领
攞袖揎拳
攧扑不破
攫为己有
攫戾执猛
攫金不见人
支分族解
支分节解
支吾其词
支床叠屋
支床迭屋
支手舞脚
支支吾吾
支支梧梧
支离破碎
支策据梧
支纷节解
收之桑榆
收刀检卦
收回成命
收因种果
收因结果
收园结果
收成弃败
收旗卷伞
收残缀轶
收离纠散
收离聚散
收缘结果
收视反听
收锣罢鼓
改俗迁风
改口沓舌
改名换姓
改名易姓
改天换地
改头换尾
改头换面
改姓易代
改姓更名
改容易貌
改张易调
改弦易张
改弦易调
改弦易辙
改弦更张
改往修来
改恶为善
改恶从善
改恶向善
改恶行善
改换头面
改换家门
改换门庭
改换门楣
改换门闾
改操易节
改政移风
改是成非
改曲易调
改朝换代
改朝换姓
改柯易叶
改柯易节
改柱张弦
改梁换柱
改步改玉
改玉改步
改玉改行
改而更张
改节易操
改行为善
改行从善
改行自新
改行迁善
改辕易辙
改辙易途
改过不吝
改过从善
改过作新
改过自新
改过迁善
改途易辙
改邪归正
攻其不备
攻其无备
攻城掠地
攻城略地
攻城野战
攻守同盟
攻心为上
攻心扼吭
攻无不克
攻玉以石
攻瑕指失
攻瑕索垢
攻疾防患
攻苦茹酸
攻苦食俭
攻苦食啖
攻苦食淡
攻过箴阙
放之四海而皆准
放任自流
放僻淫佚
放僻邪侈
放冷箭
放刁把滥
放刁撒泼
放屁添风
放心托胆
放心解体
放情丘壑
放意肆志
放歌纵酒
放泼撒豪
放浪不拘
放浪不羁
放浪形骸
放浪无拘
放浪无羁
放火烧山
放牛归马
放眼世界
放纵不拘
放纵不羁
放纵驰荡
放荡不羁
放荡形骸
放虎归山
放虎自卫
放虎遗患
放言遣辞
放言高论
放诞不拘
放诞不羁
放诞风流
放诸四海而皆准
放辟淫侈
放辟邪侈
放达不羁
放长线钓大鱼
放饭流歠
放马华阳
放马后炮
放鱼入海
放鹰逐犬
放龙入海
政令不一
政以贿成
政出多门
政清人和
政由己出
政简刑清
政通人和
故人之意
故伎重演
故作玄虚
故作高深
故入人罪
故剑情深
故土难离
故宫禾黍
故家乔木
故封识
故弄玄虚
故弄虚玄
故态复作
故态复萌
故态复还
故我依然
故技重演
故旧不弃
故步自封
故步自画
故甚其词
故纸堆
效死勿去
效死疆场
效死输忠
效犬马力
效颦学步
敌不可假
敌不可纵
敌众我寡
敌力角气
敌国外患
敌国通舟
敌忾同仇
敌惠敌怨
敌王所忾
敏而好学
救世济民
救亡图存
救偏补弊
救困扶危
救寒莫如重裘
救急扶伤
救时厉俗
救死扶伤
救死扶危
救民于水火
救民水火
救火扬沸
救火投薪
救火拯溺
救灾恤患
救焚投薪
救焚拯溺
救焚益薪
救燎助薪
救经引足
救苦弭灾
救苦救难
救过不暇
救过不给
救过不赡
救过补阙
救难解危
救饥拯溺
救黥医劓
敕始毖终
敖不可长
敖世轻物
教一识百
教亦多术
教学相长
教导有方
教无常师
教猱升木
敛后疏前
敛声匿迹
敛声屏息
敛声屏气
敛容屏气
敛影逃形
敛怨求媚
敛手屏足
敛手待毙
敛色屏气
敛锷韬光
敛骨吹魂
敝帚千金
敝帚自享
敝帚自珍
敝帷不弃
敝盖不弃
敝綈恶粟
敝绨恶粟
敝衣枵腹
敝衣粝食
敝鼓丧豚
敢不承命
敢为敢做
敢作敢为
敢作敢当
敢勇当先
敢怒敢言
敢怒而不敢言
敢怨而不敢言
散伤丑害
散兵游勇
散带衡门
散灰扃户
散言碎语
散阵投巢
散马休牛
敦世厉俗
敦本务实
敦诗说礼
敦风厉俗
敦默寡言
敩学相长
敬上接下
敬上爱下
敬业乐羣
敬业乐群
敬事不暇
敬事后食
敬天爱民
敬如上宾
敬姜犹绩
敬小慎微
敬恭桑梓
敬授人时
敬授民时
敬时爱日
敬终慎始
敬老尊贤
敬老怜贫
敬老恤贫
敬老慈少
敬老慈幼
敬老慈穉
敬而远之
敬若神明
敬谢不敏
敬贤下士
敬贤爱士
敬贤礼士
敬贤重士
敬陈管见
数一数二
数不胜数
数典忘祖
数往知来
数白论黄
数短论长
数米而炊
数米量柴
数见不鲜
数黄道白
数黄道黑
数黑论白
数黑论黄
敲冰戛玉
敲冰求火
敲冰玉屑
敲冰索火
敲山振虎
敲山震虎
敲榨勒索
敲牛宰马
敲竹杠
敲膏吸髓
敲诈勒索
敲边鼓
敲金击玉
敲金击石
敲金戛玉
敲锣打鼓
敲锣放炮
敲锣放砲
敲门砖
敲骨剥髓
敲骨取髓
敲骨吸髓
敲骨榨髓
敲髓洒膏
整军经武
整军饬武
整冠纳履
整年累月
整整截截
整旅厉卒
整旧如新
整本大套
整甲缮兵
整纷剔蠹
整衣敛容
整装待发
整襟危坐
整躬率物
整顿干坤
敷衍了事
敷衍塞责
敷衍搪塞
斆学相长
文不加点
文不对题
文丝不动
文人墨士
文人墨客
文人学士
文人无行
文人相轻
文从字顺
文以载道
文似其人
文修武偃
文修武备
文君司马
文君新寡
文君新醮
文君早寡
文圆质方
文奸济恶
文如其人
文婪武嬉
文子同升
文子文孙
文宗学府
文山会海
文弛武玩
文弱书生
文恬武嬉
文房四侯
文房四士
文房四宝
文房四寳
文房四物
文房四艺
文搜丁甲
文无加点
文无点易
文星高照
文昭武穆
文期酒会
文武之道
文武全才
文武兼备
文武双全
文武差事
文江学海
文治武力
文治武功
文深网密
文献之家
文理不通
文理俱惬
文章宗匠
文章宗工
文章宿老
文章山斗
文章巨公
文章憎命
文章星斗
文章盖世
文章经济
文章钜公
文章魁首
文籍先生
文经武略
文经武纬
文行出处
文觌武匿
文质彬彬
文质斌斌
文身剪发
文身断发
文身翦发
文过其实
文过遂非
文过饰非
文通残锦
文采风流
文韬武略
文风不动
斋心涤虑
斐然乡风
斐然向风
斐然成章
斑衣戏彩
斑驳陆离
斗丽争妍
斗升之水
斗南一人
斗唇合舌
斗媚争妍
斗志昂扬
斗怪争奇
斗折蛇行
斗挹箕扬
斗方名士
斗榫合缝
斗水活鳞
斗牙拌齿
斗筲之人
斗筲之器
斗筲穿窬
斗米尺布
斗粟尺布
斗絶一隅
斗绝一隅
斗美夸丽
斗而铸兵
斗而铸锥
斗色争妍
斗艳争妍
斗艳争芳
斗艳争辉
斗艶争妍
斗转参横
斗转星移
斗酒双柑
斗酒只鸡
斗酒学士
斗酒百篇
斗量筲计
斗量车载
斗霜傲雪
斗鸡养狗
斗鸡走犬
斗鸡走狗
斗鸡走马
料事如神
料峭春寒
料敌制胜
料敌如神
料敌若神
斜头歪脑
斜行横阵
斜风细雨
斠然一概
斠若画一
斤斤自守
斤斤计较
斤斤较量
斧破斨缺
斧钺之诛
斧钺汤镬
斩关夺隘
斩头去尾
斩头沥血
斩将刈旗
斩将夺旗
斩将搴旗
斩尽杀絶
斩尽杀绝
斩木揭竿
斩竿揭木
斩荆披棘
斩草除根
斩钉切铁
斩钉截铁
斩钢截铁
斫琱为朴
斫轮老手
斫雕为朴
断井颓垣
断决如流
断发文身
断发纹身
断圭碎璧
断垣残壁
断墨残楮
断壁残垣
断壁残璋
断壁颓垣
断头将军
断子絶孙
断子绝孙
断怪除妖
断手续玉
断无此理
断木掘地
断杼择邻
断根绝种
断梗浮萍
断梗飘萍
断梗飘蓬
断梗飞蓬
断烂朝报
断珪缺璧
断章取义
断章取意
断章截句
断章摘句
断简残编
断简遗编
断管残沈
断管残渖
断纸余墨
断纸馀墨
断线偶戏
断线风筝
断线鹞子
断织之诫
断织劝学
断缐鹞子
断编残简
断缣寸纸
断缣尺楮
断缣零璧
断羽絶鳞
断羽绝鳞
断脰决腹
断虀画粥
断蛟刺虎
断袖之宠
断袖之癖
断袖余桃
断还归宗
断金零粉
断长续短
断长补短
断雁孤鸿
断雨残云
断香零玉
断鹤继凫
断鹤续凫
断齑块粥
断齑画粥
斯文扫地
斯斯文文
新亭对泣
新人新事
新仇旧恨
新发于硎
新婚宴尔
新婚燕尔
新学小生
新愁旧恨
新故代谢
新昏宴尔
新来乍到
新益求新
新硎初试
新陈代谢
斲琱为朴
斲雕为朴
方以类聚
方便之门
方兴未已
方兴未艾
方凿圆枘
方员可施
方外之人
方头不劣
方头不律
方寸万重
方寸不乱
方寸之地
方寸已乱
方底圆盖
方来未艾
方枘圆凿
方枘圜凿
方桃譬李
方正不阿
方滋未艾
方言矩行
方足圆颅
方趾圆颅
方面大耳
方领圆冠
方领矩步
方骖并路
施仁布德
施号发令
施命发号
施施而行
施绯拖緑
施绯拖绿
施而不费
施衿结褵
旁引曲证
旁征博引
旁指曲谕
旁推侧引
旁搜博采
旁搜远绍
旁摇阴煽
旁收博采
旁敲侧击
旁文剩义
旁枝末节
旁求俊彦
旁求博考
旁若无人
旁蒐远绍
旁行斜上
旁见侧出
旁观者清
旁通曲畅
旁通曲鬯
旁逸横出
旁门外道
旁门小道
旁门左道
旁门邪道
旋乾转坤
旋干转坤
旋得旋失
旋生旋灭
旋转乾坤
旋转干坤
旌旗卷舒
旌旗蔽日
旖旎风光
旗布星峙
旗帜鲜明
旗开得胜
旗靡辙乱
旗鼓相当
无一不备
无一不知
无万大千
无下箸处
无与为比
无与伦比
无与比伦
无丝有线
无中生有
无为之治
无为而成
无为而治
无为自化
无为自成
无乎不可
无了无休
无了根蒂
无事不登三宝殿
无事不登三寳殿
无事生事
无事生非
无亲无故
无人之地
无人之境
无人问津
无从置喙
无以塞责
无以复加
无价之宝
无价之寳
无任之禄
无休无了
无伤大体
无伤大雅
无伤无臭
无何有之乡
无何有乡
无佛处称尊
无使滋蔓
无依无靠
无倚无靠
无偏无倚
无偏无党
无偏无陂
无偏无颇
无兄盗嫂
无党无偏
无关大体
无关大局
无关宏旨
无关痛痒
无关紧要
无其伦比
无其奈何
无冬历夏
无冬无夏
无出其右
无功受禄
无功而禄
无动为大
无动于中
无动于衷
无千待万
无千无万
无可不可
无可争辩
无可厚非
无可名状
无可奈何
无可奈何花落去
无可奉告
无可如何
无可救药
无可无不可
无可柰何
无可比伦
无可比拟
无可比象
无可置喙
无可置疑
无可置辩
无可讳言
无可非议
无名之师
无名之朴
无名之璞
无名孽火
无名小卒
无名小辈
无名火气
无名英雄
无咎无誉
无噍类矣
无地可容
无地自厝
无地自处
无地自容
无坚不摧
无坚不陷
无声无息
无声无臭
无声无色
无大不大
无大无小
无天无日
无头告示
无头无尾
无奇不有
无如之何
无如之奈
无如奈何
无妄之忧
无妄之灾
无妄之祸
无妄之福
无始无终
无孔不入
无孔不钻
无官一身轻
无家可奔
无家可归
无家无室
无容身之地
无寇暴死
无尤无怨
无尽无休
无尽无穷
无巧不成书
无巧不成话
无师自通
无平不颇
无幽不烛
无庸置疑
无庸置辩
无庸讳言
无庸赘述
无形之罪
无形无影
无影无形
无影无踪
无往不克
无往不利
无往不复
无往不胜
无征不信
无待蓍龟
无微不至
无德而称
无忧无虑
无思无虑
无怨无德
无恒安息
无恶不为
无恶不作
无恶不造
无情少面
无情无义
无情无彩
无情无绪
无愧衾影
无懈可击
无所不为
无所不作
无所不包
无所不及
无所不可
无所不在
无所不备
无所不容
无所不尽其极
无所不晓
无所不有
无所不用其极
无所不知
无所不能
无所不至
无所不通
无所事事
无所作为
无所依归
无所可否
无所回避
无所容心
无所忌惮
无所忌讳
无所措手
无所措手足
无所施其伎
无所施其技
无所用之
无所用心
无所畏忌
无所畏惧
无所畏惮
无所适从
无所重轻
无所错手足
无所顾忌
无所顾惮
无拘无束
无拘无碍
无拘无缚
无拳无勇
无挂无碍
无故呻吟
无敌于天下
无敌天下
无方之民
无施不可
无施不效
无旧无新
无时无刻
无明业火
无明无夜
无昼无夜
无有伦比
无服之丧
无服之殇
无机可乘
无束无拘
无根无蒂
无根而固
无毁无誉
无毒不丈夫
无毛大虫
无法无天
无洞掘蟹
无济于事
无涯之戚
无父无君
无牵无挂
无独有偶
无理取闹
无用武之地
无疆之休
无病呻吟
无病自炙
无的放矢
无盐不解淡
无相无作
无知妄作
无私之光
无私有弊
无私有意
无稽之言
无稽之谈
无穷无尽
无空不入
无立锥之地
无端生事
无米之炊
无精嗒彩
无精打彩
无精打采
无缘无故
无缝天衣
无罣无碍
无置锥地
无翼而飞
无耻之尤
无肠公子
无肠可断
无背无侧
无胫而来
无胫而至
无胫而行
无胫而走
无能为力
无能为役
无般不识
无虑无忧
无虑无思
无衣之赋
无补于事
无言可对
无计可奈
无计可施
无计奈何
无计所奈
无论如何
无足轻重
无足重轻
无踪无影
无边无垠
无边无沿
无边无际
无边风月
无远不届
无远弗届
无迹可寻
无迹可求
无适无莫
无適无莫
无遮大会
无间冬夏
无间可乘
无间可伺
无间是非
无际可寻
无隙可乘
无面目见江东父老
无须之祸
无颜落色
无颠无倒
无风三尺浪
无风不起浪
无风作浪
无风扬波
无风生浪
无风起浪
既往不咎
既得利益
既成事实
日上三竿
日下无双
日不我与
日不暇给
日不移影
日不移晷
日东月西
日中为市
日中则昃
日中则移
日中将昃
日中必彗
日中必昃
日中必湲
日中必移
日丽风和
日丽风清
日久天长
日久岁深
日久岁长
日久年深
日久月深
日久歳深
日久歳长
日久见人心
日乾夕惕
日以为常
日以继夜
日出三竿
日出不穷
日削月割
日削月朘
日升月恒
日和风暖
日坐愁城
日堙月塞
日增月益
日增月盛
日复一日
日夜兼程
日就月将
日居月诸
日已三竿
日干夕惕
日异月新
日异月更
日异月殊
日引月长
日往月来
日征月迈
日慎一日
日新月异
日新月盛
日新月着
日新月著
日无暇晷
日日夜夜
日旰不食
日旰忘食
日旰忘餐
日昃不食
日昃忘食
日昃旰食
日暖风和
日暖风恬
日暮路远
日暮途穷
日暮途远
日暮道远
日月不居
日月丽天
日月交食
日月入怀
日月其除
日月参辰
日月合壁
日月合璧
日月如梭
日月如流
日月无光
日月经天
日月踰迈
日月蹉跎
日月逾迈
日月重光
日有万机
日朘月减
日朘月削
日来月往
日渐月染
日滋月益
日濡月染
日炙风吹
日炙风筛
日理万机
日甚一日
日益月滋
日省月修
日省月试
日省月课
日短心长
日积月累
日积月聚
日程月课
日累月积
日莫途远
日落千丈
日落西山
日薄桑榆
日薄虞渊
日薄西山
日行千里
日角偃月
日角珠庭
日角龙庭
日角龙颜
日许多时
日许时间
日试万言
日诵五车
日转千街
日转千阶
日迈月征
日近长安远
日进斗金
日销月铄
日锻月炼
日长一线
日长似岁
日陵月替
日食万钱
日饮亡何
日饮无何
日高三丈
旦夕之危
旦夕之间
旦旦而伐
旦暮入地
旦种暮成
旧事重提
旧仇宿怨
旧地重游
旧念复萌
旧态复萌
旧恨新仇
旧恨新愁
旧愁新恨
旧燕归巢
旧瓶新酒
旧瓶装新酒
旧病复发
旧病难医
旧话重提
旧调重弹
旧雨今雨
旧雨新知
旧雨重逢
早出晚归
早出暮归
早占勿药
早朝晏罢
早韭晚菘
旬输月送
旭日东升
旭日初升
旰食之劳
旰食宵衣
旱苗得雨
旱魃为虐
时不再来
时不可失
时不我与
时不我待
时乖命蹇
时乖运乖
时乖运拙
时乖运舛
时乖运蹇
时亨运泰
时势造英雄
时和岁丰
时和岁稔
时和年丰
时异事殊
时异势殊
时无再来
时日曷丧
时易世变
时望所归
时来运旋
时来运来
时来运转
时殊风异
时清海宴
时移世变
时移世异
时移世易
时移俗易
时移势易
时移势迁
时绌举盈
时绌举赢
时至运来
时诎举赢
时过境迁
时运不济
时运不齐
时运亨通
时隐时见
旷世奇才
旷世无匹
旷世逸才
旷古一人
旷古奇闻
旷古未有
旷古未闻
旷古绝伦
旷夫怨女
旷心怡神
旷日引久
旷日引月
旷日弥久
旷日持久
旷日离久
旷日积晷
旷日累时
旷日经久
旷日经年
旷日长久
旷若发蒙
旷达不羁
昂头天外
昂头挺胸
昂头阔步
昂昂自若
昂然直入
昂然自得
昂然自若
昂藏七尺
昂霄耸壑
昂首伸眉
昂首天外
昂首挺胸
昂首望天
昂首阔步
昃食宵衣
昆山之玉
昆山片玉
昆弟之好
昊天不吊
昊天罔极
昌亭之客
昌亭旅食
昌歜羊枣
昌言无忌
明争暗斗
明人不做暗事
明光烁亮
明光铮亮
明光锃亮
明公正义
明公正气
明公正道
明刑不戮
明刑弼教
明升暗降
明发不寐
明哲保身
明堂正道
明如指掌
明婚正娶
明婚正配
明媒正娶
明媒正礼
明察暗访
明察秋毫
明廉暗察
明德惟馨
明心见性
明扬仄陋
明扬侧陋
明抢暗偷
明推暗就
明效大验
明教不变
明日黄花
明明白白
明明赫赫
明昭昏蒙
明月入怀
明月清风
明来暗往
明枪暗箭
明查暗访
明正典刑
明法审令
明火执仗
明火执杖
明火执械
明火持杖
明珠夜投
明珠弹雀
明珠投暗
明珠暗投
明白了当
明目张胆
明目达聪
明眸善睐
明眸皓齿
明知故犯
明知故问
明窗净几
明窗浄几
明罚勑法
明罚敕法
明耻教战
明若观火
明见万里
明赏不费
明辨是非
明镜高悬
明验大效
明鼓而攻之
昏天暗地
昏天黑地
昏头打脑
昏头搭脑
昏头昏脑
昏头晕脑
昏头转向
昏定晨省
昏庸无道
昏昏噩噩
昏昏欲睡
昏昏沉沉
昏昏浩浩
昏昏默默
昏聩无能
昏迷不省
昏迷不醒
昏镜重明
昏镜重磨
易于反手
易于反掌
易于拾遗
易俗移风
易口以食
易同反掌
易地而处
易如反掌
易如拾芥
易如破竹
易如翻掌
易子析骸
易子而教
易子而食
易辙改弦
昙花一现
星前月下
星旗电戟
星星之火
星星点点
星星落落
星月交辉
星流电击
星流霆击
星火燎原
星灭光离
星离月会
星离雨散
星移斗转
星移漏转
星移物换
星罗云布
星罗棊布
星罗棋布
星罗碁布
星落云散
星行夜归
星行电征
星霜屡移
星飞云散
星飞电急
星驰电发
星驰电掣
星驰电走
映月读书
映雪囊萤
映雪读书
春光明媚
春光漏泄
春兰秋菊
春冰虎尾
春华秋实
春去秋来
春和景明
春回大地
春宵一刻
春寒料峭
春山如笑
春意盎然
春意阑珊
春晖寸草
春暖花开
春暖花香
春树暮云
春梦无痕
春深似海
春满人间
春生秋杀
春秋无义战
春秋笔法
春秋鼎盛
春笋怒发
春色撩人
春色满园
春花秋实
春花秋月
春葩丽藻
春蚓秋蛇
春蚕到死丝方尽
春蛇秋蚓
春蛙秋蝉
春诵夏弦
春雨如油
春露秋霜
春风一度
春风化雨
春风和气
春风夏雨
春风得意
春风沂水
春风满面
春风野火
春风雨露
春风风人
昧地瞒天
昧地谩天
昧己瞒心
昧旦晨兴
昧死以闻
昭如日星
昭德塞违
昭昭在目
昭然若揭
昭聋发聩
是古非今
是是非非
是非之心
是非分明
是非口舌
是非只为多开口
是非得失
是非曲直
是非自有公论
是非颠倒
昼乾夕惕
昼伏夜动
昼伏夜游
昼伏夜行
昼吟宵哭
昼夜兼程
昼夜兼行
昼干夕惕
昼度夜思
昼思夜想
昼想夜梦
昼日三接
昼日昼夜
昼耕夜诵
昼警夕惕
昼警暮巡
昼阴夜阳
显亲扬名
显姓扬名
显山露水
显微阐幽
显祖扬名
显祖扬宗
显祖荣宗
显而易见
显露头角
晋惠闻蛙
晋用楚材
晋阳之甲
晏安酖毒
晏开之警
晏然自若
晓以利害
晓以大义
晓行夜住
晓行夜宿
晓风残月
晕头转向
晕晕沉沉
晖光日新
晚生后学
晚节不保
晚节不终
晚节黄花
晚食当肉
晦盲否塞
晦迹韬光
晨光熹微
晨兢夕厉
晨兴夜寐
晨参暮省
晨参暮礼
晨提夕命
晨昏定省
晨炊星饭
晨秦暮楚
晨钟暮鼓
晬面盎背
普天之下
普天匝地
普天同庆
普天率土
普度众生
普度羣生
普度群生
普济众生
普济羣生
普济群生
普渡众生
景入桑榆
景升豚犬
景星凤凰
景星凤皇
景星庆云
景星麟凤
晰毛辨发
晴天霹雳
智勇兼全
智勇双全
智周万物
智圆行方
智均力敌
智小言大
智小谋大
智尽能索
智昏菽麦
智穷才尽
智藏瘝在
暂劳永逸
暑往寒来
暑来寒往
暑雨祁寒
暖衣饱食
暗中摸索
暗室不欺
暗室亏心
暗室屋漏
暗室欺心
暗室求物
暗室私心
暗室逢灯
暗度金针
暗度陈仓
暗弱无断
暗斗明争
暗无天日
暗昧之事
暗气暗恼
暗淡无光
暗渡陈仓
暗箭中人
暗箭伤人
暗箭明枪
暗箭难防
暗緑稀红
暗绿稀红
暗送秋波
暗锤打人
暗香疏影
暧昧不明
暧昧之情
暮云春树
暮去朝来
暮四朝三
暮夜先容
暮夜怀金
暮夜无知
暮想朝思
暮景桑榆
暮景残光
暮暮朝朝
暮楚朝秦
暮气沉沉
暮爨朝舂
暮礼晨参
暮翠朝红
暮色苍茫
暮虢朝虞
暮雨朝云
暮鼓晨钟
暮鼓朝钟
暴内陵外
暴取豪夺
暴戾恣睢
暴敛横征
暴殄天物
暴腮龙门
暴虎冯河
暴虐无道
暴衣露冠
暴衣露盖
暴跳如雷
暴躁如雷
暴露无遗
暴风疾雨
暴风骤雨
曙后星孤
曝书见竹
曝背食芹
曝骨履肠
曲不离口
曲学诐行
曲学阿世
曲尽其妙
曲尽奇妙
曲径通幽
曲意奉迎
曲意承迎
曲意迎合
曲意逢迎
曲眉丰颊
曲突徙薪
曲突移薪
曲终奏雅
曲肱而枕
曲里拐弯
曲高和寡
曳兵之计
曳兵弃甲
曳尾泥涂
曳尾涂中
曳裾王门
更上一层楼
更仆难尽
更仆难数
更仆难终
更令明号
更名改姓
更唱叠和
更唱迭和
更姓改物
更弦改辙
更弦易辙
更待干罢
更深人静
更深夜静
更若役
更进一竿
更长梦短
更阑人静
更难仆数
曹社之谋
曼衍鱼龙
曾不惨然
曾几何时
曾参杀人
曾无与二
曾母投杼
曾经沧海
替古人担忧
替古人耽忧
替天行道
替罪羊
最可觞客
月下老人
月下老儿
月下花前
月中折桂
月值年灾
月圆花好
月地云阶
月坠花折
月夕花晨
月夕花朝
月夜花朝
月异日新
月旦春秋
月明千里
月明星稀
月晕础润
月晕而风
月朗星稀
月朗风清
月没参横
月满则亏
月白风清
月盈则食
月章星句
月缺花残
月缺难圆
月落乌啼
月落参横
月落星沈
月落星沉
月貌花容
月里嫦娥
月露之体
月露风云
月黑风高
有一利必有一弊
有一得一
有一搭没一搭
有一无二
有三有俩
有事之秋
有以善处
有伤风化
有何面目
有例可援
有借无还
有其父必有其子
有凤来仪
有凭有据
有利可图
有利有弊
有加无已
有勇无谋
有勇有谋
有勇知方
有口无心
有口无行
有口皆碑
有口难分
有口难言
有口难辩
有名亡实
有名无实
有嘴无心
有嘴没心
有嘴没舌
有国难投
有增无已
有增无损
有声无实
有声无气
有声有色
有声没气
有备无患
有天无日
有天没日
有天没日头
有头无尾
有头无脑
有头有尾
有头有脑
有头有脸
有头没脑
有女怀春
有始无终
有始有卒
有始有终
有害无利
有家难奔
有己无人
有年无月
有征无战
有心无力
有心有意
有志不在年高
有志之士
有志无时
有志竟成
有志者事竟成
有恃无恐
有恃毋恐
有意无意
有我无人
有所作为
有才无命
有损无益
有教无类
有文无行
有无相通
有是父必有是子
有朝一日
有本有原
有本有源
有机可乘
有条不紊
有条有理
有来无回
有来有往
有板有眼
有枝有叶
有枝添叶
有根有底
有根有苗
有案可查
有案可稽
有棱有角
有死无二
有气无力
有气无烟
有气没力
有求必应
有物有则
有生之年
有生以来
有生力量
有的放矢
有目共睹
有目共见
有目共赏
有目无睹
有眼不识泰山
有眼如盲
有眼无珠
有眼无瞳
有福同享
有约在先
有耻且格
有胆有识
有脚书厨
有脚书橱
有脚阳春
有色眼镜
有蠙可乘
有血有肉
有言在先
有识之士
有说有笑
有负众望
有财有势
有过之无不及
有过之而无不及
有进无退
有钱有势
有钱能使鬼推磨
有问必答
有闻必录
有闻必録
有隙可乘
有风有化
有鼻子有眼
朋党比周
朋比为奸
朋比作奸
服低做小
服服贴贴
服牛乘马
服田力穑
朗月清风
朗朗上口
朗朗乾坤
朗目疏眉
望云之情
望其肩项
望其项背
望子成龙
望尘不及
望尘僄声
望尘奔北
望尘奔溃
望尘拜伏
望尘而拜
望尘莫及
望尘追迹
望尘靡及
望屋以食
望屋而食
望岫息心
望峯息心
望峰息心
望帝啼鹃
望影揣情
望文生义
望文生训
望断白云
望梅止渴
望梅阁老
望洋兴叹
望洋而叹
望眼将穿
望眼欲穿
望秋先零
望空捉影
望穿秋水
望而却步
望而生畏
望衡对宇
望表知里
望门投止
望闻问切
望风响应
望风希指
望风希旨
望风扑影
望风承旨
望风披靡
望风捕影
望风而逃
望风而遁
望风而降
望风而靡
朝三暮二
朝三暮四
朝不保夕
朝不保暮
朝不及夕
朝不虑夕
朝不谋夕
朝乾夕惕
朝乾夕愓
朝云暮雨
朝令夕改
朝令暮改
朝前夕惕
朝升暮合
朝华夕秀
朝发夕至
朝发暮至
朝夕相处
朝夷暮跖
朝奏夕召
朝奏暮召
朝干夕惕
朝思暮想
朝成夕毁
朝成暮徧
朝成暮毁
朝成暮遍
朝折暮折
朝攀暮折
朝斯夕斯
朝更暮改
朝朝暮暮
朝梁暮周
朝梁暮晋
朝梁暮陈
朝欢暮乐
朝歌夜弦
朝歌暮弦
朝气蓬勃
朝生夕死
朝生暮死
朝种暮获
朝秦暮楚
朝穿暮塞
朝章国典
朝章国故
朝经暮史
朝虀暮盐
朝衣东市
朝趁暮食
朝过夕改
朝里无人莫做官
朝野上下
朝钟暮皷
朝钟暮鼓
朝锺暮皷
朝锺暮鼓
朝闻夕改
朝闻夕死
朝阳丹凤
朝阳鸣凤
朝露溘至
朝饔夕飧
朝齑暮盐
期期艾艾
期颐之寿
木人石心
木公金母
木坏山颓
木头木脑
木已成舟
木干鸟栖
木心石腹
木本水源
木朽蛀生
木梗之患
木石心肠
木落归本
木讷寡言
木雕泥塑
木鸡养到
未与人接
未为不可
未了公案
未卜先知
未可厚非
未可同日而语
未定之天
未形之患
未成一篑
未敢苟同
未明求衣
未焚徙薪
未知万一
未竟之志
未老先衰
未能免俗
未艾方兴
未识一丁
未足轻重
未达一间
未雨绸缪
未风先雨
末大不掉
末大必折
末如之何
末学肤受
末节细行
末路之难
末路穷途
本乡本土
本同末异
本同末离
本固邦宁
本小利微
本性难移
本支百世
本末倒置
本末源流
本来面目
本枝百世
本相毕露
札手舞脚
朱云折槛
朱唇玉面
朱唇皓齿
朱唇粉面
朱干玉戚
朱弦三叹
朱楼碧瓦
朱楼绮户
朱槃玉敦
朱甍碧瓦
朱盘玉敦
朱衣使者
朱衣点头
朱轓皁盖
朱轓皂盖
朱轮华毂
朱门绣户
朱阁青楼
朱陈之好
朱雀玄武
朱颜緑发
朱颜绿发
朱颜翠发
朱颜鹤发
朴实无华
朴斫之材
朴斲之材
朴素无华
朴讷诚笃
朵颐大嚼
机不可失
机不容发
机不旋踵
机事不密
机关用尽
机关算尽
机变如神
机心械肠
机杼一家
机难轻失
朽戈钝甲
朽木不可雕
朽木不雕
朽木死灰
朽木生花
朽木粪土
朽木粪墙
朽木难彫
朽木难雕
朽条腐索
朽株枯木
朽棘不彫
朽棘不雕
朽竹篙舟
朽索驭马
朽骨重肉
杀一儆百
杀一利百
杀一砺百
杀一警百
杀人不眨眼
杀人不见血
杀人如草
杀人如蒿
杀人如蓺
杀人如麻
杀人放火
杀人灭口
杀人盈野
杀人越货
杀妻求将
杀彘教子
杀敌致果
杀气腾腾
杀衣缩食
杀身之祸
杀身成义
杀身成仁
杀身报国
杀风景
杀马毁车
杀鸡为黍
杀鸡儆猴
杀鸡取卵
杀鸡取蛋
杀鸡吓猴
杀鸡哧猴
杀鸡抹脖
杀鸡焉用牛刀
杀鸡骇猴
杂七杂八
杂乱无序
杂乱无章
权倾中外
权倾天下
权变锋出
权均力敌
权均力齐
权宜之策
权宜之计
权时制宜
权移马鹿
权衡利弊
权衡轻重
权豪势要
权重望崇
权重秩卑
杅穿皮蠹
李下瓜田
李代桃僵
李代桃殭
李广不侯
李广未封
李广难封
李白桃红
李郭仙舟
李郭同舟
李郭同船
杏脸桃腮
杏腮桃脸
杏腮桃颊
杏花春雨
杏雨梨云
材优干济
材剧志大
材士练兵
材大难用
材德兼备
材朽行秽
材疏志大
材能兼备
材茂行洁
材茂行絜
材薄质衰
材轻德薄
材雄德茂
材高知深
村哥里妇
村夫俗子
村夫野老
村学究语
村歌社舞
村歌社鼓
村生泊长
村箫社鼓
村酒野蔬
村野匹夫
杖履相从
杖履纵横
杜口吞声
杜口无言
杜口絶言
杜口结舌
杜口绝言
杜口裹足
杜弊清源
杜微慎防
杜断房谋
杜渐防微
杜渐防萌
杜渐除微
杜绝人事
杜绝后患
杜绝言路
杜耳恶闻
杜门不出
杜门却扫
杜门屏迹
杜门晦迹
杜门絶客
杜门絶迹
杜门绝客
杜门绝迹
杜门自守
杜门自絶
杜门自绝
杜门谢客
杜门面壁
杜隙防微
杜鹃啼血
杜默为诗
杞人之忧
杞人忧天
杞国之忧
杞国忧天
杞天之虑
杞宋无征
杞梓之林
束上起下
束之高屋
束之高阁
束修自好
束兵秣马
束发封帛
束在高阁
束带结发
束广就狭
束戈卷甲
束手受毙
束手听命
束手坐视
束手就困
束手就擒
束手就殪
束手就毙
束手就禽
束手就缚
束手待死
束手待毙
束手旁观
束手无措
束手无术
束手无策
束手无计
束手束脚
束手束足
束手缚脚
束手自毙
束教管闻
束杖理民
束椽为柱
束缊举火
束缊请火
束缊还妇
束置高阁
束肩敛息
束蒲为脯
束蕴乞火
束蕴请火
束藴乞火
束藴请火
束装就道
束装盗金
束贝含犀
束身受命
束身就缚
束身自修
束身自好
束身自爱
束马县车
束马悬车
条三窝四
条修叶贯
条入叶贯
条分缕析
条分节解
条条框框
条解支劈
条贯部分
来世不可待
来之不易
来势汹汹
来历不明
来去分明
来去无踪
来回来去
来因去果
来处不易
来好息师
来情去意
来日大难
来日方长
来者不善
来者不拒
来者勿拒
来者可追
来者居上
来而不往非礼也
来踪去路
来踪去迹
来迎去送
来鸿去燕
来龙去脉
杨朱泣岐
杨柳依依
杨柳宫眉
杨生黄雀
杨穿三叶
杨花心性
杨花水性
杨虎围匡
杨雀衔环
杯中之物
杯中物
杯中蛇影
杯弓市虎
杯弓蛇影
杯影蛇弓
杯水之敬
杯水之谢
杯水粒粟
杯水舆薪
杯水车薪
杯盘狼籍
杯盘狼藉
杯羹之让
杯茗之敬
杯蛇幻影
杯蛇鬼车
杯觥交杂
杯觥交错
杯酒戈矛
杯酒解怨
杯酒言欢
杯酒释兵权
杳不可闻
杳如黄鹤
杳无人烟
杳无人迹
杳无信息
杳无影响
杳无消息
杳无踪影
杳无踪迹
杳无音信
杳无音耗
杳无音讯
杵臼之交
杵臼交
杷罗剔抉
杼柚之空
杼柚其空
杼柚空虚
松乔之寿
松形鹤骨
松枝挂剑
松柏之寿
松柏之志
松柏之茂
松柏后凋
松柏寒盟
松筠之节
松茂竹苞
松萝共倚
板上砸钉
板上钉钉
板板六十四
极乐世界
极则必反
极口项斯
极古穷今
极天罔地
极天蟠地
极天际地
极寿无疆
极往知来
极恶不赦
极恶穷凶
极情尽致
极情纵欲
极智穷思
极本穷源
极武穷兵
极深研几
极深研幾
极目远望
极目远眺
极目迥望
极而言之
极重不反
极重难返
枇杷门巷
枉勘虚招
枉口嚼舌
枉口拔舌
枉口诳舌
枉墨矫绳
枉尺直寻
枉己正人
枉曲直凑
枉法徇私
枉物难消
枉用心机
枉直同贯
枉直随形
枉矢哨壶
枉矫过激
枉突徙薪
枉费唇舌
枉费工夫
枉费心力
枉费心思
枉费心机
枉费心计
枉费日月
枉辔学步
枉道事人
析交离亲
析圭儋爵
析圭分组
析圭担爵
析律舞文
析律贰端
析微察异
析毫剖厘
析毫剖芒
析珪判野
析珪胙土
析疑匡谬
析精剖微
析缕分条
析肝刿胆
析肝吐胆
析肝沥悃
析言破律
析辨诡词
析辨诡辞
析辩诡辞
析骨而炊
析骸以爨
析骸易子
枕中鸿宝
枕中鸿寳
枕典席文
枕冷衾寒
枕善而居
枕山栖谷
枕山臂江
枕山襟海
枕山负海
枕岩漱流
枕嵓漱流
枕席过师
枕席还师
枕干之雠
枕戈以待
枕戈击楫
枕戈剚刃
枕戈坐甲
枕戈寝甲
枕戈尝胆
枕戈待命
枕戈待敌
枕戈待旦
枕戈披甲
枕戈汗马
枕戈泣血
枕戈达旦
枕戈饮胆
枕戈饮血
枕方寝绳
枕曲藉糟
枕流漱石
枕石嗽流
枕石寝绳
枕石漱流
枕稳衾温
枕籍经史
枕经籍书
枕麹藉糟
林下清风
林下风度
林下风气
林下风致
林下风范
林下风韵
林下高风
林寒洞肃
林寒涧肃
林林总总
林栖谷隐
林籁泉韵
枘凿冰炭
枘凿方圆
枘圆凿方
枚速马工
果不其然
果于自信
果刑信赏
果然如此
果熟蒂落
果行育德
枝分叶散
枝分缕解
枝别条异
枝叶扶疏
枝叶扶苏
枝叶相持
枝外生枝
枝大于本
枝对叶比
枝布叶分
枝干相持
枝末生根
枝流叶布
枝源派本
枝繁叶茂
枝节横生
枝词蔓语
枝词蔓说
枝辞蔓语
枝附叶从
枝附叶着
枝附叶著
枝附叶连
枝附影从
枪声刀影
枪林刀树
枪林弹雨
枪烟炮雨
枪烟砲雨
枭俊禽敌
枭心鹤貌
枭蛇鬼怪
枭视狼顾
枭首示众
枯体灰心
枯形灰心
枯木再生
枯木发荣
枯木朽株
枯木死灰
枯木生花
枯木逢春
枯本竭源
枯朽之余
枯杨之稊
枯杨生华
枯杨生稊
枯枝再春
枯枝败叶
枯枿朽株
枯树开花
枯树生华
枯树生花
枯树逢春
枯株朽木
枯燥无味
枯耘伤岁
枯脑焦心
枯苗望雨
枯蓬断草
枯骨之余
枯骨之馀
枯骨生肉
枯鱼之肆
枯鱼涸辙
枯鱼病鹤
枯鱼衔索
枵腹从公
枵腹终朝
架屋叠床
架屋迭床
架海金梁
架肩击毂
架肩接踵
架谎凿空
枷脰械手
柏舟之节
柏舟之誓
染丝之变
染指于鼎
染指垂涎
染旧作新
染神乱志
染神刻骨
染翰成章
染苍染黄
染蓝涅皂
染须种齿
染风习俗
柔声下气
柔心弱骨
柔情侠骨
柔情媚态
柔情密意
柔情绰态
柔情蜜意
柔懦寡断
柔枝嫩叶
柔枝嫩条
柔筋脆骨
柔而不犯
柔肠寸断
柔肠百结
柔肠百转
柔肤弱体
柔能克刚
柔能制刚
柔茹刚吐
柔茹寡断
柔远怀来
柔远怀迩
柔远绥怀
柔远能迩
柔远镇迩
柙虎樊熊
查无实据
柱天踏地
柱小倾大
柱石之坚
柳下借阴
柳亸花娇
柳亸莺娇
柳啼花怨
柳圣花神
柳夭桃艳
柳娇花媚
柳宠花迷
柳巷花街
柳市花街
柳弱花娇
柳影花阴
柳户花门
柳折花残
柳昏花暝
柳昏花螟
柳暖花春
柳暗花明
柳暗花明又一村
柳暗花遮
柳泣花啼
柳烟花雾
柳眉倒竖
柳眉剔竖
柳眉星眼
柳眉踢竖
柳絮才高
柳緑桃红
柳緑花红
柳绿桃红
柳绿花红
柳腰花态
柳腰莲脸
柳莺花燕
柳营花市
柳营花阵
柳街花巷
柳衢花市
柳门竹巷
柳陌花丛
柳陌花巷
柳陌花街
柳陌花衢
柳骨颜筋
柴天改物
柴天改玉
柴毁灭性
柴毁骨立
柴立不阿
柴米夫妻
柴米油盐
标同伐异
标情夺趣
标新创异
标新立异
标新竖异
标新竞异
标新领异
标枝野鹿
栈山航海
栉垢爬痒
栉比鳞差
栉比鳞次
栉比鳞臻
栉沐风雨
栉霜沐露
栉风沐雨
栉风酾雨
栋折榱坏
栋折榱崩
栋朽榱崩
栋梁之才
栋梁之材
栎阳雨金
树上开花
树俗立化
树倒根摧
树倒猢孙散
树倒猢狲散
树元立嫡
树同拔异
树大招风
树大根深
树德务滋
树欲息而风不停
树欲静而风不停
树欲静而风不宁
树欲静而风不止
树碑立传
树高招风
栖丘饮谷
栖冲业简
栖栖遑遑
栖风宿雨
栗栗危惧
校短推长
校短量长
栩栩如生
栩栩欲活
株连蔓引
根孤伎薄
根据槃互
根据盘互
根株牵连
根株结盘
根株附丽
根椽片瓦
根深叶茂
根深本固
根深枝茂
根深柢固
根深蒂固
根深蒂结
根深蔕固
根深蔕结
根牙盘错
根牙磐错
根牢蒂固
根生土长
根盘蒂结
根盘蔕结
根结盘固
根结盘据
根蟠节错
根连株拔
根连株逮
格不相入
格于成例
格古通今
格天彻地
格杀不论
格杀勿论
格杀弗论
格杀无论
格格不入
格格不吐
格格不纳
格物穷理
格物致知
格高意远
桀傲不恭
桀傲不驯
桀敖不驯
桀犬吠尧
桀贪骜诈
桀骜不恭
桀骜不逊
桀骜不驯
桀骜自恃
桀骜难驯
桂子兰孙
桂子飘香
桂宫兰殿
桂折一枝
桂折兰摧
桂林一枝
桂林杏苑
桂枝片玉
桂殿兰宫
桂玉之地
桂薪玉粒
桂酒椒浆
桂馥兰香
桃之夭夭
桃僵李代
桃夭李艳
桃夭柳媚
桃弧棘矢
桃李之教
桃李之馈
桃李争妍
桃李成蹊
桃李春风
桃李满天下
桃李精神
桃李遍天下
桃李门墙
桃来李答
桃红柳緑
桃红柳绿
桃羞杏让
桃腮柳眼
桃腮粉脸
桃花人面
桃花流水
桃花潭水
桃蹊柳曲
桃蹊柳陌
案兵束甲
案剑瞋目
案无留牍
案牍之劳
案牍劳形
案甲休兵
桑中之喜
桑中之约
桑土之谋
桑土之防
桑土绸缪
桑弧矢志
桑弧蒿矢
桑弧蓬矢
桑户桊枢
桑户棬枢
桑户蓬枢
桑枢瓮牖
桑枢甕牖
桑枢韦带
桑榆之景
桑榆晚景
桑榆暮景
桑榆末景
桑田沧海
桑田碧海
桑荫不徙
桑荫未移
桑落瓦解
桑间之咏
桑间之约
桑间之音
桑间濮上
桴鼓相应
梁上君子
梁孟相敬
梅妻鹤子
梗泛萍漂
梗泛萍飘
梗迹萍踪
梗迹蓬飘
梗顽不化
梦中说梦
梦寐以求
梦幻泡影
梦想颠倒
梦撒寮丁
梦撒撩丁
梦断魂劳
梦熊之喜
梦笔生花
梦见周公
梦里南轲
梦魂颠倒
梧凤之鸣
梧桐一叶落
梧桐断角
梧鼠之技
梧鼠五技
梧鼠技穷
梨园子弟
梨园弟子
梨眉艾发
梨花带雨
梭天摸地
梯山架壑
梯山栈谷
梯山航海
梯愚入圣
梳云掠月
梳妆打扮
梳文栉字
梵册贝叶
棋布星罗
棋布星陈
棋布错峙
棋输先着
棋输先著
棋逢对手
棋逢敌手
棋高一着
棒打鸳鸯
棘地荆天
森严壁垒
森罗万象
植党自私
植党营私
植发冲冠
植发穿冠
植善倾恶
椎埋屠狗
椎埋狗窃
椎埋穿掘
椎天抢地
椎心呕血
椎心泣血
椎心顿足
椎心饮泣
椎牛发冢
椎牛歃血
椎牛飨士
椎肤剥体
椎肤剥髓
椎胸跌足
椎胸顿足
椎膺顿足
椎轮大辂
椎锋陷阵
椎锋陷陈
椎髻布衣
椒焚桂折
椿庭萱室
椿萱并茂
楚云湘雨
楚囊之情
楚囚对泣
楚囚相对
楚天云雨
楚尾吴头
楚弓复得
楚弓楚得
楚弓遗影
楚得楚弓
楚才晋用
楚材晋用
楚梦云雨
楚棺秦楼
楚楚不凡
楚楚作态
楚楚动人
楚楚可人
楚楚可怜
楚楚可爱
楚楚有致
楚楚谡谡
楚歌之计
楚歌四合
楚歌四起
楚歌四面
楚水吴山
楚璧隋珍
楚界汉河
楚管蛮弦
楚腰卫鬓
楚腰纤细
楚腰蛴领
楚舞吴歌
楚越之急
楚雨巫云
楚馆秦楼
楛耘伤岁
楞头呆脑
楞头楞脑
楞头磕脑
楞手楞脚
楞眉横眼
楼台亭阁
楼船箫鼓
楼阁亭台
楼阁台榭
概日凌云
概莫能外
榆木圪垯
榆木疙瘩
榆木脑壳
榆木脑袋
榆枋之见
榆次之辱
榆瞑豆重
榜上无名
榱崩栋折
榱栋崩折
榷酒征茶
槁形灰心
槁木死灰
槁苏暍醒
槁项没齿
槁项黄馘
槁项黧馘
槃木朽株
槃根错节
槊血满袖
槌仁提义
槌牛酾酒
槌胸蹋地
槐南一梦
槛花笼鹤
樗栎庸材
模山范水
模棱两可
模棱两端
横七竖八
横三竖四
横三顺四
横从穿贯
横倒竖卧
横僿不文
横冲直撞
横冲直闯
横刀揭斧
横刀跃马
横发逆起
横失
横峰侧岭
横征暴敛
横征暴赋
横征苛役
横征苛敛
横恩滥赏
横戈盘马
横戈跃马
横扫千军
横抢武夺
横抢硬夺
横拖倒扯
横拖倒拽
横拖竖拉
横拦竖挡
横挑鼻子竖挑眼
横无忌惮
横枪跃马
横槊赋诗
横殃飞祸
横灾飞祸
横生枝节
横眉冷目
横眉冷眼
横眉努目
横眉吐气
横眉怒目
横眉怒视
横眉瞪目
横眉瞪眼
横眉立目
横眉立眼
横眉竖目
横眉竖眼
横祸非灾
横祸飞灾
横科暴敛
横翔捷出
横草之功
横蛮无理
横行不法
横行天下
横行无忌
横行直撞
横行直走
横行逆施
横行霸道
横见侧出
横说竖说
横赋暴敛
横躺竖卧
横遮竖挡
横金拖玉
横针竖线
横驱别骛
樵村渔浦
樵苏不爨
樵苏失爨
樽俎折冲
樽前月下
樽酒论文
橐甲束兵
橐驼之技
橘化为枳
橙黄桔绿
橙黄橘绿
橛守成规
橡皮钉子
橡饭菁羹
檀郎谢女
櫜弓卧鼓
櫜弓戢戈
櫜弓戢矢
櫜甲束兵
欢呼雀跃
欢呼鼓舞
欢喜冤家
欢喜若狂
欢声雷动
欢天喜地
欢忭鼓舞
欢忻鼓舞
欢欣若狂
欢欣鼓舞
欢聚一堂
欢若平生
欢蹦乱跳
欢迸乱跳
欣喜若狂
欣欣向荣
欣欣自得
欣然自得
欧风美雨
欬唾成珠
欲取姑予
欲壑难填
欲得而甘心
欲扬先抑
欲擒故纵
欲益反弊
欲益反损
欲盖弥彰
欲盖而彰
欲罢不能
欲言又止
欲谁归罪
欲速不达
欲速则不达
欲速反迟
欹嵚历落
欺三瞒四
欺上瞒下
欺上罔下
欺世盗名
欺人之谈
欺人太甚
欺人自欺
欺公罔法
欺君罔上
欺君误国
欺善怕恶
欺大压小
欺天罔人
欺天罔地
欺天诳地
欺硬怕软
欺贫爱富
欺软怕硬
欺霜傲雪
款学寡闻
款曲周至
款款深深
款款而谈
款语温言
歃血为盟
歌功颂德
歌台舞榭
歌声绕梁
歌楼舞榭
歌舞升平
歌莺舞燕
歙漆阿胶
歠菽饮水
止于至善
止戈为武
止戈兴仁
止戈散马
止暴禁非
止沸益薪
止渴思梅
止渴望梅
止谈风月
正中下怀
正中己怀
正人君子
正儿巴经
正冠李下
正冠纳履
正名定分
正声雅音
正大光明
正大堂煌
正大堂皇
正始之音
正容亢色
正己守道
正心诚意
正明公道
正本清源
正本澄源
正正之旗
正正堂堂
正正气气
正正经经
正气凛然
正法直度
正法眼藏
正理平治
正直无私
正直无邪
正经八本
正经八板
正经八百
正色危言
正色厉声
正色敢言
正色直绳
正色直言
正襟危坐
正视绳行
正言不讳
正言厉色
正言厉颜
正言直谏
正身明法
正身清心
正身率下
正颜厉色
此一时彼一时
此中三昧
此事体大
此伏彼起
此动彼应
此发彼应
此呼彼应
此唱彼和
此地无银三百两
此恨绵绵
此界彼疆
此疆尔界
此起彼伏
此起彼落
此问彼难
此风不可长
步人后尘
步履维艰
步履蹒跚
步斗踏罡
步月登云
步步为营
步步生莲华
步步生莲花
步步登高
步步莲花
步步高升
步线行针
步罡踏斗
步调一致
步雪履穿
武不善作
武偃文修
武断专横
武断乡曲
武昌剩竹
武爵武任
武艺超群
歧路亡羊
歧路徘徊
歪七竖八
歪不横楞
歪八竖八
歪心邪意
歪打正着
歪门邪道
歪风邪气
死不悔改
死不改悔
死不旋踵
死不瞑目
死不足惜
死且不朽
死中求活
死中求生
死乞白赖
死乞百赖
死于非命
死亡无日
死亡枕藉
死别生离
死去活来
死告活央
死声咷气
死声活气
死声淘气
死得其所
死心塌地
死心搭地
死心落地
死心踏地
死无对证
死无葬身之地
死有余僇
死有余罪
死有余诛
死有余责
死有余辜
死标白缠
死样活气
死模活样
死欲速朽
死气沉沉
死求白赖
死求百赖
死灰复然
死灰复燃
死灰槁木
死生存亡
死生荣辱
死皮赖脸
死眉瞪眼
死而不朽
死而后已
死而复生
死而无怨
死而无悔
死而死矣
死诸葛吓走生仲达
死诸葛能走生仲达
死败涂地
死里求生
死里逃生
死重泰山
死马当活马医
死骨更肉
歼一警百
殃及池鱼
殆无孑遗
殆无虚日
殊勋异绩
殊形妙状
殊形诡状
殊方同致
殊方异域
殊方绝域
殊涂同会
殊涂同归
殊涂同致
殊深轸念
殊致同归
殊言别语
殊路同归
殊途同归
残兵败将
残军败将
残冬腊月
残圭断璧
残山剩水
残年余力
残年暮景
残暴不仁
残杯冷炙
残民以逞
残民害物
残民害理
残汤剩饭
残渣余孽
残章断简
残篇断简
残编断简
残编裂简
残缺不全
残羹冷炙
残羹冷饭
残膏剩馥
残花败柳
残茶剩饭
殒身不恤
殒身碎首
殚思极虑
殚智竭力
殚精极虑
殚精毕力
殚精竭力
殚精竭虑
殚见洽闻
殚诚毕虑
殚谋戮力
殚财竭力
殢云尤雨
殢雨尤云
殷天蔽日
殷民阜财
殷浩书空
殷鉴不远
殿堂楼阁
毁不危身
毁不灭性
毁于一旦
毁冠裂裳
毁宗夷族
毁家纾国
毁家纾难
毁形灭性
毁方投圆
毁方瓦合
毁瓦画墁
毁舟为杕
毁誉不一
毁誉参半
毁车杀马
毁钟为铎
毁风败俗
毂交蹄劘
毂击肩摩
毅然决然
毋望之祸
毋望之福
毋翼而飞
母以子贵
母慈子孝
母难之日
每下愈况
每况愈下
每饭不忘
毒手尊前
毒手尊拳
毒泷恶雾
毒蛇猛兽
毒赋剩敛
毒魔狠怪
毓子孕孙
比众不同
比屋可封
比屋而封
比屋连甍
比岁不登
比年不登
比户可封
比手划脚
比权量力
比比皆是
比比皆然
比物丑类
比物假事
比物属事
比物此志
比物连类
比目连枝
比类从事
比翼双飞
比翼连枝
比翼齐飞
比肩叠踵
比肩叠迹
比肩并起
比肩接踵
比肩接迹
比肩皆是
比肩系踵
比肩继踵
比肩而立
比肩连袂
比肩迭踵
比肩迭迹
比肩随踵
比肩齐声
比量齐观
毕其功于一役
毕力同心
毕恭毕敬
毕雨箕风
毙而后已
毛举细务
毛举细故
毛举缕析
毛发不爽
毛发丝粟
毛发之功
毛发倒竖
毛发悚然
毛发耸然
毛手毛脚
毛森骨立
毛羽未丰
毛羽零落
毛遂堕井
毛遂自荐
毛骨悚然
毛骨竦然
毛骨耸然
毡上拖毛
毡袜裹脚靴
毫不介意
毫不讳言
毫分缕析
毫厘不爽
毫厘丝忽
毫厘千里
毫发不爽
毫发丝粟
毫无二致
毫无疑义
毫无逊色
毫毛不犯
民不堪命
民不畏死
民不聊生
民以食为天
民保于信
民和年丰
民和年稔
民困国贫
民安国泰
民安物阜
民富国强
民康物阜
民心不壹
民怨沸腾
民有菜色
民殷国富
民殷财阜
民淳俗厚
民熙物阜
民生凋敝
民生国计
民生在勤
民生涂炭
民穷财匮
民穷财尽
民胞物与
民脂民膏
民膏民脂
民贵君轻
民贼独夫
气义相投
气充志骄
气克斗牛
气冲斗牛
气冲牛斗
气冲霄汉
气决泉达
气势汹汹
气势磅礴
气吞宇宙
气吞山河
气吞湖海
气吞牛斗
气吞虹蜺
气味相投
气喘吁吁
气喘如牛
气壮如牛
气壮山河
气壮河山
气壮理直
气壮胆粗
气宇轩昂
气得志满
气忍声吞
气急败丧
气急败坏
气息奄奄
气愤填膺
气断声吞
气消胆夺
气涌如山
气满志得
气满志骄
气焰嚣张
气焰熏天
气竭声嘶
气竭声澌
气血方刚
气谊相投
气象万千
气贯长虹
气踰霄汉
气逾霄汉
气骄志满
水中捉月
水中捞月
水中着盐
水中著盐
水乳交融
水佩风裳
水光山色
水净鹅飞
水到渠成
水到鱼行
水剩山残
水土不服
水天一色
水宿山行
水宿风餐
水尽山穷
水尽鹅飞
水底捞月
水底捞针
水底摸月
水底纳瓜
水性杨花
水明山秀
水晶灯笼
水月观音
水月镜花
水木清华
水来土掩
水枯石烂
水楔不通
水母目虾
水泄不漏
水泄不透
水泄不通
水洁冰清
水洩不通
水流云散
水流花落
水流花谢
水浄鹅飞
水涨船高
水深火热
水清无鱼
水满金山
水滴石穿
水漫金山
水火不兼容
水火不相容
水火不辞
水火不避
水火之中
水火兵虫
水火无交
水火无情
水石清华
水碧山青
水磨工夫
水秀山明
水穷山尽
水米无交
水米无干
水至清则无鱼
水色山光
水菜不交
水落归槽
水落归漕
水落石出
水调歌头
水软山温
水过鸭背
水远山遥
水远山长
水里纳瓜
水长船高
水阔山高
水陆杂陈
水陆毕陈
永不磨灭
永世无穷
永劫沉沦
永劫沉轮
永垂不朽
永垂竹帛
永垂青史
永志不忘
永无宁日
永无止境
永永无穷
永生永世
永矢弗谖
求之不得
求亲告友
求亲靠友
求人不如求己
求仁得仁
求全之毁
求全责备
求同存异
求名夺利
求志达道
求忠出孝
求浆得酒
求生害仁
求田问舍
求益反损
求知若渴
求神问卜
求福禳灾
求贤下士
求贤如渴
求贤若渴
求过于供
求道于盲
求马于唐市
求马于唐肆
求马唐肆
汉人煮箦
汉官威仪
汉贼不两立
汗不敢出
汗出沾背
汗出洽背
汗出浃背
汗如雨下
汗洽股栗
汗流夹背
汗流接踵
汗流洽背
汗流洽衣
汗流浃体
汗流浃肤
汗流浃背
汗流浃踵
汗流满面
汗流至踵
汗牛充屋
汗牛充栋
汗牛塞栋
汗血盐车
汗青头白
汗颜无地
汗马之功
汗马之劳
汗马功劳
汝南晨鸡
汝成人耶
江东父老
江云渭树
江南海北
江天一色
江山如故
江山如画
江左夷吾
江心补漏
江水不犯河水
江汉朝宗
江河日下
江河行地
江洋大盗
江流日下
江海不逆小流
江淹才尽
江淹梦笔
江湖骗子
江翻海倒
江翻海扰
江翻海搅
江翻海沸
江郎才尽
江郎才掩
池酒林胾
池鱼之殃
池鱼之祸
池鱼之虑
池鱼堂燕
池鱼幕燕
池鱼林木
池鱼笼鸟
污七八糟
污手垢面
污泥浊水
汤去三面
汤池铁城
汤烧火热
汪洋大海
汪洋大肆
汪洋恣肆
汪洋浩博
汪洋自恣
汪洋自肆
汪洋闳肆
汰劣留良
汲古阁本
汲引忘疲
汲汲忙忙
汲汲皇皇
汲汲顾影
汲深绠短
汶阳田反
汹涌彭湃
汹涌淜湃
汹涌澎湃
沁人心肺
沁人心脾
沁人心腑
沁人肺腑
沁入心脾
沂水弦歌
沂水春风
沂水舞雩
沃野千里
沅江九肋
沅芷湘兰
沅芷澧兰
沅茝醴兰
沅茞澧兰
沆瀣一气
沈博絶丽
沈博绝丽
沈吟不决
沈吟未决
沈声静气
沈密寡言
沈心静气
沈思熟虑
沈思默想
沈李浮瓜
沈灶产鼃
沈灶生鼃
沈烽静柝
沈着痛快
沈腰潘鬓
沈舟破釜
沈诗任笔
沈谋研虑
沈谋重虑
沈郁顿挫
沈静寡言
沈鱼落雁
沉冤莫白
沉冤莫雪
沉博绝丽
沉厚寡言
沉吟不决
沉吟不语
沉吟未决
沉吟章句
沉声静气
沉密寡言
沉心静气
沉思熟虑
沉思默想
沉李浮瓜
沉毅寡言
沉浮俯仰
沉湎淫逸
沉湎酒色
沉滓泛起
沉潜刚克
沉灶产蛙
沉灶生蛙
沉烽静柝
沉疴宿疾
沉疴难起
沉痼自若
沉着痛快
沉舟破釜
沉著痛快
沉谋研虑
沉谋重虑
沉迷不悟
沉郁顿挫
沉重寡言
沉重少言
沉静寡言
沉鱼落雁
沉默寡言
沐仁浴义
沐日浴月
沐猴而冠
沐猴衣冠
沐雨栉风
沐雨梳风
沐雨经霜
沐露梳风
沐露沾霜
沓冈复岭
沓来踵至
沓来麕至
沙里淘金
沙鸥翔集
沛雨甘霖
沟满壕平
沟满濠平
没世不忘
没世不渝
没世无称
没世无闻
没世穷年
没世难忘
没卫饮羽
没可奈何
没头没脑
没头没脸
没头苍蝇
没完没了
没屋架梁
没日没夜
没查没利
没毛大虫
没没无闻
没法奈何
没法没天
没眉没眼
没石饮羽
没精塌彩
没精打彩
没精打采
没精没彩
没而不朽
没衷一是
没计奈何
没轻没重
没里没外
没金铩羽
没金饮羽
没颠没倒
没齿不忘
没齿无怨
没齿难忘
沤沫槿艳
沤浮泡影
沤珠槿艳
沥胆堕肝
沥胆披肝
沥胆抽肠
沥胆濯肝
沥胆隳肝
沥血叩心
沥血披心
沥血披肝
沦浃肌髓
沦肌浃髓
沦落风尘
沧浪老人
沧海一粟
沧海一鳞
沧海桑田
沧海横流
沧海遗珠
河不出图
河东三箧
河东狮吼
河东狮子
河东狮子吼
河伯为患
河倾月落
河决鱼烂
河出伏流
河同水密
河奔海聚
河山之德
河山带砺
河斜月落
河梁之谊
河梁携手
河水不洗船
河水不犯井水
河汉无极
河汉江淮
河汾门下
河沙世界
河海不择细流
河海清宴
河涸海干
河清三日
河清云庆
河清人寿
河清海宴
河清海晏
河清海竭
河清社鸣
河清难俟
河溓海夷
河溓海晏
河目海口
河落海干
河门海口
河鱼之疾
河鱼天雁
河鱼腹疾
沸反盈天
沸反连天
沸天震地
沸沸扬扬
沸沸汤汤
油光可鉴
油光晶亮
油光水滑
油嘴油舌
油嘴滑舌
油嘴花唇
油壁香车
油头光棍
油头滑脑
油头滑脸
油头滑面
油头粉面
油干火尽
油干灯尽
油干灯草尽
油浇火燎
油渍麻花
油然而生
油煎火燎
油盐酱醋
油腔滑调
治丝益棼
治丝而棼
治国安民
治国安邦
治病救人
治郭安邦
沽名卖直
沽名吊誉
沽名干誉
沽名要誉
沽名钓誉
沽誉买直
沽誉钓名
沾亲带友
沾亲带故
沾沾自喜
沾沾自好
沾沾自满
沾沾自衒
沾泥带水
沾花惹草
沾风惹草
沿才受职
沿波讨源
沿流讨源
沿门托钵
沿门持钵
沿门讬钵
泄漏天机
泄露天机
泉石膏肓
泓峥萧瑟
法不传六耳
法不徇情
法不阿贵
法出一门
法出多门
法力无边
法外施仁
法家拂士
法无二门
法无可贷
法海无边
法灸神针
法脉准绳
法轮常转
泛宅浮家
泛应曲当
泛泛之交
泛泛之人
泛泛之谈
泛泛而谈
泛浩摩苍
泛滥成灾
泛萍浮梗
泝水行舟
泝流穷源
泝流追源
泝端竟委
波光粼粼
波光鳞鳞
波委云集
波属云委
波波碌碌
波流茅靡
波涛汹涌
波澜壮阔
波澜老成
波罗塞戏
波罗奢花
波谲云诡
波路壮阔
波骇云属
泣下如雨
泣下沾襟
泣不可仰
泣不成声
泣数行下
泣涕如雨
泣血捶膺
泣血枕戈
泣血稽颡
泣麟悲凤
泥中隐刺
泥古不化
泥古拘方
泥古非今
泥名失实
泥塑木雕
泥多佛大
泥沙俱下
泥牛入海
泥猪瓦狗
泥猪疥狗
泥猪癞狗
泥而不滓
泥船渡河
泥菩萨过江
泥蟠不滓
泥足巨人
泥车瓦狗
泥车瓦马
泥金万点
注玄尚白
泪下如雨
泪如泉涌
泪如泉滴
泪如雨下
泪干肠断
泪流满面
泪眼汪汪
泪迸肠絶
泪迸肠绝
泮林革音
泰山不让土壤
泰山其颓
泰山北斗
泰山压卵
泰山压顶
泰山梁木
泰山盘石
泰山磐石
泰山鸿毛
泰来否往
泰来否极
泰极而否
泰然处之
泰然自若
泱泱大风
泼冷水
泼天大祸
泼妇骂街
泼水难收
泼油救火
泽及枯骨
泽吻磨牙
泽被后世
泾浊渭清
泾清渭浊
泾渭不分
泾渭分明
泾渭自分
泾渭自明
洁己从公
洁己奉公
洁浊扬清
洁清自矢
洁身累行
洁身自好
洁身自守
洁身自爱
洋为中用
洋洋大观
洋洋得意
洋洋洒洒
洋洋盈耳
洋洋纚纚
洋洋自得
洒心更始
洒扫应对
洒洒潇潇
洗兵牧马
洗垢匿瑕
洗垢求瑕
洗垢求瘢
洗垢索瘢
洗心回面
洗心换骨
洗心涤虑
洗心革面
洗手不干
洗手奉公
洗手奉职
洗濯磨淬
洗眉刷目
洗耳恭听
洗耳拱听
洗肠涤胃
洗脚上船
洗雪逋负
洗颈就戮
洗髓伐毛
洛阳才子
洛阳纸贵
洞中肯綮
洞天福地
洞如观火
洞察一切
洞察其奸
洞察秋毫
洞幽察微
洞幽烛微
洞幽烛远
洞彻事理
洞心骇目
洞心骇耳
洞房花烛
洞洞灟灟
洞烛其奸
洞若观火
洞见症结
洞鉴古今
洞鉴废兴
洞隐烛微
津关险塞
津津乐道
津津有味
洪乔捎书
洪水横流
洪水猛兽
洪炉点雪
洪炉燎发
洪福齐天
活剥生吞
活天冤枉
活形活现
活灵活现
活眼活现
活眼现报
活神活现
活蹦乱跳
活蹦活跳
活龙活现
活龙鲜健
洽博多闻
洽博德闻
洽闻强记
流光易逝
流光瞬息
流口常谈
流天澈地
流年不利
流年似水
流星掣电
流星赶月
流星飞电
流水无情
流水朝宗
流水桃花
流水游龙
流水落花
流水行云
流水高山
流汗浃背
流溺忘反
流离失所
流离播越
流离播迁
流离琐尾
流离转徙
流离颠沛
流离颠疐
流离颠顿
流移失所
流脍人口
流芳千古
流芳后世
流芳百世
流落他乡
流落天涯
流落失所
流落江湖
流落风尘
流血千里
流血漂卤
流行坎止
流言惑众
流言止于智者
流言混话
流言蜚语
流言风语
流言飞文
流言飞语
流连忘反
流连忘返
流金铄石
流风余俗
流风余韵
流风回雪
流风遗迹
浃沦肌髓
浃背汗流
浃髓沦肌
浃髓沦肤
浅尝辄止
浅斟低唱
浅见寡闻
浆水不交
浆酒藿肉
浆酒霍肉
浇淳散朴
浇瓜之惠
浇醇散朴
浇风薄俗
浊泾清渭
浊质凡姿
浊骨凡胎
济世之才
济世匡时
济世安人
济世安民
济世安邦
济世救人
济人利物
济困扶危
济寒赈贫
济弱扶倾
济弱锄强
济河焚舟
济济一堂
济窍飘风
济苦怜贫
济贫拔苦
浑俗和光
浑抡吞枣
浑水摸鱼
浑沦吞枣
浑浑噩噩
浑浑沉沉
浑浑沌沌
浑然一体
浑然天成
浑然无知
浑然自成
浑身是胆
浑身解数
浑金璞玉
浑金白玉
浓墨重彩
浓妆淡抹
浓妆艳抹
浓妆艳服
浓妆艳裹
浓妆艳饰
浓抹淡妆
浓桃艳李
浓眉大眼
浓荫蔽日
浓装艳抹
浞訾栗斯
浣衣菲食
浩如烟海
浩气凛然
浩气长存
浩浩汤汤
浩浩荡荡
浩然之气
浪子回头
浪子回头金不换
浪子宰相
浪蕊浮花
浪蘂浮花
浪蝶游蜂
浪蝶狂蜂
浪迹天下
浪迹天涯
浪迹江湖
浪迹浮踪
浪迹萍踪
浪酒闲茶
浮一大白
浮云富贵
浮云朝露
浮云蔽日
浮光掠影
浮光略影
浮光跃金
浮名薄利
浮名虚利
浮名虚誉
浮声切响
浮头滑脑
浮家泛宅
浮想联翩
浮收勒折
浮收勒索
浮文巧语
浮来暂去
浮湛连蹇
浮瓜沈李
浮瓜沉李
浮生切响
浮生若梦
浮白载笔
浮皮潦草
浮石沈木
浮石沉木
浮称流说
浮笔浪墨
浮翠流丹
浮而不实
浮花浪蕊
浮花浪蘂
浮语虚辞
浮踪浪迹
浮迹浪踪
浴血奋战
海不扬波
海不波溢
海中捞月
海内无双
海内鼎沸
海北天南
海啸山崩
海外奇谈
海屋添筹
海屋筹添
海市蜃楼
海底捞月
海底捞针
海怀霞想
海晏河清
海枯石烂
海枯见底
海桑陵谷
海水不可斗量
海水桑田
海水群飞
海水难量
海沸山崩
海沸山摇
海沸山裂
海沸江翻
海沸河翻
海沸波翻
海涯天角
海涵地负
海涸石烂
海盟山呪
海盟山咒
海立云垂
海约山盟
海纳百川
海角天涯
海角天隅
海誓山盟
海阔天空
海阔天高
浸润之谮
涂歌巷舞
涂歌邑诵
涂歌里咏
涂歌里抃
涂炭生灵
涂脂抹粉
涅而不淄
涅而不缁
消声匿影
消声匿迹
消声灭迹
消息灵通
消息盈冲
消息盈虚
消愁解闷
消愁释愦
消极怠工
消遥自在
涉海登山
涉笔成趣
涎玉沫珠
涎皮涎脸
涎皮赖脸
涎眉邓眼
涎脸涎皮
涎脸饧眼
涎言涎语
涓埃之力
涓滴不漏
涓滴不遗
涓滴之劳
涓滴归公
涓滴微利
涓滴成河
涕泗交下
涕泗交流
涕泗交颐
涕泗横流
涕泗流涟
涕泗滂沱
涕泗滂沲
涕泗纵横
涕泪交下
涕泪交加
涕泪交垂
涕泪交流
涕泪交集
涕泪交零
涕零如雨
涣发大号
涣如冰释
涣尔冰开
涣汗大号
涣然冰释
涣若冰消
涣若冰释
涤地无类
涤故更新
涤瑕荡垢
涤瑕荡秽
涤瑕蹈隙
涤秽布新
涤秽荡瑕
润屋润身
涩于言论
涸思干虑
涸泽而渔
涸辙之鲋
涸辙枯鱼
涸鱼得水
涸鲋得水
淆乱视听
淋漓尽致
淑人君子
淑质英才
淘沙取金
淘沙得金
淡写轻描
淡妆浓抹
淡妆轻抹
淡扫蛾眉
淡水交情
淡汝浓抹
淡泊明志
淡然处之
淡然置之
淡而不厌
淡而无味
淡饭黄虀
淡饭黄齑
淫心匿行
淫朋密友
淫朋狎友
淫言媟语
淫言狎语
淫言诐行
淫词亵语
淫词秽语
淫词艳曲
淫辞秽语
淫辞邪说
淮南鸡犬
淮橘为枳
淮王鸡狗
深不可测
深中笃行
深中肯綮
深中隐厚
深仁厚泽
深仇大恨
深仇宿怨
深仇重怨
深信不疑
深入人心
深入显出
深入浅出
深入膏肓
深入骨髓
深切着明
深切着白
深切著明
深切著白
深刺腧髓
深厉浅揭
深图远筭
深图远算
深壁固垒
深奥莫测
深奸巨猾
深宅大院
深居简出
深山密林
深山幽谷
深山穷林
深山穷谷
深山老林
深山野墺
深山长谷
深得人心
深思熟虑
深思苦索
深思远虑
深恶痛嫉
深恶痛疾
深恶痛絶
深恶痛绝
深情厚意
深情厚谊
深情底理
深情故剑
深惟重虑
深扃固钥
深文傅会
深文周内
深文周纳
深文大义
深文峻法
深文巧诋
深文曲折
深文附会
深明大义
深更半夜
深根固本
深根固柢
深根固蒂
深根固蔕
深根宁极
深根蟠结
深沟固垒
深沟壁垒
深沟高垒
深猷远计
深知灼见
深耕易耨
深藏若虚
深见远虑
深计远虑
深谋远略
深谋远虑
深谷为陵
深铭肺腑
深闭固拒
深闭固距
深雠大恨
混世魔王
混为一谈
混作一谈
混俗和光
混应滥应
混水捞鱼
混水摸鱼
混沌不分
混淆是非
混淆视听
混淆黑白
混混噩噩
混混庉庉
混混沄沄
混混沌沌
混然一体
混然天成
淹会贯通
淹旬旷月
淹淹一息
添兵减灶
添枝加叶
添枝增叶
添枝接叶
添油加醋
添油炽薪
添盐着醋
添砖加瓦
添醋加油
清一色
清净寂灭
清净无为
清君侧
清夜扪心
清天白日
清官能断家务事
清官难断家务事
清宫除道
清尘浊水
清平世界
清廉正直
清微淡远
清心寡欲
清心少欲
清新俊逸
清歌妙舞
清歌曼舞
清水无大鱼
清水衙门
清汤寡水
清洌可鉴
清浄寂灭
清浄无为
清浊同流
清浑皁白
清浑皂白
清渭浊泾
清源正本
清灰冷火
清灰冷灶
清耳悦心
清莹秀澈
清虚洞府
清规戒律
清词丽句
清贫如洗
清身洁己
清辞丽句
清辞丽曲
清都紫府
清都紫微
清都绛阙
清锅冷灶
清闲自在
清静无为
清音幽韵
清风两袖
清风亮节
清风劲节
清风峻节
清风明月
清风朗月
清风高节
渊亭山立
渊停山立
渊图远算
渊涌风厉
渊涓蠖濩
渊清玉絜
渊渟岳峙
渊渟岳立
渊渟泽汇
渊源有自
渊源有自来
渊蜎蠖伏
渊谋远略
渊鱼丛爵
渊鱼丛雀
渐不可长
渐入佳境
渐至佳境
渑池之功
渔人之利
渔人得利
渔夺侵牟
渔海樵山
渔翁之利
渔翁得利
渔阳鞞鼓
渔阳鼙鼓
渤澥桑田
温凊定省
温席扇枕
温情密意
温情脉脉
温情蜜意
温故知新
温文儒雅
温文尔雅
温枕扇席
温柔敦厚
温润而泽
温生絶裾
温生绝裾
温良恭俭让
温衾扇枕
温香艳玉
渭川千亩
渭浊泾清
渭阳之情
渴尘万斛
渴者易饮
渴而掘井
渴而穿井
渴骥奔泉
游云惊龙
游光扬声
游刃余地
游刃有余
游响停云
游回磨转
游山玩景
游山玩水
游山翫水
游心寓目
游心骇耳
游必有方
游思妄想
游戏三昧
游戏人世
游戏人间
游戏尘寰
游戏笔墨
游戏翰墨
游手偷闲
游手好闲
游目骋怀
游目骋观
游移不定
游荡不羁
游荡不羇
游荡不覊
游蜂戏蝶
游蜂浪蝶
游谈无根
游辞巧饰
游闲公子
游骑无归
渺不足道
渺无人烟
渺无人踪
渺无人迹
渺无影踪
渺无踪影
渺无音信
渺无音讯
渺渺茫茫
湖光山色
湛恩汪濊
湛湛青天
湮没无闻
湿肉伴干柴
溃不成军
溃兵游勇
源头活水
源泉万斛
源清流洁
源清流清
源源不断
源源不绝
源源本本
源源而来
源远流长
溘先朝露
溘然长往
溘然长逝
溜之乎也
溜之大吉
溜须拍马
溢于言外
溢于言表
溢美之言
溢美之语
溢美之辞
溢美溢恶
溢言虚美
溥天同庆
溥天率土
溯水行舟
溯流徂源
溯流求源
溯流穷源
溯流追源
溯源穷流
溯端竟委
溺心灭质
滂沱大雨
滋蔓难图
滑天下之大稽
滑头滑脑
滑泥扬波
滔天之罪
滔天大罪
滔天罪行
滔滔不尽
滔滔不断
滔滔不竭
滔滔不絶
滔滔不绝
滔滔汩汩
滔滔滚滚
滚瓜流水
滚瓜烂熟
满不在乎
满不在意
满园春色
满坐风生
满坑满谷
满城风雨
满天星斗
满天飞
满山遍野
满座风生
满打满算
满盘皆输
满目凄凉
满目疮痍
满目荆榛
满纸空言
满而不溢
满脸春色
满脸春风
满腔热忱
满腔热枕
满腹文章
满腹牢骚
满腹狐疑
满腹珠玑
满腹疑团
满腹经纶
满舌生花
满袖春风
满谷满坑
满载而归
满面春风
满面红光
滥官污吏
滥用职权
滥竽充数
滴水不漏
滴水不羼
滴水成冰
滴水成河
滴水穿石
滴水难消
滴粉搓酥
滴露研朱
滴露研珠
漂母进饭
漂泊无定
漂蓬断梗
漂零蓬断
漆身吞炭
漆黑一团
漏卮难满
漏尽更阑
漏尽钟鸣
漏尽锺鸣
漏泄天机
漏泄春光
漏洞百出
漏洩春光
漏瓮沃焦釜
漏网之鱼
漏脯充饥
演武修文
漠不关心
漠不相关
漠然置之
漫不加意
漫不经心
漫不经意
漫地漫天
漫天匝地
漫天叫价
漫天大谎
漫天开价
漫天掩地
漫天盖地
漫天蔽野
漫天要价
漫天过海
漫天遍地
漫天遍野
漫山塞野
漫山遍野
漫无止境
漫无边际
漫条斯理
漫藏诲盗
漱流枕石
漱石枕流
潇洒风流
潘文乐旨
潘江陆海
潜休隐德
潜光匿曜
潜光隐德
潜光隐耀
潜形匿影
潜形匿迹
潜形谲迹
潜德秘行
潜德隐行
潜心涤虑
潜心笃志
潜消默化
潜濡默化
潜濡默被
潜神嘿规
潜神默记
潜移嘿夺
潜移暗化
潜移默化
潜移默夺
潜移默转
潜移默运
潜窃阳剽
潜精研思
潜精积思
潜蛟困凤
潜踪匿影
潜踪蹑迹
潜踪隐迹
潜鳞戢羽
潜龙伏虎
潢池弄兵
潢池盗弄
潦原浸天
潮鸣电挚
潮鸣电掣
潸然泪下
澄思渺虑
澄江如练
澄沙汰砾
澄清天下
澄神离形
澈底澄清
澜倒波随
澡垢索疵
澡身浴德
澧兰沅芷
澹泊寡欲
激忿填膺
激扬清浊
激昂慷慨
激昂青云
激浊扬清
激薄停浇
激贪厉俗
濠梁之上
濯污扬清
濯足濯缨
灌夫骂坐
灌夫骂座
火上加油
火上弄冰
火上浇油
火上添油
火中取栗
火伞高张
火光烛天
火冒三丈
火冒三尺
火妻灰子
火尽灰冷
火尽薪传
火山汤海
火急火燎
火树琪花
火树银花
火海刀山
火灭烟消
火烛小心
火烛银花
火烧火燎
火烧眉毛
火热水深
火然泉达
火眼金睛
火耕水种
火耕水耨
火耕流种
火耨刀耕
火龙黼黻
灭景追风
灭此朝食
灭绝人性
灭虢取虞
灭门绝户
灭顶之灾
灯尽油干
灯火万家
灯火辉煌
灯烛辉煌
灯红酒緑
灯红酒绿
灯蛾扑火
灰头土脸
灰头土面
灰容土貌
灰心丧意
灰心丧气
灰心槁形
灰心短气
灰烟瘴气
灰身泯智
灰身灭智
灰身粉骨
灰躯糜骨
灰飞烟灭
灵丹圣药
灵丹妙药
灵心慧性
灵心慧齿
灵机一动
灵牙利齿
灵蛇之珠
灸艾分痛
灼艾分痛
灼见真知
灾梨祸枣
灾难深重
灿烂辉煌
灿然一新
灿若繁星
炉火纯青
炊沙作糜
炊沙作饭
炊沙成饭
炊沙镂冰
炊琼爇桂
炊砂作饭
炊粱跨卫
炊臼之戚
炊臼之痛
炊金馔玉
炊鲜漉清
炎凉世态
炎黄子孙
炒买炒卖
炙冰使燥
炙手可热
炙肤皲足
炙鸡渍酒
炫奇争胜
炫巧斗妍
炫异争奇
炫昼缟夜
炫玉贾石
炫石为玉
炮凤烹龙
炮火连天
炮龙烹凤
炯炯有神
炰鳖脍鲤
炳如日星
炳如观火
炳炳烺烺
炳烛夜游
炳若日星
炳若观火
点头之交
点头会意
点头咂嘴
点头哈腰
点手划脚
点手莋脚
点指划脚
点指画字
点指莋脚
点水不漏
点睛之笔
点石为金
点石成金
点纸画字
点胸洗眼
点金乏术
点金作铁
点金成铁
点金无术
点铁成金
炼石补天
烁玉流金
烁石流金
烂如指掌
烂漫天真
烂熳天真
烂若披掌
烂若披锦
烂若舒锦
烂醉如泥
烂额焦头
烈士徇名
烈火干柴
烈火烹油
烈火真金
烈火见真金
烈火轰雷
烈火辨日
烈烈轰轰
烘云托月
烘云讬月
烘堂大笑
烘托渲染
烛照数计
烜赫一时
烟不出火不进
烟云过眼
烟断火絶
烟断火绝
烟波浩渺
烟波钓徒
烟消云散
烟消火灭
烟消雾散
烟炎张天
烟聚波属
烟花风月
烟蓑雨笠
烟视媚行
烟销灰灭
烟霏雨散
烟霏雾集
烟霞痼疾
烟飞星散
烦文缛礼
烦言碎辞
烧犀观火
烧琴煮鹤
烧眉之急
热可炙手
热心快肠
热心苦口
热情洋溢
热气腾腾
热泪盈眶
热火朝天
热熬翻饼
热肠古道
热血沸腾
热锅上的蚂蚁
热锅上蚂蚁
热锅上蝼蚁
烹犬藏弓
烹狗藏弓
烹龙庖凤
烹龙炮凤
烹龙煮凤
烹龙砲凤
烽火四起
烽火相连
烽火连天
烽火连年
烽鼓不息
焕然一新
焕然如新
焚书坑儒
焚典坑儒
焚尸扬灰
焚巢捣穴
焚巢荡穴
焚林竭泽
焚林而狩
焚林而猎
焚林而田
焚林而畋
焚枯食淡
焚琴煮鹤
焚琴鬻鹤
焚符破玺
焚膏继晷
焚舟破釜
焚薮而田
焚香扫地
焚香礼拜
焚香膜拜
焚香顶礼
焚骨扬灰
焦唇干肺
焦唇干舌
焦唇敝舌
焦头烂额
焦心劳思
焦心热中
焦思苦虑
焦沙烂石
焦熬投石
焦眉愁眼
焦眉皱眼
焦眉苦脸
焦金流石
焦金烁石
焮天铄地
然糠照薪
然糠自照
然荻读书
煎水作冰
煎胶续弦
煎豆摘瓜
煞有介事
煞费心机
煞费苦心
煦煦孑孑
煦色韶光
照人肝胆
照功行赏
照本宣科
照猫画虎
照章办事
照萤映雪
照葫芦画瓢
煨干就湿
煨干避湿
煮粥焚须
煮豆燃箕
煮豆燃萁
煮鹤烧琴
煮鹤焚琴
煽风点火
熊心豹胆
熊据虎跱
熊经鸟伸
熊经鸟引
熊经鸟曳
熊经鸟申
熊经鸱顾
熊罴之士
熊罴入梦
熊罴百万
熊腰虎背
熊韬豹略
熏天赫地
熏莸不同器
熏莸同器
熏莸异器
熏陶成性
熏风解愠
熔于一炉
熔今铸古
熔古铸今
熙来攘往
熙熙壤壤
熙熙攘攘
熙熙融融
熚熚剥剥
熟思审处
熟能生巧
熟视无睹
熟视无覩
熟读深思
熟路轻车
熟路轻辙
熟门熟路
熟魏生张
熬姜呷醋
熬心费力
熬更守夜
熬枯受淡
熬油费火
熬清受淡
熬清守淡
熬清守谈
熬肠刮肚
熯天炽地
燃眉之急
燃糠自照
燃萁之敏
燃萁煎豆
燃萁煮豆
燋头烂额
燋金烁石
燎原烈火
燎发摧枯
燎如观火
燎若观火
燔书坑儒
燔书阬儒
燕侣莺俦
燕俦莺侣
燕处危巢
燕处焚巢
燕妒莺惭
燕子衔食
燕安酖毒
燕安鸩毒
燕尔新婚
燕岱之石
燕巢于幕
燕巢卫幕
燕巢危幕
燕巢幕上
燕巢幙上
燕巢飞幕
燕市悲歌
燕幕自安
燕昭好马
燕昭市骏
燕歌赵舞
燕燕于归
燕燕莺莺
燕瘦环肥
燕石妄珍
燕约莺期
燕翼贻谋
燕舞莺啼
燕舞莺歌
燕语莺啼
燕语莺声
燕跃鹄踊
燕金募秀
燕雀之居
燕雀之见
燕雀处堂
燕雀处屋
燕雀安知鸿鹄之志
燕雀安知鸿鹄志
燕雀岂知雕鹗志
燕雀岂知鵰鹗志
燕雀相贺
燕雁代飞
燕颔书生
燕颔儒生
燕颔虎头
燕颔虎须
燕颔虎颈
燕颔虬须
燕额虎头
燕驾越毂
燕骏千金
燮理阴阳
爆跳如雷
爨桂炊玉
爬山涉水
爬梳剔抉
爬梳洗剔
爬罗剔抉
爬耳搔腮
爱不忍释
爱不释手
爱之欲其生
爱人以德
爱人利物
爱人好士
爱别离苦
爱博而情不专
爱国如家
爱如己出
爱如珍宝
爱富嫌贫
爱屋及乌
爱惜羽毛
爱憎分明
爱手反裘
爱才如命
爱才如渴
爱才若渴
爱日惜力
爱毛反裘
爱民如子
爱生恶死
爱礼存羊
爱素好古
爱莫之助
爱莫能助
爱财如命
爱钱如命
爱鹤失众
父严子孝
父为子隐
父债子还
父慈子孝
父析子荷
父母之邦
父母恩勤
爷羹娘饭
爷饭娘羹
爽心悦目
爽心豁目
爽然自失
爽然若失
片云遮顶
片光零羽
片接寸附
片文只事
片瓦不留
片瓦无存
片甲不回
片甲不存
片甲不留
片甲不还
片甲无存
片纸只字
片言一字
片言只字
片言只语
片言折狱
片词只句
片语只辞
片长末技
片长薄技
片鳞半爪
片鳞只甲
片鳞残甲
片鳞碎甲
版版六十四
版筑饭牛
牖中窥日
牙牙学语
牙白口清
牙签万轴
牙签犀轴
牙签玉轴
牙签锦轴
牛不喝水强按头
牛之一毛
牛农对泣
牛刀割鸡
牛刀小试
牛口之下
牛听弹琴
牛头不对马嘴
牛头不对马面
牛头马面
牛星织女
牛毛细雨
牛溲马勃
牛溲马渤
牛童马走
牛羊勿践
牛衣夜哭
牛衣对泣
牛衣岁月
牛衣病卧
牛角之歌
牛角书生
牛角挂书
牛蹄中鱼
牛蹄之涔
牛蹄之鱼
牛郎织女
牛马襟裾
牛骥共牢
牛骥同槽
牛骥同皁
牛骥同皂
牛高马大
牛鬼蛇神
牛黄狗宝
牛鼎烹鸡
牝咮鸣辰
牝牡骊黄
牝鸡司旦
牝鸡司晨
牝鸡晨鸣
牝鸡牡鸣
牢不可破
牢什古子
牢甲利兵
牢骚满腹
牧猪奴戏
牧豕听经
物以希为贵
物以稀为贵
物以类聚
物以羣分
物以群分
物伤其类
物力维艰
物华天宝
物在人亡
物尽其用
物归原主
物换星移
物是人非
物极则反
物极将返
物极必反
物极必返
物殷俗阜
物离乡贵
物稀为贵
物竞天择
物美价廉
物腐虫生
物至则反
物议沸腾
物阜民丰
物阜民安
物阜民康
牵一发而动全身
牵丝攀藤
牵五挂四
牵合傅会
牵合附会
牵引附会
牵强附会
牵强附合
牵牛下井
牵牛织女
牵物引类
牵经引礼
牵羊担酒
牵肠割肚
牵肠挂肚
牵肠萦心
牵萝莫补
牵萝补屋
牵衣投辖
牵衣肘见
牵鬼上剑
特立独行
犀照牛渚
犀燃烛照
犀牛望月
犀角烛怪
犀顶龟文
犀颅玉颊
犁庭扫穴
犁庭扫闾
犁牛之子
犁牛骍角
犁生骍角
犂庭扫穴
犂牛之子
犂牛骍角
犂生骍角
犊牧采薪
犒赏三军
犬兔俱毙
犬吠之盗
犬吠之警
犬牙交错
犬牙盘石
犬牙相制
犬牙相错
犬牙鹰爪
犬迹狐踪
犬马之养
犬马之决
犬马之力
犬马之劳
犬马之年
犬马之恋
犬马之报
犬马之疾
犬马之诚
犬马恋主
犯上作乱
犯而不校
犯而勿校
犯言直谏
犯颜极谏
犯颜苦谏
犹解倒悬
犹豫不决
狂三诈四
狂吠狴犴
狂奴故态
狂妄自大
狂嫖滥赌
狂朋怪侣
狂朋怪友
狂朋恠友
狂涛巨浪
狂涛骇浪
狂犬吠日
狂瞽之言
狂蜂浪蝶
狂轰滥炸
狂风怒号
狂风恶浪
狂风暴雨
狂风骤雨
狎雉驯童
狐不二雄
狐假虎威
狐假鸱张
狐兔之悲
狐凭鼠伏
狐听之声
狐唱枭和
狐埋狐扬
狐埋狐搰
狐奔鼠窜
狐媚猿攀
狐媚魇道
狐朋狗党
狐朋狗友
狐死兔泣
狐死首丘
狐潜鼠伏
狐狸尾巴
狐疑不决
狐羣狗党
狐群狗党
狐藉虎威
狐虎之威
狐裘尨茸
狐裘羔袖
狐裘蒙戎
狐裘蒙茸
狐鸣枭噪
狐鸣狗盗
狐鸣篝中
狐鸣篝火
狐鸣鱼书
狐鼠之徒
狖轭鼯轩
狗仗人势
狗仗官势
狗偷鼠窃
狗傍人势
狗党狐朋
狗党狐羣
狗党狐群
狗口里吐不出象牙
狗口里生不出象牙
狗吠不惊
狗吠之惊
狗吠之警
狗吠非主
狗咬吕洞宾
狗嘴里吐不出象牙
狗头军师
狗头鼠脑
狗尾续貂
狗尾貂续
狗屁不通
狗彘不如
狗彘不若
狗彘不食
狗彘不食其余
狗心狗行
狗急跳墙
狗恶酒酸
狗拿耗子
狗猪不食其余
狗皮膏药
狗盗鸡啼
狗盗鸡鸣
狗盗鼠窃
狗眼看人
狗续侯冠
狗续貂尾
狗续金貂
狗肺狼心
狗胆包天
狗苟蝇营
狗血喷头
狗血淋头
狗行狼心
狗走狐淫
狗追耗子
狗逮老鼠
狗颠屁股
狗马声色
狞髯张目
狠心辣手
狡兔三穴
狡兔三窟
狡焉思启
狡焉思肆
狡焉思逞
狧穅及米
狩岳巡方
独一无二
独具匠心
独具只眼
独出己见
独出心裁
独出新裁
独出机杼
独到之处
独占鳌头
独善一身
独善其身
独善吾身
独坐愁城
独夫民贼
独学寡闻
独异于人
独当一面
独往独来
独得之见
独揽大权
独断专行
独断独行
独是独非
独有千古
独有千秋
独木不成林
独木不林
独木难支
独来独往
独树一帜
独步一时
独步天下
独步当世
独步当时
独立王国
独立自主
独竖一帜
独胆英雄
独茧抽丝
独行其是
独行其道
独行独断
独行踽踽
独辟蹊径
独运匠心
独霸一方
独鹤鸡羣
独鹤鸡群
狭路相逢
狮子大开口
狰狞面目
狱货非宝
狷介之士
狼前虎后
狼号鬼哭
狼吃幞头
狼吞虎咽
狼吞虎噬
狼吞虎餐
狼嗥狗叫
狼嗥鬼叫
狼嚎鬼叫
狼奔兔脱
狼奔豕突
狼奔鼠偷
狼奔鼠窜
狼子兽心
狼子野心
狼心狗肺
狼心狗行
狼烟四起
狼烟大话
狼狈万状
狼狈不堪
狼狈为奸
狼狈周章
狼猛蜂毒
狼眼鼠眉
狼突豕窜
狼突鸱张
狼羊同饲
狼艰狈蹶
狼虫虎豹
狼贪虎视
狼贪鼠窃
狼顾狐疑
狼顾虎视
狼顾鸢视
狼顾鸱张
狼顾鸱跱
狼顾麕惊
狼飡虎咽
狼飡虎食
狼飧虎咽
狼餐虎咽
狼餐虎噬
猕猴骑土牛
猖獗一时
猛志常在
猛虎出山
猛虎插翅
猛虎深山
猛虎添翼
猜拳行令
猜枚行令
猝不及防
猢狲入布袋
猪卑狗险
猪朋狗友
猪突豨勇
猫哭老鼠
猫噬鹦鹉
猫鼠同乳
猫鼠同处
猫鼠同眠
猬结蚁聚
猬起鸡连
猬锋螗斧
献可替否
献曝之忱
献替可否
猴头猴脑
猴年马月
猿啼鹤唳
猿啼鹤怨
猿悲鹤怨
猿惊鹤怨
猿猴取月
猿穴坏山
猿鹤沙虫
猿鹤虫沙
獐头鼠目
獐麇马鹿
玄之又玄
玄圃积玉
玄妙入神
玄妙莫测
玄辞冷语
玄酒瓠脯
率以为常
率兽食人
率土之滨
率土同庆
率土宅心
率土归心
率尔成章
率尔操觚
率由旧则
率由旧章
率马以骥
玉佩琼琚
玉关人老
玉减香消
玉减香销
玉卮无当
玉友金昆
玉叶金枝
玉圭金臬
玉堂人物
玉堂金马
玉宇琼楼
玉尺量才
玉巵无当
玉律金科
玉惨花愁
玉成其事
玉成其美
玉振金声
玉昆金友
玉柱擎天
玉树临风
玉树琼枝
玉树芝兰
玉楼赴召
玉毁椟中
玉汝于成
玉洁冰清
玉洁松贞
玉润冰清
玉润珠圆
玉液琼浆
玉液金波
玉液金浆
玉清冰洁
玉漏犹滴
玉燕投怀
玉石不分
玉石俱摧
玉石俱焚
玉石俱碎
玉石同沉
玉石同碎
玉石杂糅
玉石混淆
玉石皆碎
玉石相揉
玉砌雕阑
玉碎珠沉
玉碎香残
玉碎香消
玉碎香销
玉箫金琯
玉箫金管
玉粒桂薪
玉貌花容
玉质金相
玉走金飞
玉软花柔
玉食锦衣
玉骨冰肌
王佐之才
王侯将相
王公大人
王公贵戚
王后卢前
王孙公子
王孙贵戚
王祥卧冰
王贡弹冠
王顾左右而言他
玩世不恭
玩兵黩武
玩岁愒日
玩岁愒时
玩岁愒月
玩忽职守
玩故习常
玩日愒时
玩时愒日
玩时贪日
玩火自焚
玩物丧志
环堵萧然
环肥燕瘦
现世现报
现身说法
现钟不打
现钟弗打
玲珑剔透
玲珑透漏
珊珊来迟
珊瑚在网
珍禽奇兽
珍禽异兽
珍馐美馔
珑珑兀兀
珠光宝气
珠光寳气
珠围翠拥
珠围翠绕
珠圆玉洁
珠圆玉润
珠宫贝阙
珠投璧抵
珠槃玉敦
珠歌翠舞
珠沉沧海
珠沉玉碎
珠沉玉磒
珠沉玉陨
珠沉璧碎
珠流璧转
珠玉在侧
珠璧交辉
珠璧联辉
珠盘玉敦
珠窗网户
珠箔银屏
珠翠之珍
珠联玉映
珠联璧合
珠规玉矩
珠还合浦
珠连璧合
珠零玉落
珠零锦粲
珪璋特达
班功行赏
班师回俯
班师回朝
班师得胜
班班可考
班荆道故
班荆道旧
班衣戏彩
班衣戏采
班门弄斧
班香宋艳
班马文章
班驳陆离
琅嬛福地
琅琅上口
理不忘乱
理不胜辞
理之当然
理冤摘伏
理屈词穷
理所不容
理所当然
理所必然
理正词直
理直气壮
琐尾流离
琨玉秋霜
琪花玉树
琪花瑶草
琳琅满目
琳琅触目
琴剑飘零
琴心剑胆
琴挑文君
琴断朱弦
琴棋书画
琴歌酒赋
琴瑟不调
琴瑟之好
琴瑟和好
琴瑟失调
琴瑟调和
琵琶别弄
琵琶别抱
琵琶旧语
琵琶胡语
琼厨金穴
琼堆玉砌
琼岛春云
琼林玉树
琼林玉质
琼枝玉叶
琼枝玉树
琼楼玉宇
琼楼金阙
琼浆玉液
琼浆金液
瑕不掩瑜
瑕不揜瑜
瑕瑜互见
瑚琏之器
瑜不掩瑕
瑜不揜瑕
瑜百瑕一
瑞雪兆丰年
瑟弄琴调
瑟调琴弄
瑰意奇行
瑰意琦行
瑶台琼室
瑶台银阙
瑶林玉树
瑶林琼树
瑶池女使
瑶池玉液
瑶环瑜珥
瑶草奇花
瑶草琪花
瑶草琪葩
璀璨夺目
璇霄丹台
璇霄丹阙
璞玉浑金
璧合珠联
璧合珠连
璧坐玑驰
瓜分豆剖
瓜分鼎峙
瓜剖碁布
瓜剖豆分
瓜区豆分
瓜字初分
瓜李之嫌
瓜熟蒂落
瓜熟蔕落
瓜瓞绵绵
瓜田之嫌
瓜田李下
瓜皮搭李树
瓜葛相连
瓜衍之赏
瓜连蔓引
瓢泼大雨
瓦合之卒
瓦器蚌盘
瓦影之鱼
瓦影龟鱼
瓦查尿溺
瓦玉集糅
瓦解冰泮
瓦解冰消
瓦解冰销
瓦解土崩
瓦解星散
瓦釜雷鸣
瓮中之鳖
瓮中捉鳖
瓮声瓮气
瓮天之见
瓮天蠡海
瓮尽杯干
瓮牖桑枢
瓮牖绳枢
瓮里酰鸡
瓮里醯鸡
瓶坠簪折
瓶沈簪折
瓶沉簪折
瓶罄罍耻
甄奇录异
甄奇録异
甄心动惧
甑尘釜鱼
甘之如荠
甘之如饴
甘之若素
甘井先竭
甘冒虎口
甘分随时
甘处下流
甘居人后
甘心如荠
甘心情原
甘心情愿
甘心瞑目
甘心首疾
甘拜下风
甘旨肥浓
甘棠之惠
甘棠之爱
甘棠遗爱
甘死如饴
甘泉必竭
甘瓜苦蒂
甘苦与共
甘言厚礼
甘言美语
甘败下风
甘贫乐道
甘贫守分
甘雨随车
甚嚣尘上
甜嘴蜜舌
甜言媚语
甜言美语
甜言蜜语
甜言软语
甜酸苦辣
生上起下
生不逢场
生不逢时
生不逢辰
生不遇时
生众食寡
生公说法
生关死劫
生功止过
生动活泼
生发未燥
生吞活剥
生吞活夺
生夺硬抢
生寄死归
生张熟魏
生手生脚
生拉活扯
生拉活拽
生拉硬扯
生拖死拽
生拼硬凑
生拽活拖
生搬硬套
生机勃勃
生杀与夺
生杀予夺
生栋覆屋
生桑之梦
生死不易
生死不渝
生死与共
生死之交
生死予夺
生死关头
生死存亡
生死攸关
生死无贰
生死未卜
生死相依
生死肉骨
生死苦海
生死醉梦
生死长夜
生死骨肉
生民涂炭
生气勃勃
生灵涂地
生灵涂炭
生炒热卖
生生不已
生生不息
生生世世
生生死死
生知安行
生离死别
生米做成熟饭
生米煮成熟饭
生老病死
生而知之
生聚教养
生聚教训
生肉枯骨
生花之笔
生花妙笔
生花妙语
生荣亡哀
生荣死哀
生荣死衰
生荣没哀
生财之道
生财有道
生辰吉帖
生齿日繁
生龙活现
生龙活虎
用一当十
用之不竭
用兵如神
用其所长
用夏变夷
用天因地
用尽心机
用心用意
用心竭力
用心良苦
用智铺谋
用武之地
用管窥天
用舍行藏
用行舍藏
用逸待劳
用非其人
用非所学
田夫野叟
田夫野老
田月桑时
田父之功
田父之获
田父献曝
田父野叟
田父野老
田畯野老
田翁野老
田连仟伯
田连阡陌
由博返约
由来已久
由此及彼
由浅入深
由表及里
由衷之言
由近及远
甲冠天下
甲第连云
甲第连天
申冤吐气
申旦达夕
申祸无良
电光朝露
电光石火
电掣星驰
电掣风驰
电流星散
电照风行
电闪雷鸣
男唱女随
男大当娶
男大当婚
男大须婚
男女有别
男女老小
男女老少
男女老幼
男妇老幼
男婚女嫁
男婚女聘
男媒女妁
男室女家
男尊女卑
男欢女爱
男盗女娼
男耕女织
画一之法
画中有诗
画卵雕薪
画土分疆
画地为牢
画地为狱
画地作狱
画地刻木
画地成图
画地成牢
画地而趋
画意诗情
画栋雕梁
画栋飞甍
画梁雕栋
画水镂冰
画沙印泥
画沙聚米
画疆墨守
画眉举案
画眉京兆
画符念咒
画脂镂冰
画荻丸熊
画荻和丸
画荻教子
画虎不成
画虎不成反类犬
画虎不成反类狗
画虎刻鹄
画虎成狗
画虎画皮难画骨
画虎类犬
画虎类狗
画蚓涂鸦
画蛇添足
画蛇着足
画蛇著足
画野分疆
画饼充饥
画龙不成反为狗
画龙刻鹄
画龙点晴
画龙点睛
畅叫扬疾
畅所欲为
畅所欲言
畅行无碍
畅行无阻
畅通无阻
畏之如虎
畏刀避箭
畏口慎事
畏天恤民
畏天悯人
畏天爱民
畏天知命
畏头畏尾
畏威怀德
畏影恶迹
畏影而走
畏影避迹
畏敌如虎
畏死贪生
畏缩不前
畏葸不前
畏难苟安
畏首畏尾
畔道离经
留得青山在不怕没柴烧
留恋不舍
留有余地
留犂挠酒
留连不舍
留连忘返
畛域之见
畜妻养子
番来复去
番来覆去
番窠倒臼
畴咨之忧
畸流洽客
畸流逸客
畸轻畸重
畸重畸轻
疏不闲亲
疏不间亲
疏水箪瓢
疏而不漏
疏财仗义
疏财尚气
疏财重义
疐后跋前
疑事无功
疑似之间
疑信参半
疑团满腹
疑团莫释
疑心生暗鬼
疑神疑鬼
疑神见鬼
疑行无成
疑误天下
疑难杂症
疑鬼疑神
疗疮剜肉
疚心疾首
疢如疾首
疥癣之疾
疮好忘痛
疮巨衅深
疮疥之疾
疮痍弥目
疮痍满目
疲于供命
疲于奔命
疲心竭虑
疲惫不堪
疲精竭力
疾不可为
疾声厉色
疾如旋踵
疾如雷电
疾恶如仇
疾恶如雠
疾恶如风
疾恶若雠
疾病相扶
疾言倨色
疾言厉气
疾言厉色
疾言怒色
疾言遽色
疾走先得
疾足先得
疾雨暴风
疾雷不及塞耳
疾雷不及掩耳
疾雷不暇掩耳
疾霆不暇掩目
疾风劲草
疾风彰劲草
疾风扫秋叶
疾风暴雨
疾风甚雨
疾风知劲草
疾风迅雷
疾风骤雨
疾首嚬蹙
疾首痛心
疾首蹙頞
疾首蹙额
病从口入
病入膏肓
病入骨隨
病入骨髓
病国殃民
病在膏肓
病急乱投医
病染膏肓
病民害国
病民蛊国
病狂丧心
病由口入
病病歪歪
病笃乱投医
病风丧心
病骨支离
病魔缠身
痌心疾首
痌瘝一体
痌瘝在抱
痌癏在抱
痒磨树者
痛下针砭
痛不欲生
痛于骨髓
痛入心脾
痛入骨髓
痛剿穷迫
痛剿穷追
痛可言邪
痛哭流涕
痛定思痛
痛心伤臆
痛心入骨
痛心切骨
痛心拔脑
痛心疾首
痛心病首
痛心絶气
痛心绝气
痛快淋漓
痛悔前非
痛改前非
痛涤前非
痛深恶絶
痛深恶绝
痛湔宿垢
痛痒相关
痛自创艾
痛诬丑诋
痛贯心膂
痛饮黄龙
痰迷心窍
痴云腻雨
痴云騃雨
痴人说梦
痴儿呆女
痴心妄想
痴思妄想
痴男怨女
痴男騃女
痴鼠拖姜
瘏口哓音
瘗玉埋香
瘠义肥辞
瘠人肥己
瘠己肥人
瘠牛偾豚
瘠牛羸豚
瘦羊博士
瘦骨伶仃
瘦骨如柴
瘦骨嶙峋
瘦骨嶙嶙
瘦骨梭棱
瘦骨棱棱
瘦骨零丁
瘴乡恶土
瘴雨蛮烟
癞蛤蟆想吃天鹅肉
癣疥之疾
登台拜将
登坛拜将
登堂入室
登山临水
登山小鲁
登山涉水
登山越岭
登山陟岭
登峰造极
登木求鱼
登界游方
登锋履刃
登锋陷阵
登高一呼
登高去梯
登高履危
登高必赋
登高望远
登高能赋
登高自卑
白丁俗客
白云亲舍
白云孤飞
白云苍狗
白兔赤乌
白华之怨
白发丹心
白发千丈
白发朱颜
白发红颜
白发苍苍
白发苍颜
白发青衫
白叟黄童
白圭之玷
白天见鬼
白头不终
白头之叹
白头偕老
白头到老
白头如新
白头相守
白头相并
白头而新
白头蹀跇
白头迭雪
白屋之士
白屋寒门
白山黑水
白帢青衫
白往黑来
白手兴家
白手成家
白手空拳
白手起家
白旄黄钺
白日上升
白日作梦
白日做梦
白日升天
白日绣衣
白日衣绣
白日见鬼
白日青天
白日飞升
白水鉴心
白浪掀天
白玉微瑕
白玉无瑕
白璧三献
白璧微瑕
白璧无瑕
白璧青蝇
白白朱朱
白眉赤眼
白眼相看
白纸黑字
白色恐怖
白草黄云
白藋同心
白虹贯日
白蚁争穴
白蜡明经
白衣公卿
白衣卿相
白衣宰相
白衣秀士
白衣苍狗
白袷蓝衫
白话八股
白雪皑皑
白雪阳春
白雪难和
白面书生
白面书郎
白面儒冠
白面儒生
白饭青刍
白首一节
白首不渝
白首为郎
白首之心
白首北面
白首同归
白首如新
白首相庄
白首相知
白首穷经
白首空归
白首齐眉
白驹空谷
白驹过郄
白驹过隙
白骨再肉
白骨露野
白鱼入舟
白鱼登舟
白鱼赤乌
白黑不分
白黑分明
白黑颠倒
白齿青眉
白龙鱼服
百万雄兵
百万雄师
百丈竿头
百下百全
百下百着
百不一存
百不一贷
百不一遇
百不失一
百不当一
百不获一
百世一人
百世不易
百世不磨
百世之利
百世之师
百世师
百世流芬
百世流芳
百业萧条
百中百发
百举百全
百举百捷
百了千当
百事大吉
百事无成
百二关河
百二山川
百二山河
百二河山
百二金瓯
百代文宗
百代过客
百伶百俐
百依百从
百依百随
百依百顺
百八真珠
百兽率舞
百凡待举
百务具举
百动不如一静
百卉千葩
百发百中
百口同声
百口莫辩
百口难分
百品千条
百啭千声
百喙一词
百喙如一
百喙莫辩
百喙难辞
百喙难辩
百城之富
百堕俱举
百堵皆作
百媚千娇
百孔千创
百孔千疮
百宝万货
百家争鸣
百密一疏
百尺无枝
百尺竿头
百岁之后
百岁之好
百岁之盟
百岁千秋
百川归海
百川朝海
百川赴海
百巧千穷
百巧成穷
百年不遇
百年之业
百年之后
百年之好
百年之柄
百年之约
百年偕老
百年大业
百年大计
百年好事
百年好合
百年树人
百年谐老
百年难遇
百废俱举
百废俱兴
百废具举
百废具作
百废具兴
百废咸举
百废待举
百废待兴
百弊丛生
百忍成金
百念皆灰
百思不得其解
百思不解
百思莫解
百怪千奇
百感交集
百战不殆
百战无前
百战百胜
百战百败
百折不回
百折不屈
百折不挠
百折不摧
百折不移
百折千回
百拙千丑
百无一堪
百无一失
百无一成
百无一是
百无一用
百无一能
百无所成
百无是处
百无禁忌
百无聊赖
百星不如一月
百步穿杨
百死一生
百炼成刚
百炼成钢
百福具臻
百端交集
百端待举
百紫千红
百纵千随
百结悬鹑
百结愁肠
百舌之声
百舍重茧
百舍重趼
百般刁难
百般奉承
百般折磨
百般抚慰
百花争妍
百花争艳
百花生日
百花齐放
百虑一致
百虑攒心
百衣百随
百计千心
百计千方
百计千谋
百读不厌
百谋千计
百足不僵
百足之虫
百身何赎
百身莫赎
百载树人
百辞莫辩
百里之命
百里之才
百里挑一
百闻不如一见
百顺千随
百顺百依
百鬼众魅
百鸟朝凤
百龄眉寿
皂丝麻线
皂白不分
皂白沟分
皂白难分
的一确二
皆大欢喜
皇亲国戚
皇天上帝
皇天不负有心人
皇天不负苦心人
皇天后土
皇皇不可终日
皎如日星
皎阳似火
皓月千里
皓首穷经
皓首苍颜
皓齿娥眉
皓齿明眸
皓齿朱唇
皓齿红唇
皓齿蛾眉
皓齿青蛾
皡天罔极
皮伤肉绽
皮开肉绽
皮相之见
皮相之谈
皮破肉烂
皮破血流
皮笑肉不笑
皮肤之见
皮里抽肉
皮里春秋
皮里阳秋
皲手茧足
盂方水方
盈则必亏
盈千累万
盈满之咎
盈盈一水
盈盈秋水
盈科后进
盈篇累牍
益国利民
益寿延年
益谦亏盈
盎盂相击
盎盂相敲
盐梅之寄
盐梅相成
盐梅舟楫
监临自盗
监主自盗
监守自盗
监市履狶
盖不由己
盖世之才
盖世无双
盖世英雄
盖头换面
盖棺事定
盖棺定论
盖棺论定
盗亦有道
盗名暗世
盗名欺世
盗嫂受金
盗怨主人
盗憎主人
盗玉窃钩
盗跖之物
盗钟掩耳
盗铃掩耳
盗锺掩耳
盗食致饱
盘古开天地
盘木朽株
盘根究底
盘根错节
盘根问底
盘水加剑
盘游无度
盘石之固
盘石之安
盘石桑苞
盘马弯弓
盘龙之癖
盘龙卧虎
盛况空前
盛名难副
盛宴难再
盛必虑衰
盛情难却
盛极一时
盛气临人
盛气凌人
盛水不漏
盛筵必散
盛筵易散
盛筵难再
盛衰兴废
盛衰荣辱
盛食厉兵
盟山誓海
目下十行
目不交睫
目不别视
目不忍睹
目不忍覩
目不忍见
目不忍视
目不斜视
目不暇接
目不暇给
目不知书
目不窥园
目不给赏
目不苟视
目不见睫
目不识丁
目不识书
目不转睛
目不邪视
目中无人
目乱睛迷
目乱精迷
目交心通
目使颐令
目光如炬
目光如豆
目光如鼠
目光炯炯
目兔顾犬
目击耳闻
目击道存
目别汇分
目动言肆
目定口呆
目怔口呆
目成心许
目指气使
目挑心悦
目挑心招
目挑眉语
目擩耳染
目断魂销
目断鳞鸿
目无三尺
目无下尘
目无余子
目无全牛
目无尊长
目无法纪
目无王法
目染耳濡
目治手营
目注心凝
目注心营
目濡耳染
目牛无全
目目相觑
目眐心骇
目眢心忳
目眦尽裂
目眩头昏
目眩头晕
目眩神摇
目睁口呆
目睫之论
目睹耳闻
目瞪口僵
目瞪口呆
目瞪口张
目瞪口歪
目瞪口结
目瞪心骇
目瞪舌强
目瞪舌彊
目瞪舌挢
目知眼见
目空一世
目空一切
目空余子
目窕心与
目若悬珠
目见耳闻
目语额瞬
目达耳通
目迷五色
目送手挥
目逆而送
目酣神醉
目量意营
目食耳视
盱衡厉色
盲人扪烛
盲人把烛
盲人摸象
盲人瞎马
盲人说象
盲人骑瞎马
盲翁扪籥
盲翁扪钥
盲者得镜
盲风妒雨
盲风妬雨
盲风怪云
盲风怪雨
盲风晦雨
盲风暴雨
盲风涩雨
直上直下
直上青云
直入公堂
直内方外
直口无言
直情径行
直截了当
直扑无华
直抒己见
直抒胸臆
直捣黄龙
直捷了当
直接了当
直撞横冲
直木先伐
直木必伐
直朴无华
直权无华
直眉怒目
直眉楞眼
直眉睖眼
直眉瞪眼
直言不讳
直言切谏
直言勿讳
直言取祸
直言无讳
直言无隐
直言极谏
直言正色
直言正论
直言正谏
直言贾祸
直认不讳
直谅多闻
直道而行
相与一口
相与为一
相为表里
相习成俗
相习成风
相亲相爱
相仿相效
相体裁衣
相依为命
相克相济
相切相磋
相去几何
相去悬殊
相去无几
相反相成
相呴以湿
相呴相济
相喣以沫
相因相生
相失交臂
相女配夫
相安无事
相安相受
相对无言
相差无几
相帅成风
相庄如宾
相形失色
相形见拙
相形见绌
相待如宾
相得无间
相得甚欢
相得益彰
相得益章
相忍为国
相忘形骸
相惊伯有
相持不下
相提并论
相提而论
相敬如宾
相时度力
相时而动
相映成趣
相机而动
相机行事
相沿成习
相沿成俗
相濡以沫
相濡以泽
相濡相呴
相煎何急
相煎太急
相生相克
相生相成
相知恨晚
相知有素
相见恨晚
相视失色
相视而笑
相视莫逆
相貌堂堂
相辅相成
相辅而行
相逢恨晚
相逢狭路
相门出相
相门有相
相门洒埽
相门相种
相须为命
相顾失色
相风使帆
相鼠有皮
省事宁人
省吃俭用
省吃细用
省役薄赋
省愆寡过
省烦从简
省衣节食
省身克己
眄视指使
眈眈虎视
眈眈逐逐
眉下添眉
眉南面北
眉厖齿鲵
眉头不伸
眉头眼后
眉头眼尾
眉头眼脑
眉尖眼尾
眉开眼笑
眉扬目展
眉来眼去
眉欢眼笑
眉毛胡子一把抓
眉清目朗
眉清目秀
眉留目乱
眉目传情
眉目如画
眉眼如画
眉眼高低
眉睫之内
眉睫之祸
眉舒目展
眉花眼笑
眉语目笑
眉飞目舞
眉飞眼笑
眉飞色悦
眉飞色舞
眉高眼下
眉高眼低
看人下菜碟儿
看人眉眼
看人眉睫
看人行事
看家本事
看家本领
看景生情
看朱成碧
看杀卫玠
看生见长
看破红尘
看碧成朱
看菜吃饭
看风使帆
看风使舵
看风使船
看风行船
看风转舵
看风驶船
真人不露相
真伪莫辨
真凭实据
真凶实犯
真刀真枪
真命天子
真心实意
真心真意
真心诚意
真情实意
真情实感
真才实学
真枪实弹
真独简贵
真相大白
真相毕露
真知卓见
真知灼见
真脏实犯
真赃实犯
真赃真贼
真金不怕火
真金不怕火炼
真金不镀
真金烈火
真龙天子
真龙活现
眠云卧石
眠思梦想
眠花卧柳
眠花宿柳
眠花藉柳
眠花醉柳
眠霜卧雪
眢井瞽人
眦裂发指
眩目惊心
眩碧成朱
眩视惑听
眷眷之心
眷红偎翠
眼不交睫
眼不回睛
眼不着砂
眼不见为净
眼不识丁
眼不转睛
眼中拔钉
眼中有铁
眼中钉
眼光如豆
眼内无珠
眼去眉来
眼尖手快
眼底无人
眼开眉展
眼急手快
眼想心思
眼意心期
眼捷手快
眼明心亮
眼明手快
眼明手捷
眼泪洗面
眼疾手快
眼瞎耳聋
眼空一世
眼空四海
眼穿心死
眼穿肠断
眼笑眉舒
眼笑眉飞
眼约心期
眼腰黄赤
眼花历乱
眼花心乱
眼花撩乱
眼花缭乱
眼花耳热
眼花雀乱
眼观六路
眼语颐指
眼跳心惊
眼跳耳热
眼迷心荡
眼饧耳热
眼馋肚饱
眼高手低
眼高手生
着三不着两
着书立说
着人先鞭
着手成春
着手生春
睚眦之忿
睚眦之怒
睚眦之怨
睚眦之隙
睚眦必报
睚眦触死
睟面盎背
睡卧不宁
睡生梦死
睡眼惺忪
睡长梦多
睥睨一切
睹始知终
睹微知着
睹微知著
睹景伤情
睹物伤情
睹物兴情
睹物思人
睹着知微
睹著知微
瞋目切齿
瞋目张胆
瞋目扼腕
瞋目搤腕
瞋目竖眉
瞎子摸象
瞎子摸鱼
瞎子断匾
瞎灯灭火
瞎灯黑火
瞎马临池
瞑思苦想
瞒上不瞒下
瞒上欺下
瞒天大谎
瞒天席地
瞒天昧地
瞒天瞒地
瞒天要价
瞒天讨价
瞒天过海
瞒心昧己
瞒神弄鬼
瞠乎其后
瞠乎后已
瞠乎后矣
瞠呼其后
瞠然自失
瞠目咋舌
瞠目挢舌
瞠目结舌
瞠目而视
瞪目哆口
瞪目结舌
瞪眉瞠眼
瞪眼咋舌
瞬息万变
瞬息万状
瞬息之间
瞬息千变
瞭如观火
瞰瑕伺隙
瞻云就日
瞻云陟屺
瞻前忽后
瞻前思后
瞻前顾后
瞻情顾意
瞻星揆地
瞻望咨嗟
瞻蒲劝穑
瞻顾前后
瞽言妄举
瞽言萏议
矙瑕伺隙
矜世取宠
矜功不立
矜功伐善
矜功伐能
矜功恃宠
矜功自伐
矜功负气
矜句饰字
矜名妒能
矜名嫉能
矜奇立异
矜己自饰
矜平躁释
矜情作态
矜愚饰智
矜才使气
矜智负能
矜牙舞爪
矜纠收缭
矜能负才
矜贫恤独
矜贫救厄
矢不虚发
矢力同心
矢口否认
矢口抵赖
矢口狡赖
矢口猖言
矢在弦上
矢如雨下
矢心不二
矢志不摇
矢志不渝
矢志不移
矢忠不二
矢无虚发
矢死不二
矢死无贰
矢石之难
知一万毕
知书明理
知书知礼
知书识字
知书识礼
知书达礼
知书通礼
知人下士
知人之明
知人之鉴
知人则哲
知人善任
知人知面不知心
知人论世
知其一不知其二
知其不可而为之
知名当世
知命不忧
知命之年
知命乐天
知地知天
知子莫若父
知小言大
知小谋大
知尽能索
知己之遇
知己知彼
知彼知己
知往鉴今
知微知彰
知微知章
知心可腹
知心着意
知心知意
知恩报德
知恩报恩
知情不举
知情识趣
知情达理
知我罪我
知文达礼
知无不为
知无不尽
知无不言
知易行难
知来藏往
知止不殆
知止不辱
知法犯法
知疼着热
知疼着痒
知白守黑
知章知微
知羞识廉
知荣守辱
知行合一
知足不殆
知足不辱
知足常乐
知足知止
知过必改
知过能改
知遇之恩
知难而进
知难而退
知雄守雌
知音识趣
知高识低
矩步方行
矫世励俗
矫世厉俗
矫世变俗
矫国更俗
矫国革俗
矫尾厉角
矫情干誉
矫情镇物
矫情饰行
矫情饰诈
矫情饰貌
矫揉造作
矫时慢物
矫枉过中
矫枉过当
矫枉过正
矫枉过直
矫矫不羣
矫矫不群
矫若惊龙
矫若游龙
矫言伪行
矫邪归正
短中取长
短兵接战
短兵相接
短刀直入
短叹长吁
短吁长叹
短吃少穿
短垣自逾
短寿促命
短小精悍
短绠汲深
短衣匹马
短褐不全
短褐不完
短褐穿结
短见薄识
矮人看场
矮人看戏
矮人观场
矮子看戏
矮子观场
石城汤池
石室金匮
石室金鐀
石尤风
石心木肠
石沈大海
石沉大海
石泐海枯
石火光阴
石火电光
石火风灯
石火风烛
石烂江枯
石烂海枯
石破天惊
石缄金匮
石赤不夺
砂里淘金
砌红堆緑
砌红堆绿
砌词捏控
研京练都
研机综微
研桑心计
研精殚力
研精殚思
研精毕智
研精究微
研精竭虑
研精致思
研精苦思
研精覃思
研精钩深
研精阐微
研经铸史
砥兵砺伍
砥厉名号
砥厉廉隅
砥廉峻隅
砥志研思
砥柱中流
砥砺名号
砥砺名节
砥砺廉隅
砥砺琢磨
砥砺风节
砥节励行
砥节厉行
砥节奉公
砥节砺行
砥行磨名
砥行立名
砥身砺行
砥锋挺锷
砭庸针俗
砲凤烹龙
砲龙烹凤
破产荡业
破军杀将
破卵倾巢
破口大骂
破国亡家
破坚摧刚
破壁飞去
破天荒
破头烂额
破奸发伏
破家丧产
破家为国
破家亡国
破家县令
破家竭产
破家荡业
破家荡产
破家败产
破崖絶角
破崖绝角
破巢余卵
破巢完卵
破愁为笑
破斧缺斨
破旧立新
破柱求奸
破桐之叶
破死忘生
破浪乘风
破涕为笑
破涕成笑
破烂不堪
破烂流丢
破玩意儿
破琴絶弦
破琴绝弦
破璧毁珪
破瓜之年
破瓦颓垣
破甑不顾
破矩为圆
破竹之势
破竹建瓴
破绽百出
破罐破摔
破肝糜胃
破胆寒心
破脑刳心
破衲疏羹
破觚为圜
破觚斫雕
破觚斲雕
破釜沈舟
破釜沉舟
破釜焚舟
破铜烂铁
破镜分钗
破镜重合
破镜重圆
破门而入
破门而出
破除迷信
破题儿第一遭
破颜微笑
破鼓乱人捶
砸锅卖铁
砺世摩钝
砺世磨钝
砺山带河
砺岳盟河
砺带河山
砺戈秣马
础泣而雨
础润而雨
硁硁之愚
硕大无朋
硕大无比
硕学通儒
硕望宿德
硕果仅存
硝云弹雨
硬语盘空
确乎不拔
确凿不移
确切不移
确固不拔
确然不羣
确然不群
碁布星罗
碁逢敌手
碌碌寡合
碌碌无为
碌碌无奇
碌碌无能
碌碌无闻
碍口识羞
碍手碍脚
碍足碍手
碍难从命
碎尸万段
碎心裂胆
碎玉零玑
碎琼乱玉
碎瓦颓垣
碎身粉骨
碎身糜躯
碎首糜躯
碎首縻躯
碎骨粉尸
碎骨粉身
碔砆混玉
碧海青天
碧空万里
碧空如洗
碧落黄泉
碧血丹心
碧鬟红袖
碰钉子
磊浪不羁
磊瑰不羁
磊瑰不覉
磊磊落落
磊落不凡
磊落不羁
磊落不羇
磊落不覊
磊落光明
磊落豪横
磊落轶荡
磊落飒爽
磐石之固
磐石之安
磕头如捣
磕头碰脑
磕头礼拜
磕牙料嘴
磨刀不误砍柴工
磨刀擦枪
磨刀霍霍
磨动
磨厉以须
磨形炼性
磨拳擦掌
磨昬抉聩
磨杵作针
磨杵成针
磨棱刓角
磨牙凿齿
磨牙吮血
磨盘两圆
磨盾之暇
磨砖作镜
磨砖成镜
磨砥刻厉
磨砺以须
磨砻底厉
磨砻浸灌
磨砻砥砺
磨砻镌切
磨礲浸灌
磨礲淬励
磨礲砥砺
磨穿铁砚
磨穿铁鞋
磨踵灭顶
磨铅策蹇
磬石之固
磬竹难书
磬笔难书
示贬于褒
礼为情貌
礼义廉耻
礼仪之邦
礼先一饭
礼先壹饭
礼坏乐崩
礼奢宁俭
礼尚往来
礼崩乐坏
礼无不答
礼让为国
礼贤下士
礼轻人意重
礼轻情意重
礼顺人情
社会贤达
社威擅势
社燕秋鸿
社鼠城狐
祁奚举午
祁奚之举
祁奚之荐
祖功宗德
祖宗家法
祖宗成法
祖宗法度
祖武宗文
祖龙之虐
祛病延年
祛累
祛蠹除奸
祝不胜诅
祝僇祝鲠
祝发文身
祝发空门
祝咽祝哽
祝哽祝噎
祝鮀之佞
祝鲠祝噎
祝鲠祝饐
神不守舍
神不收舍
神不知鬼不晓
神不知鬼不觉
神不附体
神丧胆落
神乎其技
神乎其神
神仙中人
神会心融
神使鬼差
神僊中人
神兵天将
神出鬼入
神出鬼没
神到之笔
神功圣化
神区鬼奥
神号鬼哭
神号鬼泣
神哗鬼叫
神嚎鬼哭
神圣工巧
神头鬼脸
神头鬼面
神奸巨猾
神奸巨蠹
神妙莫测
神安气集
神完气足
神州赤县
神州陆沉
神工天巧
神工意匠
神工鬼力
神工鬼斧
神差鬼使
神差鬼遣
神往神来
神怒人怨
神思恍惚
神怡心旷
神怿气愉
神情不属
神情恍惚
神情自若
神愁鬼哭
神意自若
神抶电击
神摇意夺
神摇目夺
神施鬼设
神术妙计
神机妙算
神机鬼械
神来之笔
神来气旺
神枢鬼藏
神武挂冠
神气十足
神气活现
神流气鬯
神清气朗
神清气爽
神清气茂
神清骨秀
神湛骨寒
神灭形消
神焦鬼烂
神牵鬼制
神眉鬼眼
神眉鬼道
神短气浮
神竦心惕
神经过敏
神经错乱
神而明之
神至之笔
神色不动
神色不惊
神色仓皇
神色张皇
神色自若
神藏鬼伏
神融气泰
神谋魔道
神谟庙筭
神谟庙算
神谟远算
神超形越
神输鬼运
神运鬼输
神迷意夺
神通广大
神逝魄夺
神道设教
神郁气悴
神醉心往
神采奕奕
神采奕然
神采焕发
神采英拔
神采飞扬
神閒气定
神闲气定
神闲气静
神霄绛阙
神领意得
神领意造
神飞气扬
神飞色舞
神驰力困
神骥出枥
神鬼不测
神鬼莫测
神鬼难测
神魂摇荡
神魂荡扬
神魂荡飏
神魂颠倒
神魂飘荡
神魂飞越
神龙失埶
神龙见首
神龙见首不见尾
神龙马壮
祥云瑞气
祥风时雨
祥麟威凤
祲威盛容
祸不单行
祸不旋踵
祸中有福
祸为福先
祸乱滔天
祸从口出
祸从口生
祸从天降
祸及池鱼
祸国殃民
祸在旦夕
祸枣灾梨
祸生肘腋
祸盈恶稔
祸福之门
祸福倚伏
祸福同门
祸福惟人
祸福无常
祸福无门
祸福有命
祸福由人
祸福相依
祸福相倚
祸福相生
祸稔恶积
祸结兵连
祸绝福连
祸起萧墙
祸近池鱼
祸迫眉睫
祸首罪魁
禀性难移
禁中颇牧
禁情割欲
禁攻寝兵
禁暴正乱
禁暴诛乱
禁止令行
禁网疏阔
禁舍开塞
禁鼎一脔
禅世雕龙
禅絮沾泥
福不盈眦
福为祸先
福为祸始
福倚祸伏
福善祸淫
福地洞天
福如东海
福孙荫子
福寿双全
福寿年高
福寿康宁
福寿无疆
福寿绵绵
福寿齐天
福慧双修
福无双至
福星高照
福禄双全
福至心灵
福衢寿车
福过灾生
禹惜寸阴
禹行舜趋
离世异俗
离世絶俗
离世绝俗
离世遁上
离乡别井
离乡别土
离乡背井
离乡背土
离合悲欢
离奇古怪
离山调虎
离弦走板
离心离德
离情别绪
离本依末
离本徼末
离本趣末
离析分崩
离析涣奔
离离矗矗
离经叛道
离经畔道
离经辨志
离羣索居
离群索居
离蔬释屩
离蔬释蹻
离题万里
离魂倩女
离鸾别凤
离鸾别鹄
离鸾别鹤
禽困覆车
禽息鸟视
禾黍之伤
禾黍之悲
禾黍故宫
秀出班行
秀外惠中
秀外慧中
秀才人情
秀才造反
秀水明山
秀而不实
秀色可餐
秀色堪餐
私心妄念
私心杂念
私心自用
私情密语
私淑弟子
私盐私醋
私相授受
私谐欢好
秉公任直
秉公办理
秉公无私
秉公灭私
秉文兼武
秉文经武
秉正无私
秉烛夜游
秉烛待旦
秉笔直书
秉节持重
秉要执本
秉钧当轴
秉钧持轴
秋后算账
秋实春华
秋扇见捐
秋收东藏
秋收冬藏
秋月寒江
秋月春花
秋月春风
秋毫不犯
秋毫之末
秋毫勿犯
秋毫无犯
秋毫见捐
秋水伊人
秋水盈盈
秋波盈盈
秋色平分
秋荼密网
秋行夏令
秋豪之末
秋风团扇
秋风扫叶
秋风扫落叶
秋风纨扇
秋风落叶
秋风过耳
秋高气和
秋高气爽
秋高气肃
秋高马肥
种学织文
种学绩文
种玉蓝田
科头徒跣
科头箕踞
科头袒体
科头裸身
科头赤足
科头跣足
科班出身
科第出身
秕言谬说
秘而不宣
秘而不言
秘而不露
秣马利兵
秣马厉兵
秣马脂车
秤不离砣
秤不离铊
秤平斗满
秤斤注两
秤砣虽小压千斤
秤薪而爨
秤薪量水
秤锤落井
秦失其鹿
秦女楚珠
秦庭之哭
秦庭朗镜
秦晋之好
秦晋之盟
秦智虞愚
秦树楚天
秦楼楚馆
秦楼谢馆
秦欢晋爱
秦筝赵瑟
秦诿楚諈
秦越肥瘠
秦镜高悬
秦鬟妆镜
积不相能
积习成俗
积习生常
积习难改
积习难除
积于忽微
积以为常
积功兴业
积劳成疾
积劳成病
积厚成器
积厚流光
积善余庆
积善成德
积土成山
积基树本
积小成大
积少成多
积岁累月
积年累岁
积年累月
积微成着
积微成著
积微致着
积德累仁
积德累功
积德累善
积德裕后
积忧成疾
积思广益
积恶余殃
积日累久
积日累岁
积日累月
积日絫久
积时累日
积本求原
积案盈箱
积毁消骨
积毁销金
积毁销骨
积水成渊
积沙成塔
积沙成滩
积玉堆金
积甲如山
积甲山齐
积简充栋
积箧盈藏
积素累旧
积羞成怒
积羽沉舟
积草屯粮
积薪候燎
积薪厝火
积讹成蠹
积谗磨骨
积谗糜骨
积谷防饥
积重不反
积重不返
积重难反
积重难返
积金累玉
积铢累寸
积雪囊萤
积雪封霜
积露为波
积非习贯
积非成是
称体载衣
称兄道弟
称功诵德
称功颂德
称名道姓
称奇道絶
称奇道绝
称孤道寡
称家有无
称帝称王
称德度功
称心如意
称心快意
称心满意
称心满愿
称斤掂两
称斤约两
称柴而爨
称物平施
称王称伯
称王称霸
称臣纳贡
称薪而爨
称觞上寿
称觞举寿
称贤使能
称贤荐能
称赏不已
称雨道晴
移东就西
移东换西
移东补西
移商换羽
移国动众
移天徙日
移天换日
移天易日
移孝为忠
移孝作忠
移宫换羽
移山倒海
移山回海
移山填海
移山拔海
移山竭海
移山跨海
移山造海
移形换步
移情遣意
移日卜夜
移易迁变
移星换斗
移有足无
移根换叶
移根接叶
移樽就教
移步换形
移气养体
移的就箭
移缓就急
移罇就教
移船就岸
移花接木
移风崇教
移风平俗
移风振俗
移风改俗
移风易俗
移风易尚
移风革俗
秽德垢行
秽言污语
稀世之宝
稀奇古怪
稂不稂莠不莠
稂莠不齐
程序动作
程朱之学
程朱学派
程朱理学
程门度雪
程门立雪
程门飞雪
稍关打节
稍安毋躁
稍纵则逝
稍纵即逝
稍胜一筹
稍逊一筹
稍黩筐篚
稔恶不悛
稔恶盈贯
稔恶藏奸
稗官小说
稗官野史
稗耳贩目
稚齿婑媠
稠人广众
稠人广坐
稠人广座
稳吃三注
稳坐钓鱼船
稳如泰山
稳扎稳打
稳打稳扎
稳操左券
稳操胜券
稳操胜算
稳步前进
稷蜂社鼠
稼穑艰难
稽古振今
稽古揆今
稽疑送难
穆如清风
穪心满意
穰穰满家
穴室枢户
穴居野处
究而言之
穷不失义
穷且益坚
穷乡僻壤
穷亡解沮
穷侈极奢
穷侈极欲
穷儿暴富
穷兵极武
穷兵黩武
穷凶极恶
穷凶极悖
穷凶极暴
穷凶极虐
穷凶极逆
穷则思变
穷原竟委
穷困潦倒
穷大失居
穷天极地
穷奢极侈
穷奢极欲
穷奸极恶
穷家富路
穷寇勿迫
穷寇勿追
穷寇莫追
穷富极贵
穷山僻壤
穷山恶水
穷山竭泽
穷岁累月
穷崖絶谷
穷工极变
穷工极巧
穷工极态
穷巷陋室
穷年尽气
穷年屡月
穷年没世
穷年累世
穷年累岁
穷年累月
穷幽极微
穷当益坚
穷形尽相
穷形极相
穷思极想
穷思毕精
穷愁潦倒
穷搜博采
穷日之力
穷日落月
穷本极源
穷极思变
穷极无聊
穷极要妙
穷根究底
穷泉朽壤
穷泰极侈
穷源朔流
穷源溯流
穷源竟委
穷猿失木
穷猿奔林
穷猿投林
穷理尽性
穷理居敬
穷神知化
穷神观化
穷而后工
穷苗苦根
穷荒絶徼
穷言杂语
穷途之哭
穷途末路
穷途潦倒
穷阎漏屋
穷陬僻壤
穷鸟入怀
穷鸟归人
穷鸟投人
穷鸟触笼
穷鼠啮狸
空中楼阁
空前絶后
空前绝后
空口无凭
空口说白话
空口说空话
空城计
空头支票
空室清野
空心架子
空心汤圆
空拳白手
空洞无物
空穴来风
空空如也
空腹便便
空腹高心
空言虚语
空话连篇
空谈快意
空谷传声
空谷幽兰
空谷白驹
空谷足音
空谷跫音
空费词说
穿云裂石
穿井得人
穿凿傅会
穿凿附会
穿壁引光
穿宵连夜
穿房入户
穿文凿句
穿杨贯虱
穿穴踰墙
穿窬之盗
穿红着緑
穿红着绿
穿花纳锦
穿花蛱蝶
穿荆度棘
穿针引线
突如其来
突梯滑稽
突然袭击
突飞猛进
窃位素餐
窃势拥权
窃据要津
窃玉偷花
窃玉偷香
窃窃私议
窃窃私语
窃窃诩诩
窃衣取温
窃钟掩耳
窃钩盗国
窃钩窃国
窃锺掩耳
窄门窄户
窈窕淑女
窒碍难行
窗明几净
窗间过马
窜端匿迹
窝停主人
窝火憋气
窥牖小儿
窥窬分毫
窥见一斑
窥豹一斑
窥间伺隙
立业安邦
立于不败之地
立人达人
立功赎罪
立命安身
立国安邦
立地书厨
立地书橱
立地成佛
立少观多
立时三刻
立木南门
立此存照
立盹行眠
立眉竖眼
立竿见影
立谈之间
立贤无方
立足之地
立身处世
立身扬名
立身行己
立锥之地
立马万言
立马盖桥
立马追镫
立马追驹
立马造桥
竖子成名
竖起脊梁
竞今疏古
竞短争长
章决句断
章句之徒
章句小儒
章台杨柳
章父荐屦
章甫荐履
童叟无欺
童山濯濯
童心未泯
童牛角马
童男童女
童颜鹤发
竦魂骇目
竭力虔心
竭尽全力
竭尽心力
竭忠尽智
竭智尽力
竭智尽忠
竭泽焚薮
竭泽而渔
竭诚尽节
竭诚相待
端人正士
端倪可察
端本正源
端本澄源
竹头木屑
竹报平安
竹柏异心
竹清松瘦
竹烟波月
竹篮打水
竹篱茅舍
竹罄南山
竹苞松茂
竹马之交
竹马之友
竹马之好
竿头一步
竿头日上
竿头日进
竿头直上
笃信好学
笃学不倦
笃学好古
笃定泰山
笃实好学
笃志好学
笃新怠旧
笃而论之
笃论高言
笃近举远
笑不可仰
笑不可支
笑中有刀
笑之以鼻
笑傲风月
笑处藏刀
笑容可掬
笑歌戏舞
笑比河清
笑筵歌席
笑而不答
笑话奇谈
笑语指麾
笑逐颜开
笑里藏刀
笑青吟翠
笑面夜叉
笑面虎
笑骂从汝
笔下生花
笔下超生
笔伐口诛
笔冢研穿
笔削褒贬
笔困纸穷
笔墨之林
笔墨官司
笔墨横姿
笔大如椽
笔头生花
笔底春风
笔底超生
笔底龙蛇
笔扫千军
笔歌墨舞
笔翰如流
笔老墨秀
笔耕砚田
笔诛墨伐
笔误作牛
笔走龙蛇
笔酣墨饱
笔饱墨酣
笙歌鼎沸
笙磬同音
笨口拙舌
笨嘴拙舌
笨嘴笨舌
笨头笨脑
笨手笨脚
笨鸟先飞
笼中之鸟
笼山络野
笼禽槛兽
笼络人心
笼而统之
笼鸟槛猿
笼鸟池鱼
等价连城
等因奉此
等夷之心
等夷之志
等礼相亢
等米下锅
等而上之
等而下之
等身著作
等量齐观
等闲之辈
等闲人家
等闲视之
筋疲力倦
筋疲力尽
筋疲力敝
筋疲力竭
筌蹏一悟
筐箧中物
筑台募士
筑坛拜将
筑室反耕
筑室道谋
筑岩钓渭
筑舍道傍
答问如流
答非所问
策名委质
策名就列
策无遗算
策顽磨钝
策马飞舆
策驽砺钝
筚簬篮缕
筚路蓝缕
筚路蓝褛
筚路褴褛
筚门圭窦
筚门圭窬
筚门闺窦
筚门闺窬
筛锣擂鼓
筱簵之箭
简丝数米
简傲絶俗
简傲绝俗
简切了当
简在帝心
简墨尊俎
简截了当
简捷了当
简明扼要
简约详核
简能而任
简落狐狸
简要不烦
简要清通
简贤任能
简贤附势
箕山之志
箕山之操
箕山之节
箕山之风
箕山挂瓢
箕帚之使
箕引裘随
箕箒之使
箕裘相继
箕风毕雨
算尽锱铢
算无遗策
算沙抟空
箝口侧目
箝口结舌
管中窥天
管中窥豹
管仲随马
管城毛颖
管宁割席
管秃唇焦
管窥之见
管窥之说
管窥筐举
管窥蛙见
管窥蠡测
管蠡窥测
管见所及
管鲍之交
管鲍分金
箧书潜递
箪瓢屡空
箪瓢屡罄
箪瓢陋室
箪瓢陋巷
箪豆见色
箪醪投川
箪食壶浆
箪食壶酒
箪食瓢饮
箪食豆羹
箫心剑态
箫韶九成
箭不虚发
箭在弦上
箭拔弩张
箭穿雁嘴
箸长碗短
篆刻虫雕
篝火狐鸣
篝灯呵冻
篡位夺权
篡党夺权
篱牢犬不入
篲泛画涂
簇锦团花
簟纹如水
簠簋不修
簠簋不饬
簠簋不饰
簠簋之风
簧口利舌
簪星曳月
簪笔磬折
簪缨世族
簪缨世胄
簪缨门第
簪蒿席草
簸土扬沙
簸扬糠粃
米已成炊
米珠薪桂
米盐博辩
米粒之珠
类聚群分
粉墨登场
粉妆玉琢
粉妆玉砌
粉白墨黑
粉白黛緑
粉白黛绿
粉白黛黑
粉装玉琢
粉身碎骨
粉面油头
粉饰太平
粉骨碎身
粉骨糜身
粒米束薪
粒米狼戾
粗中有细
粗制滥造
粗心大意
粗心浮气
粗服乱头
粗枝大叶
粗株大叶
粗茶淡饭
粗衣恶食
粗衣淡饭
粗衣粝食
粗袍粝食
粗通文墨
粗风暴雨
粘皮带骨
粘皮着骨
粘花惹草
粜风卖雨
粝食粗衣
粟红贯朽
粟陈贯朽
粤犬吠雪
粥少僧多
粥粥无能
粪土不如
粮多草广
粮尽援绝
粲然可观
粲花之论
精义入神
精兵强将
精兵简政
精力充沛
精卫填海
精妙绝伦
精彩逼人
精忠报国
精打细算
精明强干
精明能干
精疲力倦
精疲力尽
精疲力竭
精益求精
精神恍惚
精神抖擞
精神满腹
精神焕发
精神百倍
精美绝伦
精耕细作
精诚团结
精诚所至
精贯白日
精进勇猛
精采秀发
精金百炼
精金美玉
精金良玉
精锐之师
精雕细刻
糊口度日
糊里糊涂
糖舌蜜口
糖衣炮弹
糜躯碎首
糟糠之妻
糟糠之妻不下堂
糠菜半年粮
糠豆不赡
系铃解铃
系颈牵羊
系风捕影
系风捕景
系马埋轮
素不相能
素不相识
素丝羔羊
素丝良马
素口骂人
素昧平生
素昧生平
素未谋面
素车白马
素隐行怪
素餐尸位
索垢吹瘢
索垢寻疵
索然寡味
索然无味
索隐行怪
紧急关头
紧打慢敲
紧箍咒
紧行无好步
紧要关头
紧锣密鼓
紫气东来
紫绶金章
紫芝眉宇
累卵之危
累及无辜
累土聚沙
累土至山
累块积苏
累屋重架
累教不改
累月经年
累牍连篇
累瓦结绳
累累如珠
累苏积块
累苏积磈
累足成步
絮果兰因
絮絮叨叨
絮酒炙鸡
絶世无双
絶仁弃义
絶伦超羣
絶伦逸羣
絶后光前
絶后空前
絶圣弃智
絶圣弃知
絶地天通
絶处逢生
絶妙好词
絶妙好辞
絶少分甘
絶无仅有
絶甘分少
絶类离伦
絶类离羣
絶羣拔类
絶薪止火
絶长继短
絶长续短
絶长补短
絺句绘章
絺章绘句
絺章饰句
絺绘章句
絺辞绘句
綦溪利跂
繁丝急管
繁刑重赋
繁华损枝
繁弦急管
繁征博引
繁文末节
繁文缛礼
繁文缛节
繁枝细节
繁称博引
繁花似锦
繁荣兴旺
繁荣富强
繁荣昌盛
繁音促节
纚风沐雨
纠合之众
纠缠不清
纡佩金紫
纡尊降贵
纡朱怀金
纡朱拖紫
纡朱曳紫
纡金曳紫
纡青佩紫
纡青拕紫
纡青拖紫
红叶题诗
红情緑意
红情绿意
红愁绿惨
红旗报捷
红日三竿
红杏出墙
红灯緑酒
红炉点雪
红男緑女
红男绿女
红白喜事
红粉青楼
红紫乱朱
红紫夺朱
红绳系足
红腐贯朽
红衰翠减
红装素裹
红豆相思
红颜白发
红颜薄命
红飞翠舞
纤介之失
纤介之祸
纤尘不染
纤悉无遗
纤毫不爽
纤毫无爽
纤毫无犯
纤芥之疾
纤芥无爽
约定俗成
约法三章
纨绔子弟
纨绮子弟
纨袴子弟
纨袴膏粱
纪纲人论
纪群之交
纬地经天
纬武经文
纯一不杂
纯属骗局
纯正无邪
纲举目张
纲挈目张
纲提领挈
纲目不疏
纲纪废弛
纳垢藏污
纳士招贤
纳履决踵
纳履踵决
纳屦踵决
纳新吐故
纳污含垢
纳污藏垢
纳污藏疾
纳污藏秽
纳谏如流
纳贡称臣
纵曲枉直
纵横交贯
纵横交错
纵横天下
纵横开合
纵横开阖
纵横捭阖
纵横驰骋
纵虎出匣
纵虎出柙
纵虎归山
纵风止燎
纶巾羽扇
纶音佛语
纷乱如麻
纷红骇緑
纷红骇绿
纷纭杂沓
纷纷不一
纷纷扬扬
纷纷扰扰
纷纷拥拥
纷纷攘攘
纷纷洋洋
纷纷穰穰
纷纷籍籍
纷至沓来
纷至踏来
纸上空谈
纸上谈兵
纸上谭兵
纸短情长
纸笔喉舌
纸落云烟
纸贵洛城
纸贵洛阳
纸醉金迷
纹丝不动
纹丝没动
纹风不动
线断风筝
练兵秣马
练达老成
细不容发
细入毫芒
细大不捐
细大不踰
细大无遗
细微末节
细枝末节
细水长流
细针密线
细针密缕
细雨和风
织当访婢
织楚成门
织白守黑
织锦回文
终其天年
终南快捷方式
终南捷径
终天之恨
终始不渝
终始如一
终始若一
终成泡影
终焉之志
终而复始
终身大事
经世之才
经丘寻壑
经久不息
经史百子
经国之才
经国大业
经天纬地
经帮纬国
经年累月
经文纬武
经明行修
经武纬文
经济之才
经纬万端
经纬天下
经纬天地
经纶济世
经纶满腹
经营惨淡
经邦纬国
经邦论道
经验之谈
结不解缘
结党营私
结发夫妻
结结巴巴
结绳而治
结舌杜口
结舌钳口
结草衔环
结驷列骑
结驷连镳
结驷连骑
绕梁三日
绕梁之音
绘事后素
绘声写影
绘声绘形
绘声绘影
绘声绘色
绘影绘声
绚丽多彩
络绎不絶
络绎不绝
络驿不絶
绝世佳人
绝世无双
绝世独立
绝世超伦
绝人事
绝仁弃义
绝代佳人
绝伦逸群
绝其本根
绝口不道
绝后光前
绝国殊俗
绝圣弃智
绝处逢生
绝妙好辞
绝子绝孙
绝少分甘
绝无仅有
绝甘分少
绝色佳人
绝薪止火
绝裙而去
绝裾而去
绝路逢生
绝长继短
绝长续短
绝长补短
绝顶聪明
绞尽脑汁
统筹兼顾
绠短汲深
绠短絶泉
绠短绝泉
绣口锦心
绣花枕头
绣虎雕龙
继古开今
继往开来
继晷焚膏
继绝存亡
继继存存
继继承承
继继绳绳
绨袍之义
绩学之士
绫罗绸缎
续凫截鹤
续凫断鹤
续鹜短鹤
绮纨之岁
绮襦纨绔
绮襦纨袴
绰有余暇
绰有余裕
绰然有余
绰约多姿
绰绰有余
绰绰有裕
绳一戒百
绳之以法
绳先启后
绳其祖武
绳厥祖武
绳墨之言
绳床瓦灶
绳愆纠缪
绳愆纠谬
绳愆纠违
绳枢瓮牖
绳趋尺步
绳锯木断
维妙维肖
绵力薄材
绵延不断
绵绵不断
绵绵不絶
绵绵不绝
绵绵瓜瓞
绵绵缗缗
绵言细语
绵里薄材
绵里藏针
绷巴吊拷
绷扒吊拷
绷爬吊拷
绸缪帐扆
绸缪帷帐
绸缪帷幄
绸缪未雨
绸缪束薪
绸缪桑土
绸缪牖户
综核名实
绿林大盗
绿林好汉
绿林强盗
绿林豪士
绿林豪客
绿林豪杰
缀玉联珠
缄口不言
缄口无言
缄口结舌
缊褐瓢箪
缓不济急
缓兵之计
缓带轻裘
缓急相济
缓急轻重
缓歌慢舞
缓歌缦舞
缓步代车
缓步当车
缘悭一面
缘悭分浅
缘悭命蹇
缘情体物
缘文生义
缘木希鱼
缘木求鱼
缘鹄饰玉
缚舌交唇
缚鸡之力
缚鸡弄丸
缛礼烦仪
缝衣浅带
缟纻之交
缠夹不清
缠绵床褥
缠绵悱恻
缠绵缱绻
缠绵蕴藉
缧绁
缧绁之忧
缩地补天
缩头缩脑
缩头缩颈
缩屋称贞
缩手缩脚
缩衣啬食
缩衣节口
缩衣节食
缪力同心
缪种流传
缮甲治兵
缺一不可
缺口镊子
缺吃少穿
缺吃短穿
缺衣少食
缺食无衣
缾沈簪折
缾竭罍耻
缾罍之耻
罄山采木
罄竹难书
罄竹难穷
罄笔难书
网开一面
网开三面
网漏吞舟
罔极之恩
罔知所措
罕言寡语
罕譬而喻
罗之一目
罗掘一空
罗掘俱穷
罗敷有夫
罗纹结角
罗织构陷
罗织罪名
罗钳吉网
罗雀掘鼠
罚一劝百
罚不当罪
罚不责众
罢于奔命
罢黜百家
罪不可逭
罪不容诛
罪不胜诛
罪业深重
罪人不孥
罪人不帑
罪加一等
罪大恶极
罪孽深重
罪应万死
罪当万死
罪恶如山
罪恶昭彰
罪恶昭著
罪恶深重
罪恶滔天
罪恶贯盈
罪有应得
罪有攸归
罪该万死
罪责难逃
罪逆深重
罪魁祸首
置之不理
置之不论
置之不问
置之不顾
置之度外
置之弗论
置之死地
置之死地而后快
置之死地而后生
置之脑后
置之高阁
置棋不定
置水不漏
置水之情
置水之清
置若罔闻
置诸度外
置诸高阁
置身事外
置锥之地
羊入虎群
羊头狗肉
羊很狼贪
羊枣昌歜
羊毛出在羊身上
羊狠狼贪
羊续悬鱼
羊羔美酒
羊肠九曲
羊肠小道
羊肠鸟道
羊落虎口
羊触藩篱
羊质虎皮
羊踏菜园
羌无故实
美不胜收
美中不足
美人迟暮
美人香草
美女破舌
美女簪花
美如冠玉
美意延年
美景良辰
美玉无瑕
美男破老
美益求美
美芹之献
美言不信
美轮美奂
羚羊挂角
羝羊触藩
羞与为伍
羞与哙伍
羞人答答
羞以牛后
羞恼成怒
羞花闭月
羞面见人
羣分类聚
羣口铄金
羣居穴处
羣策羣力
羣而不党
羣蚁溃堤
羣蚁趋膻
羣蚁附膻
羣轻折轴
羣雌粥粥
羣魔乱舞
羣龙无首
群威群胆
群居穴处
群情鼎沸
群空冀北
群策群力
群而不党
群蚁溃堤
群蚁附膻
群起效尤
群起而攻之
群轻折轴
群雄逐鹿
群雌粥粥
群魔乱舞
群鸿戏海
群龙无首
羯鼓催花
羲皇上人
羹藜含糗
羹藜唅糗
羽扇纶巾
羽毛丰满
羽毛未丰
羽翮飞肉
羽翼已成
羽翼既成
羿射九日
羿氏舛射
翔鸾翥凤
翔鸾舞凤
翘足可待
翘足引领
翘足而待
翘首企足
翘首引领
翘首跂踵
翠围珠绕
翠围珠裹
翠尘珠坱
翠消红减
翠竹黄花
翠绕珠围
翠羽明珠
翠羽明珰
翠袖红裙
翠被豹舄
翥凤翔鸾
翦发待宾
翦草除根
翩其反矣
翩翩公子
翩翩少年
翩翩年少
翩翩起舞
翩翩风度
翩若惊鸿
翫岁愒月
翫日愒月
翰林子墨
翻云覆雨
翻唇弄舌
翻复无常
翻天作地
翻天覆地
翻天蹙地
翻山越岭
翻手云覆手雨
翻来覆去
翻江倒海
翻江搅海
翻然悔悟
翻然改图
翻然改悔
翻然改进
翻空出奇
翻箱倒柜
翻箱倒笼
翻箱倒箧
翻肠搅肚
翻衾倒枕
翻陈出新
翻黄倒皁
翻黄倒皂
翼翼小心
翼翼飞鸾
耀武扬威
耀祖荣宗
老之将至
老于世故
老僧入定
老医少卜
老大帝国
老大徒伤
老大徒伤悲
老大无成
老天拔地
老奸巨滑
老奸巨猾
老妪能解
老婆当军
老子长孙
老实巴交
老师宿儒
老弱残兵
老当益壮
老态龙钟
老成持重
老成炼达
老成练达
老成见到
老有所终
老朽无能
老枢能解
老死不相往来
老死牖下
老气横秋
老江湖
老泪纵横
老熊当道
老牛破车
老牛舐犊
老王卖瓜
老生常谈
老罴当道
老羞变怒
老羞成怒
老而不死
老而不死是为贼
老莱娱亲
老虎头上扑苍蝇
老虎头上搔痒
老蚌珠胎
老蚌生珠
老蚕作茧
老调重弹
老调重谈
老谋深算
老身长子
老迈龙钟
老马为驹
老马嘶风
老马恋栈
老马识途
老骥伏枥
老骥嘶风
老鹤乘轩
老鼠过街
考名责实
考绩幽明
耄安稚嬉
者也之乎
耆儒硕德
耆寿耇老
耆年硕德
耆德硕老
而今而后
而立之年
耍嘴皮子
耍花腔
耐人咀嚼
耐人寻味
耕当问奴
耕耘树艺
耗矣哀哉
耦俱无猜
耳后生风
耳后风生
耳听八方
耳听心受
耳报神
耳提面命
耳提面训
耳旁风
耳染目濡
耳根清净
耳根清浄
耳满鼻满
耳濡目击
耳濡目及
耳濡目染
耳熟能详
耳目一新
耳目众多
耳目昭彰
耳目股肱
耳目闭塞
耳红面赤
耳聪目明
耳视目听
耳视目食
耳软心活
耳边风
耳闻不如目见
耳闻不如面见
耳闻则诵
耳闻目击
耳闻目染
耳闻目睹
耳闻目见
耳闻目览
耳闻眼见
耳顺之年
耳食之言
耳食之论
耳食之谈
耳鬓厮磨
耳鬓撕磨
耳鬓斯磨
耸人听闻
耸入云霄
耸动听闻
耸壑凌霄
耸壑昂霄
耸肩曲背
耸肩缩背
耸膊成山
耻与哙伍
耻居人下
耻居王后
耻言人过
耽惊受怕
耿耿于心
耿耿于怀
聆音察理
聊以卒岁
聊以塞责
聊以自娱
聊以自慰
聊以解嘲
聊备一格
聊复尔尔
聊复尔耳
聊胜一筹
聊胜于无
聊表寸心
聋者之歌
联篇累牍
联翩而至
联袂而至
聚众滋事
聚少成多
聚敛无厌
聚沙成塔
聚米为山
聚米为谷
聚精会神
聚精凝神
聚萤映雪
聚萤积雪
聚蚊成雷
聚讼纷纭
聪明一世
聪明伶俐
聪明反被聪明误
聪明叡知
聪明才智
聪明智慧
聪明智能
聪明正直
聪明睿智
聪明睿知
聪明绝世
聪明自误
聱牙佶屈
聱牙戟口
聱牙诎曲
聱牙诘屈
聱牙诘曲
肃然生敬
肃然起敬
肆意妄为
肆意横行
肆无忌惮
肆虐横行
肆行无忌
肆言詈辱
肉中刺
肉山脯林
肉山酒海
肉朋酒友
肉眼凡夫
肉眼凡胎
肉眼惠眉
肉眼愚眉
肉薄骨并
肉袒牵羊
肉袒面缚
肉跳心惊
肉跳神惊
肉颤心惊
肉飞眉舞
肉食者鄙
肌劈理解
肘胁之患
肘腋之患
肘行膝步
肚里泪下
肚里蛔虫
肝心涂地
肝心若裂
肝肠寸断
肝胆披沥
肝胆楚越
肝胆欲碎
肝胆涂地
肝胆照人
肝胆相照
肝胆胡越
肝胆过人
肝脑涂地
肝髓流野
肠肥脑满
股战而栗
股掌之上
股肱之力
肤受之愬
肤受之言
肤受之诉
肤如凝脂
肤寸而合
肤末支离
肤皮潦草
肤粟股栗
肤见謭识
肤见谫识
肥冬瘦年
肥头大耳
肥头大面
肥头胖耳
肥甘轻暖
肥肠满脑
肥遁鸣高
肥遯鸣高
肥马轻裘
肥鱼大肉
肩从齿序
肩劳任怨
肩摩毂击
肩摩毂接
肩摩袂接
肩摩踵接
肩背相望
肩背难望
肯堂肯构
肯构肯堂
肺石风清
肺腑之言
胁不沾席
胁肩低眉
胁肩低首
胁肩累足
胁肩絫足
胁肩谄笑
胆丧魂惊
胆丧魂消
胆壮心雄
胆壮气粗
胆大于身
胆大包天
胆大如斗
胆大妄为
胆大心小
胆大心粗
胆大心细
胆大心雄
胆大心麄
胆大心麤
胆大泼天
胆寒发竖
胆小如豆
胆小如鼠
胆小如鼷
胆小怕事
胆战心寒
胆战心惊
胆战心慌
胆战心摇
胆破心寒
胆粗气壮
胆裂魂飞
胆颤心惊
背义忘恩
背义负信
背义负恩
背乡离井
背井离乡
背信弃义
背公向私
背公营私
背前面后
背城一战
背城借一
背山起楼
背恩弃义
背恩忘义
背恩负义
背惠食言
背暗投明
背曲腰弯
背曲腰躬
背本就末
背本趋末
背水一战
背生芒刺
背盟败约
背碑覆局
背腹受敌
背若芒刺
背道而驰
胜任愉快
胜友如云
胜残去杀
胜读十年书
胜败乃兵家常事
胝肩茧足
胡作乱为
胡作胡为
胡作非为
胡天胡地
胡天胡帝
胡思乱想
胡思乱量
胡打海摔
胡拉乱扯
胡搅蛮缠
胡支扯叶
胡服骑射
胡枝扯叶
胡猜乱想
胡肥锺瘦
胡行乱为
胡言乱语
胡言乱道
胡言汉语
胡诌乱扯
胡诌乱说
胡诌乱道
胡诌八扯
胡说乱道
胡说八道
胡说白道
胡越一家
胡越之祸
胡越同舟
胡里胡涂
胫大于股
胯下之辱
胯下蒲伏
胶柱调瑟
胶柱鼓瑟
胶鬲之困
胸中万卷
胸中垒块
胸中无数
胸中有数
胸中甲兵
胸中鳞甲
胸怀大志
胸怀磊落
胸无城府
胸无大志
胸无宿物
胸无成竹
胸无点墨
胸有丘壑
胸有城府
胸有悬镜
胸有成略
胸有成竹
胸有成算
胸有邱壑
胸有鳞甲
胼手胝足
胼胝手足
能上能下
能不称官
能伸能屈
能写会算
能屈能伸
能工巧匠
能征惯战
能掐会算
能文能武
能牙利齿
能者为师
能者多劳
能言善辩
能言巧辩
能言快语
能言快说
能说会道
能说惯道
能谋善断
能近取譬
脂膏不润
脂膏莫润
脆而不坚
脉脉含情
脉脉相通
脍炙人口
脏污狼藉
脑满肠肥
脚不沾地
脚不点地
脚心朝天
脚忙手乱
脚踏两只船
脚踏实地
脚高步低
脩辞立诚
脱口成章
脱口而出
脱壳金蝉
脱天漏网
脱手弹丸
脱白挂緑
脱白挂绿
脱缰之马
脱胎换骨
脱袍退位
脱颖囊锥
脱颖而出
脱骨换胎
脸无人色
脸红筋暴
脸红筋涨
脸红耳热
脸红耳赤
脸青鼻肿
脸黄肌瘦
腊尽春回
腥闻在上
腥风血雨
腥风醎雨
腰缠万贯
腰金拖紫
腰金衣紫
腰鼓兄弟
腹中兵甲
腹心之患
腹心之疾
腹心相照
腹有鳞甲
腹热心煎
腹热肠慌
腹热肠荒
腹背之毛
腹背受敌
腹诽心谤
腹载五车
腹非心谤
腹饱万言
腼颜事仇
腼颜事敌
腼颜人世
腼颜天壤
腾云驾雾
腾声飞实
腾焰飞芒
腾空而起
腾腾兀兀
腾蛟起凤
腾达飞黄
膏唇岐舌
膏唇拭舌
膏唇试舌
膏唇贩舌
膏场绣浍
膏梁子弟
膏梁纨袴
膏梁锦绣
膏泽脂香
膏火之费
膏火自煎
膏粱子弟
膏粱年少
膏粱文绣
膏粱纨袴
膏粱锦绣
膏肓之疾
膏腴之地
膏腴子弟
膏腴贵游
膏车秣马
膘肥体壮
膝痒搔背
膝行匍伏
膝行而前
膝行肘步
膝行蒲伏
膝语蛇行
膺图受箓
膺箓受图
臂有四肘
臣心如水
臣门如市
臧否人物
臧穀亡羊
臧谷亡羊
自不待言
自不量力
自业自得
自以为得计
自以为是
自作主张
自作聪明
自作自受
自作解人
自作门户
自信不疑
自僝自僽
自出一家
自出心裁
自出新裁
自出机杼
自出机轴
自刽以下
自力更生
自卖自夸
自厝同异
自取其咎
自取其祸
自取咎戾
自取灭亡
自取罪戾
自同寒蝉
自吹自捧
自吹自擂
自告奋勇
自命不凡
自命清高
自圆其说
自坏长城
自始自终
自始至终
自媒自衒
自寻烦恼
自寻短见
自崖而反
自弃自暴
自强不息
自得其乐
自怨自艾
自惭形秽
自愧不如
自愧弗如
自成一家
自成一格
自我作古
自我作故
自我吹嘘
自我牺牲
自我表现
自我解嘲
自我陶醉
自投网罗
自投罗网
自拔来归
自掘坟墓
自救不暇
自新之路
自暴自弃
自有公论
自树一帜
自欺欺人
自求多福
自然而然
自甘堕落
自甘暴弃
自生自灭
自用则小
自由放任
自由泛滥
自由自在
自相惊忧
自相惊扰
自相残害
自相残杀
自相水火
自相矛盾
自相鱼肉
自矜功伐
自知之明
自私自利
自立门户
自繇自在
自给自足
自行其是
自衒自媒
自视甚高
自觉形秽
自觉自愿
自言自语
自讨没趣
自讨苦吃
自诒伊戚
自负不凡
自贻伊咎
自贻伊戚
自身难保
自轻自贱
自郐以下
自郐无讥
自郐而下
自顾不暇
自食其力
自食其恶果
自食其果
自食其言
自高自大
自鸣得意
臭不可当
臭不可闻
臭名昭彰
臭名昭著
臭名远扬
臭味相投
臭肉来蝇
臭腐神奇
至亲好友
至亲骨肉
至人无梦
至公无我
至公无私
至再至三
至善至美
至圣先师
至圣至明
至大至刚
至尊至贵
至当不易
至德要道
至心朝礼
至死不二
至死不变
至死不悟
至死不渝
至死靡它
至理名言
至矣尽矣
至纤至悉
至诚高节
至高无上
致之度外
致远任重
臼头深目
臼杵之交
臼灶生蛙
舂容大雅
舄乌虎帝
舆死扶伤
舆论哗然
舌剑唇枪
舌剑唇鎗
舌尖口快
舌战群儒
舌挢不下
舌敝唇枯
舌敝唇焦
舌敝耳聋
舌桥不下
舌端月旦
舌锋如火
舍实听声
舍己为人
舍己为公
舍己从人
舍己就人
舍己成人
舍己救人
舍己芸人
舍我其谁
舍旧谋新
舍本从末
舍本求末
舍本逐末
舍死忘生
舍生取义
舍生取谊
舍生存义
舍生忘死
舍短取长
舍短録长
舍策追羊
舍经从权
舍身为国
舍身求法
舍近务远
舍近即远
舍近求远
舍近谋远
舍道用权
舐犊之爱
舐犊情深
舐痈吮痔
舐皮论骨
舐糠及米
舒头探脑
舒眉展眼
舛讹百出
舜日尧天
舜日尧年
舞凤飞龙
舞刀跃马
舞弄文墨
舞弊营私
舞文巧诋
舞文弄墨
舞文弄法
舞文玩法
舞文饰智
舞榭歌台
舞榭歌楼
舞爪张牙
舞笔弄文
舞衫歌扇
舞裙歌扇
舞词弄札
舟中敌国
舟水之喻
舟车劳顿
航海梯山
舳舻相继
船到桥头自会直
船到桥门自会直
船到桥门自然直
船到江心补漏迟
船坚炮利
船多不碍路
良宵好景
良宵美景
良工巧匠
良工心苦
良工苦心
良师益友
良师诤友
良弓无改
良时吉日
良时美景
良知良能
良禽择木
良药苦口
良莠不一
良莠不分
良莠不齐
良莠淆杂
良贾深藏
良辰吉日
良辰媚景
良辰美景
良金美玉
艰深晦涩
艰苦创业
艰苦卓絶
艰苦卓绝
艰苦奋斗
艰苦朴素
艰难困苦
艰难曲折
艰难玉成
艰难竭蹶
艰难险阻
色丝虀臼
色仁行违
色厉内荏
色厉胆薄
色如死灰
色授魂与
色胆包天
色胆如天
色胆迷天
色色俱全
色若死灰
色衰爱弛
色飞眉舞
艳如桃李
艳紫妖红
艳色绝世
艴然不悦
艺不压身
艺高胆大
节上生枝
节中长节
节变岁移
节哀顺变
节外生枝
节威反文
节用爱民
节用裕民
节衣素食
节衣缩食
芒刺在背
芒刺在躬
芒寒色正
芒屩布衣
芒然自失
芒芒苦海
芒鞋竹笠
芙蓉出水
芙蓉并蒂
芝兰之室
芝兰玉树
芝残蕙焚
芝焚蕙叹
芝艾俱焚
芝艾共焚
芝艾并焚
芝草无根
芟繁就简
芬芳馥郁
花下晒裈
花信年华
花前月下
花团锦簇
花堆锦簇
花天酒地
花天锦地
花好月圆
花容月貌
花攒绮簇
花攒锦簇
花攒锦聚
花明柳媚
花明柳暗
花晨月夕
花朝月夕
花朝月夜
花枝招展
花枝招颤
花枝招颭
花枝招飐
花样新翻
花样翻新
花残月缺
花烛洞房
花甲之年
花簇锦攒
花红柳緑
花红柳绿
花花世界
花花公子
花花太岁
花花绿绿
花营锦阵
花街柳巷
花街柳市
花街柳陌
花衢柳陌
花言巧语
花说柳说
花貌蓬心
花貎蓬心
花辰月夕
花遮柳掩
花遮柳隐
花里胡哨
花锦世界
花阶柳市
花颜月貌
花香鸟语
芳兰竟体
芳年华月
芸芸众生
苌弘化碧
苌弘碧血
苍松翠柏
苍狗白云
苍狗白衣
苍生涂炭
苍白无力
苍翠欲滴
苍蝇见血
苍颜白发
苍髯如戟
苍黄反复
苍黄翻复
苍黄翻覆
苏海韩潮
苗而不秀
苛捐杂税
苛政猛于虎
苞苴竿牍
苞藏祸心
苟且之心
苟且偷安
苟且偷生
苟且因循
苟全性命
苟合取容
苟安一隅
苟延残喘
苟延残息
若不胜衣
若丧考妣
若出一轨
若出一辙
若即若离
若卵投石
若合符节
若存若亡
若崩厥角
若敖之鬼
若敖鬼馁
若无其事
若明若昧
若明若暗
若有所丧
若有所亡
若有所失
若有所思
若有若无
若涉渊冰
若涉渊水
若烹小鲜
若离若即
若释重负
若隐若显
若隐若现
苦不可言
苦不堪言
苦中作乐
苦乐不均
苦口婆心
苦口恶石
苦口良药
苦口逆耳
苦大仇深
苦尽甘来
苦尽甜来
苦心孤诣
苦心积虑
苦心经营
苦思冥想
苦海无边
苦海茫茫
苦身焦思
苦难深重
苦雨凄风
苫眼铺眉
英声欺人
英声茂实
英姿勃勃
英姿勃发
英姿焕发
英姿飒爽
英英玉立
英雄入彀
英雄所见略同
英雄无用武之地
英雄本色
英雄欺人
英雄气短
英雄豪杰
英雄辈出
英风亮节
苴茅焘土
苴茅裂土
茁壮成长
茂林修竹
范张鸡黍
范水模山
茅塞顿开
茅室蓬户
茅屋采椽
茅庐三顾
茅茨不翦
茅茨土阶
茕茕孑立
茧丝牛毛
茫无头绪
茫无所知
茫无涯际
茫无端绪
茫无边际
茫然不解
茫然自失
茫然若失
茫茫苦海
茵席之臣
茶余酒后
茶余饭后
茶余饭饱
茶饭无心
茹古涵今
茹柔吐刚
茹毛饮血
茹苦含辛
荆人涉澭
荆天棘地
荆山之玉
荆棘丛生
荆棘塞途
荆棘满途
荆棘载途
荆棘铜驼
荆榛满目
荆钗布裙
草偃风从
草偃风行
草创未就
草头天子
草庐三顾
草木俱朽
草木愚夫
草木皆兵
草木知威
草木萧疏
草满囹圄
草率从事
草率将事
草率收兵
草腹菜肠
草船借箭
草芥人命
草草了事
草草收兵
草莽英雄
草菅人命
草薙禽狝
草蛇灰线
草行露宿
草衣木食
草长莺飞
草间求活
草靡风行
荒唐无稽
荒子孱孙
荒无人烟
荒时暴月
荒淫无度
荒淫无耻
荒淫无道
荒诞不经
荒诞无稽
荒谬絶伦
荒谬绝伦
荜路蓝缕
荜门圭窦
荜门委巷
荜露蓝蒌
荟萃一堂
荡产倾家
荡析离居
荡检踰闲
荡检逾闲
荡气回肠
荡海拔山
荡然无存
荡魂摄魄
荣华富贵
荣古虐今
荣古陋今
荣宗耀祖
荣谐伉俪
荦荦大端
荦荦大者
荦荦确确
荫子封妻
药到病除
药店飞龙
药石之言
药笼中物
荷枪实弹
荷橐持筹
荼毒生民
荼毒生灵
莞尔而笑
莫为已甚
莫之与京
莫予毒也
莫余毒也
莫可名状
莫可奈何
莫可究诘
莫名其妙
莫展一筹
莫敢谁何
莫明其妙
莫此为甚
莫测高深
莫知所为
莫衷一是
莫辨楮叶
莫逆之交
莫逆于心
莫须有
获兔烹狗
获陇望蜀
获隽公交车
获隽公车
莺俦燕侣
莺吟燕儛
莺吟燕舞
莺啼燕语
莺声燕语
莺巢燕垒
莺期燕约
莺歌燕舞
莺歌燕语
莺歌蝶舞
莺猜燕妒
莺闺燕阁
莺飞燕舞
莺飞草长
莼羹鲈脍
莼鲈之思
菊老荷枯
菜蔬之色
菩萨低眉
菱角磨作鸡头
菲食薄衣
菽水承欢
萁豆相煎
萍水相逢
萍踪浪影
萍踪浪迹
萍飘蓬转
萎糜不振
萎靡不振
萤灯雪屋
萤窗雪案
营私作弊
营私植党
营私罔利
营私舞弊
营营苟苟
营营逐逐
营蝇斐锦
萦肠惹肚
萧墙祸起
萧曹避席
萧然物外
萧规曹随
萧郎陌路
萱花椿树
落井下石
落井投石
落叶归根
落叶知秋
落地生根
落拓不羁
落月屋梁
落汤螃蟹
落纸云烟
落花无言
落花时节
落花流水
落英缤纷
落草为寇
落荒而走
落荒而逃
落落大方
落落寡合
落落穆穆
落落难合
落阱下石
落雁沉鱼
落魄不偶
落魄不羁
落魄江湖
落鴈沉鱼
葑菲之采
著书立说
著于竹帛
著作等身
著述等身
葛屦履霜
董狐之笔
董狐直笔
葫芦依样
葬身鱼腹
葭莩之亲
葵藿倾阳
蒙以养正
蒙在鼓里
蒙头转向
蒙尘
蒙昧无知
蒙混过关
蒙袂辑屦
蒙面丧心
蒲柳之姿
蒲柳之质
蒲鞭之罚
蒲鞭示辱
蒸沙成饭
蒸蒸日上
蒸蒸日盛
蒸蒸日进
蒹葭之思
蒹葭伊人
蒹葭倚玉
蒹葭倚玉树
蒹葭玉树
蒿目时艰
蓄精养鋭
蓄精养锐
蓝田生玉
蓬头历齿
蓬头厉齿
蓬头垢面
蓬头赤脚
蓬头跣足
蓬户柴门
蓬户瓮牖
蓬生麻中
蓬筚生辉
蓬荜生辉
蓬赖麻直
蓬门生辉
蓬门筚户
蓬门荜户
蓬首垢面
蓼虫忘辛
蔑伦悖理
蔓引株求
蔓引株连
蔓草难除
蔓蔓日茂
蔚为大观
蔚成风气
蔚然成风
蔼然仁者
蔼然可亲
蔽日干云
蔽日遮天
蔽明塞聪
蔽聪塞明
蕙心兰质
蕙心纨质
蕙折兰摧
蕙损兰摧
蕙质兰心
蕞尔弹丸
蕤宾铁响
薄命佳人
薄唇轻言
薄寒中人
薄情无义
薄技在身
薄暮冥冥
薄物细故
薏苡之谗
薏苡之谤
薏苡明珠
薏苡蒙谤
薪尽火传
薪尽火灭
薪桂米珠
薮中荆曲
薰天赫地
薰莸不同器
薰莸同器
藉草枕块
藏之名山
藏器待时
藏垢纳污
藏头亢脑
藏头露尾
藏巧于拙
藏弓烹狗
藏形匿影
藏怒宿怨
藏污纳垢
藏诸名山
藏踪蹑迹
藏锋敛鋭
藏锋敛锐
藏锋敛锷
藏锋敛颖
藏龙卧虎
藕断丝联
藕断丝连
藕断丝长
虎不食儿
虎体元斑
虎体原斑
虎体熊腰
虎体鹓班
虎兕出柙
虎党狐侪
虎入羊群
虎卧龙跳
虎变龙蒸
虎口余生
虎口扳须
虎口拔牙
虎口拔须
虎口逃生
虎咽狼飡
虎咽狼餐
虎啸狼号
虎啸风生
虎啸风驰
虎啸龙吟
虎头燕颔
虎头燕额
虎头虎脑
虎头蛇尾
虎子狼孙
虎尾春冰
虎据龙蟠
虎掷龙拿
虎掷龙挐
虎斗龙争
虎步龙行
虎狼之势
虎珀拾芥
虎略龙韬
虎皮羊质
虎目豕喙
虎穴得子
虎穴狼巢
虎穴龙潭
虎窟龙潭
虎而冠
虎背熊腰
虎荡羊群
虎落平川
虎落平阳
虎视眈眈
虎视耽耽
虎视鹰扬
虎视鹰瞵
虎超龙骧
虎跃龙骧
虎踞鲸吞
虎踞龙盘
虎踞龙蟠
虚与委蛇
虚位以待
虚嘴掠舌
虚堂悬镜
虚室生白
虚左以待
虚己以听
虚己受人
虚应故事
虚废词说
虚度年华
虚张声势
虚往实归
虚心冷气
虚心平意
虚怀若谷
虚情假意
虚文缛礼
虚文缛节
虚无恬惔
虚无恬淡
虚无缥缈
虚无飘渺
虚晃一枪
虚有其表
虚构无端
虚生浪死
虚美隐恶
虚舟飘瓦
虚虚实实
虚论高议
虚词诡说
虚骄恃气
虫书鸟篆
虫书鸟迹
虫叶成字
虫沙猿鹤
虫臂拒辙
虫臂鼠肝
虫言鸟迹
虫鱼之学
虫鸣螽跃
虮虱相吊
虱处裈中
虱多不痒
虱胫虮肝
虹销雨霁
虽有搞暴
虽死犹生
虽覆能复
虾兵蟹将
蚁封穴雨
蚁拥蜂攒
蚁斗蜗争
蚁溃鼠骇
蚁穴坏堤
蚁穴溃堤
蚁穴自封
蚁聚蜂屯
蚁聚蜂攒
蚁聚蠭攒
蚁膻鼠腐
蚁萃螽集
蚁附蜂屯
蚁附蝇集
蚁集蜂攒
蚂蚁缘槐
蚊思负山
蚊虻负山
蚌病成珠
蚌病生珠
蚌鹬相持
蚍蜉戴盆
蚍蜉撼大木
蚍蜉撼大树
蚍蜉撼树
蚕丛鸟道
蚕头燕尾
蚕绩蟹匡
蚕食鲸吞
蚤入晏出
蚤兴夜寐
蚤出夜入
蚤出莫入
蚤朝晏罢
蚤朝晏退
蚤谋先定
蛇入鼠出
蛇口蜂针
蛇头蝎尾
蛇头鼠眼
蛇影杯弓
蛇心佛口
蛇杯弓影
蛇欲吞象
蛇毛马角
蛇灰蚓线
蛇珠雀环
蛇盘鬼附
蛇神牛鬼
蛇蝎为心
蛇蝎心肠
蛇螫断腕
蛇蟠蚓结
蛇行鳞潜
蛇行鼠步
蛇雀之报
蛇食鲸吞
蛊心丧志
蛊惑人心
蛙蟆胜负
蛙鸣狗吠
蛙鸣蚓叫
蛙鸣蝉噪
蛙鸣鸱叫
蛛丝马迹
蛛游蜩化
蛛网尘封
蛟龙失水
蛟龙得水
蛟龙戏水
蛟龙擘水
蛮不在乎
蛮不讲理
蛮云瘴雨
蛮云蜑雨
蛮来生作
蛮横无理
蛮歌獠语
蛮烟瘴雨
蛮烟瘴雾
蛮睫螳轮
蛮笺象管
蛮触相争
蛮风瘴雨
蛾度虵行
蛾眉曼睩
蛾眉皓齿
蛾眉螓首
蛾附蠭屯
蜀犬吠日
蜀锦吴绫
蜂出泉流
蜂合蚁聚
蜂合豕突
蜂媒蝶使
蜂屯乌合
蜂屯蚁杂
蜂屯蚁聚
蜂屯蚁附
蜂房蚁穴
蜂扇蚁聚
蜂拥而上
蜂拥而来
蜂拥而至
蜂拥蚁屯
蜂拥蚁聚
蜂攒蚁聚
蜂攒蚁集
蜂游蝶舞
蜂狂蝶乱
蜂猜蝶觑
蜂目豺声
蜂窠蚁穴
蜂腰削背
蜂腰猿背
蜂腰鹤膝
蜂营蚁队
蜂虿之祸
蜂虿作于怀袖
蜂虿有毒
蜂虿起怀
蜂识莺猜
蜂起云涌
蜂趋蚁附
蜂迷蝶恋
蜂迷蝶猜
蜂附云集
蜃楼山市
蜃楼海市
蜉蝣撼大树
蜕化变质
蜕故孳新
蜗名微利
蜗名蝇利
蜗舍荆扉
蜗行牛步
蜗角之争
蜗角斗争
蜗角虚名
蜗角蚊睫
蜗角蝇头
蜘丝马迹
蜚瓦拔木
蜚短流长
蜚英腾茂
蜚蓬之问
蜚黄腾达
蜜口剑腹
蜜语甜言
蜜里藏刀
蜜里调油
蜩螗沸羹
蜱蜉戴盆
蜻蜓撼石柱
蜻蜓点水
蝇名蜗利
蝇声蚓窍
蝇声蛙噪
蝇声蛙躁
蝇头小利
蝇头小楷
蝇头微利
蝇头蜗角
蝇攒蚁聚
蝇攒蚁附
蝇粪点玉
蝇营狗苟
蝇营蚁聚
蝇营蚁附
蝇营鼠窥
蝇附骥尾而致千里
蝇随骥尾
蝇集蚁附
蝇飞蚁聚
蝉不知雪
蝉喘雷干
蝉緌蟹匡
蝉联往复
蝉联蚕绪
蝉腹龟肠
蝉蜕蛇解
蝉蜕龙变
蝉衫麟带
蝎蝎螫螫
蝘蜓嘲龙
蝮螫解腕
蝶使蜂媒
蝶化庄周
蝶化庄生
蝶怨蛩凄
蝶恋蜂狂
蝶意莺情
蝶粉蜂黄
蝼蚁贪生
融为一体
融会贯通
融会通浃
融汇贯通
融洽无间
融液贯通
融释贯通
螓首蛾眉
螫手解腕
螭盘虎踞
螭鬽魍魉
螭魅罔两
螭魅魍魉
螳臂当车
螳臂当辙
螳臂扼辙
螳臂挡车
螳蜋之卫
螳蜋奋臂
螳螂奋臂
螳螂拒辙
螳螂黄雀
螽斯振羽
螽斯衍庆
螽羽诜诜
蟒袍玉带
蟠天际地
蟠委错紾
蟠屈缭纠
蟠据固结
蟠木朽株
蟠根错节
蟠结根据
蟠青丛翠
蟠龙卧虎
蟠龙踞虎
蟹匡蝉緌
蟾宫扳桂
蟾宫折桂
蠒丝牛毛
蠖屈不伸
蠖屈求伸
蠖屈蜗潜
蠖屈螭盘
蠖屈鼠伏
蠡测管窥
蠡酌管窥
蠢动含灵
蠢蠢思动
蠢蠢欲动
蠲敝崇善
蠹众木折
蠹啄剖梁柱
蠹国嚼民
蠹国害民
蠹国殃民
蠹国残民
蠹国病民
蠹国耗民
蠹居棊处
蠹居棋处
蠹政害民
蠹政病民
蠹民梗政
蠹简遗编
血债累累
血光之灾
血口喷人
血国三千
血性男儿
血战到底
血染沙场
血气之勇
血气方刚
血气方壮
血气方盛
血泪斑斑
血泪盈襟
血流如注
血流成河
血流成渠
血流漂卤
血流漂杵
血海冤仇
血海尸山
血海深仇
血盆大口
血竭髯枯
血肉模糊
血肉横飞
血肉相联
血肉相连
血迹斑斑
血雨腥风
血风肉雨
衅发萧墙
衅稔恶盈
衅起萧墙
行不从径
行不副言
行不履危
行不得也哥哥
行不由径
行不胜衣
行不苟合
行不贰过
行不踰方
行不逾方
行之有效
行云流水
行住坐卧
行侠好义
行兵布阵
行动坐卧
行古志今
行号卧泣
行号巷哭
行合趋同
行同狗彘
行同狗豨
行同能偶
行奸卖俏
行家里手
行将就木
行尸走肉
行尸走骨
行崄侥幸
行己有耻
行师动众
行思坐忆
行思坐想
行思坐筹
行成于思
行易知难
行有余力
行步如飞
行浊言清
行百里者半九十
行百里者半于九十
行眠立盹
行者让路
行色匆匆
行色怱怱
行色悤悤
行若无事
行若狗彘
行藏用舍
行行出状元
行行蛇蚓
行踪无定
行远升高
行远自迩
行针步线
行间字里
行险徼幸
行香挂牌
衒玉求售
衒玉自售
衒玉贾石
衔冤负屈
衔华佩实
衔尾相随
衔悲茹恨
衔枚疾走
衔橛之变
衔橛之虞
衔橜之变
衔橜之虞
衔沙填海
衔玉贾石
衔环结草
衔石填海
衔胆栖冰
街号巷哭
街坊四邻
街坊邻里
街头巷尾
街头巷底
街巷阡陌
街谈巷议
街谈巷语
街谈巷说
街谈巷谚
街谭巷议
衙官屈宋
衡情酌理
衡短论长
衡石程书
衡石量书
衡虑困心
衡门深巷
衡阳雁断
衣不兼彩
衣不兼采
衣不完采
衣不曳地
衣不蔽体
衣不解带
衣不遮体
衣不遮身
衣不重帛
衣不重彩
衣不重采
衣冠优孟
衣冠土枭
衣冠扫地
衣冠枭獍
衣冠楚楚
衣冠济楚
衣冠济济
衣冠礼乐
衣冠禽兽
衣冠齐楚
衣单食薄
衣妆楚楚
衣宵食旰
衣宽带松
衣屩蓝缕
衣带一江
衣弊履穿
衣敝履空
衣无二彩
衣架饭囊
衣架饭袋
衣狐坐熊
衣租食税
衣紫腰金
衣紫腰银
衣紫腰黄
衣绣夜游
衣绣夜行
衣绣昼行
衣衫蓝缕
衣衫褴褛
衣被群生
衣裳之会
衣裳槅子
衣裳盟会
衣轻乘肥
衣钵相传
衣锦夜游
衣锦夜行
衣锦昼游
衣锦昼行
衣锦荣归
衣锦褧衣
衣锦过乡
衣锦还乡
衣锦食肉
衣食不周
衣食住行
衣食父母
衣食税租
衣食饭碗
衣香人影
衣香髻影
衣香鬓影
衣马轻肥
补偏救弊
补厥挂漏
补天柱地
补天浴日
补残守缺
补漏订讹
补牢顾犬
补苴罅漏
补过拾遗
补过饰非
补阙拾遗
补阙挂漏
补阙灯檠
表壮不如理壮
表壮不如里壮
表里一致
表里不一
表里为奸
表里受敌
表里如一
表里山河
表里相依
表里相应
表里相济
表里相符
表面文章
衮实无阙
衮衣以归
衮衣西归
衮衮诸公
衰当益壮
衽扱囊括
衽革枕戈
衾寒枕冷
衾影无惭
衾影独对
袁安高卧
袂云汗雨
袂接肩摩
袅娜娉婷
袅袅亭亭
袅袅余音
袅袅娉娉
袅袅娜娜
袅袅婷婷
袍笏登场
袒胸露背
袒臂挥拳
袒裼裸裎
袖中挥拳
袖手充耳
袖手旁观
袖里乾坤
袖里玄机
袪衣受业
被发佯狂
被发入山
被发左衽
被发左袵
被发文身
被发缨冠
被发详狂
被发跣足
被坚执鋭
被坚执锐
被宠若惊
被山带河
被朱佩紫
被泽蒙庥
被甲执兵
被甲执鋭
被甲持兵
被甲据鞍
被甲枕戈
被甲载兵
被绣之牺
被绣昼行
被褐怀宝
被褐怀玉
被褐怀珠
被褐藏辉
被赭贯木
袭人故智
袭冶承弓
袭凡蹈故
袭常缀琐
袭故蹈常
袭衣兼食
裁书叙心
裁云剪水
裁云翦水
裁心镂舌
裁月镂云
裁红点翠
裁长补短
裂冠毁冕
裂土分茅
裂地分茅
裂眦嚼齿
裂石流云
裂石穿云
裂裳衣疮
裂裳裹膝
裂裳裹足
装傻充愣
装妖作怪
装怯作勇
装模作样
装模做样
装模装样
装潢门面
装点门面
装疯作傻
装疯卖俏
装疯卖傻
装痴作傻
装痴作态
装痴卖傻
装神弄鬼
装聋作哑
装聋做哑
装聋卖傻
装聋装哑
装腔作势
装腔作态
装葱卖蒜
装虚作假
裒多增寡
裒多益寡
裕后光前
裕国足民
裕民足国
裘弊金尽
裘敝金尽
裘马声色
裘马清狂
裘马轻狂
裘马轻肥
裙屐少年
裙布荆钗
裙带关系
裸袖揎拳
裸袖揎衣
裸裎袒裼
裹尸马革
裹粮坐甲
裹血力战
裹足不前
裾马襟牛
褎如充耳
褎然举首
褎然冠首
褎然居首
褐衣不完
褐衣蔬食
褒善贬恶
褒衣博带
褒衣危冠
褒贬与夺
褚小怀大
褚小杯大
褪后趋前
褭褭亭亭
褭褭婷婷
褴褛筚路
襃衣博带
襟怀坦白
襟怀洒落
襟怀磊落
襟江带湖
襟裾马牛
西台痛哭
西子捧心
西山日薄
西方净国
西方净土
西方浄国
西方浄土
西施捧心
西眉南脸
西窗剪烛
西窗翦烛
西装革履
西赆南琛
西邻责言
西除东荡
西颦东效
西风残照
西风落叶
西食东眠
西鹣东鲽
要价还价
要利盗名
要好成歉
要害之地
要死要活
要而言之
要而论之
要言不烦
要言妙道
覆亡无日
覆公折足
覆军杀将
覆前戒后
覆去翻来
覆地翻天
覆宗灭祀
覆巢无完卵
覆巢毁卵
覆巢破卵
覆是为非
覆水不收
覆水难收
覆海移山
覆盂之安
覆盆之冤
覆盆难照
覆窟倾巢
覆舟之戒
覆蕉寻鹿
覆车之戒
覆车之轨
覆车之鉴
覆车继轨
覆酱烧薪
覆雨翻云
覆鹿寻蕉
覆鹿遗蕉
覩始知终
覩着知微
见世生苗
见义勇为
见义当为
见义必为
见义敢为
见事生风
见事风生
见仁见智
见兔放鹰
见兔顾犬
见其一未见其二
见几而作
见利忘义
见利思义
见势不妙
见危授命
见危致命
见卵求鸡
见可而进
见哭兴悲
见善必迁
见噎废食
见墙见羹
见多识广
见始知终
见小暗大
见小闇大
见幾而作
见异思迁
见弃于人
见弹求鸮
见弹求鹗
见微知着
见微知萌
见微知著
见德思齐
见性成佛
见怪不怪
见怪非怪
见惯不惊
见惯司空
见所不见
见所未见
见时知几
见景生情
见智见仁
见机而作
见机而行
见机行事
见死不救
见溺不救
见物不见人
见猎心喜
见神见鬼
见笑大方
见精识精
见素抱朴
见经识经
见缝插针
见羹见墙
见诮大方
见豕负涂
见貌辨色
见财起意
见贤思齐
见钱眼开
见钱眼红
见雀张罗
见鞍思马
见风使帆
见风使舵
见风使船
见风是雨
见风转篷
见风转舵
观今宜鉴古
观化听风
观场矮人
观山玩水
观山翫水
观形察色
观往知来
观望不前
观机而作
观机而动
观眉说眼
观者云集
观者如云
观者如垛
观者如堵
观者如市
观者如织
观者成堵
观衅伺隙
观貌察色
观过知仁
观隅反三
观风察俗
规圆矩方
规天矩地
规旋矩折
规求无度
规矩准绳
规矩绳墨
规矩钩绳
规绳矩墨
规行矩止
规行矩步
规言矩步
规贤矩圣
规重矩叠
规重矩迭
觅迹寻踪
视下如伤
视丹如緑
视丹如绿
视为儿戏
视为寇雠
视为畏途
视为知己
视人如伤
视人如子
视同一律
视同儿戏
视同拱璧
视同秦越
视同路人
视同陌路
视如土芥
视如寇仇
视如敝屐
视如敝屣
视如珍宝
视如粪土
视如草芥
视如陌路
视微知着
视微知著
视日如年
视死如归
视死如生
视死如饴
视死犹归
视死若归
视死若生
视民如伤
视民如子
视而不见
视若儿戏
视若无睹
视若路人
视财如命
视远步高
视险如夷
视险若夷
览闻辩见
觉人觉世
角巾东路
角巾私第
角户分门
角立杰出
觞酒豆肉
解人难得
解兵释甲
解剑拜仇
解发佯狂
解囊相助
解弦更张
解民倒悬
解甲休兵
解甲休士
解甲倒戈
解甲归田
解甲投戈
解疑释惑
解纷排难
解衣包火
解衣卸甲
解衣抱火
解衣推食
解衣槃磅
解衣盘磅
解衣盘礴
解衣磅礴
解衣般礴
解衣衣人
解铃系铃
解铃还是系铃人
解铃还需系铃人
解铃还须系铃人
解铃须用系铃人
解骖推食
解黏去缚
觥筹交错
觥饭不及壶飧
触地号天
触处机来
触手可及
触手生春
触斗蛮争
触景伤心
触景伤怀
触景伤情
触景生情
触机便发
触物伤情
触物兴怀
触目伤心
触目伤怀
触目儆心
触目兴叹
触目如故
触目崩心
触目恸心
触目惊心
触目成诵
触目皆是
触目经心
触目警心
触石决木
触类旁通
触类而通
触类而长
言三语四
言不二价
言不及义
言不及行
言不尽意
言不由中
言不由衷
言不达意
言不逮意
言不顾行
言与心违
言中事隐
言为心声
言之不预
言之凿凿
言之成理
言之无物
言之有序
言之有故
言之有物
言之有理
言之有礼
言之过甚
言人人殊
言从计听
言从计纳
言从计行
言传身教
言信行果
言信行直
言出法随
言出祸从
言出祸随
言十妄九
言发祸随
言听事行
言听行从
言听计从
言听计用
言听计行
言听谋决
言和意顺
言外之味
言外之意
言多伤倖
言多伤幸
言多伤行
言多必失
言归于好
言归和好
言归正传
言必有中
言必有据
言必有物
言扬行举
言提其耳
言文行远
言方行圆
言无不尽
言无二价
言无伦次
言是人非
言有尽而意无穷
言来语去
言气卑弱
言清行浊
言犹在耳
言笑不苟
言笑晏晏
言笑自如
言笑自若
言简义丰
言简意少
言简意深
言简意该
言简意赅
言类悬河
言约旨远
言者不知
言者弗知
言而不信
言而无信
言而有信
言芳行洁
言若悬河
言行一致
言行不一
言行不符
言行不贰
言行信果
言行抱一
言行相副
言行相悖
言行相符
言行相诡
言行相顾
言行若一
言行计从
言论风生
言语妙天下
言语路絶
言语路绝
言语道断
言谈举止
言谈林薮
言过其实
言近意远
言近指远
言近旨远
言重九鼎
言颠语倒
言高语低
詀言詀语
詈夷为跖
詟谀立懦
詹言曲说
詹詹炎炎
誉不绝口
誉满天下
誓不两立
誓以皦日
誓同生死
誓天指日
誓天断发
誓山盟海
誓日指天
誓死不二
誓死不屈
誓死不渝
誓死不贰
誓海盟山
諠客夺主
謷牙诘屈
警愦觉聋
计上心头
计上心来
计不反顾
计不旋跬
计不旋踵
计不返顾
计伐称勋
计出万全
计出万死
计出无奈
计出无聊
计功受爵
计功受赏
计功程劳
计功行封
计功行赏
计功补过
计功谋利
计功量罪
计勋行赏
计合谋从
计将安出
计尽力穷
计斗负才
计无付之
计无复之
计无所之
计无所出
计无所施
计无由出
计无返顾
计日以俟
计日以待
计日以期
计日可待
计日可期
计日奏功
计日指期
计日程功
计日而俟
计日而待
计深虑远
计然之术
计然之策
计研心筭
计研心算
计穷力尽
计穷力屈
计穷力极
计穷力竭
计穷力诎
计穷势蹙
计穷势迫
计穷智极
计穷智短
计穷虑尽
计穷虑极
计穷途拙
计绌方匮
计获事足
计行虑义
计行言听
计较锱铢
计过自讼
认仇作父
认奴作郎
认奴作郞
认影为头
认影迷头
认敌作父
认祖归宗
认贼为子
认贼为父
认贼作子
认贼作父
认鸡作凤
讨价还价
讨恶翦暴
讨是寻非
讨流泝源
讨流溯源
讨类知原
让三让再
让再让三
让枣推梨
让逸竞劳
讪牙闲嗑
讪皮讪脸
讫情尽意
讬孤寄命
训格之言
训练有素
议不反顾
议事日程
议论纷纭
议论纷纷
议论纷错
议论英发
议论风发
议论风生
记功忘失
记功忘过
记忆犹新
记问之学
讲信修睦
讲古论今
讲文张字
讲是说非
讲经说法
讳兵畏刑
讳恶不悛
讳树数马
讳疾忌医
讳莫如深
讳莫高深
讴功颂德
讷口少言
讷言敏行
讹以传讹
讹以滋讹
讹言惑众
论世知人
论今说古
论列是非
论功受赏
论功封赏
论功行封
论功行赏
论千论万
论德使能
论心定罪
论甘忌辛
论短道长
论议风生
论资排辈
论辩风生
论道经邦
论长说短
论长道短
论高寡合
论黄数白
论黄数黑
讽一劝百
讽多要寡
讽德诵功
设心处虑
设心积虑
设身处地
访亲问友
访贫问苦
证据确凿
证龟成鳖
诃佛诋巫
诃佛骂祖
评功摆好
评头品足
评头论脚
评头论足
识二五而不知十
识变从宜
识字知书
识微知着
识微知著
识微见几
识微见远
识才尊贤
识文断字
识文谈字
识时务者为俊杰
识时达务
识时达变
识时通变
识明智审
识涂老马
识礼知书
识途老马
诈哑佯聋
诈奸不及
诈痴不颠
诈痴佯呆
诈败佯输
诌上抑下
词不达意
词不逮意
词不逮理
词严义密
词严义正
词华典赡
词无枝叶
词正理直
词清讼简
词穷理尽
词穷理屈
词穷理极
词穷理絶
词穷理绝
词约指明
词言义正
词钝意虚
诎寸信尺
诎要桡腘
试金石
诗中有画
诗书发冢
诗云子曰
诗以言志
诗家三昧
诗庭之训
诗情画意
诗朋酒侣
诗朋酒友
诗礼之家
诗礼之训
诗礼人家
诗礼传家
诗肠鼓吹
诗酒朋侪
诗酒风流
诘屈磝碻
诘屈聱牙
诘屈謷牙
诘戎治兵
诘曲聱牙
诘诎聱牙
诚心实意
诚心正意
诚心诚意
诚惶诚恐
诚至金开
诛尽杀絶
诛尽杀绝
诛心之论
诛故贳误
诛暴讨逆
诛求不已
诛求无厌
诛求无已
诛求无度
诛锄异己
话不投机
话不相投
话不虚传
话中带刺
话中有话
话言话语
话里带刺
话里有刺
话里有话
话里藏阄
话长说短
诞妄不经
诞幻不经
诞罔不经
诞谩不经
诟如不闻
诟龟呼天
诠才末学
诡变多端
诡形奇制
诡秘莫测
诡衔窃辔
诡言浮说
诡计多端
诡诞不经
诡谲多变
诡谲怪诞
诡雅异俗
询事考言
询于刍荛
询根问底
询谋佥同
询谋谘度
询迁询谋
详情度理
详星拜斗
诪张为幻
诪张变眩
诬良为盗
语不惊人
语不投机
语出月胁
语四言三
语妙天下
语妙絶伦
语妙绝伦
语无伦次
语无诠次
语焉不详
语短情长
语笑喧呼
语笑喧哗
语笑喧阗
语简意赅
语言无味
语近指远
语近词冗
语重心沉
语重心长
语重情深
语长心重
误人子弟
误付洪乔
误作非为
误入歧途
误国殃民
误打误撞
误认颜标
诱掖后进
诱掖奖劝
诱掖奬劝
诱敌深入
诱秦诓楚
诲人不倦
诲人不惓
诲奸导淫
诲淫诲盗
诲盗诲淫
诳时惑众
说一不二
说三道四
说东谈西
说东道西
说亲道热
说今道古
说千说万
说千道万
说古谈今
说古道今
说嘴郎中
说地谈天
说好嫌歹
说好说歹
说是弄非
说是谈非
说是道非
说来话长
说来说去
说梅止渴
说白道緑
说白道绿
说白道黑
说短论长
说短道长
说长论短
说长话短
说长说短
说长道短
说黄道黑
说黑道白
请先入瓮
请君入瓮
请将不如激将
请由此亡
请自隗始
诸亲六眷
诸亲好友
诸如此例
诸如此比
诸如此类
诸子百家
诸恶莫作
诸有此类
诸色人等
诸若此类
诺诺连声
读不舍手
读书三余
读书三到
读书君子
读书得间
读书破万卷
读书种子
诽誉在俗
诽谤之木
课嘴撩牙
课语讹言
谁是谁非
调三惑四
调三斡四
调三窝四
调丝品竹
调停两用
调兵遣将
调和阴阳
调和鼎鼐
调唇弄舌
调嘴学舌
调嘴弄舌
调嘴调舌
调墨弄笔
调弦品竹
调朱傅粉
调朱弄粉
调理阴阳
调神畅情
调脂弄粉
调舌弄唇
调良稳泛
调虎离山
调词架讼
调风变俗
调风弄月
谄上傲下
谄上抑下
谄上欺下
谄上骄下
谄笑胁肩
谄词令色
谄谀取容
谆谆不倦
谆谆告戒
谆谆告诫
谆谆善诱
谆谆教导
谆谆诰诫
谇帚德锄
谈不容口
谈今论古
谈优务劣
谈何容易
谈古论今
谈古说今
谈吐生风
谈吐风生
谈圆说通
谈天论地
谈天说地
谈情说爱
谈玄说妙
谈空说幻
谈空说有
谈笑封侯
谈笑有鸿儒
谈笑自如
谈笑自若
谈笑风生
谈若悬河
谈虎色变
谈言微中
谈议风生
谈论风生
谈过其实
谈霏玉屑
谊不容辞
谊不敢辞
谊切苔岑
谋为不轨
谋事在人
谋听计行
谋图不轨
谋夫孔多
谋如涌泉
谋无遗策
谋无遗谞
谋臣如雨
谋臣武将
谋臣猛将
谋谟帷幄
谋财害命
谋道作舍
谏争如流
谏尸谤屠
谑浪笑傲
谑浪笑敖
谑而不虐
谓予不信
谗口铄金
谗言佞语
谘经诹史
谛分审布
谠言嘉论
谠言直声
谠论侃侃
谢兰燕桂
谢天谢地
谢家宝树
谢家活计
谢庭兰玉
谢馆秦楼
谦尊而光
谦恭下士
谦虚敬慎
谦虚谨慎
谦让未遑
谦谦君子
谦躬下士
谨始虑终
谨小慎微
谨本详始
谨毛失貌
谨终如始
谨终慎始
谨行俭用
谨言慎行
谨谢不敏
谨身节用
谩不经意
谩天昧地
谩天谩地
谩藏诲盗
谩辞哗说
谬以千里
谬妄无稽
谬想天开
谬托知己
谬种流传
谬采虚声
谬采虚誉
谭天说地
谭言微中
谮下谩上
谲怪之谈
谲而不正
谷父蚕母
谷贱伤农
谷马砺兵
豁人耳目
豁口截舌
豁然大悟
豁然开悟
豁然开朗
豁然省悟
豁然确斯
豁然贯通
豁然顿悟
豁达大度
豆分瓜剖
豆剖瓜分
豆萁燃豆
豆萁相煎
豆蔻年华
豆重榆瞑
豕交兽畜
豕亥鱼鲁
豕分蛇断
豕突狼奔
豕窜狼逋
豕虎传讹
豕食丐衣
豚蹄穰田
象煞有介事
象牙之塔
象简乌纱
象箸玉杯
象耕鸟耘
象齿焚身
豪取智笼
豪商巨贾
豪夺巧取
豪奢放逸
豪干暴取
豪情壮志
豪情逸致
豪放不羁
豪横跋扈
豪竹哀丝
豪管哀弦
豪言壮语
豪迈不群
豪门巨室
豪门贵胄
豹头环眼
豹死留皮
豺狐之心
豺狼之吻
豺狼当涂
豺狼当路
豺狼当道
豺狼成性
豺狼横道
豺狼虎豹
豺狼野心
豺虎肆虐
貂狗相属
貂蝉满座
貂裘换酒
貊乡鼠壤
貊乡鼠攘
貌似强大
貌合形离
貌合心离
貌合情离
貌合神离
貌合行离
貌如其心
貌是心非
貌是情非
貌离神合
贝阙珠宫
贞下起元
贞不絶俗
贞不绝俗
贞元会合
贞松劲柏
贞风亮节
贞高绝俗
负义忘恩
负乘斯夺
负乘致寇
负任蒙劳
负俗之累
负俗之讥
负债累累
负固不宾
负固不服
负土成坟
负地矜才
负坚执鋭
负屈含冤
负屈衔冤
负弩前驱
负德孤恩
负德背义
负德辜恩
负心违愿
负恩忘义
负恩昧良
负恩背义
负手之歌
负才任气
负才使气
负才傲物
负担舍舟
负材任气
负材矜地
负气仗义
负气含灵
负气斗狠
负石赴河
负类反伦
负罪引慝
负老提幼
负老携幼
负芒披苇
负荆请罪
负荆谢罪
负薪之忧
负薪救火
负薪构堂
负衡据鼎
负诟忍尤
负重吞污
负重含污
负重涉远
负重致远
负阻不宾
负险不宾
负险不臣
负隅顽抗
负驽前驱
贡禹弹冠
财不露白
财匮力绌
财大气粗
财殚力尽
财殚力痡
财殚力竭
财竭力尽
财运亨通
财迷心窍
责备求全
责实循名
责无旁贷
责有所归
责有攸归
贤妻良母
贤母良妻
贤良方正
贤贤易色
贤身贵体
败不旋踵
败于垂成
败井颓垣
败俗伤化
败俗伤风
败兴而归
败军之将
败化伤风
败国丧家
败国亡家
败将残兵
败德辱行
败材伤锦
败柳残花
败法乱纪
败绩失据
败鳞残甲
败鼓之皮
货真价实
货而不售
货贿公行
货赂公行
货赂大行
质伛影曲
质疑辨惑
质疑问难
质而不俚
质非文是
贩交买名
贩夫俗子
贩夫皁隶
贩夫皂隶
贩夫贩妇
贩夫走卒
贩夫驺卒
贩官鬻爵
贩贱卖贵
贪位慕禄
贪利忘义
贪功起衅
贪吃懒做
贪名逐利
贪墨成风
贪声逐色
贪多务得
贪多嚼不烂
贪天之功
贪夫徇财
贪夫殉利
贪夫狥利
贪夫狥财
贪婪无厌
贪官污吏
贪小失大
贪得无厌
贪心不足
贪惏无餍
贪欲无厌
贪欲无艺
贪求无厌
贪求无已
贪求无猒
贪污狼藉
贪污腐化
贪猥无厌
贪生怕死
贪生恶死
贪生畏死
贪而无信
贪脏枉法
贪蛇忘尾
贪财好色
贪贿无艺
贪赃坏法
贪赃枉法
贫不学俭
贫嘴恶舌
贫嘴滑舌
贫嘴薄舌
贫嘴贱舌
贫困潦倒
贫无立锥
贫无立锥之地
贫无置锥
贫病交侵
贫病交加
贫病交攻
贫病交迫
贫而乐道
贫而无谄
贫贱不移
贫贱之交
贫贱之知
贫贱糟糠
贫贱骄人
贯斗双龙
贯朽粟红
贯朽粟腐
贯朽粟陈
贯盈恶稔
贯穿今古
贯穿融会
贯通融会
贯颐备戟
贯颐奋戟
贯鱼之序
贯鱼之次
贱买贵卖
贱入贵出
贱敛贵出
贱敛贵发
贱目贵耳
贵不召骄
贵不可言
贵不期骄
贵人善忘
贵人多忘
贵人多忘事
贵人贱己
贵冠履轻头足
贵古贱今
贵在知心
贵壮贱弱
贵壮贱老
贵少贱老
贵极人臣
贵而贱目
贵耳贱目
贵贱无二
贵贱无常
贵贱高下
贵远贱近
贵远鄙近
贵阴贱璧
贸首之仇
贸首之雠
费力劳心
费尽心机
费财劳民
贻人口实
贻厥孙谋
贻害无穷
贻笑后人
贻笑大方
贻臭万年
贻误军机
贼人心虚
贼人胆虚
贼去关门
贼喊捉贼
贼头狗脑
贼头贼脑
贼头鬼脑
贼头鼠脑
贼子乱臣
贼心不死
贼眉贼眼
贼眉鼠眼
贼臣乱子
贼臣逆子
贿货公行
贿赂公行
贿赂并行
赁耳佣目
赃官污吏
赃污狼籍
赃污狼藉
赃盈恶贯
赃私狼籍
赃私狼藉
赃秽狼藉
赃货狼藉
赃贿狼籍
赃贿狼藉
资深望重
赈贫贷乏
赌咒发誓
赌彩一掷
赌物思人
赌神发咒
赌誓发原
赌誓发愿
赌长较短
赍志以殁
赍志以没
赍志而殁
赍志而没
赍粮藉寇
赏一劝众
赏一劝百
赏不当功
赏不踰日
赏不踰时
赏不逾日
赏不逾时
赏信罚必
赏信罚明
赏功罚罪
赏劳罚罪
赏同罚异
赏善罚否
赏善罚恶
赏奇析疑
赏心乐事
赏心悦目
赏立诛必
赏罚不明
赏罚严明
赏罚信明
赏罚分审
赏罚分明
赏贤使能
赏贤罚暴
赏高罚下
赐墙及肩
赐茅授土
赒穷恤匮
赔了夫人又折兵
赔身下气
赖有此耳
赘食太仓
赜探隐索
赞不絶口
赞不绝口
赞口不絶
赞口不绝
赞叹不已
赞声不绝
赢奸卖俏
赢金一经
赤体上阵
赤县神州
赤口毒舌
赤口烧城
赤口白舌
赤地千里
赤壁鏖兵
赤子之心
赤心奉国
赤心报国
赤心相待
赤手空拳
赤手起家
赤绳系足
赤胆忠心
赤胆忠肝
赤膊上阵
赤舌烧城
赤诚相待
赤贫如洗
赤身裸体
赤身露体
赦事诛意
赦过宥罪
赧颜汗下
赫斯之威
赫然而怒
赫赫之光
赫赫之功
赫赫巍巍
赫赫扬扬
赫赫有名
赫赫炎炎
赫赫魏魏
赭衣塞路
走丸逆坂
走为上着
走为上策
走为上计
走伏无地
走南闯北
走壁飞檐
走头无路
走头没路
走投无计
走投无路
走投没路
走斝传觞
走斝飞觞
走漏天机
走石飞沙
走肉行尸
走胡走越
走花溜冰
走花溜水
走蚓惊蛇
走身无路
走过场
走马上任
走马到任
走马看花
走马章台
走马观花
走马赴任
走骨行尸
赳赳武夫
赴死如归
赴汤投火
赴汤跳火
赴汤蹈火
赴火蹈刃
赴蹈汤火
赴险如夷
赶尽杀絶
赶尽杀绝
赶浪头
赶鸭子上架
起偃为竖
起凤腾蛟
起居无时
起承转合
起早挂晚
起早摸黑
起早睡晚
起早贪黑
起根发由
起死人而肉白骨
起死人肉白骨
起死回生
起死回骸
趁人之危
趁伙打劫
趁势落篷
趁哄打劫
趁心像意
趁心如意
趁水和泥
趁波逐浪
趁浪逐波
趁火打劫
趁火抢劫
趁热打铁
趁虚而入
趁风使柁
趁风转帆
趁风转篷
超世之才
超世拔俗
超世絶伦
超世絶俗
超世绝伦
超世绝俗
超今冠古
超今絶古
超今绝古
超今越古
超以象外
超伦轶羣
超俗绝世
超凡入圣
超凡出世
超前絶后
超前绝后
超前轶后
超古冠今
超尘出俗
超尘拔俗
超尘逐电
超度众生
超然不群
超然物外
超然独处
超然独立
超然绝俗
超然自引
超然自得
超然自逸
超然象外
超然迈伦
超然远举
超然远引
超类絶伦
超类绝伦
超羣出众
超羣拔类
超羣拔萃
超羣絶伦
超群出众
超群拔类
超群绝伦
超群越辈
超群轶类
超超玄箸
超超玄著
超轶絶尘
超轶绝尘
超迈绝伦
超逸絶尘
超逸绝尘
超阶越次
越人肥瘠
越俎代庖
越俎代谋
越凡遗世
越凫楚乙
越古超今
越次超伦
越瘠秦视
越瘦吴肥
越瘦秦肥
越鸟南栖
趋之如鹜
趋之若骛
趋之若鹜
趋利避害
趋吉避凶
趋时奉势
趋时附势
趋权附势
趋炎奉势
趋炎赶热
趋炎附势
趋炎附热
趑趄不前
趑趄嗫嚅
足不出户
足不出门
足不履影
足不窥户
足不踰户
足不逾户
足兵足食
足尺加二
足智多谋
足茧手胝
足衣足食
足足有余
足趼舌敝
足踏实地
足蹈手舞
足音空谷
足音跫然
足食丰衣
足食足兵
足高气强
足高气扬
趾踵相接
趾踵相错
趾高气扬
跃然纸上
跃跃欲试
跃马弯弓
跃马扬鞭
跅幪不羁
跅弛不羁
跅弢不羁
跋前疐后
跋前踕后
跋前踬后
跋履山川
跋山涉川
跋山涉水
跋扈恣睢
跋扈自恣
跋扈飞扬
跋来报往
跋涉山川
跋胡疐尾
跌宕不羁
跌宕不覊
跌宕昭彰
跌宕风流
跌弹斑鸠
跌脚捶胸
跌脚搥胸
跌脚槌胸
跌脚绊手
跌荡不拘
跌荡不羁
跌荡风流
跑了和尚跑不了寺
跑了和尚跑不了庙
跑马观花
跑龙套
跖犬吠尧
跖犬噬尧
跖狗吠尧
跗萼联芳
跗萼载韡
跗萼连晖
跗蕚载韡
跗蕚连晖
跛行千里
跛鳖千里
距人千里
距跃三百
跣足科头
跨凤乘鸾
跨凤乘龙
跨山压海
跫响空谷
跫然足音
跬步千里
路不拾遗
路人皆知
路叟之忧
路断人稀
路无拾遗
路柳墙花
路絶人稀
路绝人稀
路见不平
路远迢迢
跳丸日月
跳到黄河洗不清
跳在黄河洗不清
跳梁小丑
跳进黄河洗不清
践土食毛
践律蹈礼
践规踏矩
跷足抗手
跷足抗首
跷足而待
跻峰造极
跼地籥天
跼天促地
跼天蹐地
跼蹐不安
跼高蹐厚
踉踉跄跄
踌躇不决
踌躇不前
踌躇满志
踏故习常
踏破铁鞋
踔厉奋发
踔厉风发
踔厉骏发
踔绝之能
踞炉炭上
踞虎盘龙
踞鼃食蛤
踟蹰不前
踢天弄井
踣地呼天
踧踖不安
踵事增华
踵决肘见
踵接肩摩
踵武前贤
踵武相接
踵足相接
踵趾相接
踵迹相接
踽踽凉凉
踽踽独行
蹀躞不下
蹄閒三寻
蹄闲三寻
蹄间三寻
蹇之匪躬
蹇人上天
蹇人升天
蹇视高步
蹇谔匪躬
蹇蹇匪躬
蹈人旧辙
蹈仁履义
蹈其覆辙
蹈刃不旋
蹈厉之志
蹈厉奋发
蹈常习故
蹈常袭故
蹈故习常
蹈机握杼
蹈汤赴火
蹈火探汤
蹈火赴汤
蹈矩循彟
蹈矩循规
蹈矩践墨
蹈节死义
蹈袭前人
蹈袭覆辙
蹈规循矩
蹈赴汤火
蹈锋饮血
蹉跎岁月
蹉跎日月
蹉跎时日
蹉跎自误
蹊田夺牛
蹐地局天
蹐地跼天
蹑屩担簦
蹑屩檐簦
蹑影潜踪
蹑影藏形
蹑影追风
蹑手蹑脚
蹑手蹑足
蹑脚蹑手
蹑足其间
蹑足潜踪
蹑足附耳
蹑蹻担簦
蹑蹻檐簦
蹙蹙靡骋
蹙金结绣
蹠犬噬尧
蹠狗吠尧
蹿房越脊
躁言丑句
身不由主
身不由己
身不遇时
身临其境
身价百倍
身体力行
身体发肤
身做身当
身先士众
身先士卒
身先朝露
身单力薄
身历其境
身名两泰
身名俱泰
身名俱灭
身名俱败
身后萧条
身后识方干
身在曹营心在汉
身外之物
身家性命
身寄虎吻
身废名裂
身强力壮
身当其境
身当矢石
身微力薄
身微言轻
身心交病
身心交瘁
身怀六甲
身操井臼
身无分文
身无完肤
身无寸缕
身无寸铁
身无择行
身无立锥
身无长处
身无长物
身显名扬
身经百战
身败名裂
身败名隳
身轻言微
身远心近
身退功成
身遥心迩
身非木石
身首异地
身首异处
躬体力行
躬先士卒
躬冒矢石
躬擐甲胄
躬耕乐道
躬自菲薄
躬行实践
躬行节俭
躬蹈矢石
躬逢其盛
躭惊受怕
躲躲闪闪
车击舟连
车在马前
车填马隘
车尘马足
车尘马迹
车怠马烦
车无退表
车殆马烦
车水马龙
车烦马毙
车笠之盟
车轨共文
车载斗量
车载船装
车辙马迹
车量斗数
车马填门
车马如龙
车马盈门
车马辐辏
车马骈阗
车驰马骤
轨物范世
轩昂气宇
轩然大波
轩然霞举
轩盖如云
轩轩甚得
轩轾不分
轩鹤冠猴
转危为安
转喉触讳
转嗔为喜
转弯抹角
转弯磨角
转忧为喜
转悲为喜
转愁为喜
转战千里
转斗千里
转日回天
转死沟壑
转死沟渠
转海回天
转湾抹角
转灾为福
转眼之间
转瞬之间
转祸为福
转败为功
转败为成
转败为胜
转辗反侧
轮扁斫轮
轮焉奂焉
软弱无力
软玉温香
软硬兼施
软红十丈
软红香土
软裘快马
软语温言
软谈丽语
软香温玉
轰动一时
轰堂大笑
轰天烈地
轰天裂地
轰轰烈烈
轰雷掣电
轰雷贯耳
轶事遗闻
轶类超羣
轶类超群
轶羣絶类
轶群绝类
轶闻遗事
轹釜待炊
轻世傲物
轻世肆志
轻举妄动
轻举絶俗
轻举绝俗
轻举远游
轻于鸿毛
轻傜薄赋
轻卒锐兵
轻口薄舌
轻口轻舌
轻吞慢吐
轻嘴薄舌
轻如鸿毛
轻尘栖弱草
轻徙鸟举
轻徭薄税
轻徭薄赋
轻怜疼惜
轻怜痛惜
轻怜重惜
轻手蹑脚
轻手软脚
轻手轻脚
轻才好施
轻描淡写
轻敲缓击
轻歌曼舞
轻死重义
轻死重气
轻生重义
轻繇薄赋
轻而易举
轻若鸿毛
轻薄无知
轻薄无礼
轻薄无行
轻虑浅谋
轻装上阵
轻装简从
轻裘缓带
轻裘缓辔
轻裘肥马
轻视傲物
轻言寡信
轻言细语
轻言肆口
轻言软语
轻言轻语
轻诺寡信
轻财仗义
轻财好义
轻财好士
轻财好施
轻财敬士
轻财贵义
轻财重义
轻财重士
轻赋薄敛
轻身下气
轻身殉义
轻身重义
轻车减从
轻车熟路
轻车熟道
轻车简从
轻重倒置
轻重失宜
轻重缓急
轻饶素放
轻骑减从
轻骑简从
载一抱素
载欢载笑
载歌且舞
载歌载舞
载沉载浮
载笑载言
载舟覆舟
载酒问字
载驰载驱
载驱载驰
较德焯勤
较武论文
较瘦量肥
较短比长
较短絜长
较短量长
较若画一
较长絜短
辅世长民
辅牙相倚
辅车唇齿
辅车相依
辅车相将
辉光日新
辉煌金碧
辍毫栖牍
辑志协力
输心服意
输肝写胆
输肝剖胆
输肝沥胆
输财助边
辗转反侧
辙乱旂靡
辙乱旗靡
辛壬癸甲
辜恩背义
辜恩负义
辞不获命
辞不达义
辞不达意
辞严义正
辞严意正
辞严气正
辞严谊正
辞多受少
辞富居贫
辞尊居卑
辞巧理拙
辞微旨远
辞穷理屈
辞简义赅
辞金蹈海
辨如悬河
辨日炎凉
辨物居方
辨若悬河
辩口利舌
辩口利辞
辩才无碍
辩才无阂
辱国丧师
辱国殃民
辱国殄民
辱身败名
辱门败户
边尘不惊
辽东白豕
辽东豕
达人知命
达地知根
达士通人
达官显宦
达官知命
达官要人
达官贵人
达官贵要
达权知变
达权通变
达观知命
迁乔出谷
迁于乔木
迁兰变鲍
迁善去恶
迁善塞违
迁善改过
迁善远罪
迁善黜恶
迁客骚人
迁延岁月
迁延日月
迁延时日
迁延稽留
迁延羁留
迁延观望
迁延顾望
迁怒于人
迁思回虑
迁臣逐客
迁莺出谷
迁风移俗
迂回曲折
迂谈阔论
迅电流光
迅雷不及掩耳
迅雷风烈
过为已甚
过五关斩六将
过从甚密
过化存神
过屠大嚼
过屠门而大嚼
过市招摇
过府冲州
过庭之训
过时黄花
过桥抽板
过桥拆桥
过江之鲫
过河卒子
过河拆桥
过犹不及
过甚其词
过甚其辞
过目不忘
过目成诵
过眼云烟
过眼烟云
过程控制
过而能改
过街老鼠
过路财神
过都历块
过门不入
过隙白驹
迈古超今
迎刃以解
迎刃冰解
迎刃立解
迎刃而理
迎刃而解
迎头痛击
迎头赶上
迎奸卖俏
迎新弃旧
迎新送故
迎新送旧
迎来送往
迎神赛会
迎门请盗
迎风冒雪
迎风待月
迎风招展
运之掌上
运乖时蹇
运开时泰
运拙时乖
运拙时艰
运掉自如
运斤如风
运斤成风
运斧般门
运旺时盛
运智铺谋
运用自如
运移时易
运策决机
运策帷幄
运筹借箸
运筹决策
运筹决算
运筹决胜
运筹出奇
运筹划策
运筹制胜
运筹千里
运筹帏幄
运筹帷帐
运筹帷幄
运筹建策
运筹演谋
运筹画策
运筹设策
运计铺谋
运蹇时乖
运蹇时低
运转时来
近乡情怯
近交远攻
近亲繁殖
近在咫尺
近在眉睫
近悦远来
近水楼台
近水楼台先得月
近火先焦
返哺之恩
返我初服
返本朝元
返本还元
返本还原
返本还源
返朴归真
返朴还淳
返朴还真
返来复去
返照回光
返璞归真
返老归童
返老还童
返虚入浑
返观内照
返观内视
返视内照
返辔收帆
返邪归正
还乡昼锦
还元返本
还原反本
还年却老
还年卻老
还年驻色
还我河山
还朴反古
还淳反古
还淳反朴
还淳反素
还淳返朴
还珠买椟
还珠合浦
还珠返璧
还醇返朴
这山望着那山高
进俯退俯
进利除害
进可替不
进可替否
进善惩奸
进善惩恶
进善退恶
进善黜恶
进壤广地
进寸退尺
进德修业
进德脩业
进旅退旅
进本退末
进禄加官
进种善羣
进种善群
进荣退辱
进谗害贤
进贤任能
进贤兴功
进贤屏恶
进贤拔能
进贤用能
进贤达能
进贤进能
进贤退佞
进贤退奸
进贤退愚
进贤黜佞
进贤黜奸
进贤黜恶
进身之阶
进退两端
进退两难
进退中度
进退中绳
进退为难
进退亡据
进退出处
进退双难
进退可否
进退可度
进退唯谷
进退失图
进退失所
进退失据
进退失措
进退失踞
进退存亡
进退履绳
进退应矩
进退惟咎
进退惟谷
进退损益
进退无依
进退无所
进退无据
进退无措
进退无路
进退无途
进退无门
进退有常
进退有度
进退有节
进退消息
进退消长
进退狐疑
进退狼狈
进退维亟
进退维艰
进退维谷
进退荣辱
进退裕如
进退触篱
进退触籓
进退触藩
进退跋疐
进退路穷
进退迍邅
进退首鼠
进道若蜷
进道若踡
进道若退
进鋭退速
进锐退速
远不间亲
远交近攻
远亲不如近邻
远亲近邻
远垂不朽
远山芙蓉
远年近岁
远年近日
远怀近集
远愁近虑
远来和尚好看经
远水不救近火
远水不解近渴
远水救不得近火
远水解不了近渴
远求骐骥
远泝博索
远涉重洋
远溯博索
远瞩高瞻
远至迩安
远虑深谋
远见卓识
远谋深算
远走高飞
违世乖俗
违世异俗
违世絶俗
违世绝俗
违乡负俗
违利赴名
违天害理
违天悖人
违天悖理
违天逆理
违害就利
违强陵弱
违心之论
违时絶俗
违时绝俗
违条犯法
违条舞法
违法乱纪
连三并四
连三接二
连三接五
连三接四
连三跨五
连中三元
连二并三
连二赶三
连城之璧
连墙接栋
连天匝地
连天烽火
连宵彻曙
连宵达旦
连山排海
连州比县
连州跨郡
连帙累牍
连战皆捷
连日带夜
连日继夜
连日连夜
连明彻夜
连明达夜
连明连夜
连昏接晨
连昏达曙
连昬接晨
连更彻夜
连更星夜
连更晓夜
连枝共冢
连枝分叶
连枝同气
连枝带叶
连枝并头
连枝比翼
连根带梢
连模拟事
连模拟物
连汤带水
连珠合璧
连理之木
连理分枝
连甍接栋
连畴接陇
连章累牍
连篇累册
连篇累帙
连篇累帧
连篇累幅
连篇累牍
连篇絫幅
连篇絫牍
连类比事
连类比物
连绵不断
连绵不绝
连绵起伏
连编累牍
连舆并席
连舆接席
连街倒巷
连衽成帷
连袵成帷
连车平斗
连里竟街
连锁反应
连镳并轸
连镳并驾
连阡累陌
连阶累任
连鳌跨鲸
迟回观望
迟徊不决
迟徊观望
迟日旷久
迟暮之年
迟疑不决
迟疑不定
迟疑不断
迟疑未决
迟疑观望
迟疑顾望
迟眉钝眼
迟迟吾行
迥不犹人
迥乎不同
迥然不同
迥然不羣
迥然不群
迩安远至
迫不及待
迫不可待
迫不得已
迫于眉睫
迫在眉睫
迭嶂层峦
迭床架屋
迭矩重规
迭见层出
述而不作
迷人眼目
迷天大罪
迷天大谎
迷头认影
迷恋骸骨
迷惑不解
迷惑视听
迷涂知反
迷离徜仿
迷离徜恍
迷离恍惚
迷离惝恍
迷离扑朔
迷而不反
迷而不返
迷而知反
迷而知返
迷花沾草
迷踪失路
迷迷荡荡
迷途知反
迷途知返
迷金醉纸
迷魂夺魄
迷魂汤
迷魂淫魄
迷魂阵
追云逐电
追亡逐北
追亡逐遁
追奔逐北
追悔何及
追悔莫及
追本溯源
追本穷源
追根寻底
追根查源
追根求源
追根溯源
追根究底
追根究蒂
追根穷源
追根问底
追欢买笑
追欢作乐
追欢卖笑
追欢取乐
追趋逐耆
追远慎终
追风掣电
追风摄景
追风蹑影
追风蹑景
追风逐影
追风逐日
追风逐电
追魂夺命
追魂夺魄
追魂摄魄
退如山移
退思补过
退旅进旅
退有后言
退步抽身
退藏于密
退让贤路
退避三舍
退食从容
退食自公
送佛送到西
送佛送到西天
送去迎来
送往事居
送往劳来
送往视居
送往迎来
送抱推襟
送故迎新
送旧迎新
送暖偎寒
送暖偷寒
送眼流眉
适以相成
适俗随时
适可而止
适如其分
适居其反
适当其冲
适当其时
适得其反
适心娱目
适性任情
适性忘虑
适情任欲
适情率意
适时应务
适材适所
适逢其会
适逢其时
逃之夭夭
逆取顺守
逆坂走丸
逆天暴物
逆天犯顺
逆天违众
逆天违理
逆子贼臣
逆施倒行
逆来顺受
逆水行舟
逆耳之言
逆耳利行
逆耳良言
逆臣贼子
逆行倒施
逆道乱常
逆阪走丸
逆风恶浪
选兵秣马
选妓征歌
选歌试舞
选舞征歌
选色征歌
选贤与能
选贤举能
选贤任能
逊志时敏
逋慢之罪
逋逃之臣
逋逃之薮
逍遥事外
逍遥法外
逍遥物外
逍遥自在
逍遥自娱
逍遥自得
透骨酸心
逐句逐字
逐名趋势
逐字逐句
逐宕失返
逐客令
逐影吠声
逐影寻声
逐影随波
逐新趣异
逐日追风
逐末弃本
逐末忘本
逐末舍本
逐机应变
逐流忘返
逐浪随波
逐物不还
逐电追风
逐臭之夫
逐近弃远
逐逐眈眈
逐队成羣
逐队成群
逐风追电
逐鹿中原
递兴递废
递胜递负
途穷日暮
途途是道
途遥日暮
逖听远闻
逖听遐视
通上彻下
通书达礼
通今博古
通今达古
通儒硕学
通儒达士
通儒达识
通元识微
通共有无
通前彻后
通前澈后
通前至后
通力合作
通功易事
通南彻北
通变达权
通古博今
通古达变
通同一气
通同作弊
通商惠工
通天彻地
通天达地
通宵彻夜
通宵彻旦
通宵彻昼
通宵达旦
通家之好
通工易事
通幽动微
通幽洞冥
通幽洞微
通幽洞灵
通忧共患
通情达理
通才硕学
通才练识
通文调武
通文达理
通文达礼
通文达艺
通无共有
通时合变
通时达务
通时达变
通权达变
通权达理
通材达识
通真达灵
通衢大邑
通衢广陌
通计熟筹
通达谙练
通邑大都
通都大埠
通都大邑
通都巨邑
通险畅机
通风报信
通风报讯
通风讨信
通首至尾
逝将去汝
逝者如斯
逞凶肆虐
逞奇眩异
逞妍斗色
逞娇呈美
逞娇斗媚
逞工炫巧
逞工衒巧
逞己失众
逞异夸能
逞强好胜
逞强称能
逞心如意
逞性妄为
逞怪披奇
速战速决
造作矫揉
造化小儿
造因得果
造因结果
造微入妙
造恶不悛
造极登峯
造极登峰
造次行事
造次颠沛
造端倡始
造端托始
造端讬始
造茧自缚
造言捏词
造言生事
造謡惑众
造謡生事
造謡生非
造谋布穽
造谋布阱
造谣中伤
造谣惑众
造谣生事
造谣生非
造车合辙
逢人说项
逢凶化吉
逢吉丁辰
逢君之恶
逢场作乐
逢场作戏
逢场作趣
逢场游戏
逢场竿木
逢山开路
逢山开道
逢恶导非
逢时遇节
逢机立断
逢机遘会
逴俗絶物
逴俗绝物
逶迤退食
逷听远闻
逸以待劳
逸兴云飞
逸兴横飞
逸兴遄飞
逸尘断鞅
逸态横生
逸羣絶伦
逸群之才
逸群绝伦
逸趣横生
逸辈殊伦
逸闻琐事
逸闻趣事
逸闻轶事
逸韵高致
逼上梁山
逼不得已
逼人太甚
逼良为娼
逾千越万
逾墙窥蠙
逾墙窥隙
逾墙越舍
逾墙钻穴
逾墙钻蠙
逾墙钻隙
逾山越海
逾年历岁
逾次超秩
逾沙轶漠
逾淮之橘
逾绳越契
逾闲荡检
遁世幽居
遁世无闷
遁世离俗
遁世离羣
遁世离群
遁世絶俗
遁世绝俗
遁世遗荣
遁世长往
遁世隐居
遁俗无闷
遁入空门
遁名匿迹
遁名改作
遁天之刑
遁天倍情
遁天妄行
遁形远世
遁身远迹
遁迹匿影
遁迹方外
遁迹桑门
遁迹潜形
遁迹空门
遁迹藏名
遁迹销声
遁迹黄冠
遁逸无闷
遁阴匿景
遂心如意
遂心应手
遂心快意
遂心满意
遂迷不寤
遂迷不窹
遂迷忘反
遂非文过
遇事生端
遇事生风
遇人不淑
遇水叠桥
遇水架桥
遇水迭桥
遇物持平
遇难呈祥
遇难成祥
遍体鳞伤
遍地开花
遏云绕梁
遏密八音
遏恶扬善
遏渐防萌
遐尔闻名
遐州僻壤
遐方絶域
遐方絶壤
遐方绝域
遐方绝壤
遐迩一体
遐迩着闻
遐迩著闻
遐迩闻名
道不举遗
道不同不相为谋
道不拾遗
道不掇遗
道不相谋
道东说西
道义之交
道傍之筑
道傍筑室
道傍苦李
道合志同
道同义合
道同契合
道同志合
道听涂说
道听耳食
道听途说
道在人为
道在屎溺
道大莫容
道头会尾
道头知尾
道存目击
道学先生
道寡称孤
道尽涂殚
道尽涂穷
道尽途殚
道尽途穷
道山学海
道弟称兄
道微德薄
道德文章
道旁苦李
道无拾遗
道殣相属
道殣相望
道殣相枕
道而不径
道西说东
道貌俨然
道貌凛然
道貌岸然
道路以目
道路侧目
道边苦李
道远日暮
道远知骥
道长争短
道长论短
道骨仙风
道高德重
道高望重
道高魔重
遗世忘累
遗世拔俗
遗世独立
遗世絶俗
遗世绝俗
遗世越俗
遗休余烈
遗俗絶尘
遗俗绝尘
遗华反质
遗名去利
遗哂大方
遗声余价
遗声坠绪
遗大投艰
遗孽余烈
遗害无穷
遗寝载怀
遗形去貌
遗形忘性
遗形藏志
遗德休烈
遗德余烈
遗恨千古
遗恨终天
遗恩余烈
遗惠余泽
遗文逸句
遗物忘形
遗物识心
遗珠弃璧
遗珥坠簪
遗珥堕簪
遗祸无穷
遗笑大方
遗篇坠款
遗篇断简
遗簪坠履
遗簪坠屦
遗簪坠珥
遗簪坠舄
遗簪堕履
遗簪堕珥
遗簪弃舄
遗簪弊履
遗簪弊屦
遗簪絶缨
遗簪绝缨
遗簪脱舃
遗簪脱舄
遗编坠简
遗编断简
遗编絶简
遗编绝简
遗老孤臣
遗老遗少
遗臭万世
遗臭万代
遗臭万年
遗臭万载
遗臭千年
遗臭千秋
遗臭无穷
遗艰投大
遗芬余荣
遗芬剩馥
遗芳余烈
遗落世事
遗训余风
遗迹谈虚
遗闻琐事
遗闻轶事
遗闻逸事
遗音余韵
遗风余习
遗风余俗
遗风余思
遗风余教
遗风余泽
遗风余烈
遗风余象
遗风余采
遗风余韵
遗风古道
遗风旧俗
遗风逸尘
遗魂亡魄
遗黎故老
遝冈复岭
遡流徂源
遡流求源
遡流穷源
遡源穷流
遣兴陶情
遣兵调将
遣将征兵
遣将调兵
遣愁索笑
遣言措意
遣词措意
遣词立意
遣词造意
遣辞措意
遥呼相应
遥相呼应
遥遥华胄
遥遥在望
遥遥无期
遥遥相对
遥遥领先
遨翔自得
遭事制宜
遭倾遇祸
遭劫在数
遭家不造
遭时不偶
遭时制宜
遭时定制
遭逢不偶
遭逢会遇
遭逢时会
遭逢际会
遭遇不偶
遭遇运会
遭遇际会
遭际不偶
遭际时会
遮三瞒四
遮人眼目
遮人耳目
遮前掩后
遮地漫天
遮地盖天
遮天映日
遮天盖地
遮天盖日
遮天蔽日
遮天迷地
遮掩耳目
遮空蔽日
遵养待时
遵养时晦
遵养晦时
遵厌兆祥
遵时养晦
遵而不失
遵而勿失
遵道秉义
避世墙东
避世离俗
避世绝俗
避世金门
避世金马
避之若浼
避井入坎
避人眼目
避人耳目
避俗趋新
避军三舍
避凉附炎
避凶趋吉
避君三舍
避坑落井
避实击虚
避实就虚
避害就利
避强击弱
避强击惰
避强打弱
避影匿形
避影敛迹
避李嫌瓜
避毁就誉
避溺山隅
避烦斗捷
避瓜防李
避祸就福
避祸求福
避穽入坑
避而不谈
避让贤路
避迹藏时
避迹违心
避重就轻
避重逐轻
避阱入坑
避难就易
避难趋易
避面尹邢
邀功希宠
邀功求赏
邀名射利
邂逅不偶
邂逅相逢
邂逅相遇
邈以山河
邈处欿视
邈如旷世
邈若山河
邈若河山
邈若河汉
邦以民为本
邦国殄瘁
邪不伐正
邪不压正
邪不干正
邪不敌正
邪不犯正
邪不胜正
邪门歪道
邪魔外祟
邪魔外道
邪魔怪道
邪魔歪道
邯郸匍匐
邯郸学步
邯郸重步
邹缨齐紫
邹衍谈天
邺架之藏
邻女窥墙
邻女詈人
郁郁不乐
郁郁不得志
郁郁寡欢
郁郁沉沉
郁郁累累
郁郁芊芊
郁郁苍苍
郁郁葱葱
郄诜丹桂
郄诜高第
郊寒岛瘦
郎才女姿
郎才女貌
郐下无讥
郑人买履
郑人争年
郑人实履
郑卫之音
郑昭宋聋
郑重其事
郑重其辞
郢中白雪
郢书燕说
郢人斤斧
郢人斤斫
郢人斤斲
郢人斫垩
郢人斵垩
郢人运斧
郢匠挥斤
郤诜丹桂
郤诜高第
都中纸贵
都俞吁咈
都头异姓
鄙于不屑
鄙俚浅陋
鄙吝复萌
鄙夷不屑
酌古准今
酌古参今
酌古御今
酌古斟今
酌古沿今
酌水知源
酌盈剂虚
酌盈注虚
酌金馔玉
配享从汜
配套成龙
酒余茶后
酒入舌出
酒后失言
酒后无德
酒后茶余
酒囊饭包
酒囊饭袋
酒地花天
酒有别肠
酒池肉林
酒瓮饭囊
酒病花愁
酒緑灯红
酒绿灯红
酒肉兄弟
酒肉朋友
酒色之徒
酒色财气
酒虎诗龙
酒足饭饱
酒逢知己千杯少
酒酣耳热
酒酣耳熟
酒酸不售
酒醉饭饱
酒阑人散
酒食地狱
酒食征逐
酒龙诗虎
酗酒滋事
酣嬉淋漓
酣歌恒舞
酣歌醉舞
酣然入梦
酣畅淋漓
酣痛淋漓
酩酊大醉
酩酊烂醉
酬功给效
酸咸苦辣
酸文假醋
酸甜苦辣
醇酒妇人
醇酒美人
醉吐相茵
醉山颓倒
醉死梦生
醉玉颓山
醉生梦死
醉翁之意不在酒
醉舞狂歌
醉酒饱德
醋海翻波
醍醐灌顶
醒聩震聋
醴酒不设
采兰赠芍
采兰赠药
采凤随鸦
采及葑菲
采椽不斫
采葑采菲
采薪之忧
采薪之患
采薪之疾
采风问俗
释回增美
释生取义
释知遗形
释缚焚榇
里丑捧心
里出外进
里勾外连
里外夹攻
里应外合
里程碑
里谈巷议
里通外国
重三叠四
重三迭四
重义轻生
重义轻财
重于泰山
重作冯妇
重光累洽
重关击柝
重兴旗鼓
重厚寡言
重厚少文
重圭叠组
重垣叠锁
重垣迭锁
重增其放
重山复岭
重山复水
重山峻岭
重岩叠嶂
重岩叠障
重岩迭嶂
重岩迭障
重峦叠嶂
重峦叠巘
重峦复嶂
重峦迭嶂
重峦迭巘
重床叠屋
重床叠架
重床迭屋
重床迭架
重手累足
重振旗鼓
重操旧业
重整旗鼓
重明继焰
重望高名
重气徇命
重气狥名
重气轻命
重气轻生
重温旧业
重温旧梦
重熙累叶
重熙累洽
重熙累盛
重熙累绩
重珪叠组
重珪迭组
重理旧业
重生父母
重生爷娘
重男轻女
重睹天日
重纰貤缪
重纸累札
重葩累藻
重裀列鼎
重见天日
重规叠矩
重规沓矩
重规累矩
重规袭矩
重规迭矩
重财轻义
重起炉灶
重足一迹
重足屏息
重足屏气
重足累息
重足而立
重蹈覆辙
重迹屏气
重逆无道
重金兼紫
重金袭汤
重门击柝
重门叠户
野人奏曝
野人献日
野人献曝
野人献芹
野心勃勃
野无遗才
野无遗贤
野没遗贤
野草闲花
野蔌山肴
野调无腔
野马无缰
野鹤孤云
野鹤闲云
量体裁衣
量入为出
量入计出
量凿正枘
量力度德
量力而为
量力而行
量如江海
量小力微
量己审分
量才器使
量才录用
量才而为
量才録用
量时度力
量材录用
量材録用
量枘制凿
量能授官
量金买赋
金丹换骨
金人三缄
金人之箴
金人之缄
金人缄口
金光盖地
金兰之交
金兰之友
金兰之契
金刚努目
金刚怒目
金刚眼睛
金匮石室
金印紫绶
金友玉昆
金口御言
金口木舌
金口玉牙
金口玉言
金口玉音
金台市骏
金吾不禁
金城千里
金城汤池
金城石室
金声掷地
金声玉振
金声玉服
金声玉润
金声玉色
金壶墨汁
金字招牌
金尽裘弊
金尽裘敝
金屋之选
金屋娇娘
金屋藏娇
金屋贮娇
金戈铁甲
金戈铁马
金戈铁骑
金断觿决
金无足赤
金昭玉粹
金枝玉叶
金枷玉锁
金榜挂名
金榜题名
金汤之固
金波玉液
金浆玉液
金浆玉醴
金淘沙拣
金玉之言
金玉其质
金玉满堂
金玉良缘
金玉良言
金玉锦绣
金璧辉煌
金瓯无缺
金瓶落井
金相玉式
金相玉振
金相玉映
金相玉质
金石不渝
金石丝竹
金石为开
金石之交
金石之功
金石之坚
金石之策
金石之言
金石之计
金石交情
金石可开
金石至交
金石良言
金碧荧煌
金碧辉映
金碧辉煌
金科玉律
金科玉条
金科玉臬
金章玉句
金章紫绶
金童玉女
金篦刮目
金精玉液
金紫银青
金翅擘海
金舌弊口
金舌蔽口
金蝉脱壳
金蝉脱殻
金谷酒数
金貂取酒
金貂换酒
金貂贳酒
金辉玉洁
金迷纸碎
金迷纸醉
金针度人
金针见血
金钗十二
金钗换酒
金钗细合
金钗钿合
金镳玉络
金镳玉辔
金镶玉裹
金门绣户
金闺国士
金闺玉堂
金题玉躞
金风玉露
金风送爽
金马玉堂
金鳷擘海
金鸡消息
金鸡独立
金鼓喧阗
金鼓连天
金鼓齐鸣
金龟换酒
釜中之鱼
釜中游鱼
釜中生尘
釜中生鱼
釜底抽薪
釜底游魂
釜底游鱼
釜鱼幕燕
釜鱼甑尘
鉥心刳形
鉥心刿目
鉥心刿肾
鉥肝刿肾
鉴前毖后
鉴影度形
鉴往知来
鉴机识变
鉴毛辨色
鉴空衡平
鉴貌辨色
鋭挫望絶
鋭挫气索
针头削铁
针头线尾
针头线脑
针尖对麦芒
针芥之合
针芥之契
针芥之投
针芥相投
针锋相对
钉嘴铁舌
钉头磷磷
钓名欺世
钓名沽誉
钓名要誉
钓游之地
钓誉沽名
钗横鬓乱
钗荆裙布
钜人长德
钜学鸿生
钝口拙腮
钝学累功
钟漏并歇
钟灵毓秀
钟皷之色
钟鸣漏尽
钟鸣鼎列
钟鸣鼎重
钟鸣鼎食
钟鼎之家
钟鼎人家
钟鼎山林
钟鼓之色
钟鼓馔玉
钢浇铁铸
钢筋铁骨
钦差大臣
钧天广乐
钩元提要
钩元摘秘
钩心斗角
钩深图远
钩深极奥
钩深索隐
钩深致远
钩爪锯牙
钩玄提要
钩玄猎秘
钩章棘句
钩辀格磔
钩金舆羽
钱可通神
钳口不言
钳口吞舌
钳口挢舌
钳口结舌
钻冰取火
钻冰求火
钻冰求酥
钻坚仰高
钻坚研微
钻天入地
钻天打洞
钻天觅缝
钻头就锁
钻头觅缝
钻山塞海
钻心刺骨
钻懒帮闲
钻故纸堆
钻洞觅缝
钻火得冰
钻牛角尖
钻皮出羽
钻穴踰垣
钻穴踰墙
钻穴踰隙
钻穴逾垣
钻穴逾墙
钻穴逾隙
钻隙踰墙
钻隙逾墙
钿合金钗
铁中铮铮
铁嘴钢牙
铁壁铜墙
铁壁铜山
铁心木肠
铁心石肠
铁打心肠
铁打铜铸
铁杵成针
铁杵磨成针
铁板一块
铁板不易
铁板歌喉
铁板钉钉
铁板铜弦
铁板铜琶
铁树开华
铁树开花
铁树花开
铁案如山
铁桶江山
铁棒磨成针
铁狱铜笼
铁画银钩
铁石心肝
铁石心肠
铁砚磨穿
铁窗风味
铁笔无私
铁绰铜琶
铁网珊瑚
铁肠石心
铁证如山
铁郭金城
铁面御史
铁面无私
铁面枪牙
铁面鎗牙
铁鞋踏破
铁马金戈
铄古切今
铄懿渊积
铄石流金
铄金毁骨
铄金点玉
铅刀一割
铜唇铁舌
铜围铁马
铜城铁壁
铜墙铁壁
铜壶滴漏
铜头铁臂
铜头铁额
铜山金穴
铜山铁壁
铜心铁胆
铜打铁铸
铜浇铁铸
铜琶铁板
铜盘重肉
铜筋铁肋
铜筋铁骨
铜臭熏天
铜觔铁肋
铜铸铁浇
铜驼荆棘
铜驼草莽
铢两分寸
铢两悉称
铢两相称
铢分毫析
铢寸累积
铢施两较
铢积丝累
铢积寸累
铢积锱累
铢称寸量
铢穪寸量
铢累寸积
铢量寸度
铢铢校量
铢铢较量
铤而走险
铤鹿走险
铩羽暴鳞
铩羽涸鳞
铩羽而归
铭心刻骨
铭心镂骨
铭感不忘
铭感五内
铭肌镂骨
铭肤镂骨
铭记不忘
铭诸肺腑
铮铮佼佼
铮铮有声
铮铮铁汉
铮铮铁骨
铲迹销声
银屏金屋
银山铁壁
银样蜡枪头
银样镴枪头
银样镴鎗头
银河倒泻
银花火树
银钩玉唾
银钩虿尾
银钩铁画
铸剑为犁
铸山煑海
铸山煮海
铸成大错
铸新淘旧
铸木镂冰
铸甲销戈
铺天盖地
铺张扬厉
铺张浪费
铺眉苫眼
铺眉蒙眼
铺胸纳地
铺谋定计
铺采摛文
铺锦列绣
铿金戛玉
铿金霏玉
铿锵有力
铿镪顿挫
销声匿影
销声匿迹
销声敛迹
销声避影
销毁骨立
销神流志
销魂夺魄
销魂荡魄
锄强扶弱
锋不可当
锋发韵流
锋芒不露
锋芒所向
锋芒毕露
锋芒逼人
锋铓毕露
锋镝余生
锐不可当
锐挫望绝
锐挫气索
锒铛入狱
错彩镂金
错综复杂
错节盘根
错落不齐
错落参差
错落有致
错落高下
错认颜标
锣鼓喧天
锥刀之利
锥刀之末
锥处囊中
锦上添花
锦囊佳制
锦囊佳句
锦囊妙计
锦囊玉轴
锦囊还矢
锦团花簇
锦天绣地
锦心绣口
锦心绣肠
锦心绣腹
锦片前程
锦瑟华年
锦瑟年华
锦篇绣帙
锦簇花团
锦绣前程
锦绣山河
锦绣心肠
锦绣江山
锦绣河山
锦绣肝肠
锦胸绣口
锦营花阵
锦衣玉食
锦衣肉食
锦衣行昼
锦阵花营
锯牙钩爪
锱珠必较
锱铢不爽
锱铢必较
锱铢较量
锲而不舍
锵金铿玉
锵金鸣玉
锺鸣漏尽
锺鸣鼎食
锺鼎山林
镂冰劚雪
镂冰斸雪
镂冰炊砾
镂冰雕朽
镂冰雕琼
镂尘吹影
镂心刻骨
镂心呕血
镂心鉥肝
镂月裁云
镂玉裁冰
镂肝鉥肾
镂脂翦楮
镂金铺翠
镂金错彩
镂金错采
镂骨铭心
镂骨铭肌
镇日镇夜
镌心铭骨
镌空妄实
镌脾琢肾
镌骨铭心
镕今铸古
镕古铸今
镜分鸾凤
镜圆璧合
镜破钗分
镜花水月
镜里观花
镜里采花
镞砺括羽
长久之计
长乐未央
长亭短亭
长傲饰非
长吁短叹
长吁短气
长命富贵
长命百岁
长嘘短叹
长夜之饮
长夜漫漫
长夜难明
长安少年
长安居大不易
长安棋局
长安道上
长年三老
长年累月
长幼尊卑
长幼有叙
长幼有序
长往远引
长念却虑
长恶不悛
长恶靡悛
长戟高门
长才广度
长才短驭
长揖不拜
长斋礼佛
长斋绣佛
长春不老
长材小试
长材茂学
长枕大衾
长枕大被
长林丰草
长歌当哭
长此以往
长江后浪推前浪
长江天堑
长治久安
长生不死
长生不老
长生久视
长目飞耳
长眠不起
长算远略
长篇大套
长篇大论
长篇累牍
长绳系日
长绳系景
长舌之妇
长虑却顾
长虑后顾
长虑顾后
长虺成蛇
长蛇封豕
长街短巷
长袖善舞
长计远虑
长话短说
长谈阔论
长辔远御
长辔远驭
长途跋涉
长颈鸟喙
长风破浪
长驱深入
长驱直入
长驱直进
长驾远驭
长鸣都尉
闇室不欺
闇无天日
门不停宾
门不夜关
门不夜扃
门到户说
门单户薄
门可张罗
门可罗雀
门堪罗雀
门墙桃李
门外汉
门庭如市
门庭若市
门庭赫奕
门当户对
门户之争
门户之见
门无杂客
门无杂宾
门殚户尽
门生故吏
门生故旧
门禁森严
门衰祚薄
门闾之望
门阶户席
闩门闭户
闪烁其词
闪烁其辞
闭关却扫
闭关絶市
闭关绝市
闭关自主
闭关自守
闭关锁国
闭口不言
闭口捕舌
闭口无言
闭口结舌
闭口藏舌
闭合思过
闭合自责
闭塞眼睛捉麻雀
闭境自守
闭壁清野
闭户读书
闭明塞聪
闭月羞花
闭目塞听
闭目塞耳
闭目塞聪
闭门不出
闭门不纳
闭门却扫
闭门却轨
闭门合辙
闭门埽轨
闭门塞户
闭门塞窦
闭门墐户
闭门思愆
闭门思过
闭门扫轨
闭门扫迹
闭门投辖
闭门羹
闭门自守
闭门觅句
闭门读书
闭门造车
闭门酣歌
闭阁思过
闭阁自责
问一答十
问十道百
问天买卦
问安视寝
问安视膳
问官答花
问寒问暖
问寝视膳
问心无愧
问柳寻花
问柳评花
问牛知马
问罪之师
问羊知马
问舍求田
问诸水滨
问道于盲
问长问短
问鼎中原
问鼎轻重
闯南走北
闯荡江湖
闲不容发
闲不容息
闲不容瞚
闲不容砺
闲不容缓
闲不容缕
闲云孤鹤
闲云野鹤
闲情别致
闲情逸志
闲情逸致
闲情逸趣
闲愁万种
闲是闲非
闲曹冷局
闲杂人等
闲神野鬼
闲花埜草
闲花野草
闲见层出
闲言冷语
闲言泼语
闲言淡语
闲言碎语
闲言赘语
闲言长语
闲言闲语
闲邪存诚
闲非闲是
闲鸥野鹭
闳中肆外
闳侈不经
闳大不经
闳宇崇楼
闳意妙指
闳意眇指
闳言崇议
闳言高论
闳识孤怀
间不容发
间不容息
间不容瞚
间不容瞬
间不容砺
间不容缓
间不容缕
间见层出
闵乱思治
闷海愁山
闷葫芦
闷闷不乐
闺英闱秀
闻一知二
闻一知十
闻名不如见面
闻名丧胆
闻名遐迩
闻噎废食
闻声相思
闻宠若惊
闻所不闻
闻所未闻
闻融敦厚
闻过则喜
闻雷失箸
闻风丧胆
闻风响应
闻风破胆
闻风而兴
闻风而动
闻风而至
闻风而起
闻风而逃
闻风远扬
闻风远遁
闻鸡起舞
闾阎安堵
阅人多矣
阆苑琼楼
阋墙御侮
阋墙谇帚
阐幽抉微
阐幽探赜
阐幽明微
阐扬光大
阑风伏雨
阑风长雨
阒其无人
阒无一人
阒无人声
阒然无声
阔步高谈
阔论高谈
阖门百口
阙一不可
阪上走丸
阮囊羞涩
防不及防
防不胜防
防微杜渐
防微杜衅
防微虑远
防心摄行
防患于未然
防患未然
防患未萌
防意如城
防祸于未然
防芽遏萌
防萌杜渐
阳关三迭
阳关大道
阳奉阴违
阳春有脚
阳春白雪
阳煦山立
阳解阴毒
阴凝冰坚
阴凝坚冰
阴山背后
阴差阳错
阴曹地府
阴服微行
阴疑阳战
阴谋诡计
阴错阳差
阴阳交错
阴阳怪气
阴阳惨舒
阴魂不散
阵马风樯
阶前万里
阻山带河
阽危之域
阿世取容
阿世媚俗
阿世盗名
阿党比周
阿党相为
阿其所好
阿姑阿翁
阿娇金屋
阿家阿翁
阿平絶倒
阿平绝倒
阿弥陀佛
阿意取容
阿时趋俗
阿权膴仕
阿毗地狱
阿狗阿猫
阿猫阿狗
阿谀取容
阿谀奉承
阿谀谄媚
阿谀逢迎
阿鼻地狱
陂湖禀量
附上罔下
附下罔上
附会穿凿
附凤攀龙
附势趋炎
附声吠影
附庸风雅
附影附声
附炎趋热
附翼攀鳞
附耳低言
附耳射声
附肤落毛
附膻逐腥
附赘县疣
附赘悬疣
附赘悬肬
附骥名彰
附骥尾
附骥攀鳞
附骥攀鸿
际会风云
际地蟠天
际遇风云
陆海潘江
陆离光怪
陆离斑驳
陆詟水栗
陇头音信
陈力就列
陈古刺今
陈善闭邪
陈师鞠旅
陈规陋习
陈言务去
陈言老套
陈言肤词
陈词滥调
陈谷子烂芝麻
陈辞滥调
陈陈相因
陋巷箪瓢
陌路相逢
降妖捉怪
降尊临卑
降尊纡贵
降心下气
降心俯首
降心相从
降心顺俗
降志辱身
降服而囚
降本流末
降格以求
降贵纡尊
降颜屈体
降龙伏虎
陟岵瞻望
陟岵陟屺
陟罚臧否
陡壁悬崖
除奸革弊
除害兴利
除恶务尽
除恶务本
除患兴利
除旧布新
除旧更新
除暴安良
除残去秽
除狼得虎
除疾遗类
除秽布新
除邪惩恶
陨身糜骨
陨雹飞霜
险象环生
险遭不测
险阻艰难
陵劲淬砺
陵弱暴寡
陵谷变迁
陵谷沧桑
陵迟
陶情适性
陶然自得
陶熔鼓铸
陶犬瓦鸡
陶陶兀兀
陷于缧绁
陷入僵局
陷落计中
陷身囹圄
隆刑峻法
隋侯之珠
隋珠和玉
隋珠和璧
隋珠弹雀
隋珠荆璧
随世沈浮
随世沉浮
随乡入乡
随乡入俗
随事制宜
随人作计
随人俯仰
随俗沈浮
随俗沉浮
随俗浮沈
随俗浮沉
随俗雅化
随圆就方
随地随时
随声吠影
随声是非
随声趋和
随声附和
随寓而安
随寓随安
随心所欲
随才器使
随方就圆
随方逐圆
随时制宜
随时施宜
随时随地
随机应变
随波逐尘
随波逐流
随波逐浪
随物应机
随物赋形
随珠和璧
随珠弹雀
随珠荆玉
随缘乐助
随行就市
随行逐队
随踵而至
随车夏雨
随车甘雨
随车致雨
随近逐便
随遇而安
随风倒舵
随风而靡
随风转舵
随风逐浪
随高就低
随高逐低
隐介藏形
隐占身体
隐名埋姓
隐天蔽日
隐姓埋名
隐居求志
隐忍不发
隐忍不言
隐恶扬善
隐晦曲折
隐然敌国
隐约其词
隐约其辞
隐若敌国
隐迹埋名
隐隐约约
隐鳞戢羽
隐鳞戢翼
隐鳞藏彩
隔世之感
隔墙有耳
隔壁听话
隔壁撺椽
隔屋撺椽
隔山买老牛
隔岸观火
隔年皇历
隔皮断货
隔行如隔山
隔靴抓痒
隔靴搔痒
隔靴爬痒
隙大墙坏
隙穴之窥
隳肝尝胆
隳肝沥胆
隳胆抽肠
隳节败名
隶首之学
难乎为情
难乎为继
难乎其难
难于上天
难于上青天
难以为情
难以为继
难以置信
难以预料
难兄难弟
难分难舍
难分难解
难如登天
难弟难兄
难得糊涂
难更仆数
难能可贵
难舍难分
难解难分
难言之隐
难进易退
难鸣孤掌
雀喧鸠聚
雀小脏全
雀屏中选
雀目鼠步
雀角鼠牙
雀马鱼龙
雀鼠之争
雁南燕北
雁去鱼来
雁塔新题
雁塔题名
雁影分飞
雁断鱼沈
雁断鱼沉
雁杳鱼沉
雁泊人户
雁素鱼笺
雁过拔毛
雁过拨毛
雁过留声
雁逝鱼沉
雁默先烹
雄伟壮观
雄唱雌和
雄姿英发
雄心勃勃
雄心壮志
雄才大略
雄文大手
雄材大略
雄深雅健
雄视一世
雄辩高谈
雄飞雌伏
雄鸡夜鸣
雄鸡断尾
雅人深致
雅人清致
雅人韵士
雅俗共赏
雅量高致
雅雀无声
集思广益
集思广议
集矢之的
集腋为裘
集腋成裘
集苑集枯
集萤映雪
雉伏鼠窜
雉头狐腋
雌雄未决
雍容不迫
雍容典雅
雍容华贵
雍容大度
雍容大雅
雍容尔雅
雍容闲雅
雍容雅步
雍荣华贵
雍荣闲雅
雍荣雅步
雍门刎首
雏凤清声
雏鹰展翅
雕墙峻宇
雕心刻肾
雕心雁爪
雕心鹰爪
雕文刻镂
雕文织彩
雕文织采
雕栏玉砌
雕梁画栋
雕梁绣户
雕楹碧槛
雕玉双联
雕盘绮食
雕章琢句
雕章绘句
雕章缛彩
雕章镂句
雕肝掐肾
雕肝琢肾
雕肝琢膂
雕肝镂肾
雕虎焦原
雕虫刻篆
雕虫小事
雕虫小巧
雕虫小技
雕虫小艺
雕虫末伎
雕虫末技
雕虫篆刻
雕虫薄技
雕蚶镂蛤
雕镂藻绘
雕阑玉砌
雕风镂月
雕龙画凤
雨丝风片
雨井烟垣
雨僝云僽
雨僝风僽
雨僽风僝
雨凑云集
雨卧风餐
雨后春笋
雨后送伞
雨宿风餐
雨巾风帽
雨帘云栋
雨恨云愁
雨愁烟恨
雨打风吹
雨收云散
雨散云收
雨散云飞
雨散风流
雨断云销
雨旸时若
雨条烟叶
雨栋风帘
雨歇云收
雨沐风餐
雨沾云惹
雨泣云愁
雨消云散
雨淋日晒
雨淋日炙
雨笠烟蓑
雨约云期
雨膏烟腻
雨蓑烟笠
雨蓑风笠
雨覆云翻
雨踪云迹
雨过天晴
雨过天青
雨迹云踪
雨零星乱
雨零星散
雨露之恩
雨霾风障
雨顺风调
雨鬓风鬟
雨鬣霜蹄
雪上加霜
雪中送炭
雪中鸿爪
雪兆丰年
雪北香南
雪天萤席
雪操冰心
雪月风花
雪案萤灯
雪案萤窗
雪泥鸿爪
雪泥鸿迹
雪碗冰瓯
雪窑冰天
雪窖冰天
雪窗萤几
雪窗萤火
雪耻报仇
雪胎梅骨
雪虐风饕
雪里送炭
雪鬓霜毛
雪鬓霜鬟
雪鸿指爪
零丁孤苦
零七八碎
零光片羽
零圭断璧
零打碎敲
零敲碎打
零珠碎玉
零零星星
雷令风行
雷动风行
雷厉风行
雷厉风飞
雷嗔电怒
雷奔云谲
雷惊电绕
雷打不动
雷电交加
雷霆万钧
雷霆之怒
雷鸣瓦釜
雾兴云涌
雾惨云愁
雾散云披
雾暗云深
雾涌云蒸
雾起云涌
雾释冰融
雾里看花
雾锁烟迷
雾阁云窗
雾集云合
雾鬓云鬟
雾鬓风鬟
雾鳞云爪
需沙出穴
霁月光风
霁风朗月
霄壤之别
霄壤之殊
霄鱼垂化
震古烁今
震古铄今
震天动地
震撼人心
震耳欲聋
震聋发聩
霍然而愈
霜凋夏緑
霜凋夏绿
霜气横秋
霜行草宿
霜露之思
霜露之悲
霜露之感
霜露之病
霜露之辰
霞光万道
霞友云朋
霞姿月韵
霞思云想
霞思天想
霞明玉映
霞蔚云蒸
霞裙月帔
露宿风餐
露尾藏头
露己扬才
露影藏形
露往霜来
露才扬己
露水夫妻
露纂雪钞
露红烟紫
露红烟緑
露红烟绿
露胆披肝
露胆披诚
露钞雪纂
露面抛头
露餐风宿
露马脚
霸王别姬
霸王风月
霸道横行
霸陵醉尉
青丝白马
青云万里
青云独步
青云直上
青出于蓝
青出于蓝而胜于蓝
青口白舌
青史传名
青史垂名
青史标名
青史流芳
青史留名
青史留芳
青堂瓦舍
青天白日
青天霹雳
青山一发
青山不老
青山緑水
青山绿水
青州从事
青林黑塞
青枝緑叶
青枝绿叶
青梅竹马
青楼楚馆
青灯古佛
青灯黄卷
青眼相看
青竹丹枫
青紫被体
青红皁白
青红皂白
青肝碧血
青蓝冰水
青藜学士
青蝇之吊
青蝇吊客
青蝇染白
青蝇点玉
青蝇点璧
青蝇点素
青衫司马
青裙缟袂
青过于蓝
青钱万选
青钱学士
青霄白日
青霄直上
青面獠牙
青鞋布袜
青鸟殷勤
青黄不接
青黄未接
青黄沟木
青龙金匮
靖言庸回
靖言庸违
靖谮庸回
静影沉璧
静极思动
静观默察
静言令色
静言庸违
非亲非故
非分之念
非分之想
非分之财
非同儿戏
非同寻常
非同小可
非常之谋
非异人任
非意相干
非愚则诬
非我族类
非昔是今
非此即彼
非池中物
非驴非马
靠天吃饭
靡坚不摧
靡所底止
靡所适从
靡有孑遗
靡然乡风
靡然从风
靡然向风
靡然成风
靡然顺风
靡知所措
靡衣偷食
靡衣媮食
靡衣玉食
靡靡之乐
靡靡之声
靡靡之音
靡颜腻理
面不改容
面不改色
面争庭论
面从腹诽
面似靴皮
面北眉南
面命耳提
面墙而立
面壁功深
面壁磨砖
面如傅粉
面如冠玉
面如凝脂
面如土色
面如死灰
面如满月
面如灰土
面引廷争
面折庭争
面折廷争
面折廷诤
面授机宜
面无人色
面无惭色
面是心非
面是背非
面有菜色
面有难色
面朋口友
面目一新
面目全非
面目可憎
面目狰狞
面红耳热
面红耳赤
面红面緑
面红面绿
面红面赤
面红颈赤
面缚舆榇
面缚衔璧
面色如土
面若死灰
面誉背毁
面誉背非
面谀背毁
面谩腹诽
面面俱到
面面俱圆
面面厮觑
面面圆到
面面皆到
面面相看
面面相睹
面面相窥
面面相覩
面面相觑
面黄肌瘦
靦颜事仇
靦颜人世
革凡成圣
革凡登圣
革命创制
革命反正
革图易虑
革奸铲暴
革带移孔
革心易行
革故立新
革故鼎新
革新变旧
革旧从新
革旧图新
革旧维新
革旧鼎新
革邪反正
革面悛心
革面敛手
革面洗心
革面革心
革风易俗
靴刀誓死
鞅鞅不乐
鞋弓袜小
鞋弓袜浅
鞋弓襪小
鞋弓襪浅
鞍前马后
鞍马之劳
鞍马劳倦
鞍马劳困
鞍马劳神
鞍马劳顿
鞘里藏刀
鞠为茂草
鞠躬君子
鞠躬尽力
鞠躬尽瘁
鞠躬屏气
鞫为茂草
鞭不及腹
鞭丝帽影
鞭擗向里
鞭擗进里
鞭约近里
鞭辟入里
鞭辟向里
鞭辟着里
鞭辟近里
鞭长不及
鞭长不及马腹
鞭长莫及
鞭长驾远
鞭驽策蹇
韦弦之佩
韦编三絶
韦编三绝
韦裤布被
韩卢逐块
韩卢逐逡
韩寿偷香
韩寿分香
韩海苏潮
韩潮苏海
韩獹逐块
韫椟而藏
韫椟藏珠
韬光俟奋
韬光养晦
韬光敛彩
韬光敛迹
韬光晦迹
韬光灭迹
韬光用晦
韬光隐晦
韬光隐迹
韬光韫玉
韬声匿迹
韬形灭影
韬戈偃武
韬戈卷甲
韬晦之计
韬晦待时
韬曜含光
韬神晦迹
韬迹隐智
音信杳无
音容如在
音容宛在
音容笑貌
音问两绝
韶华如驶
韶颜稚齿
顶名冒姓
顶名替身
顶天立地
顶天踵地
顶礼膜拜
顶踵尽捐
顶踵捐糜
顶针续麻
顶门壮户
顶门立户
项庄舞剑
项背相望
顺人应天
顺口开河
顺天从人
顺天应人
顺天应时
顺手牵羊
顺时施宜
顺时而动
顺时随俗
顺水人情
顺水推舟
顺水推船
顺水放船
顺水行舟
顺水顺风
顺理成章
顺美匡恶
顺蔓摸瓜
顺藤摸瓜
顺过饰非
顺非而泽
顺风使帆
顺风使舵
顺风使船
顺风吹火
顺风张帆
顺风扯帆
顺风而呼
顺风行船
顺风转舵
顺风驶船
须发皆白
须弥芥子
须眉交白
须眉男子
须眉皓然
须髯如戟
须髯若神
顽固不化
顽廉懦立
顽梗不化
顽父嚚母
顽皮贼骨
顽皮赖肉
顽皮赖骨
顽石点头
顾全大局
顾前不顾后
顾名思义
顾后瞻前
顾复之恩
顾头不顾尾
顾小失大
顾左右而言他
顾影弄姿
顾影惭形
顾影自怜
顾景惭形
顾曲周郎
顾此失彼
顾犬补牢
顾盼多姿
顾盼生姿
顾盼生辉
顾盼神飞
顾盼自豪
顾盼自雄
顾而言他
顾虑重重
顿口拙腮
顿口无言
顿学累功
顿开茅塞
顿挫抑扬
顿纲振纪
顿脚捶胸
顿腹之言
顿足不前
顿足失色
顿足捩耳
顿足捶胸
顿足搓手
顿足搥胸
顿足椎胸
顿首再拜
颂古非今
颂声载道
颂德歌功
领异标新
颊上三毛
颊上三毫
颊上添毫
颐养天年
颐养精神
颐性养寿
颐指气使
颐指风使
颐神养寿
颐神养性
颐神养气
颐精养神
颓垣废井
颓垣废址
颓垣断堑
颓垣败井
颓垣败壁
颖悟绝人
颖悟绝伦
颖脱而出
颗粒无收
题名道姓
颜丹鬓緑
颜丹鬓绿
颜筋柳骨
颜精柳骨
颜面扫地
颜骨柳筋
额外主事
额手相庆
额手称庆
额手称颂
额蹙心痛
额首称庆
颠三倒四
颠乾倒坤
颠仆流离
颠倒乾坤
颠倒干坤
颠倒是非
颠倒衣裳
颠倒阴阳
颠倒黑白
颠唇簸嘴
颠干倒坤
颠扑不破
颠扑不磨
颠斤播两
颠来倒去
颠来播去
颠来簸去
颠毛种种
颠沛流离
颠簸不破
颠衣到裳
颠颠倒倒
颠鸾倒凤
风不鸣条
风中之烛
风中秉烛
风举云摇
风举云飞
风云不测
风云之志
风云人物
风云变幻
风云变态
风云变色
风云叱咤
风云月露
风云突变
风云际会
风从响应
风俗人情
风信年华
风僝雨僽
风光旖旎
风光月霁
风兴云蒸
风兵草甲
风刀霜剑
风前月下
风前残烛
风华正茂
风华浊世
风华绝代
风卷残云
风口浪尖
风吹云散
风吹日晒
风吹浪打
风吹草动
风吹雨打
风吹马耳
风和日丽
风和日暄
风和日暖
风和日煗
风和日美
风回电激
风土人情
风声鹤唳
风姿绰约
风宿水飡
风宿水餐
风尘之会
风尘之变
风尘之声
风尘之惊
风尘之言
风尘之警
风尘仆仆
风尘外物
风尘物表
风尘碌碌
风尘肮脏
风尘表物
风平波息
风平浪静
风度翩翩
风张风势
风影敷衍
风急浪高
风恬浪静
风情月债
风情月思
风情月意
风掣雷行
风斯在下
风旋电掣
风景不殊
风暖日丽
风月无涯
风月无边
风木之思
风木之悲
风木含悲
风栉雨沐
风树之悲
风樯阵马
风檐刻烛
风檐寸晷
风波平地
风流事过
风流云散
风流人物
风流倜傥
风流儒雅
风流冤孽
风流千古
风流博浪
风流才子
风流潇洒
风流缊藉
风流罪犯
风流罪过
风流蕴藉
风流藴藉
风流跌宕
风流酝藉
风流雨散
风流韵事
风清弊絶
风清弊绝
风清月明
风清月朗
风清月白
风清月皎
风潇雨晦
风激电飞
风激电骇
风烛之年
风烛残年
风烛草露
风牛马不相及
风环雨鬓
风禾尽起
风移俗变
风移俗改
风移俗易
风花雪夜
风花雪月
风萍浪迹
风虎云龙
风行一世
风行一时
风行水上
风行电击
风行电扫
风行电掣
风行电照
风行草从
风行草偃
风行草靡
风行雨散
风行雷厉
风行革偃
风言影语
风言醋语
风言雾语
风言风语
风语不透
风调雨顺
风谲云诡
风起云布
风起云涌
风起云蒸
风起云飞
风起水涌
风起泉涌
风起浪涌
风起潮涌
风趣横生
风车云马
风车雨马
风轻云净
风轻云浄
风通道会
风里杨花
风门水口
风雨不改
风雨不测
风雨不透
风雨交加
风雨共舟
风雨凄凄
风雨同舟
风雨如晦
风雨如盘
风雨如磐
风雨对床
风雨摇摆
风雨无阻
风雨时若
风雨晦冥
风雨晦暝
风雨漂摇
风雨萧条
风雨连床
风雨飘摇
风雨飘零
风雨飘飖
风雪交加
风雷之变
风雷火炮
风霜雨雪
风靡一世
风靡一时
风靡云涌
风靡云蒸
风韵犹存
风风火火
风风雨雨
风风韵韵
风飞云会
风飡水宿
风飧水宿
风餐水宿
风餐雨宿
风餐露宿
风马不接
风马云车
风马牛
风马牛不相及
风驰云卷
风驰云走
风驰电击
风驰电卷
风驰电掣
风驰电赴
风驰电逝
风驰电骋
风驰草靡
风驰雨骤
风驰霆击
风驱电击
风驱电扫
风骨峭峻
风鬟雨鬓
风鬟雾鬓
飒爽英姿
飘樊落溷
飘泊无定
飘洋航海
飘洋过海
飘瓦虚舟
飘籓坠溷
飘茵堕溷
飘茵落溷
飘茵随溷
飘萍断梗
飘萍浪迹
飘蓬断梗
飘藩坠溷
飘零书剑
飘风急雨
飘风暴雨
飘风苦雨
飘风过耳
飘风骤雨
飘飘欲仙
飙举电至
飙发电举
飜手云覆手雨
飜黄倒皂
飞书走檄
飞云掣电
飞刍挽粒
飞刍挽粟
飞刍挽粮
飞刍转饷
飞升腾实
飞土逐害
飞土逐肉
飞声腾实
飞扬浮躁
飞扬跋扈
飞文染翰
飞来横祸
飞檐走壁
飞檐走脊
飞殃走祸
飞沙扬砾
飞沙走石
飞沙走砾
飞沿走壁
飞流短长
飞灾横祸
飞熊入梦
飞珠溅玉
飞眼传情
飞短流长
飞砂扬砾
飞砂走石
飞砂转石
飞禽走兽
飞米转刍
飞粮挽秣
飞苍走黄
飞蒭挽粟
飞蓬乘风
飞蓬随风
飞蛾扑火
飞蛾投火
飞蛾赴火
飞蛾赴烛
飞蛾赴焰
飞觞走斝
飞觥献斝
飞觥走斝
飞谋荐谤
飞谋钓谤
飞遁离俗
飞遁鸣高
飞针走线
飞阁流丹
飞霜六月
飞鸟依人
飞鸟惊蛇
飞鸾翔凤
飞鸿印雪
飞鸿踏雪
飞鸿雪爪
飞鹰奔犬
飞鹰走犬
飞鹰走狗
飞鹰走马
飞黄腾踏
飞黄腾达
飞龙乘云
飞龙在天
食不下咽
食不二味
食不充口
食不充肠
食不充饥
食不兼味
食不兼肉
食不暇饱
食不果腹
食不求甘
食不甘味
食不知味
食不累味
食不终味
食不遑味
食不重味
食不重肉
食不餬口
食为民天
食亲财黑
食前方丈
食古不化
食古如鲠
食味方丈
食子徇君
食宿相兼
食少事烦
食少事繁
食必方丈
食指大动
食方于前
食日万钱
食案方丈
食毛践土
食玉炊桂
食甘寝宁
食甘寝安
食生不化
食租衣税
食箪浆壶
食而不化
食肉寝皮
食荼卧棘
食藿悬鹑
食言而肥
食辨劳薪
食饥息劳
食马留肝
食鱼遇鲭
餐云卧石
餐松啖柏
餐松饮涧
餐腥啄腐
餐葩饮露
餐霞吸露
餐霞漱瀣
餐霞饮景
餐霞饮液
餐霞饮瀣
餐风咽露
餐风啮雪
餐风宿水
餐风宿草
餐风宿雨
餐风宿露
餐风沐雨
餐风茹雪
餐风露宿
餐风饮露
餔糟啜漓
餔糟啜醨
餔糟歠漓
餔糟歠醨
饔飧不济
饔飧不给
饔飧不继
饔飧不饱
饔飱不给
饔飱不继
饕口馋舌
饕风虐雪
饕餮之徒
饥不择食
饥不暇食
饥不遑食
饥冻交切
饥寒交凑
饥寒交切
饥寒交至
饥寒交迫
饥渴交攻
饥火烧肠
饥焰中烧
饥肠辘辘
饥附饱扬
饥附饱飏
饥飡渴饮
饥餐渴饮
饥饱劳役
饥馑荐臻
饥駈叩门
饥驱叩门
饥鹰饿虎
饫甘餍肥
饫闻厌见
饭囊衣架
饭囊酒瓮
饭囊酒甕
饭坑酒囊
饭来开口
饭来张口
饭牛屠狗
饭粝茹蔬
饭糗茹草
饭蔬饮水
饮冰内热
饮冰吞檗
饮冰茹檗
饮冰茹蘖
饮冰食檗
饮冰食蘖
饮恨吞声
饮恨而终
饮气吞声
饮水啜菽
饮水思源
饮水曲肱
饮水栖衡
饮水知源
饮水辨源
饮水食菽
饮河满腹
饮河鼹鼠
饮泉清节
饮泣吞声
饮灰洗胃
饮犊上流
饮胆尝血
饮血崩心
饮血茹毛
饮谷栖丘
饮醇自醉
饮露餐风
饮食男女
饮食起居
饮马投钱
饮马长江
饮鸩止渴
饮鸩解渴
饰垢掩疵
饰怪装奇
饰情矫行
饰智矜愚
饰非养过
饰非拒谏
饰非掩过
饰非文过
饰非遂过
饱人不知饿人饥
饱以老拳
饱学之士
饱暖思淫欲
饱暖生淫欲
饱汉不知饿汉饥
饱练世故
饱经世变
饱经世故
饱经忧患
饱经沧桑
饱经霜雪
饱经风雨
饱经风霜
饱谙世故
饱食暖衣
饱食终日
饱飨老拳
饴含抱孙
饶有风趣
饶舌调唇
饿殍枕藉
饿殍满道
饿殍载道
饿殍遍野
饿莩载道
饿莩遍野
饿虎之蹊
饿虎吞羊
饿虎扑羊
饿虎扑食
饿虎擒羊
饿虎饥鹰
馈贫之粮
馋涎欲滴
馔玉炊珠
馔玉炊金
首下尻高
首丘之情
首善之区
首善之地
首尾两端
首尾共济
首尾相卫
首尾相应
首尾相援
首尾相继
首尾相连
首屈一指
首当其冲
首施两端
首足异处
首身分离
首鼠两端
香培玉琢
香消玉减
香消玉损
香消玉殒
香消玉碎
香火不绝
香火因缘
香火姻缘
香花供养
香草美人
香药脆梅
香象渡河
香象絶流
香象绝流
香车宝马
香轮宝骑
香闺绣阁
馨香祷祝
騃女痴儿
騃女痴男
騃童钝夫
马上功成
马上墙头
马上得天下
马上房子
马上看花
马不停蹄
马不解鞍
马中关五
马仰人翻
马入华山
马到功成
马到成功
马前卒
马前泼水
马勃牛溲
马去马归
马后炮
马咽车阗
马壮人强
马如流水
马如游鱼
马如游龙
马尘不及
马工枚速
马捉老鼠
马放南山
马毛猬磔
马毛蝟磔
马水车龙
马浡牛溲
马牛其风
马牛襟裾
马瘦毛长
马空冀北
马翻人仰
马耳东风
马耳春风
马腹逃鞭
马角乌头
马角乌白
马足车尘
马足龙沙
马迟枚疾
马迹蛛丝
马面牛头
马革盛尸
马革裹尸
马首是瞻
马首欲东
马马虎虎
马鹿异形
马鹿易形
马齿徒增
马齿徒长
马龙车水
驭凤骖鹤
驰名中外
驰名天下
驰名当世
驰声走誉
驰志伊吾
驰风骋雨
驰马试剑
驰骋疆场
驰高鹜远
驰魂夺魄
驰魂宕魄
驱羊战狼
驱羊攻虎
驱雷掣电
驱雷策电
驱霆策电
驳瑕指颣
驷不及舌
驷之过蠙
驷之过隙
驷马不追
驷马仰秣
驷马莫追
驷马轩车
驷马难追
驷马高盖
驷马高车
驷马高门
驹光过隙
驹留空谷
驹窗电逝
驹齿未落
驻红却白
驻跸
驻颜有术
驻颜益寿
驽箭离弦
驽马十舍
驽马十驾
驽马恋栈
驽马恋栈豆
驽马鈆刀
驽马铅刀
驾肩接武
驾肩接迹
驾轻就熟
驾雾腾云
驾鹤成仙
驾鹤西游
驿使梅花
驿寄梅花
驿路梅花
骀背鹤发
骁勇善战
骂不绝口
骂天咒地
骂天扯地
骄佚奢淫
骄侈暴佚
骄侈淫虐
骄傲自满
骄儿騃女
骄兵之计
骄兵必败
骄奢放逸
骄奢淫佚
骄奢淫泆
骄奢淫逸
骄泰淫泆
骄生惯养
骅骝开道
骆驿不絶
骆驿不绝
骇人听闻
骇人视听
骇人闻听
骇人闻见
骇心动目
骇浪惊涛
骇状殊形
骇目惊心
骇目振心
骇龙走蛇
骈兴错出
骈四俪六
骈拇枝指
骈枝俪叶
骈肩叠迹
骈肩接迹
骈肩累足
骈肩累踵
骈肩累迹
骈肩迭迹
骈门连室
骈首就僇
骈首就戮
骈首就死
骈首就系
骈首就逮
骊黄牝牡
骋嗜奔欲
骋怀游目
骋耆奔欲
骏波虎浪
骏骨牵盐
骐骥一毛
骐骥困盐车
骐骥过隙
骑上扬州鹤
骑扬州鹤
骑曹不记马
骑牛觅牛
骑牛读汉书
骑者善堕
骑虎难下
骑马寻马
骑马找马
骑驴倒堕
骑驴吟灞上
骑驴索句
骑驴觅驴
骑驴风雪中
骑鹤上扬
骑鹤上扬州
骑鹤上维扬
骑鹤扬州
骑鹤更扬州
骑鹤望扬州
骑鹤维扬
骑龙弄凤
骖风驷霞
骖鸾驭鹤
骚人墨士
骚人墨客
骚人词客
骚人逸客
骚人雅士
骚情赋骨
骚翁墨客
骤不及防
骤雨暴风
骤雨狂风
骤风急雨
骤风暴雨
骥伏盐车
骥子龙文
骥服盐车
骨化形销
骨化风成
骨寒毛竖
骨瘦如柴
骨瘦如豺
骨瘦形销
骨肉团圆
骨肉未寒
骨肉相残
骨肉相连
骨肉离散
骨肉至亲
骨腾肉飞
骨软筋酥
骨软筋麻
骨软肉酥
骨软觔麻
骨鲠之臣
骨鲠在喉
髀肉复生
髀里肉生
高下任心
高下其手
高下在口
高下在心
高下在手
高不凑低不就
高不可攀
高不可登
高不成低不就
高不辏低不就
高世骇俗
高举深藏
高举远蹈
高义薄云
高义薄云天
高人一等
高人一筹
高人逸士
高人雅士
高位厚禄
高位重禄
高傲自大
高冠博带
高凤自秽
高出一筹
高卧东山
高名大姓
高唱入云
高垒深沟
高城深池
高堂大厦
高天厚地
高头大马
高头讲章
高姓大名
高官厚禄
高官尊爵
高官显爵
高官极品
高官重禄
高居深拱
高屋建瓴
高山仰之
高山仰止
高山峻岭
高山景行
高山流水
高岸深谷
高悬秦镜
高情厚谊
高情远意
高情远致
高情远韵
高情逸兴
高情逸态
高才卓识
高才大学
高才大德
高才捷足
高才疾足
高才絶学
高才绝学
高才远识
高抬明镜
高抬贵手
高掌远跖
高掌远蹠
高文典册
高文典策
高文大册
高斋学士
高明远识
高朋满座
高材捷足
高材疾足
高枕勿忧
高枕安卧
高枕安寝
高枕无忧
高枕而卧
高楼大厦
高歌猛进
高步云衢
高步通衢
高步阔视
高深莫测
高爵厚禄
高爵重禄
高牙大纛
高睨大谈
高瞻远瞩
高翔远引
高而不危
高耸入云
高自位置
高自标树
高自标置
高自标誉
高节清风
高见远识
高视阔步
高识远见
高谈大论
高谈弘论
高谈虚论
高谈阔论
高谈雄辩
高足弟子
高蹈远举
高车驷马
高遏行云
高门大屋
高门大户
高阳酒徒
高顾遐视
高风亮节
高风劲节
高风峻节
高飞远举
高飞远翔
高飞远走
高飞远遁
高飞远集
高高在上
高鸟尽良弓藏
鬓乱钗横
鬻儿卖女
鬻声钓世
鬻宠擅权
鬻矛誉楯
鬻良杂苦
鬻驽窃价
鬻鸡为凤
鬼使神差
鬼出电入
鬼出神入
鬼刻神劖
鬼功神力
鬼吒狼嚎
鬼咤狼嚎
鬼哭天愁
鬼哭狼嗥
鬼哭狼嚎
鬼哭神号
鬼哭神嚎
鬼哭神惊
鬼哭神愁
鬼哭粟飞
鬼头滑脑
鬼头鬼脑
鬼工雷斧
鬼形怪状
鬼怕恶人
鬼抓狼嚎
鬼斧神工
鬼泣神号
鬼泣神嚎
鬼烂神焦
鬼瞰其室
鬼瞰高明
鬼神不测
鬼神莫测
鬼蜮伎俩
鬼蜮技俩
鬼计多端
鬼计百端
鬼设神使
鬼话连篇
鬼迷心窍
鬼鬼祟祟
鬼魅伎俩
魁梧奇伟
魂不守宅
魂不守舍
魂不着体
魂不著体
魂不负体
魂不赴体
魂不附体
魂丧神夺
魂亡胆落
魂亡魄失
魂劳梦断
魂惊胆落
魂惊胆颤
魂惊魄惕
魂惊魄落
魂惭色褫
魂慑色沮
魂慴色沮
魂摇魄乱
魂消胆丧
魂消魄丧
魂消魄夺
魂牵梦萦
魂耗魄丧
魂销目断
魂销肠断
魂颠梦倒
魂飘神荡
魂飘魄散
魂飞天外
魂飞目断
魂飞神丧
魂飞胆丧
魂飞胆战
魂飞胆破
魂飞胆落
魂飞胆裂
魂飞胆颤
魂飞魄丧
魂飞魄扬
魂飞魄散
魂飞魄荡
魂飞魄越
魂飞魄飏
魂驰梦想
魄散魂消
魄散魂飘
魄散魂飞
魄消魂散
魄荡魂摇
魄荡魂飞
魆风骤雨
魏紫姚黄
魏颗结草
魏鹊无枝
魑魅罔两
魑魅魍魉
鱼与熊掌
鱼书雁信
鱼书雁帖
鱼书雁帛
鱼书鴈信
鱼书鴈帛
鱼传尺素
鱼升龙门
鱼县鸟窜
鱼大水小
鱼封雁帖
鱼封鴈帖
鱼尾雁行
鱼帛狐声
鱼帛狐篝
鱼惊鸟散
鱼死网破
鱼水和谐
鱼水深情
鱼水相投
鱼水相欢
鱼沉雁杳
鱼沉雁渺
鱼沉雁落
鱼沉雁静
鱼沉鴈杳
鱼沉鴈渺
鱼沉鴈落
鱼沉鸿断
鱼游沸釜
鱼游沸鼎
鱼游濠上
鱼游燋釜
鱼游釜中
鱼游釜内
鱼游釜底
鱼溃鸟散
鱼溃鸟离
鱼烂取亡
鱼烂土崩
鱼烂河决
鱼烂瓦解
鱼烂而亡
鱼生空釜
鱼目混珍
鱼目混珎
鱼目混珠
鱼目间珠
鱼瞵鹗睨
鱼笺雁书
鱼米之乡
鱼米之地
鱼网鸿离
鱼肉乡里
鱼肉百姓
鱼肠尺素
鱼肠雁足
鱼质龙文
鱼贯而入
鱼贯而出
鱼贯而行
鱼贯雁比
鱼贯雁行
鱼跃鸢飞
鱼跃龙门
鱼釜尘甑
鱼馁肉败
鱼鱼雅雅
鱼鲁帝虎
鱼龙变化
鱼龙曼延
鱼龙曼羡
鱼龙曼衍
鱼龙混杂
鱼龙漫衍
鱼龙百变
鲁人回日
鲁卫之政
鲁戈回日
鲁戈挥日
鲁斤燕削
鲁殿灵光
鲁灵光殿
鲁莽灭裂
鲁连蹈海
鲁阳回日
鲁阳指日
鲁阳挥戈
鲁阳挥日
鲁阳麾戈
鲁鱼亥豕
鲁鱼帝虎
鲁鱼陶阴
鲂鱼赪尾
鲂鱼頳尾
鲇鱼上竹
鲇鱼上竹竿
鲇鱼上竿
鲇鱼缘竹竿
鲍子知我
鲍鱼之次
鲍鱼之肆
鲜廉寡耻
鲜眉亮眼
鲜艳夺目
鲜血淋漓
鲜衣怒马
鲜衣美食
鲜衣良马
鲜蹦活跳
鲜车健马
鲜车怒马
鲤鱼跳龙门
鲸吞虎噬
鲸吞蚕食
鲸吞蛇噬
鲸吸牛饮
鲸波怒浪
鲸波鳄浪
鲸波鼍浪
鲸涛鼍浪
鲽离鹣背
鳄鱼眼泪
鳌头独占
鳌愤龙愁
鳌掷鲸吞
鳌掷鲸呿
鳌里夺尊
鳌鸣鳖应
鳏寡孤惸
鳏寡孤独
鳏寡孤茕
鳏寡惸独
鳏寡茕独
鳏鱼渴凤
鳞次栉比
鳞次相比
鳞萃比栉
鳞集仰流
鳞集毛萃
鵰心雁爪
鵰心鴈爪
鵰心鹰爪
鶗鴂雕卉
鸟伏兽穷
鸟入樊笼
鸟兽散
鸟哭猿啼
鸟啼花怨
鸟啼花落
鸟声兽心
鸟尽弓藏
鸟得弓藏
鸟惊鱼散
鸟惊鱼溃
鸟惊鱼骇
鸟惊鼠窜
鸟散鱼溃
鸟枪换炮
鸟枪换砲
鸟焚鱼烂
鸟穷则啄
鸟覆危巢
鸟语花香
鸟迹虫丝
鸟道羊肠
鸟集鳞萃
鸟面鹄形
鸟革翚飞
鸟骇鼠窜
鸠僭鹊巢
鸠占鹊巢
鸠夺鹊巢
鸠居鹊巢
鸠工庀材
鸠形鹄面
鸠车竹马
鸠集凤池
鸡不及凤
鸡争鹅斗
鸡口牛后
鸡声鹅斗
鸡头鱼刺
鸡尸牛从
鸡栖凤巢
鸡毛蒜皮
鸡烂嘴巴硬
鸡犬不宁
鸡犬不安
鸡犬不惊
鸡犬不留
鸡犬不闻
鸡犬升天
鸡犬无惊
鸡犬桑麻
鸡犬皆仙
鸡犬相闻
鸡皮鹤发
鸡肠狗肚
鸡肤鹤发
鸡胸龟背
鸡虫得丧
鸡虫得失
鸡蛋里找骨头
鸡豚之息
鸡零狗碎
鸡飞狗叫
鸡飞狗走
鸡飞狗跳
鸡飞蛋打
鸡骨支床
鸡鸣候旦
鸡鸣戒旦
鸡鸣犬吠
鸡鸣狗吠
鸡鸣狗盗
鸡鸣而起
鸡鸣起舞
鸡鸣馌耕
鸡鹜争食
鸡鹜相争
鸢肩羔膝
鸢肩豺目
鸢肩鹄颈
鸢飞鱼跃
鸣于乔木
鸣冤叫屈
鸣凤朝阳
鸣玉曳履
鸣玉曳组
鸣珂锵玉
鸣琴而治
鸣野食苹
鸣金收兵
鸣金收军
鸣钟列鼎
鸣钟食鼎
鸣锣喝道
鸣锣开道
鸣雁直木
鸣鹤之应
鸣鼓而攻
鸣鼓而攻之
鸥水相依
鸥波萍迹
鸥鹭忘机
鸦巢生凤
鸦没鹊静
鸦雀无声
鸦雀无闻
鸦飞雀乱
鸦飞鹊乱
鸦鹊无声
鸦默雀静
鸦默鹊静
鸭步鹅行
鸭行鹅步
鸮啼鬼啸
鸮心鸝舌
鸮心鹂舌
鸮鸟生翼
鸮鸣鼠暴
鸱张蚁聚
鸱张门户
鸱张鱼烂
鸱张鼠伏
鸱目虎吻
鸱视狼顾
鸱视虎顾
鸱鸦嗜鼠
鸱鸮弄舌
鸳俦凤侣
鸷击狼噬
鸷狠狼戾
鸾交凤俦
鸾交凤友
鸾俦凤侣
鸾停鹄峙
鸾凤分飞
鸾凤和鸣
鸾分凤离
鸾只凤单
鸾吟凤唱
鸾回凤翥
鸾回凤舞
鸾姿凤态
鸾孤凤只
鸾孤凤寡
鸾歌凤吹
鸾歌凤舞
鸾漂凤泊
鸾翔凤翥
鸾翔凤集
鸾翱凤翥
鸾胶凤丝
鸾舆凤驾
鸾跂鸿惊
鸾音鹤信
鸾颠凤倒
鸾飘凤泊
鸾飞凤翥
鸾飞凤舞
鸾鸣凤奏
鸾鹄停峙
鸾鹄在庭
鸿业远图
鸿俦鹤侣
鸿儒硕学
鸿函巨椟
鸿函钜椟
鸿商富贾
鸿图华构
鸿断鱼沈
鸿断鱼沉
鸿案相庄
鸿案鹿车
鸿毛泰山
鸿毛泰岱
鸿毳沉舟
鸿泥雪爪
鸿消鲤息
鸿渐之仪
鸿渐之翼
鸿渐于干
鸿爪春泥
鸿爪留泥
鸿爪雪泥
鸿稀鳞絶
鸿稀鳞绝
鸿章巨字
鸿章钜字
鸿笔丽藻
鸿篇巨制
鸿篇巨着
鸿篇巨著
鸿篇钜制
鸿翔鸾起
鸿蒙初辟
鸿衣羽裳
鸿轩凤翥
鸿都买第
鸿隐凤伏
鸿雁哀鸣
鸿飞冥冥
鸿飞雪爪
鸿飞霜降
鸿鳦满纸
鸿鶱凤立
鸿鶱凤逝
鸿鹄之志
鸿鹄将至
鹄峙鸾停
鹄峙鸾翔
鹄形菜色
鹄形鸟面
鹄面鸠形
鹅毛大雪
鹅湖之会
鹅王择乳
鹅行鸭步
鹊反鸾惊
鹊垒巢鸠
鹊巢鸠主
鹊巢鸠佔
鹊巢鸠占
鹊巢鸠居
鹊巢鸠据
鹊巢鸠踞
鹊笑鸠舞
鹊返鸾回
鹏抟鹢退
鹏游蝶梦
鹏程万里
鹏霄万里
鹑居鷇食
鹑居鷇饮
鹑衣百结
鹑衣鷇食
鹑衣鹄面
鹘仑吞枣
鹘入鸦羣
鹘入鸦群
鹡鸰在原
鹤势螂形
鹤发松姿
鹤发童颜
鹤发鸡皮
鹤唳华亭
鹤唳猿声
鹤唳风声
鹤困鸡羣
鹤困鸡群
鹤处鸡羣
鹤处鸡群
鹤子梅妻
鹤归华表
鹤怨猿惊
鹤知夜半
鹤短凫长
鹤立鸡羣
鹤立鸡群
鹤背扬州
鹤膝蜂腰
鹤行鸡羣
鹤行鸡群
鹤长凫短
鹤长鳬短
鹤骨松姿
鹤骨松筋
鹤骨霜髯
鹤骨鸡肤
鹤骨龙筋
鹤鸣之士
鹤鸣九皋
鹦鹉学舌
鹦鹉学语
鹪巢蚊睫
鹪鹩一枝
鹬蚌相争
鹬蚌相危
鹬蚌相持
鹬蚌相斗
鹭序鸳行
鹭序鹓行
鹭朋鸥侣
鹭约鸥盟
鹯视狼顾
鹰击毛挚
鹰击长空
鹰嘴鹞目
鹰头雀脑
鹰心雁爪
鹰扬虎噬
鹰扬虎视
鹰拿燕雀
鹰拿雁捉
鹰挚狼食
鹰撮霆击
鹰犬之才
鹰犬塞途
鹰睃狼顾
鹰瞵虎攫
鹰瞵虎视
鹰瞵鹗视
鹰视狼步
鹰视狼顾
鹰视虎步
鹰觑鹘望
鹰鼻鹞眼
鹿死不择荫
鹿死不择音
鹿死谁手
鹿皮苍璧
鹿裘不完
鹿走苏台
鹿车共挽
鹿驯豕暴
麇至沓来
麇骇雉伏
麈尾之诲
麋沸蚁动
麞头鼠目
麟凤一毛
麟凤龟龙
麟子凤雏
麟肝凤髓
麟角凤嘴
麟角凤毛
麟角凤觜
麟角凤距
麟角虎翅
麟趾呈祥
麤心浮气
麤服乱头
麤枝大叶
麤衣恶食
麤衣淡饭
麤衣粝食
麤袍粝食
麦丘之祝
麦秀两岐
麦秀两歧
麦秀黍离
麦穗两岐
麦穗两歧
麦饭豆羹
麻姑献寿
麻木不仁
麻痹不仁
麻痹大意
麻痺不仁
麾之即去
黄人守日
黄人捧日
黄公酒垆
黄冠草履
黄冠草服
黄冠野服
黄卷幼妇
黄卷青灯
黄发儿齿
黄发台背
黄发垂髫
黄发骀背
黄发鲐背
黄口孺子
黄口小儿
黄台之瓜
黄垆之痛
黄天焦日
黄尘清水
黄干黑廋
黄旗紫盖
黄杨厄闰
黄梁一梦
黄梁美梦
黄汤淡水
黄汤辣水
黄河水清
黄泉之下
黄皮刮廋
黄皮寡廋
黄童白叟
黄童白颠
黄童皓首
黄粱一梦
黄粱美梦
黄绢幼妇
黄绵袄子
黄耳传书
黄花晚节
黄茅白苇
黄虀淡饭
黄虀白饭
黄袍加体
黄袍加身
黄道吉日
黄金世界
黄金时代
黄金时间
黄金铸象
黄钟大吕
黄钟毁弃
黄钟瓦釜
黄钟长弃
黄锺毁弃
黄锺瓦缶
黄雀伺蝉
黄雀在后
黄雀衔环
黄风雾罩
黄麻紫书
黄麻紫泥
黄齑淡饭
黄齑白饭
黄龙痛饮
黍油麦秀
黍离麦秀
黍秀宫庭
黎丘丈人
黎庶涂炭
黏吝缴绕
黏恡缴绕
黏皮带骨
黏皮着骨
黑云压城城欲摧
黑价白日
黑地昏天
黑天半夜
黑天墨地
黑天摸地
黑天白日
黑家白日
黑更半夜
黑漆一团
黑漆皮灯
黑漆皮灯笼
黑灯下火
黑灯瞎火
黑白分明
黑白混淆
黑言诳语
黑风孽海
黔突暖席
黔驴之技
黔驴之计
黔驴技孤
黔驴技穷
默不作声
默化潜移
默契神会
默换潜移
默而识之
默转潜移
默默无言
默默无闻
黜奢崇俭
黜幽陟明
黜昏启圣
黜衣缩食
黜邪崇正
黜陟幽明
黩武穷兵
黯晦消沉
黯淡无光
黯然伤神
黯然失色
黯然无色
黯然神伤
黯然销魂
黼国黻家
黼蔀黻纪
黼衣方领
黼黻文章
黼黻皇猷
黾穴鸲巢
鼋鸣鳖应
鼌不及夕
鼍愤龙愁
鼍鸣鳖应
鼎分三足
鼎成龙升
鼎成龙去
鼎折覆餗
鼎折餗覆
鼎新革故
鼎湖龙去
鼎玉龟符
鼎足三分
鼎足之势
鼎足而三
鼎足而居
鼎足而立
鼎铛有耳
鼎铛玉石
鼎镬刀锯
鼎镬如饴
鼎食钟鸣
鼎食鸣钟
鼎食鸣锺
鼎鱼幕燕
鼎鼎大名
鼎鼎有名
鼎鼐调和
鼓乐喧天
鼓乐齐鸣
鼓吹喧阗
鼓吻奋爪
鼓吻弄舌
鼓唇咋舌
鼓唇弄舌
鼓唇摇舌
鼓旗相当
鼓盆之戚
鼓眼努睛
鼓睛暴眼
鼓脑争头
鼓腹击壤
鼓腹含和
鼓腹含哺
鼓舌扬唇
鼓舌掀簧
鼓舌摇唇
鼓舞人心
鼓舞欢忻
鼓舞欢欣
鼓衰力尽
鼓角齐鸣
鼓馁旗靡
鼓鼓囊囊
鼠偷狗盗
鼠入牛角
鼠凭社贵
鼠啮虫穿
鼠啮蠹蚀
鼠屎汙羹
鼠屎污羹
鼠心狼肺
鼠撺狼奔
鼠牙雀角
鼠盗狗窃
鼠目寸光
鼠目獐头
鼠目麞头
鼠穴寻羊
鼠窃狗偷
鼠窃狗盗
鼠窜狗盗
鼠窜狼奔
鼠窜蜂逝
鼠肚鸡肠
鼠肝虫臂
鼠腹蜗肠
鼠腹鸡肠
鼠臂虮肝
鼠迹狐踪
鼠雀之牙
鼠雀之辈
鼠首偾事
鼠齧虫穿
鼠齧蠹蚀
鼪鼬之径
鼪鼬之迳
鼪鼯之径
鼷腹鹪枝
鼷鼠饮河
鼻垩挥斤
鼻塌唇青
鼻塌嘴歪
鼻塌脣青
鼻头出火
鼻孔撩天
鼻孔朝天
鼻孔辽天
鼻息如雷
鼻端出火
鼻端生火
鼻肿眼青
鼻青眼乌
鼻青眼紫
鼻青眼肿
鼻青脸肿
鼻青额肿
鼾声如雷
齐东野语
齐人攫金
齐名并价
齐大非偶
齐大非耦
齐天洪福
齐头并进
齐家治国
齐心一力
齐心併力
齐心协力
齐心合力
齐心同力
齐心并力
齐心戮力
齐心涤虑
齐烟九点
齐王舍牛
齐眉举案
齐纨鲁缟
齐趋并驾
齐足并驱
齐轨连辔
齐量等观
齐镳并驱
齐驱并进
齐驱并驾
齐驱并骤
齑身粉骨
齩姜呷醋
齩文嚼字
齰舌缄唇
齿亡舌存
齿剑如归
齿危发秀
齿如含贝
齿如编贝
齿如齐贝
齿少心鋭
齿少心锐
齿少气鋭
齿少气锐
齿弊舌存
齿牙为猾
齿牙为祸
齿牙之猾
齿牙余惠
齿牙余慧
齿牙余论
齿牙春色
齿牙馀惠
齿牙馀慧
齿牙馀论
齿甘乘肥
齿白唇红
齿若编贝
齿落舌钝
齿豁头童
齿过肩随
齿颊挂人
齿颊生香
龂齿弹舌
龂龂计较
龃龉不合
龇牙咧嘴
龇牙裂嘴
龈齿弹舌
龈龈计较
龙举云兴
龙举云属
龙争虎战
龙争虎斗
龙争虎鬪
龙伸蠖屈
龙兴云属
龙兴凤举
龙凤呈祥
龙化虎变
龙去鼎湖
龙吟虎啸
龙多乃旱
龙头蛇尾
龙头锯角
龙姿凤采
龙威燕颔
龙威虎震
龙屈蛇伸
龙幡虎纛
龙御上宾
龙德在田
龙心凤肝
龙战玄黄
龙战虎争
龙战鱼骇
龙拏虎掷
龙拏虎攫
龙拏虎跳
龙攀凤附
龙断之登
龙断可登
龙楼凤城
龙楼凤池
龙楼凤阁
龙楼凤阙
龙江虎浪
龙游曲沼
龙潜凤采
龙潭虎穴
龙潭虎窟
龙生九子
龙生九种
龙盘凤翥
龙盘凤舞
龙盘凤逸
龙盘虎拏
龙盘虎踞
龙眉凤目
龙眉豹颈
龙睁虎眼
龙神马壮
龙章凤函
龙章凤姿
龙章凤彩
龙章秀骨
龙章麟角
龙精虎猛
龙翔凤翥
龙翔凤舞
龙翔凤跃
龙翔虎跃
龙翰凤翼
龙翰凤雏
龙肝凤脑
龙肝凤髓
龙肝豹胎
龙胡之痛
龙腾凤集
龙腾虎啸
龙腾虎掷
龙腾虎跃
龙腾虎踞
龙腾虎踯
龙腾虎蹴
龙腾豹变
龙荒朔漠
龙荒蛮甸
龙虎风云
龙蛇混杂
龙蛇飞动
龙蛇飞舞
龙蛰蠖屈
龙蟠凤翥
龙蟠凤逸
龙蟠虎伏
龙蟠虎绕
龙蟠虎踞
龙蟠虎遶
龙蟠虬结
龙血凤髓
龙血玄黄
龙行虎变
龙行虎步
龙言凤语
龙跃凤鸣
龙跃虎踞
龙跃鸿矫
龙跧虎卧
龙跳虎伏
龙跳虎卧
龙蹲虎踞
龙门点额
龙阳泣鱼
龙雏凤种
龙雕凤咀
龙韬豹略
龙颜凤姿
龙飞凤翔
龙飞凤翥
龙飞凤舞
龙飞虎跳
龙首豕足
龙马精神
龙驭上宾
龙驰虎骤
龙驹凤雏
龙骧凤矫
龙骧虎啸
龙骧虎步
龙骧虎视
龙骧虎跱
龙骧蠖屈
龙骧豹变
龙骧麟振
龙鬼蛇神
龙鸣狮吼
龚行天罚
龟冷搘床
龟冷支床
龟厌不告
龟年鹤寿
龟年鹤算
龟文鸟迹
龟毛兔角
龟玉毁椟
龟鹤遐寿
龟鹤遐龄
龟龄鹤算
龟龙片甲
龟龙鳞凤
龟龙麟凤
